<?php
/* iWebCal Version 2.0 beta
 * Copyright (C) 2003-2005 David A. Feldman.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of version 2 of the GNU General Public License 
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU 
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License 
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA. Or, 
 * visit http://gnu.org.
 * 
 * This file is part of the iWebCal calendar-viewing service. The iWebCal
 * service is available on the Web at http://iWebCal.com, and does not
 * require any programming knowledge or Web server configuration to use.
 * Anyone with an iCal or other .ics calendar file and a place to post
 * it on the Web can view the calendar using iWebCal.
 */
 
/*
 * iWebCal.inc: Defines the iWebCal class, which read a calendar file;
 * creates a Calendar object for it; and displays the calendar and controls.
 * Relies on the Calendar, CallItem, and Property classes.
 *
 * File version 2.0b3, last modified April 29, 2005.
 */

class iWebCal {		
	var $cache_directory;
	var $cache_size;
	var $main_filename;
	var $error = false;
	
	var $cal;
	
	var $file, $today, $month, $year, $day, $view, $sort, $showCompleted;

	function iWebCal() {
		$this->limit_caching = isset($GLOBALS["iWebCal_LIMIT_CACHE"]) ? $GLOBALS["iWebCal_LIMIT_CACHE"] : false;
		$this->cache_directory = $GLOBALS["iWebCal_CACHE_DIRECTORY"];
		$this->cache_size = $GLOBALS["iWebCal_CACHE_SIZE"];
		$this->main_filename = $GLOBALS["iWebCal_MAIN_FILENAME"];

		// Globals, for convenience
		$this->file = $GLOBALS["iWebCal_CALENDAR_FILE"];
		
		$this->today = getdate();
		if (isset($_GET["date"])) {
			$dateInfo = getdate(strtotime($_GET["date"]));
			$this->year = $dateInfo["year"];
			$this->month = $dateInfo["mon"];
			$this->day = $dateInfo["mday"];
		}
		else {
			$this->month = isset($_GET["month"]) ? $_GET["month"] : $this->today["mon"];
			$this->year = isset($_GET["year"]) ? $_GET["year"] : $this->today["year"];
			$this->day = isset($_GET["day"]) ? $_GET["day"] : $this->today["mday"];
			if (!checkdate($this->month, $this->day, $this->year)) {
				$this->day = 1;
			}
		}
		$this->view = isset($_GET["view"]) ? $_GET["view"] : "month";
		
		$this->year = (int)$this->year;
		$this->month = (int)$this->month;
		$this->day = (int)$this->day;
		
		$this->sort = isset($_GET["sort"]) ? $_GET["sort"] : "priority";
		$this->showCompleted = isset($_GET["showCompleted"]) ? $_GET["showCompleted"] : false;
		
		// Get user agent info
		if (isset($_SERVER['HTTP_USER_AGENT'])) {
			$uaRaw = strtolower($_SERVER['HTTP_USER_AGENT']);
			$this->uaVersion = "unk";
			if (strpos($uaRaw, "opera") !== false)
				$this->userAgent = "opera";
			elseif (strpos($uaRaw, "msie") !== false) {
				$this->userAgent = "ie";
				if (strpos($uaRaw, "msie 6") !== false) $this->uaVersion = 6;
			}
			else
				$this->userAgent = "other";
			
			if (strpos($uaRaw, "mac") !== false)
				$this->uaPlatform = "mac";
			else
				$this->uaPlatform = "other";
		}
		else {
			$this->uaVersion = "unk";
			$this->userAgent = "unk";
			$this->uaPlatform = "unk";
		}

		session_start();
		
		if ($new_session = !session_is_registered("stored_calendar")) {
			// Verify that there's room for a new session.
			if ($this->limit_caching && (dirSize($this->cache_directory) >= $this->cache_size * 1048576)) {
				$this->error = "<p>Sorry, there are too many people using the iWebCal service right now. " .
					"Please try back in a few minutes. We apologize for the inconvenience.</p>";

				if (isset($GLOBALS["iWebCal_ADMINISTRATOR_EMAIL"]) && $GLOBALS["iWebCal_ADMINISTRATOR_EMAIL"]) {
					$lockfile = $GLOBALS["iWebCal_CACHE_DIRECTORY"] . "/cache-warning-sent-" . date("Y-m-d");
					if (!file_exists($lockfile)) {
						if (touch($lockfile)) {
							$msg = "iWebCal has exceeded the maximum storage allotted to it on your Web server. "
								. "You can increase the amount by changing the value of \$iWebCal_CACHE_SIZE in config.inc.\n\n"
								. 'Each time a new user views a calendar in iWebCal, iWebCal temporarily stores information '
								. 'about that calendar on your Web server in the directory specified by $iWebCal_CACHE_DIRECTORY '
								. 'in config.inc. This information helps iWebCal display the calendar quickly and without using too '
								. "much bandwidth.\n\n"
								. 'However, your Web server has only so much space, and if your Web site is hosted on a shared Web '
								. 'server with other users you probably have a storage quota. So, iWebCal allows you to limit the '
								. 'amount of space used by it. This protects you from exceeding your available space and your '
								. "Web server from suffering an attack through iWebCal.\n\n"
								. 'If you can spare more space, increase $iWebCal_CACHE_SIZE to allow more simultaneous users. '
								. 'You can also decrease $iWebCal_SESSION_LENGTH so that this temporary information expires sooner, '
								. "allowing new connections to replace old ones more quickly.\n\n"
								. "You will only receive this message once per day.\n\n--iWebCal\n";
							if (!mail($GLOBALS["iWebCal_ADMINISTRATOR_EMAIL"], "iWebCal has exceeded its storage space", $msg)) {
								$this->error .= "<p>In addition, iWebCal was unable to send mail to the site administrator "
									. "regarding the problem. You may wish to contact the administrator directly.</p>";
							}
						}
						else {
							$this->error .= "<p>In addition, iWebCal encountered a problem sending mail to the administrator of this site "
								. "about the problem. You may wish to contact the administrator directly</p>";
						}
					}
				}
	
				return;
			}
			session_register("stored_calendar");
		}
		
		if ($new_session || (isset($_REQUEST["act"]) && ($_REQUEST["act"] == "refresh"))) {
			$this->cal = new Calendar($this->file); 
		}
		else {
			$this->cal = unserialize($_SESSION["stored_calendar"]);
			$this->cal->wake();
		}
		
		$cal = &$this->cal;

		if ($cal->url != $this->file) {
			$cal = new Calendar($this->file);
		}

		$cal->sortTasks($this->sort);
		
		$cal->showCompletedTasks($this->showCompleted);
	}
	
	function title() {
		return $this->cal->title;
	}
	
	function includes() {
		global $iWebCal_URL_PATH;

		?>
		<link href="<? echo $iWebCal_URL_PATH ?>/include/iWebCal.css" rel="stylesheet" />
		<?
		if ($this->userAgent == "ie") {
			?>
			<link href="<? echo $iWebCal_URL_PATH ?>/include/iWebCal-ie6.css" rel="stylesheet" />
			<?
		}
		?>
		<script type="text/javascript" src="<? echo $iWebCal_URL_PATH ?>/include/iWebCal.js"></script>
		<?php
	}
	
	function display() {
		global $iWebCal_URL_PATH;
		if ($this->error) {
			?>
			<div class="iWebCal Err">
				<div class="Error">
					<h2>iWebCal Error</h2>
					<p><? echo $this->error ?></p>
				</div>
			</div>
			<?php
		}
		else {
			$cal = &$this->cal;
		
			$this->todayURL = $this->main_filename . "?view=" . (($this->view == "tasks") ? "day" : $this->view) . "&year=";
			$this->todayURL .= $this->today["year"] . "&month=";
			$this->todayURL .= $this->today["mon"] . "&day=";
			$this->todayURL .= $this->today["mday"] . "&file=" . $this->file;
			
			$year = &$this->year;
			$month = &$this->month;
			$day = &$this->day;
			$file = &$this->file;
			$view = &$this->view;
			$sort = &$this->sort;
			
			// Generate URLs for next/prev buttons
			switch($this->view) {
				case "month":
					$nextMonth = ($month == 12) ? 1 : $month+1;
					$prevMonth = ($month == 1) ? 12 : $month-1;
					$nextYear = ($month == 12) ? $year+1 : $year;
					$prevYear = ($month == 1) ? $year-1 : $year;
					$prevURL = $this->main_filename . "?view=month&year=${prevYear}&month=${prevMonth}&file=" . $file;
					$nextURL = $this->main_filename . "?view=month&year=${nextYear}&month=${nextMonth}&file=" . $file;
					break;
				case "week":
					list($nextYear, $nextMonth, $nextDay) = explode(",", strftime("%Y,%m,%e", strtotime("+7 days", strtotime("${year}-${month}-${day}"))));
					list($prevYear, $prevMonth, $prevDay) = explode(",", strftime("%Y,%m,%e", strtotime("-7 days", strtotime("${year}-${month}-${day}"))));
					
					$prevURL = $this->main_filename . "?view=week&year=${prevYear}&month=${prevMonth}&day=${prevDay}&file=${file}";
					$nextURL = $this->main_filename . "?view=week&year=${nextYear}&month=${nextMonth}&day=${nextDay}&file=${file}";
					
					break;
				case "day":
					list($nextYear, $nextMonth, $nextDay) = explode(",", strftime("%Y,%m,%e", strtotime("+1 day", strtotime("${year}-${month}-${day}"))));
					list($prevYear, $prevMonth, $prevDay) = explode(",", strftime("%Y,%m,%e", strtotime("-1 day", strtotime("${year}-${month}-${day}"))));
					
					$prevURL = $this->main_filename . "?view=day&year=${prevYear}&month=${prevMonth}&day=${prevDay}&file=${file}";
					$nextURL = $this->main_filename . "?view=day&year=${nextYear}&month=${nextMonth}&day=${nextDay}&file=${file}";
					
					break;
			}
			if ($cal->isValid) {
				?>
				<div class="iWebCal">
					<? $linkToHere = "http://interfacethis.com/iwebcal/iwebcal.php?file=${file}"; ?>
					<div id="calToolbar">
						<?
						if ($view == "tasks") {
							?>
							<form method="get" name="taskControlForm" action="." class="Item">
								<label>
									<input type="checkbox" name="showCompleted" value="1" onclick="toggleShowCompleted()" <? if ($this->showCompleted) { ?>checked<? } ?> />
									Show completed tasks
								</label>
							</form>
							<?
						}
						else { 
							?>
							<div id="calPager" class="Item">
								<a class="Item" href="<? echo $prevURL ?>" title="<? echo "previous ${view}"; ?>"
									onmouseover="imageSwap('prevBtn_img', '<? echo $iWebCal_URL_PATH ?>/img/btn-prev-over.gif')"
									onmouseout="imageSwap('prevBtn_img', '<? echo $iWebCal_URL_PATH ?>/img/btn-prev.gif')"><? $this->image("btn-prev.gif", "previous ${view}", "prevBtn_img"); ?></a>
								<span class="ViewTitle Item">
									<? $cal->printViewTitle($year, $month, $day, $view); ?>
								</span>
								<a class="Item" href="<? echo $nextURL ?>" title="<? echo "next ${view}" ?>"
									onmouseover="imageSwap('nextBtn_img', '<? echo $iWebCal_URL_PATH ?>/img/btn-next-over.gif')"
									onmouseout="imageSwap('nextBtn_img', '<? echo $iWebCal_URL_PATH ?>/img/btn-next.gif')"><? $this->image("btn-next.gif", "next ${view}", "nextBtn_img"); ?></a>
							</div>
							<?
						}
						$this->button("Today", $this->todayURL, "Item");
						switch($month) {
							case "1":
								$monthName = "Jan";
								break;
							case "2":
								$monthName = "Feb";
								break;
							case "3":
								$monthName = "Mar";
								break;
							case "4":
								$monthName = "Apr";
								break;
							case "5":
								$monthName = "May";
								break;
							case "6":
								$monthName = "Jun";
								break;
							case "7":
								$monthName = "Jul";
								break;
							case "8":
								$monthName = "Aug";
								break;
							case "9":
								$monthName = "Sep";
								break;
							case "10":
								$monthName = "Oct";
								break;
							case "11":
								$monthName = "Nov";
								break;
							case "12":
								$monthName = "Dec";
								break;
						}
						?>
						<form action="<? echo $this->main_filename ?>" method="get" name="controlForm" id="controlForm" class="Item">
							<input class="Item" type="text" name="date" value="<? echo "$monthName $day, $year" ?>" size="13" maxlength="20" title="jump to date: most standard formats accepted" /> 
							<input type="hidden" name="view" value="<? echo $view; ?>" />
							<input type="hidden" name="act" value="" />
							<input type="hidden" name="file" value="<? echo $file ?>" />
							<input type="hidden" name="showCompleted" value="<? echo (isset($_GET["showCompleted"]) ? $_GET["showCompleted"] : "1") ?>" />
							<input type="hidden" name="sort" value="<? echo $sort ?>" />
							<? $this->button("Go", "javascript:document.controlForm.submit();", "Item"); ?>
						</form>
						<div id="viewSelector" class="Item">
							<a class="Ft End<? if ($view == "day") echo " Sel" ?>" href="javascript:document.controlForm.view.value='day';document.controlForm.submit();">
								<span class="Lt"></span>
								<span class="Ctr">Day</span>
							</a>
							<a <? if ($view == "week") echo "class=\"Sel\""; ?> href="javascript:document.controlForm.view.value='week';document.controlForm.submit();">Week</a>
							<a <? if ($view == "month") echo "class=\"Sel\""; ?> href="javascript:document.controlForm.view.value='month';document.controlForm.submit();">Month</a>
							<a class="Lst End<? if ($view == "tasks") echo " Sel" ?>" href="javascript:document.controlForm.view.value='tasks';document.controlForm.submit();">
								<span class="Ctr">Tasks</span>
								<span class="Rt"></span>
							</a>
						</div>
					</div>
					<?php
					$cal->printCal($year, $month, $day, $view);
					if (isset($GLOBALS["iWebCal_PAGE_TOOLBAR_ITEMS"]) && count($tbItems = $GLOBALS["iWebCal_PAGE_TOOLBAR_ITEMS"])) {
						echo '<ul id="pageToolbar">';
						for ($i=0;$i<count($tbItems);$i++) {
							echo "<li";
							if ($i == 0) echo ' class="Ft"';
							echo '>';
							echo $tbItems[$i];
							echo "</li>";
						}
						echo '</ul>';
					}
					?>
					<a id="poweredBy" href="<? echo $GLOBALS["iwcint_PWRBY_LINK"] ?>"><img src='<? echo $GLOBALS["iwcint_PWRBY_IMG"] ?>'
						height="<? echo $GLOBALS["iwcint_PWRBY_HEIGHT"] ?>" 
						width="<? echo $GLOBALS["iwcint_PWRBY_WIDTH"] ?>" 
					border="0"></a>
					<?
				}
				else {
					include "error.php";
					printErrorPage($cal->errorString);
				}
				$_SESSION["stored_calendar"] = serialize($cal);
				?>
			</div>
			<?php
		}
	}
	
	function button($label, $url, $class="") {
		?>
		<a href="<? echo $url ?>" class="Btn<? if ($class) echo " " . $class; ?>">
			<span class="Lt"></span>
			<span class="Ctr"><? echo $label ?></span>
			<span class="Rt"></span>
		</a>
		<?
	}
	
	function image($name, $alt = "[needs alt tag]", $id="", $attrs="") {
		global $iWebCal_URL_PATH, $iWebCal_LOCAL_PATH;
	
		list($width, $height, $d0, $d1) = getimagesize($iWebCal_LOCAL_PATH . "/img/" . $name);
		?><img src="<? echo $iWebCal_URL_PATH . "/img/" . $name ?>" id="<? echo $id ?>" width="<? echo $width ?>" height="<? echo $height ?>" alt="<? echo $alt ?>" border="0" <? echo $attrs ?> /><?
	}
	
	/*
	function imageButton($src, $url, $id, $tip = "[needs tool tip]", $class="", $overExtension="-over") {
		$attrs = "";
		if ($overExtension) {
			$srcParts = pathinfo($src);
			$overSrc = $srcParts["dirname"] . "/" . substr($srcParts["basename"], -1, strlen($srcParts["extension"])+1)
				. $overExtension . "." . $srcParts["extension"];
			$attrs .= "onmouseover=\"swapImage('${id}_img', '${overSrc}')\" ";
			$attrs .= "onmouseout=\"swapImage('${id}_img', '${src}')\" ";
			$attrs .= "class=\"ImgBtn";
			if ($class)
				$attrs .= " $class";
			$attrs .= "\"";
		}
		echo "<a href=\"${url}\" id=\"${id}\" title=\"${tip}\" $attrs>";
		$this->image($src, $tip, "id=\"${id}_img\""); 
	*/
}

?>