<?php
/* iWebCal Version 2.0 beta
 * Copyright (C) 2003-2005 David A. Feldman.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of version 2 of the GNU General Public License 
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU 
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License 
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA. Or, 
 * visit http://gnu.org.
 * 
 * This file is part of the iWebCal calendar-viewing service. The iWebCal
 * service is available on the Web at http://iWebCal.com, and does not
 * require any programming knowledge or Web server configuration to use.
 * Anyone with an iCal or other .ics calendar file and a place to post
 * it on the Web can view the calendar using iWebCal.
 */
 
/*
 * index.php: A simple iWebCal setup that will display a single calendar.
 * iWebCal is capable of handling multiple calendars, as you can see from
 * the main iWebCal.com site, which uses very little code beyond the basic
 * iWebCal source to do its work.
 *
 * You shouldn't need to modify this file to get it working. Once you've
 * installed the iWebCal source folder on your Web server, you should be
 * able to point your browser at it and see the included sample calendar
 * (Sample.ics). To show your calendar, just edit config.inc and set the 
 * $iWebCal_CALENDAR_FILE variable to the location of your calendar file.
 *
 * File version 2.0b1, last modified April 11, 2005.
 */

include "config.inc"; // Sets up iWebCal.

error_reporting(E_ALL);
$my_iWebCal = new iWebCal(); // Creates a new iWebCal viewer and calendar based on your settings in config.inc.
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
	<head>
		<meta http-equiv="content-type" content="text/html;charset=UTF-8" />
		<meta name="generator" content="BBEdit" />
		<title>iWebCal</title>
		<? 
		$my_iWebCal->includes(); // Includes stylesheets and scripts needed by the calendar viewer.
		?>
	</head>
	<body class="iWebCal_Page">
		<h1>
			<? 
			echo $my_iWebCal->title(); // Gives the page a title based on the filename of the calendar.
			?>
		</h1>
		<?
		$my_iWebCal->display(); // Displays the calendar and controls for it (i.e. most of the page).

		// If you need to do debugging, you can use Calendar's dprint() method to print out raw Calendar
		// object data in a reasonably readable form. Just comment out the call to printCal() above and
		// uncomment the line below. For actual deployment, make sure the dprint() call is commented out
		// again.
		//$my_iWebCal->cal->dprint();
		?>
	</body>
</html>					