/*
 * Decompiled with CFR 0.152.
 */
package com.sun.CORBA.iiop;

import com.sun.CORBA.IOR;
import com.sun.CORBA.MarshalInputStream;
import com.sun.CORBA.ORB;
import com.sun.CORBA.ServerSubcontract;
import com.sun.CORBA.idl.PrincipalImpl;
import com.sun.CORBA.idl.TypeCodeImpl;
import java.io.IOException;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.Object;
import org.omg.CORBA.Principal;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.portable.InputStream;

public class CDRInputStream
extends InputStream
implements MarshalInputStream {
    protected boolean littleEndian;
    protected int index;
    protected int size;
    protected byte[] buf;
    ORB orb;

    public CDRInputStream() {
    }

    public CDRInputStream(CDRInputStream cDRInputStream) {
        this.littleEndian = cDRInputStream.littleEndian;
        this.index = cDRInputStream.index;
        this.size = cDRInputStream.size;
        this.buf = cDRInputStream.buf;
        this.orb = cDRInputStream.orb;
    }

    public CDRInputStream(org.omg.CORBA.ORB oRB, byte[] byArray, int n) {
        this(oRB, byArray, n, false);
    }

    public CDRInputStream(org.omg.CORBA.ORB oRB, byte[] byArray, int n, boolean bl) {
        this.orb = (ORB)oRB;
        this.littleEndian = bl;
        this.size = n;
        this.buf = byArray;
    }

    private final void alignAndCheck(int n, int n2) {
        int n3 = this.index - 1 + n & ~(n - 1);
        if (n3 + n2 <= this.size) {
            this.index = n3;
            return;
        }
        this.grow(n, n2);
    }

    public int available() throws IOException {
        return this.size - this.index;
    }

    public final void consumeEndian() {
        this.littleEndian = this.read_boolean();
    }

    public CDRInputStream dup() {
        return new CDRInputStream(this);
    }

    public ORB getORB() {
        return this.orb;
    }

    protected void grow(int n, int n2) {
        throw new MARSHAL();
    }

    public final boolean isAtEnd() {
        return this.index == this.size;
    }

    public int mark() {
        return this.index;
    }

    public final String peek_string() {
        int n;
        int n2;
        int n3;
        int n4;
        this.alignAndCheck(4, 4);
        if (this.littleEndian) {
            n4 = this.buf[this.index] & 0xFF;
            n3 = this.buf[this.index + 1] << 8 & 0xFF00;
            n2 = this.buf[this.index + 2] << 16 & 0xFF0000;
            n = this.buf[this.index + 3] << 24 & 0xFF000000;
        } else {
            n = this.buf[this.index] << 24 & 0xFF000000;
            n2 = this.buf[this.index + 1] << 16 & 0xFF0000;
            n3 = this.buf[this.index + 2] << 8 & 0xFF00;
            n4 = this.buf[this.index + 3] & 0xFF;
        }
        int n5 = n | n2 | n3 | n4;
        if (n5 == 0) {
            return "";
        }
        byte[] byArray = new byte[n5];
        int n6 = this.index + 4;
        this.alignAndCheck(1, 1);
        int n7 = this.size - n6;
        if (n5 > n7) {
            throw new INTERNAL(6, CompletionStatus.COMPLETED_MAYBE);
        }
        System.arraycopy(this.buf, n6, byArray, 0, n5);
        String string = new String(byArray, 0, 0, byArray.length - 1);
        int n8 = 0;
        while (n8 < string.length()) {
            if (string.charAt(n8) > '\u00ff') {
                throw new MARSHAL(6, CompletionStatus.COMPLETED_MAYBE);
            }
            ++n8;
        }
        return string;
    }

    public final Object read_Object() {
        try {
            IOR iOR = new IOR(this.orb);
            iOR.read(this);
            if (iOR.is_nil()) {
                return null;
            }
            byte[] byArray = iOR.getProfile().getObjectKey();
            ServerSubcontract serverSubcontract = this.orb.getSubcontractRegistry().getServerSubcontract(byArray);
            return (Object)serverSubcontract.createObjref(iOR);
        }
        catch (Exception exception) {
            throw new MARSHAL(4, CompletionStatus.COMPLETED_NO);
        }
    }

    public final Principal read_Principal() {
        int n = this.read_long();
        byte[] byArray = new byte[n];
        this.read_octet_array(byArray, 0, n);
        PrincipalImpl principalImpl = new PrincipalImpl();
        ((Principal)principalImpl).name(byArray);
        return principalImpl;
    }

    public final TypeCode read_TypeCode() {
        TypeCodeImpl typeCodeImpl = new TypeCodeImpl(this.orb);
        typeCodeImpl.read_value(this);
        return typeCodeImpl;
    }

    public final Any read_any() {
        Any any = this.orb.create_any();
        TypeCodeImpl typeCodeImpl = new TypeCodeImpl(this.orb);
        typeCodeImpl.read_value(this);
        any.read_value(this, typeCodeImpl);
        return any;
    }

    public final boolean read_boolean() {
        boolean bl = this.read_octet() != 0;
        return bl;
    }

    public final void read_boolean_array(boolean[] blArray, int n, int n2) {
        int n3 = 0;
        while (n3 < n2) {
            blArray[n3 + n] = this.read_boolean();
            ++n3;
        }
    }

    public final char read_char() {
        this.alignAndCheck(1, 1);
        char c = (char)(this.buf[this.index++] & 0xFF);
        if (c > '\u00ff') {
            throw new MARSHAL(6, CompletionStatus.COMPLETED_NO);
        }
        return c;
    }

    public final void read_char_array(char[] cArray, int n, int n2) {
        int n3 = 0;
        while (n3 < n2) {
            cArray[n3 + n] = this.read_char();
            ++n3;
        }
    }

    public final double read_double() {
        return Double.longBitsToDouble(this.read_longlong());
    }

    public final void read_double_array(double[] dArray, int n, int n2) {
        int n3 = 0;
        while (n3 < n2) {
            dArray[n3 + n] = this.read_double();
            ++n3;
        }
    }

    public final float read_float() {
        return Float.intBitsToFloat(this.read_long());
    }

    public final void read_float_array(float[] fArray, int n, int n2) {
        int n3 = 0;
        while (n3 < n2) {
            fArray[n3 + n] = this.read_float();
            ++n3;
        }
    }

    public final int read_long() {
        int n;
        int n2;
        int n3;
        int n4;
        this.alignAndCheck(4, 4);
        if (this.littleEndian) {
            n4 = this.buf[this.index++] & 0xFF;
            n3 = this.buf[this.index++] << 8 & 0xFF00;
            n2 = this.buf[this.index++] << 16 & 0xFF0000;
            n = this.buf[this.index++] << 24 & 0xFF000000;
        } else {
            n = this.buf[this.index++] << 24 & 0xFF000000;
            n2 = this.buf[this.index++] << 16 & 0xFF0000;
            n3 = this.buf[this.index++] << 8 & 0xFF00;
            n4 = this.buf[this.index++] & 0xFF;
        }
        return n | n2 | n3 | n4;
    }

    public final void read_long_array(int[] nArray, int n, int n2) {
        int n3 = 0;
        while (n3 < n2) {
            nArray[n3 + n] = this.read_long();
            ++n3;
        }
    }

    public final long read_longlong() {
        long l;
        long l2;
        this.alignAndCheck(8, 8);
        if (this.littleEndian) {
            l2 = (long)this.read_long() & 0xFFFFFFFFL;
            l = (long)this.read_long() << 32;
        } else {
            l = (long)this.read_long() << 32;
            l2 = (long)this.read_long() & 0xFFFFFFFFL;
        }
        return l | l2;
    }

    public final void read_longlong_array(long[] lArray, int n, int n2) {
        int n3 = 0;
        while (n3 < n2) {
            lArray[n3 + n] = this.read_longlong();
            ++n3;
        }
    }

    public final byte read_octet() {
        this.alignAndCheck(1, 1);
        return this.buf[this.index++];
    }

    public final void read_octet_array(byte[] byArray, int n, int n2) {
        if (byArray == null) {
            throw new BAD_PARAM();
        }
        int n3 = n;
        while (n3 < n2 + n) {
            this.alignAndCheck(1, 1);
            int n4 = this.size - this.index;
            int n5 = n2 + n - n3;
            int n6 = n5 < n4 ? n5 : n4;
            System.arraycopy(this.buf, this.index, byArray, n3, n6);
            this.index += n6;
            n3 += n6;
        }
    }

    public final short read_short() {
        int n;
        int n2;
        this.alignAndCheck(2, 2);
        if (this.littleEndian) {
            n2 = this.buf[this.index++] & 0xFF;
            n = this.buf[this.index++] << 8 & 0xFF00;
        } else {
            n = this.buf[this.index++] << 8 & 0xFF00;
            n2 = this.buf[this.index++] & 0xFF;
        }
        return (short)(n | n2);
    }

    public final void read_short_array(short[] sArray, int n, int n2) {
        int n3 = 0;
        while (n3 < n2) {
            sArray[n3 + n] = this.read_short();
            ++n3;
        }
    }

    public final String read_string() {
        int n = this.read_long();
        if (n == 0) {
            return "";
        }
        byte[] byArray = new byte[n];
        this.read_octet_array(byArray, 0, n);
        String string = new String(byArray, 0, 0, byArray.length - 1);
        int n2 = 0;
        while (n2 < string.length()) {
            if (string.charAt(n2) > '\u00ff') {
                throw new MARSHAL(6, CompletionStatus.COMPLETED_MAYBE);
            }
            ++n2;
        }
        return string;
    }

    public final int read_ulong() {
        return this.read_long();
    }

    public final void read_ulong_array(int[] nArray, int n, int n2) {
        this.read_long_array(nArray, n, n2);
    }

    public final long read_ulonglong() {
        return this.read_longlong();
    }

    public final void read_ulonglong_array(long[] lArray, int n, int n2) {
        this.read_longlong_array(lArray, n, n2);
    }

    public final short read_ushort() {
        return this.read_short();
    }

    public final void read_ushort_array(short[] sArray, int n, int n2) {
        this.read_short_array(sArray, n, n2);
    }

    public final char read_wchar() {
        throw new MARSHAL(5, CompletionStatus.COMPLETED_NO);
    }

    public final void read_wchar_array(char[] cArray, int n, int n2) {
        int n3 = 0;
        while (n3 < n2) {
            cArray[n3 + n] = this.read_wchar();
            ++n3;
        }
    }

    public final String read_wstring() {
        throw new MARSHAL(5, CompletionStatus.COMPLETED_NO);
    }

    public void reset(int n) {
        this.index = n;
    }

    public final void rewind() {
        this.index = 0;
    }

    public void setOffset(int n) {
        this.index = n;
    }
}

