/*
 * Decompiled with CFR 0.152.
 */
package com.sun.CORBA.iiop;

import com.sun.CORBA.ClientResponse;
import com.sun.CORBA.IOR;
import com.sun.CORBA.Profile;
import com.sun.CORBA.iiop.CDROutputStream;
import com.sun.CORBA.iiop.ClientResponseImpl;
import com.sun.CORBA.iiop.Connection;
import com.sun.CORBA.iiop.ConnectionTable;
import com.sun.CORBA.iiop.GIOPImpl;
import com.sun.CORBA.iiop.IIOPConnection;
import com.sun.CORBA.iiop.IIOPInputStream;
import com.sun.CORBA.iiop.Message;
import com.sun.CORBA.iiop.ORB;
import com.sun.CORBA.iiop.ReplyMessage;
import com.sun.CORBA.iiop.RequestMessage;
import com.sun.CORBA.util.Utility;
import java.io.IOException;
import java.io.OutputStream;
import org.omg.CORBA.Any;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.Streamable;

public class IIOPOutputStream
extends CDROutputStream {
    private Connection conn;
    private Message msg;
    private static final int MAX_RETRIES = 3;

    public IIOPOutputStream(IIOPInputStream iIOPInputStream) {
        super(iIOPInputStream.orb);
        this.conn = iIOPInputStream.getConnection();
    }

    public IIOPOutputStream(ORB oRB, Connection connection) {
        super(oRB);
        this.conn = connection;
    }

    public InputStream create_input_stream() {
        return new IIOPInputStream((ORB)this.orb, this.buf, this.size, this.littleEndian, this.msg);
    }

    public final Connection getConnection() {
        return this.conn;
    }

    public final Message getMessage() {
        return this.msg;
    }

    public IIOPInputStream invoke(boolean bl) {
        SystemException systemException = null;
        ClientResponse clientResponse = null;
        int n = 0;
        while (n < 3) {
            try {
                clientResponse = (ClientResponse)((Object)this.conn.send(this, bl));
                if (bl) {
                    return null;
                }
                if (!clientResponse.isSystemException()) {
                    return (IIOPInputStream)((Object)clientResponse);
                }
                systemException = clientResponse.getSystemException();
            }
            catch (SystemException systemException2) {
                systemException = systemException2;
            }
            if (systemException.completed != CompletionStatus.COMPLETED_NO) {
                if (clientResponse != null) {
                    return (IIOPInputStream)((Object)clientResponse);
                }
                return new ClientResponseImpl(systemException);
            }
            ++n;
            if (systemException.minor != 2) continue;
            GIOPImpl gIOPImpl = (GIOPImpl)this.orb.getServerGIOP();
            ConnectionTable connectionTable = gIOPImpl.getConnectionTable();
            IIOPConnection iIOPConnection = (IIOPConnection)this.conn;
            this.conn = connectionTable.get(iIOPConnection.getHost(), iIOPConnection.getPort());
        }
        if (bl) {
            return null;
        }
        if (clientResponse != null) {
            return (IIOPInputStream)((Object)clientResponse);
        }
        if (systemException == null) {
            systemException = new COMM_FAILURE(6, CompletionStatus.COMPLETED_NO);
        }
        return new ClientResponseImpl(systemException);
    }

    public IIOPInputStream reInvoke(IOR iOR, int[] nArray) {
        Profile profile = iOR.getProfile();
        String string = profile.getHost();
        int n = profile.getPort();
        byte[] byArray = profile.getObjectKey();
        RequestMessage requestMessage = (RequestMessage)this.msg;
        CDROutputStream cDROutputStream = new CDROutputStream(this.orb);
        boolean bl = true;
        requestMessage.realignAndWrite(cDROutputStream, byArray, bl);
        byte[] byArray2 = cDROutputStream.toByteArray();
        int n2 = byArray2.length;
        int n3 = nArray[0];
        if (n2 == n3) {
            System.arraycopy(byArray2, 0, this.buf, 0, n2);
        } else {
            int n4 = this.size - n3 + n2;
            byte[] byArray3 = new byte[n4];
            System.arraycopy(byArray2, 0, byArray3, 0, n2);
            System.arraycopy(this.buf, n3, byArray3, n2, this.size - n3);
            this.buf = byArray3;
            this.size = n4;
            nArray[0] = n2;
        }
        GIOPImpl gIOPImpl = (GIOPImpl)this.orb.getServerGIOP();
        this.conn = gIOPImpl.getConnectionTable().get(string, n);
        return this.invoke(false);
    }

    public void sendDSIException(Any any, IIOPInputStream iIOPInputStream) {
        this.reset();
        int n = iIOPInputStream.getMessage().getRequestId();
        ReplyMessage replyMessage = new ReplyMessage(null, n, 1);
        this.setMessage(replyMessage);
        replyMessage.write(this);
        any.write_value(this);
    }

    public void sendSystemException(SystemException systemException, int n) throws SystemException {
        this.reset();
        ReplyMessage replyMessage = new ReplyMessage(null, n, 2);
        this.setMessage(replyMessage);
        replyMessage.write(this);
        Utility.writeSystemException(systemException, this);
    }

    public void sendUserException(Streamable streamable, int n) throws SystemException {
        this.reset();
        ReplyMessage replyMessage = new ReplyMessage(null, n, 1);
        this.setMessage(replyMessage);
        replyMessage.write(this);
        streamable._write(this);
    }

    public final void setConnection(Connection connection) {
        this.conn = connection;
    }

    public final void setMessage(Message message) {
        this.msg = message;
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        this.msg.setSize(this.buf, this.size);
        outputStream.write(this.buf, 0, this.size);
        this.conn.stampTime();
    }
}

