/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.ActiveEvent;
import java.awt.Component;
import java.awt.Conditional;
import java.awt.EventQueue;
import java.awt.event.InputEvent;
import java.lang.reflect.Method;
import java.security.AccessController;
import sun.security.action.GetPropertyAction;

class EventDispatchThread
extends Thread {
    private EventQueue theQueue;
    private boolean doDispatch = true;
    private static final String handlerPropName = "sun.awt.exception.handler";
    private static String handlerClassName = null;
    private static String NO_HANDLER = new String();
    static /* synthetic */ Class class$java$lang$Throwable;

    EventDispatchThread(String string, EventQueue eventQueue) {
        super(string);
        this.theQueue = eventQueue;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    EventQueue getEventQueue() {
        return this.theQueue;
    }

    private boolean handleException(Throwable throwable) {
        try {
            Object object;
            Method method;
            if (handlerClassName == NO_HANDLER) {
                return false;
            }
            if (handlerClassName == null && (handlerClassName = (String)AccessController.doPrivileged(new GetPropertyAction(handlerPropName))) == null) {
                handlerClassName = NO_HANDLER;
                return false;
            }
            try {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                Class clazz = Class.forName(handlerClassName, true, classLoader);
                method = clazz.getMethod("handle", new Class[]{class$java$lang$Throwable != null ? class$java$lang$Throwable : (class$java$lang$Throwable = EventDispatchThread.class$("java.lang.Throwable"))});
                object = clazz.newInstance();
            }
            catch (Throwable throwable2) {
                handlerClassName = NO_HANDLER;
                return false;
            }
            method.invoke(object, new Object[]{throwable});
        }
        catch (Throwable throwable3) {
            return false;
        }
        return true;
    }

    boolean isDispatching(EventQueue eventQueue) {
        return this.theQueue.equals(eventQueue);
    }

    void pumpEvents(Conditional conditional) {
        this.pumpEventsForComponent(conditional, null);
    }

    void pumpEventsForComponent(Conditional conditional, Component component) {
        while (this.doDispatch && conditional.evaluate()) {
            if (!this.isInterrupted() && this.pumpOneEventForComponent(component)) continue;
            this.doDispatch = false;
        }
    }

    boolean pumpOneEvent() {
        return this.pumpOneEventForComponent(null);
    }

    boolean pumpOneEventForComponent(Component component) {
        try {
            AWTEvent aWTEvent = this.theQueue.getNextEvent();
            if (component != null) {
                while (aWTEvent instanceof InputEvent) {
                    Component component2 = (Component)aWTEvent.getSource();
                    while (component2 != component && component2 != null) {
                        component2 = component2.getParent();
                    }
                    if (component2 == component) break;
                    aWTEvent = this.theQueue.getNextEvent();
                }
            }
            this.theQueue.dispatchEvent(aWTEvent);
            return true;
        }
        catch (ThreadDeath threadDeath) {
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (Throwable throwable) {
            if (!this.handleException(throwable)) {
                System.err.println("Exception occurred during event dispatching:");
                throwable.printStackTrace();
            }
            return true;
        }
    }

    public void run() {
        this.pumpEvents(new Conditional(){

            public boolean evaluate() {
                return true;
            }
        });
    }

    public void stopDispatching() {
        block2: {
            this.doDispatch = false;
            this.theQueue.postEventPrivate(new EmptyEvent());
            if (Thread.currentThread() == this) break block2;
            try {
                this.join();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    class EmptyEvent
    extends AWTEvent
    implements ActiveEvent {
        public EmptyEvent() {
            super(EventDispatchThread.this, 0);
        }

        public void dispatch() {
        }
    }
}

