/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.text.CharacterIterator;

public abstract class FontMetrics
implements Serializable {
    protected Font font;
    private static final long serialVersionUID = 1681126225205050147L;

    static {
        Toolkit.loadLibraries();
        FontMetrics.initIDs();
    }

    protected FontMetrics(Font font) {
        this.font = font;
    }

    public int bytesWidth(byte[] byArray, int n, int n2) {
        return this.stringWidth(new String(byArray, 0, n, n2));
    }

    public int charWidth(char c) {
        if (c < '\u0100') {
            return this.getWidths()[c];
        }
        char[] cArray = new char[]{c};
        return this.charsWidth(cArray, 0, 1);
    }

    public int charWidth(int n) {
        return this.charWidth((char)n);
    }

    public int charsWidth(char[] cArray, int n, int n2) {
        return this.stringWidth(new String(cArray, n, n2));
    }

    public int getAscent() {
        return this.font.getSize();
    }

    public int getDescent() {
        return 0;
    }

    public Font getFont() {
        return this.font;
    }

    public int getHeight() {
        return this.getLeading() + this.getAscent() + this.getDescent();
    }

    public int getLeading() {
        return 0;
    }

    public LineMetrics getLineMetrics(String string, int n, int n2, Graphics graphics) {
        return this.font.getLineMetrics(string, n, n2, this.myFRC(graphics));
    }

    public LineMetrics getLineMetrics(String string, Graphics graphics) {
        return this.font.getLineMetrics(string, this.myFRC(graphics));
    }

    public LineMetrics getLineMetrics(CharacterIterator characterIterator, int n, int n2, Graphics graphics) {
        return this.font.getLineMetrics(characterIterator, n, n2, this.myFRC(graphics));
    }

    public LineMetrics getLineMetrics(char[] cArray, int n, int n2, Graphics graphics) {
        return this.font.getLineMetrics(cArray, n, n2, this.myFRC(graphics));
    }

    public int getMaxAdvance() {
        return -1;
    }

    public int getMaxAscent() {
        return this.getAscent();
    }

    public Rectangle2D getMaxCharBounds(Graphics graphics) {
        return this.font.getMaxCharBounds(this.myFRC(graphics));
    }

    public int getMaxDecent() {
        return this.getMaxDescent();
    }

    public int getMaxDescent() {
        return this.getDescent();
    }

    public Rectangle2D getStringBounds(String string, int n, int n2, Graphics graphics) {
        return this.font.getStringBounds(string, n, n2, this.myFRC(graphics));
    }

    public Rectangle2D getStringBounds(String string, Graphics graphics) {
        return this.font.getStringBounds(string, this.myFRC(graphics));
    }

    public Rectangle2D getStringBounds(CharacterIterator characterIterator, int n, int n2, Graphics graphics) {
        return this.font.getStringBounds(characterIterator, n, n2, this.myFRC(graphics));
    }

    public Rectangle2D getStringBounds(char[] cArray, int n, int n2, Graphics graphics) {
        return this.font.getStringBounds(cArray, n, n2, this.myFRC(graphics));
    }

    public int[] getWidths() {
        int[] nArray = new int[256];
        char c = '\u0000';
        while (c < '\u0100') {
            nArray[c] = this.charWidth(c);
            c = (char)(c + '\u0001');
        }
        return nArray;
    }

    public boolean hasUniformLineMetrics() {
        return this.font.hasUniformLineMetrics();
    }

    private static native void initIDs();

    private FontRenderContext myFRC(Graphics graphics) {
        if (graphics instanceof Graphics2D) {
            return ((Graphics2D)graphics).getFontRenderContext();
        }
        return new FontRenderContext(null, false, false);
    }

    public int stringWidth(String string) {
        int n = string.length();
        char[] cArray = new char[n];
        string.getChars(0, n, cArray, 0);
        return this.charsWidth(cArray, 0, n);
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[font=" + this.getFont() + "ascent=" + this.getAscent() + ", descent=" + this.getDescent() + ", height=" + this.getHeight() + "]";
    }
}

