/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Component;
import java.awt.Toolkit;
import java.awt.peer.LabelPeer;

public class Label
extends Component {
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    String text;
    int alignment = 0;
    private static final String base = "label";
    private static int nameCounter;
    private static final long serialVersionUID = 3094126758329070636L;

    static {
        Toolkit.loadLibraries();
        Label.initIDs();
        nameCounter = 0;
    }

    public Label() {
        this("", 0);
    }

    public Label(String string) {
        this(string, 0);
    }

    public Label(String string, int n) {
        this.text = string;
        this.setAlignment(n);
    }

    public void addNotify() {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.peer == null) {
                this.peer = this.getToolkit().createLabel(this);
            }
            super.addNotify();
        }
    }

    String constructComponentName() {
        Class clazz = this.getClass();
        synchronized (clazz) {
            String string = base + nameCounter++;
            Object var3_3 = null;
            return string;
        }
    }

    public int getAlignment() {
        return this.alignment;
    }

    public String getText() {
        return this.text;
    }

    private static native void initIDs();

    protected String paramString() {
        String string = ",align=";
        switch (this.alignment) {
            case 0: {
                string = String.valueOf(string) + "left";
                break;
            }
            case 1: {
                string = String.valueOf(string) + "center";
                break;
            }
            case 2: {
                string = String.valueOf(string) + "right";
                break;
            }
        }
        return String.valueOf(super.paramString()) + string + ",text=" + this.text;
    }

    public synchronized void setAlignment(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: {
                this.alignment = n;
                LabelPeer labelPeer = (LabelPeer)this.peer;
                if (labelPeer != null) {
                    labelPeer.setAlignment(n);
                }
                return;
            }
        }
        throw new IllegalArgumentException("improper alignment: " + n);
    }

    public void setText(String string) {
        boolean bl = false;
        Label label = this;
        synchronized (label) {
            if (!(string == this.text || this.text != null && this.text.equals(string))) {
                this.text = string;
                LabelPeer labelPeer = (LabelPeer)this.peer;
                if (labelPeer != null) {
                    labelPeer.setText(string);
                }
                bl = true;
            }
        }
        if (bl && this.valid) {
            this.invalidate();
        }
    }
}

