/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.io.Serializable;

public class MenuShortcut
implements Serializable {
    int key;
    boolean usesShift;
    private static final long serialVersionUID = 143448358473180225L;

    public MenuShortcut(int n) {
        this(n, false);
    }

    public MenuShortcut(int n, boolean bl) {
        if (n >= 97 && n <= 122) {
            n = Character.toUpperCase((char)n);
        }
        this.key = n;
        this.usesShift = bl;
    }

    public boolean equals(MenuShortcut menuShortcut) {
        return menuShortcut != null && menuShortcut.getKey() == this.key && menuShortcut.usesShiftModifier() == this.usesShift;
    }

    public boolean equals(Object object) {
        if (object instanceof MenuShortcut) {
            return this.equals((MenuShortcut)object);
        }
        return false;
    }

    public int getKey() {
        return this.key;
    }

    public int hashCode() {
        return this.usesShift ? ~this.key : this.key;
    }

    protected String paramString() {
        String string = "key=" + this.key;
        if (this.usesShiftModifier()) {
            string = String.valueOf(string) + ",usesShiftModifier";
        }
        return string;
    }

    public String toString() {
        int n = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        if (this.usesShiftModifier()) {
            n |= 1;
        }
        return String.valueOf(KeyEvent.getKeyModifiersText(n)) + "+" + KeyEvent.getKeyText(this.key);
    }

    public boolean usesShiftModifier() {
        return this.usesShift;
    }
}

