/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTError;
import java.awt.AWTEventMulticaster;
import java.awt.Adjustable;
import java.awt.ScrollPane;
import java.awt.Toolkit;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.peer.ScrollPanePeer;
import java.io.Serializable;

class ScrollPaneAdjustable
implements Adjustable,
Serializable {
    private ScrollPane sp;
    private int orientation;
    private int minimum;
    private int maximum;
    private int visibleAmount;
    private int unitIncrement = 1;
    private int blockIncrement = 1;
    private int value;
    private AdjustmentListener adjustmentListener;
    private static final String SCROLLPANE_ONLY = "Can be set by scrollpane only";
    private static final long serialVersionUID = -3359745691033257079L;

    static {
        Toolkit.loadLibraries();
        ScrollPaneAdjustable.initIDs();
    }

    public ScrollPaneAdjustable(ScrollPane scrollPane, AdjustmentListener adjustmentListener, int n) {
        this.sp = scrollPane;
        this.orientation = n;
        this.addAdjustmentListener(adjustmentListener);
    }

    public synchronized void addAdjustmentListener(AdjustmentListener adjustmentListener) {
        if (adjustmentListener == null) {
            return;
        }
        this.adjustmentListener = AWTEventMulticaster.add(this.adjustmentListener, adjustmentListener);
    }

    public int getBlockIncrement() {
        return this.blockIncrement;
    }

    public int getMaximum() {
        return this.maximum;
    }

    public int getMinimum() {
        return 0;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public int getUnitIncrement() {
        return this.unitIncrement;
    }

    public int getValue() {
        return this.value;
    }

    public int getVisibleAmount() {
        return this.visibleAmount;
    }

    private static native void initIDs();

    public String paramString() {
        return String.valueOf(this.orientation == 1 ? "vertical," : "horizontal,") + "[0.." + this.maximum + "]," + "val=" + this.value + ",vis=" + this.visibleAmount + ",unit=" + this.unitIncrement + ",block=" + this.blockIncrement;
    }

    public synchronized void removeAdjustmentListener(AdjustmentListener adjustmentListener) {
        if (adjustmentListener == null) {
            return;
        }
        this.adjustmentListener = AWTEventMulticaster.remove(this.adjustmentListener, adjustmentListener);
    }

    public synchronized void setBlockIncrement(int n) {
        this.blockIncrement = n;
    }

    public void setMaximum(int n) {
        throw new AWTError(SCROLLPANE_ONLY);
    }

    public void setMinimum(int n) {
        throw new AWTError(SCROLLPANE_ONLY);
    }

    void setSpan(int n, int n2, int n3) {
        this.minimum = n;
        this.maximum = Math.max(n2, this.minimum + 1);
        this.visibleAmount = Math.min(n3, this.maximum - this.minimum);
        this.visibleAmount = Math.max(this.visibleAmount, 1);
        this.blockIncrement = Math.max((int)((double)n3 * 0.9), 1);
        this.setValue(this.value);
    }

    public synchronized void setUnitIncrement(int n) {
        if (n != this.unitIncrement) {
            this.unitIncrement = n;
            if (this.sp.peer != null) {
                ScrollPanePeer scrollPanePeer = (ScrollPanePeer)this.sp.peer;
                scrollPanePeer.setUnitIncrement(this, n);
            }
        }
    }

    public void setValue(int n) {
        n = Math.max(n, this.minimum);
        if ((n = Math.min(n, this.maximum - this.visibleAmount)) != this.value) {
            this.value = n;
            AdjustmentEvent adjustmentEvent = new AdjustmentEvent(this, 601, 5, this.value);
            this.adjustmentListener.adjustmentValueChanged(adjustmentEvent);
        }
    }

    public void setVisibleAmount(int n) {
        throw new AWTError(SCROLLPANE_ONLY);
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[" + this.paramString() + "]";
    }
}

