/*
 * Decompiled with CFR 0.152.
 */
package java.awt.datatransfer;

import java.awt.datatransfer.MimeType;
import java.awt.datatransfer.MimeTypeParameterList;
import java.awt.datatransfer.MimeTypeParseException;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class DataFlavor
implements Externalizable,
Cloneable {
    static final long serialVersionUID = 8367026044764648243L;
    static final Class ioInputStreamClass = class$java$io$InputStream != null ? class$java$io$InputStream : (class$java$io$InputStream = DataFlavor.class$("java.io.InputStream"));
    public static final DataFlavor stringFlavor = DataFlavor.createConstant(class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = DataFlavor.class$("java.lang.String")), "Unicode String");
    public static final DataFlavor plainTextFlavor = DataFlavor.createConstant("text/plain; charset=unicode; class=java.io.InputStream", "Plain Text");
    public static final String javaSerializedObjectMimeType = "application/x-java-serialized-object";
    public static final DataFlavor javaFileListFlavor = DataFlavor.createConstant("application/x-java-file-list;class=java.util.List", null);
    public static final String javaJVMLocalObjectMimeType = "application/x-java-jvm-local-objectref";
    public static final String javaRemoteObjectMimeType = "application/x-java-remote-object";
    transient int atom;
    MimeType mimeType;
    private String humanPresentableName;
    private Class representationClass;
    static /* synthetic */ Class class$java$io$InputStream;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$io$Serializable;
    static /* synthetic */ Class class$java$rmi$Remote;
    static /* synthetic */ Class class$java$util$List;

    public DataFlavor() {
    }

    private DataFlavor(MimeType mimeType, Class clazz, String string, int n) {
        this.mimeType = mimeType;
        this.representationClass = clazz;
        this.humanPresentableName = string;
        this.atom = n;
    }

    public DataFlavor(Class clazz, String string) {
        this("application", "x-java-serialized-object", null, clazz, string);
    }

    public DataFlavor(String string) throws ClassNotFoundException {
        try {
            this.initialize(string, null, this.getClass().getClassLoader());
        }
        catch (MimeTypeParseException mimeTypeParseException) {
            throw new IllegalArgumentException("failed to parse:" + string);
        }
    }

    public DataFlavor(String string, String string2) {
        try {
            this.initialize(string, string2, this.getClass().getClassLoader());
        }
        catch (MimeTypeParseException mimeTypeParseException) {
            throw new IllegalArgumentException("failed to parse:" + string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalArgumentException("cant find specified class: " + classNotFoundException.getMessage());
        }
    }

    private DataFlavor(String string, String string2, MimeTypeParameterList mimeTypeParameterList, Class clazz, String string3) {
        if (mimeTypeParameterList == null) {
            mimeTypeParameterList = new MimeTypeParameterList();
        }
        mimeTypeParameterList.set("class", clazz.getName());
        if (string3 == null && (string3 = mimeTypeParameterList.get("humanPresentableName")) == null) {
            string3 = String.valueOf(string) + "/" + string2;
        }
        try {
            this.mimeType = new MimeType(string, string2, mimeTypeParameterList);
        }
        catch (MimeTypeParseException mimeTypeParseException) {
            throw new IllegalArgumentException("MimeType Parse Exception: " + mimeTypeParseException.getMessage());
        }
        this.representationClass = clazz;
        this.humanPresentableName = string3;
        this.mimeType.removeParameter("humanPresentableName");
    }

    public DataFlavor(String string, String string2, ClassLoader classLoader) throws ClassNotFoundException {
        try {
            this.initialize(string, string2, classLoader);
        }
        catch (MimeTypeParseException mimeTypeParseException) {
            throw new IllegalArgumentException("failed to parse:" + string);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public Object clone() throws CloneNotSupportedException {
        if (this.mimeType == null) {
            return new DataFlavor(null, this.representationClass, this.humanPresentableName, this.atom);
        }
        return new DataFlavor((MimeType)this.mimeType.clone(), this.representationClass, this.humanPresentableName, this.atom);
    }

    private static DataFlavor createConstant(Class clazz, String string) {
        try {
            return new DataFlavor(clazz, string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static DataFlavor createConstant(String string, String string2) {
        try {
            return new DataFlavor(string, string2);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean equals(DataFlavor dataFlavor) {
        if (dataFlavor == null) {
            return false;
        }
        if (this.representationClass == null) {
            if (dataFlavor.getRepresentationClass() != null) {
                return false;
            }
            if (this.mimeType == null) {
                return dataFlavor.mimeType == null;
            }
            return this.mimeType.match(dataFlavor.mimeType);
        }
        if (this.mimeType == null) {
            return this.representationClass.equals(dataFlavor.getRepresentationClass()) && dataFlavor.mimeType == null;
        }
        return this.mimeType.match(dataFlavor.mimeType) && this.representationClass.equals(dataFlavor.getRepresentationClass());
    }

    public boolean equals(Object object) {
        return object instanceof DataFlavor && this.equals((DataFlavor)object) || object instanceof String && this.equals((String)object);
    }

    public boolean equals(String string) {
        if (string == null || this.mimeType == null) {
            return false;
        }
        return this.isMimeTypeEqual(string);
    }

    public String getHumanPresentableName() {
        return this.humanPresentableName;
    }

    public String getMimeType() {
        return this.mimeType.toString();
    }

    public String getParameter(String string) {
        return string.equals("humanPresentableName") ? this.humanPresentableName : this.mimeType.getParameter(string);
    }

    public String getPrimaryType() {
        return this.mimeType.getPrimaryType();
    }

    public Class getRepresentationClass() {
        return this.representationClass;
    }

    public String getSubType() {
        return this.mimeType.getSubType();
    }

    private void initialize(String string, String string2, ClassLoader classLoader) throws MimeTypeParseException, ClassNotFoundException {
        this.mimeType = new MimeType(string);
        String string3 = this.getParameter("class");
        if (string3 == null) {
            if (javaSerializedObjectMimeType.equals(this.mimeType.getBaseType())) {
                throw new IllegalArgumentException("no representation class specified for:" + string);
            }
            this.representationClass = class$java$io$InputStream != null ? class$java$io$InputStream : (class$java$io$InputStream = DataFlavor.class$("java.io.InputStream"));
        } else {
            this.representationClass = DataFlavor.tryToLoadClass(string3, classLoader);
        }
        this.mimeType.setParameter("class", this.representationClass.getName());
        if (string2 == null && (string2 = this.mimeType.getParameter("humanPresentableName")) == null) {
            string2 = String.valueOf(this.mimeType.getPrimaryType()) + "/" + this.mimeType.getSubType();
        }
        this.humanPresentableName = string2;
        this.mimeType.removeParameter("humanPresentableName");
    }

    public boolean isFlavorJavaFileListType() {
        if (this.mimeType == null || this.representationClass == null) {
            return false;
        }
        return (class$java$util$List != null ? class$java$util$List : (class$java$util$List = DataFlavor.class$("java.util.List"))).isAssignableFrom(this.representationClass) && this.mimeType.match(DataFlavor.javaFileListFlavor.mimeType);
    }

    public boolean isFlavorRemoteObjectType() {
        return this.isRepresentationClassRemote() && this.isRepresentationClassSerializable() && this.equals(javaRemoteObjectMimeType);
    }

    public boolean isFlavorSerializedObjectType() {
        return this.isRepresentationClassSerializable() && this.equals(javaSerializedObjectMimeType);
    }

    public final boolean isMimeTypeEqual(DataFlavor dataFlavor) {
        return this.isMimeTypeEqual(dataFlavor.mimeType);
    }

    private boolean isMimeTypeEqual(MimeType mimeType) {
        return this.mimeType.match(mimeType);
    }

    public boolean isMimeTypeEqual(String string) {
        try {
            return this.mimeType.match(new MimeType(string));
        }
        catch (MimeTypeParseException mimeTypeParseException) {
            return false;
        }
    }

    public boolean isMimeTypeSerializedObject() {
        if (this.mimeType == null) {
            return false;
        }
        return this.isMimeTypeEqual(javaSerializedObjectMimeType);
    }

    public boolean isRepresentationClassInputStream() {
        return ioInputStreamClass.isAssignableFrom(this.representationClass);
    }

    public boolean isRepresentationClassRemote() {
        return (class$java$rmi$Remote != null ? class$java$rmi$Remote : (class$java$rmi$Remote = DataFlavor.class$("java.rmi.Remote"))).isAssignableFrom(this.representationClass);
    }

    public boolean isRepresentationClassSerializable() {
        return (class$java$io$Serializable != null ? class$java$io$Serializable : (class$java$io$Serializable = DataFlavor.class$("java.io.Serializable"))).isAssignableFrom(this.representationClass);
    }

    protected String normalizeMimeType(String string) {
        return string;
    }

    protected String normalizeMimeTypeParameter(String string, String string2) {
        return String.valueOf(string) + "=" + string2;
    }

    private String paramString() {
        String string = "";
        string = String.valueOf(string) + "representationclass=";
        string = this.representationClass == null ? String.valueOf(string) + "null" : String.valueOf(string) + this.representationClass.getName();
        string = String.valueOf(string) + ",mimetype=[" + this.getMimeType() + "]";
        return string;
    }

    public synchronized void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.mimeType = (MimeType)objectInput.readObject();
        this.humanPresentableName = this.mimeType.getParameter("humanPresentableName");
        this.mimeType.removeParameter("humanPresentableName");
        String string = this.mimeType.getParameter("class");
        if (string == null) {
            throw new IOException("no class parameter specified in: " + this.mimeType);
        }
        DataFlavor.tryToLoadClass(string, this.getClass().getClassLoader());
    }

    public void setHumanPresentableName(String string) {
        this.humanPresentableName = string;
    }

    public String toString() {
        String string = this.getClass().getName();
        string = String.valueOf(string) + "[" + this.paramString() + "]";
        return string;
    }

    protected static final Class tryToLoadClass(String string, ClassLoader classLoader) throws ClassNotFoundException {
        ClassLoader classLoader2 = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                return classLoader != null ? classLoader : ClassLoader.getSystemClassLoader();
            }
        });
        try {
            return Class.forName(string, true, classLoader2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (classLoader != null) {
                return Class.forName(string, true, classLoader);
            }
            throw new ClassNotFoundException(string);
        }
    }

    public synchronized void writeExternal(ObjectOutput objectOutput) throws IOException {
        this.mimeType.setParameter("humanPresentableName", this.humanPresentableName);
        objectOutput.writeObject(this.mimeType);
        this.mimeType.removeParameter("humanPresentableName");
    }
}

