/*
 * Decompiled with CFR 0.152.
 */
package java.awt.datatransfer;

import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.io.StringReader;

public class StringSelection
implements Transferable,
ClipboardOwner {
    static final int STRING = 0;
    static final int PLAIN_TEXT = 1;
    DataFlavor[] flavors = new DataFlavor[]{DataFlavor.stringFlavor, DataFlavor.plainTextFlavor};
    private String data;

    public StringSelection(String string) {
        this.data = string;
    }

    public synchronized Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        if (dataFlavor.equals(this.flavors[0])) {
            return this.data;
        }
        if (dataFlavor.equals(this.flavors[1])) {
            return new StringReader(this.data);
        }
        throw new UnsupportedFlavorException(dataFlavor);
    }

    public synchronized DataFlavor[] getTransferDataFlavors() {
        return this.flavors;
    }

    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        return dataFlavor.equals(this.flavors[0]) || dataFlavor.equals(this.flavors[1]);
    }

    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }
}

