/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RasterOp;
import java.awt.image.WritableRaster;
import sun.awt.color.ICC_Transform;
import sun.awt.color.ProfileDeferralMgr;

public class ColorConvertOp
implements BufferedImageOp,
RasterOp {
    ICC_Profile[] profileList;
    ColorSpace[] CSList;
    ICC_Transform thisTransform;
    ICC_Transform thisRasterTransform;
    ICC_Profile thisSrcProfile;
    ICC_Profile thisDestProfile;
    RenderingHints hints;
    boolean gotProfiles;

    static {
        if (ProfileDeferralMgr.deferring) {
            ProfileDeferralMgr.activateProfiles();
        }
    }

    public ColorConvertOp(RenderingHints renderingHints) {
        this.profileList = new ICC_Profile[0];
        this.hints = renderingHints;
    }

    public ColorConvertOp(ColorSpace colorSpace, RenderingHints renderingHints) {
        if (colorSpace instanceof ICC_ColorSpace) {
            this.profileList = new ICC_Profile[1];
            this.profileList[0] = ((ICC_ColorSpace)colorSpace).getProfile();
        } else {
            this.CSList = new ColorSpace[1];
            this.CSList[0] = colorSpace;
        }
        this.hints = renderingHints;
    }

    public ColorConvertOp(ColorSpace colorSpace, ColorSpace colorSpace2, RenderingHints renderingHints) {
        if (colorSpace instanceof ICC_ColorSpace && colorSpace2 instanceof ICC_ColorSpace) {
            this.profileList = new ICC_Profile[2];
            this.profileList[0] = ((ICC_ColorSpace)colorSpace).getProfile();
            this.profileList[1] = ((ICC_ColorSpace)colorSpace2).getProfile();
        } else {
            this.CSList = new ColorSpace[2];
            this.CSList[0] = colorSpace;
            this.CSList[1] = colorSpace2;
        }
        this.hints = renderingHints;
    }

    public ColorConvertOp(ICC_Profile[] iCC_ProfileArray, RenderingHints renderingHints) {
        this.gotProfiles = true;
        this.profileList = new ICC_Profile[iCC_ProfileArray.length];
        int n = 0;
        while (n < iCC_ProfileArray.length) {
            this.profileList[n] = iCC_ProfileArray[n];
            ++n;
        }
        this.hints = renderingHints;
    }

    private final BufferedImage ICCBIFilter(BufferedImage bufferedImage, ColorSpace colorSpace, BufferedImage bufferedImage2, ColorSpace colorSpace2) {
        int n;
        int n2 = this.profileList.length;
        ICC_Profile iCC_Profile = null;
        ICC_Profile iCC_Profile2 = null;
        iCC_Profile = ((ICC_ColorSpace)colorSpace).getProfile();
        if (bufferedImage2 == null) {
            if (n2 == 0) {
                throw new IllegalArgumentException("Destination ColorSpace is undefined");
            }
            n = n2 + 1;
            iCC_Profile2 = this.profileList[n2 - 1];
            bufferedImage2 = this.createCompatibleDestImage(bufferedImage, null);
        } else {
            if (bufferedImage.getHeight() != bufferedImage2.getHeight() || bufferedImage.getWidth() != bufferedImage2.getWidth()) {
                throw new IllegalArgumentException("Width or height of BufferedImages do not match");
            }
            n = n2 + 2;
            iCC_Profile2 = ((ICC_ColorSpace)colorSpace2).getProfile();
        }
        if (this.thisTransform == null || this.thisSrcProfile != iCC_Profile || this.thisDestProfile != iCC_Profile2) {
            ICC_Profile[] iCC_ProfileArray = new ICC_Profile[n];
            iCC_ProfileArray[0] = iCC_Profile;
            int n3 = 1;
            while (n3 < n - 1) {
                iCC_ProfileArray[n3] = this.profileList[n3 - 1];
                ++n3;
            }
            iCC_ProfileArray[n - 1] = iCC_Profile2;
            ICC_Transform[] iCC_TransformArray = new ICC_Transform[n];
            int n4 = iCC_ProfileArray[0].getProfileClass() == 2 ? 1 : 0;
            int n5 = 1;
            n3 = 0;
            while (n3 < n) {
                if (n3 == n - 1) {
                    n5 = 2;
                } else if (n5 == 4 && iCC_ProfileArray[n3].getProfileClass() == 5) {
                    n4 = 0;
                    n5 = 1;
                }
                iCC_TransformArray[n3] = new ICC_Transform(iCC_ProfileArray[n3], n4, n5);
                n4 = this.getRenderingIntent(iCC_ProfileArray[n3]);
                n5 = 4;
                ++n3;
            }
            this.thisTransform = new ICC_Transform(iCC_TransformArray);
            this.thisSrcProfile = iCC_Profile;
            this.thisDestProfile = iCC_Profile2;
        }
        this.thisTransform.colorConvert(bufferedImage, bufferedImage2);
        return bufferedImage2;
    }

    private void convertBIfromCIEXYZ(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        WritableRaster writableRaster = bufferedImage.getRaster();
        WritableRaster writableRaster2 = bufferedImage2.getRaster();
        int n = bufferedImage.getColorModel().getNumColorComponents();
        int n2 = bufferedImage2.getColorModel().getNumColorComponents();
        int[] nArray = null;
        int[] nArray2 = new int[n2];
        float[] fArray = new float[n];
        float[] fArray2 = null;
        int[] nArray3 = bufferedImage.getColorModel().getComponentSize();
        int[] nArray4 = bufferedImage2.getColorModel().getComponentSize();
        float[] fArray3 = new float[n];
        float[] fArray4 = new float[n2];
        ColorSpace colorSpace = bufferedImage2.getColorModel().getColorSpace();
        int n3 = writableRaster.getHeight();
        int n4 = writableRaster.getWidth();
        int n5 = 0;
        while (n5 < n) {
            fArray3[n5] = (1 << nArray3[n5]) - 1;
            ++n5;
        }
        int n6 = 0;
        while (n6 < n2) {
            fArray4[n6] = (1 << nArray4[n6]) - 1;
            ++n6;
        }
        int n7 = writableRaster.getMinY();
        int n8 = writableRaster2.getMinY();
        int n9 = 0;
        while (n9 < n3) {
            int n10 = writableRaster.getMinX();
            int n11 = writableRaster2.getMinX();
            int n12 = 0;
            while (n12 < n4) {
                nArray = writableRaster.getPixel(n10, n7, nArray);
                int n13 = 0;
                while (n13 < n) {
                    fArray[n13] = (float)nArray[n13] / fArray3[n13];
                    ++n13;
                }
                fArray2 = colorSpace.fromCIEXYZ(fArray);
                int n14 = 0;
                while (n14 < n2) {
                    nArray2[n14] = (int)(fArray2[n14] * fArray4[n14]);
                    ++n14;
                }
                writableRaster2.setPixel(n11, n8, nArray2);
                ++n12;
                ++n10;
                ++n11;
            }
            ++n9;
            ++n7;
            ++n8;
        }
    }

    private void convertBItoBI(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        WritableRaster writableRaster = bufferedImage.getRaster();
        WritableRaster writableRaster2 = bufferedImage2.getRaster();
        int n = bufferedImage.getColorModel().getNumColorComponents();
        int n2 = bufferedImage2.getColorModel().getNumColorComponents();
        int[] nArray = null;
        int[] nArray2 = new int[n2];
        float[] fArray = new float[n];
        float[] fArray2 = null;
        float[] fArray3 = null;
        int[] nArray3 = bufferedImage.getColorModel().getComponentSize();
        int[] nArray4 = bufferedImage2.getColorModel().getComponentSize();
        float[] fArray4 = new float[n];
        float[] fArray5 = new float[n2];
        ColorSpace colorSpace = bufferedImage.getColorModel().getColorSpace();
        ColorSpace colorSpace2 = bufferedImage2.getColorModel().getColorSpace();
        int n3 = writableRaster.getHeight();
        int n4 = writableRaster.getWidth();
        int n5 = 0;
        while (n5 < n) {
            fArray4[n5] = (1 << nArray3[n5]) - 1;
            ++n5;
        }
        int n6 = 0;
        while (n6 < n2) {
            fArray5[n6] = (1 << nArray4[n6]) - 1;
            ++n6;
        }
        int n7 = writableRaster.getMinY();
        int n8 = writableRaster2.getMinY();
        int n9 = 0;
        while (n9 < n3) {
            int n10 = writableRaster.getMinX();
            int n11 = writableRaster2.getMinX();
            int n12 = 0;
            while (n12 < n4) {
                nArray = writableRaster.getPixel(n10, n7, nArray);
                int n13 = 0;
                while (n13 < n) {
                    fArray[n13] = (float)nArray[n13] / fArray4[n13];
                    ++n13;
                }
                fArray3 = colorSpace.toCIEXYZ(fArray);
                fArray2 = colorSpace2.fromCIEXYZ(fArray3);
                int n14 = 0;
                while (n14 < n2) {
                    nArray2[n14] = (int)(fArray2[n14] * fArray5[n14]);
                    ++n14;
                }
                writableRaster2.setPixel(n11, n8, nArray2);
                ++n12;
                ++n10;
                ++n11;
            }
            ++n9;
            ++n7;
            ++n8;
        }
    }

    private void convertBItoCIEXYZ(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        WritableRaster writableRaster = bufferedImage.getRaster();
        WritableRaster writableRaster2 = bufferedImage2.getRaster();
        int n = bufferedImage.getColorModel().getNumColorComponents();
        int n2 = bufferedImage2.getColorModel().getNumColorComponents();
        int[] nArray = null;
        int[] nArray2 = new int[n2];
        float[] fArray = new float[n];
        float[] fArray2 = null;
        int[] nArray3 = bufferedImage.getColorModel().getComponentSize();
        int[] nArray4 = bufferedImage2.getColorModel().getComponentSize();
        float[] fArray3 = new float[n];
        float[] fArray4 = new float[n2];
        ColorSpace colorSpace = bufferedImage.getColorModel().getColorSpace();
        int n3 = writableRaster.getHeight();
        int n4 = writableRaster.getWidth();
        int n5 = 0;
        while (n5 < n) {
            fArray3[n5] = (1 << nArray3[n5]) - 1;
            ++n5;
        }
        int n6 = 0;
        while (n6 < n2) {
            fArray4[n6] = (1 << nArray4[n6]) - 1;
            ++n6;
        }
        int n7 = writableRaster.getMinY();
        int n8 = writableRaster2.getMinY();
        int n9 = 0;
        while (n9 < n3) {
            int n10 = writableRaster.getMinX();
            int n11 = writableRaster2.getMinX();
            int n12 = 0;
            while (n12 < n4) {
                nArray = writableRaster.getPixel(n10, n7, nArray);
                int n13 = 0;
                while (n13 < n) {
                    fArray[n13] = (float)nArray[n13] / fArray3[n13];
                    ++n13;
                }
                fArray2 = colorSpace.toCIEXYZ(fArray);
                int n14 = 0;
                while (n14 < n2) {
                    nArray2[n14] = (int)(fArray2[n14] * fArray4[n14]);
                    ++n14;
                }
                writableRaster2.setPixel(n11, n8, nArray2);
                ++n12;
                ++n10;
                ++n11;
            }
            ++n9;
            ++n7;
            ++n8;
        }
    }

    public BufferedImage createCompatibleDestImage(BufferedImage bufferedImage, ColorModel colorModel) {
        ColorSpace colorSpace = null;
        if (colorModel == null) {
            if (this.CSList == null) {
                int n = this.profileList.length;
                if (n == 0) {
                    throw new IllegalArgumentException("Destination ColorSpace is undefined");
                }
                ICC_Profile iCC_Profile = this.profileList[n - 1];
                colorSpace = new ICC_ColorSpace(iCC_Profile);
            } else {
                int n = this.CSList.length;
                colorSpace = this.CSList[n - 1];
            }
        }
        return this.createCompatibleDestImage(bufferedImage, colorModel, colorSpace);
    }

    private BufferedImage createCompatibleDestImage(BufferedImage bufferedImage, ColorModel colorModel, ColorSpace colorSpace) {
        int n;
        if (colorModel == null) {
            ColorModel colorModel2 = bufferedImage.getColorModel();
            n = colorSpace.getNumComponents();
            boolean bl = colorModel2.hasAlpha();
            if (bl) {
                ++n;
            }
            int[] nArray = new int[n];
            int n2 = 0;
            while (n2 < n) {
                nArray[n2] = 8;
                ++n2;
            }
            colorModel = new ComponentColorModel(colorSpace, nArray, bl, colorModel2.isAlphaPremultiplied(), colorModel2.getTransparency(), 0);
        }
        int n3 = bufferedImage.getWidth();
        n = bufferedImage.getHeight();
        BufferedImage bufferedImage2 = new BufferedImage(colorModel, colorModel.createCompatibleWritableRaster(n3, n), colorModel.isAlphaPremultiplied(), null);
        return bufferedImage2;
    }

    public WritableRaster createCompatibleDestRaster(Raster raster) {
        int n;
        if (this.CSList != null) {
            if (this.CSList.length != 2) {
                throw new IllegalArgumentException("Destination ColorSpace is undefined");
            }
            n = this.CSList[1].getNumComponents();
        } else {
            int n2 = this.profileList.length;
            if (n2 < 2) {
                throw new IllegalArgumentException("Destination ColorSpace is undefined");
            }
            n = this.profileList[n2 - 1].getNumComponents();
        }
        WritableRaster writableRaster = Raster.createInterleavedRaster(0, raster.getWidth(), raster.getHeight(), n, new Point(raster.getMinX(), raster.getMinY()));
        return writableRaster;
    }

    public final BufferedImage filter(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        ColorSpace colorSpace;
        Object object;
        BufferedImage bufferedImage3 = null;
        if (bufferedImage.getColorModel() instanceof IndexColorModel) {
            object = (IndexColorModel)bufferedImage.getColorModel();
            bufferedImage = ((IndexColorModel)object).convertToIntDiscrete(bufferedImage.getRaster(), true);
        }
        ColorSpace colorSpace2 = bufferedImage.getColorModel().getColorSpace();
        if (bufferedImage2 != null) {
            if (bufferedImage2.getColorModel() instanceof IndexColorModel) {
                bufferedImage3 = bufferedImage2;
                bufferedImage2 = null;
                colorSpace = null;
            } else {
                colorSpace = bufferedImage2.getColorModel().getColorSpace();
            }
        } else {
            colorSpace = null;
        }
        bufferedImage2 = this.CSList != null || !(colorSpace2 instanceof ICC_ColorSpace) || bufferedImage2 != null && !(colorSpace instanceof ICC_ColorSpace) ? this.nonICCBIFilter(bufferedImage, colorSpace2, bufferedImage2, colorSpace) : this.ICCBIFilter(bufferedImage, colorSpace2, bufferedImage2, colorSpace);
        if (bufferedImage3 != null) {
            object = bufferedImage3.createGraphics();
            ((Graphics)object).drawImage(bufferedImage2, 0, 0, null);
            return bufferedImage3;
        }
        return bufferedImage2;
    }

    public final WritableRaster filter(Raster raster, WritableRaster writableRaster) {
        if (this.CSList != null) {
            return this.nonICCRasterFilter(raster, writableRaster);
        }
        int n = this.profileList.length;
        if (n < 2) {
            throw new IllegalArgumentException("Source or Destination ColorSpace is undefined");
        }
        if (raster.getNumBands() != this.profileList[0].getNumComponents()) {
            throw new IllegalArgumentException("Numbers of source Raster bands and source color space components do not match");
        }
        if (writableRaster == null) {
            writableRaster = this.createCompatibleDestRaster(raster);
        } else {
            if (raster.getHeight() != writableRaster.getHeight() || raster.getWidth() != writableRaster.getWidth()) {
                throw new IllegalArgumentException("Width or height of Rasters do not match");
            }
            if (writableRaster.getNumBands() != this.profileList[n - 1].getNumComponents()) {
                throw new IllegalArgumentException("Numbers of destination Raster bands and destination color space components do not match");
            }
        }
        if (this.thisRasterTransform == null) {
            ICC_Transform[] iCC_TransformArray = new ICC_Transform[n];
            int n2 = this.profileList[0].getProfileClass() == 2 ? 1 : 0;
            int n3 = 1;
            int n4 = 0;
            while (n4 < n) {
                if (n4 == n - 1) {
                    n3 = 2;
                } else if (n3 == 4 && this.profileList[n4].getProfileClass() == 5) {
                    n2 = 0;
                    n3 = 1;
                }
                iCC_TransformArray[n4] = new ICC_Transform(this.profileList[n4], n2, n3);
                n2 = this.getRenderingIntent(this.profileList[n4]);
                n3 = 4;
                ++n4;
            }
            this.thisRasterTransform = new ICC_Transform(iCC_TransformArray);
        }
        this.thisRasterTransform.colorConvert(raster, writableRaster);
        return writableRaster;
    }

    private void fixDestAlpha(BufferedImage bufferedImage, BufferedImage bufferedImage2, boolean bl, boolean bl2, ColorModel colorModel) {
        if (bl && bufferedImage != bufferedImage2) {
            WritableRaster writableRaster = bufferedImage.getRaster();
            WritableRaster writableRaster2 = bufferedImage2.getRaster();
            int n = writableRaster.getNumBands() - 1;
            int n2 = writableRaster2.getNumBands() - 1;
            int n3 = writableRaster2.getMinX();
            int n4 = writableRaster2.getMinY();
            int n5 = writableRaster.getMinX();
            int n6 = writableRaster.getMinY();
            int n7 = n5 + writableRaster.getWidth();
            int n8 = n6 + writableRaster.getHeight();
            int n9 = bufferedImage.getColorModel().getComponentSize(n);
            int n10 = bufferedImage2.getColorModel().getComponentSize(n2);
            int n11 = n10 - n9;
            int n12 = -n11;
            int n13 = n6;
            while (n13 < n8) {
                int n14;
                int n15;
                if (n11 > 0) {
                    n15 = n5;
                    while (n15 < n7) {
                        n14 = writableRaster.getSample(n15, n13, n);
                        writableRaster2.setSample(n3, n4, n2, n14 <<= n11);
                        ++n15;
                        ++n3;
                    }
                } else if (n11 == 0) {
                    n15 = n5;
                    while (n15 < n7) {
                        n14 = writableRaster.getSample(n15, n13, n);
                        writableRaster2.setSample(n3, n4, n2, n14);
                        ++n15;
                        ++n3;
                    }
                } else {
                    n15 = n5;
                    while (n15 < n7) {
                        n14 = writableRaster.getSample(n15, n13, n);
                        writableRaster2.setSample(n3, n4, n2, n14 >>>= n12);
                        ++n15;
                        ++n3;
                    }
                }
                ++n13;
                ++n4;
            }
            if (bl2) {
                colorModel.coerceData(writableRaster2, true);
            }
        } else if (!bl) {
            WritableRaster writableRaster = bufferedImage2.getRaster();
            int n = writableRaster.getNumBands() - 1;
            int n16 = writableRaster.getMinX();
            int n17 = writableRaster.getMinY();
            int n18 = n16 + writableRaster.getWidth();
            int n19 = n17 + writableRaster.getHeight();
            int n20 = (1 << bufferedImage2.getColorModel().getComponentSize(n)) - 1;
            int n21 = n17;
            while (n21 < n19) {
                int n22 = n16;
                while (n22 < n18) {
                    writableRaster.setSample(n22, n21, n, n20);
                    ++n22;
                }
                ++n21;
            }
        }
    }

    public final Rectangle2D getBounds2D(BufferedImage bufferedImage) {
        return this.getBounds2D(bufferedImage.getRaster());
    }

    public final Rectangle2D getBounds2D(Raster raster) {
        return raster.getBounds();
    }

    public final ICC_Profile[] getICC_Profiles() {
        if (this.gotProfiles) {
            ICC_Profile[] iCC_ProfileArray = new ICC_Profile[this.profileList.length];
            int n = 0;
            while (n < this.profileList.length) {
                iCC_ProfileArray[n] = this.profileList[n];
                ++n;
            }
            return iCC_ProfileArray;
        }
        return null;
    }

    public final Point2D getPoint2D(Point2D point2D, Point2D point2D2) {
        if (point2D2 == null) {
            point2D2 = new Point2D.Float();
        }
        point2D2.setLocation(point2D.getX(), point2D.getY());
        return point2D2;
    }

    public final RenderingHints getRenderingHints() {
        return this.hints;
    }

    private int getRenderingIntent(ICC_Profile iCC_Profile) {
        byte[] byArray = iCC_Profile.getData(1751474532);
        int n = 64;
        return (byArray[n] & 0xFF) << 24 | (byArray[n + 1] & 0xFF) << 16 | (byArray[n + 2] & 0xFF) << 8 | byArray[n + 3] & 0xFF;
    }

    private final BufferedImage nonICCBIFilter(BufferedImage bufferedImage, ColorSpace colorSpace, BufferedImage bufferedImage2, ColorSpace colorSpace2) {
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        ColorModel colorModel = bufferedImage.getColorModel();
        boolean bl = colorModel.hasAlpha();
        boolean bl2 = false;
        ColorModel colorModel2 = null;
        BufferedImage bufferedImage3 = bufferedImage;
        ColorSpace colorSpace3 = ColorSpace.getInstance(1001);
        if (bl && colorModel.isAlphaPremultiplied()) {
            bl2 = true;
            colorModel2 = colorModel.coerceData(bufferedImage.getRaster(), false);
            bufferedImage3 = new BufferedImage(colorModel2, bufferedImage.getRaster(), false, null);
        }
        if (bufferedImage2 == null) {
            bufferedImage2 = this.createCompatibleDestImage(bufferedImage, null);
            colorSpace2 = bufferedImage2.getColorModel().getColorSpace();
        } else if (n2 != bufferedImage2.getHeight() || n != bufferedImage2.getWidth()) {
            throw new IllegalArgumentException("Width or height of BufferedImages do not match");
        }
        ColorModel colorModel3 = bufferedImage2.getColorModel();
        boolean bl3 = colorModel3.hasAlpha();
        boolean bl4 = false;
        ColorModel colorModel4 = null;
        BufferedImage bufferedImage4 = bufferedImage2;
        if (bl3 && colorModel3.isAlphaPremultiplied()) {
            bl4 = true;
            colorModel4 = bufferedImage != bufferedImage2 ? colorModel3.coerceData(bufferedImage2.getRaster(), false) : colorModel2;
            bufferedImage4 = new BufferedImage(colorModel4, bufferedImage2.getRaster(), false, null);
        }
        if (this.CSList == null && this.profileList.length != 0) {
            BufferedImage bufferedImage5;
            if (!(colorSpace instanceof ICC_ColorSpace)) {
                bufferedImage5 = this.createCompatibleDestImage(bufferedImage3, null, colorSpace3);
                this.convertBItoCIEXYZ(bufferedImage3, bufferedImage5);
            } else {
                bufferedImage5 = bufferedImage3;
            }
            if (!(colorSpace2 instanceof ICC_ColorSpace)) {
                BufferedImage bufferedImage6 = bufferedImage5 != bufferedImage3 ? bufferedImage5 : this.createCompatibleDestImage(bufferedImage3, null, colorSpace3);
                bufferedImage6 = this.ICCBIFilter(bufferedImage5, bufferedImage5.getColorModel().getColorSpace(), bufferedImage6, colorSpace3);
                this.convertBIfromCIEXYZ(bufferedImage6, bufferedImage4);
            } else {
                this.ICCBIFilter(bufferedImage5, bufferedImage5.getColorModel().getColorSpace(), bufferedImage4, colorSpace2);
            }
        } else {
            int n3;
            ColorSpace[] colorSpaceArray;
            if (this.CSList == null) {
                colorSpaceArray = new ColorSpace[]{colorSpace, colorSpace2};
            } else {
                colorSpaceArray = new ColorSpace[this.CSList.length + 2];
                colorSpaceArray[0] = colorSpace;
                n3 = 0;
                while (n3 < this.CSList.length) {
                    colorSpaceArray[n3 + 1] = this.CSList[n3];
                    ++n3;
                }
                colorSpaceArray[colorSpaceArray.length - 1] = colorSpace2;
            }
            BufferedImage bufferedImage7 = bufferedImage3;
            n3 = 1;
            while (n3 < colorSpaceArray.length) {
                BufferedImage bufferedImage8 = this.createCompatibleDestImage(bufferedImage7, null, colorSpaceArray[n3]);
                this.convertBItoBI(bufferedImage7, bufferedImage8);
                bufferedImage7 = bufferedImage8;
                ++n3;
            }
        }
        if (bl && bl2) {
            colorModel2.coerceData(bufferedImage.getRaster(), true);
        }
        if (bl3) {
            this.fixDestAlpha(bufferedImage, bufferedImage2, bl, bl4, colorModel4);
        }
        return bufferedImage2;
    }

    private final WritableRaster nonICCRasterFilter(Raster raster, WritableRaster writableRaster) {
        if (this.CSList.length != 2) {
            throw new IllegalArgumentException("Destination ColorSpace is undefined");
        }
        if (raster.getNumBands() != this.CSList[0].getNumComponents()) {
            throw new IllegalArgumentException("Numbers of source Raster bands and source color space components do not match");
        }
        if (writableRaster == null) {
            writableRaster = this.createCompatibleDestRaster(raster);
        } else {
            if (raster.getHeight() != writableRaster.getHeight() || raster.getWidth() != writableRaster.getWidth()) {
                throw new IllegalArgumentException("Width or height of Rasters do not match");
            }
            if (writableRaster.getNumBands() != this.CSList[1].getNumComponents()) {
                throw new IllegalArgumentException("Numbers of destination Raster bands and destination color space components do not match");
            }
        }
        int n = raster.getNumBands();
        int n2 = writableRaster.getNumBands();
        int[] nArray = null;
        int[] nArray2 = new int[n2];
        float[] fArray = new float[n];
        float[] fArray2 = null;
        float[] fArray3 = null;
        int[] nArray3 = raster.getSampleModel().getSampleSize();
        int[] nArray4 = writableRaster.getSampleModel().getSampleSize();
        float[] fArray4 = new float[n];
        float[] fArray5 = new float[n2];
        int n3 = raster.getHeight();
        int n4 = raster.getWidth();
        int n5 = 0;
        while (n5 < n) {
            fArray4[n5] = (1 << nArray3[n5]) - 1;
            ++n5;
        }
        int n6 = 0;
        while (n6 < n2) {
            fArray5[n6] = (1 << nArray4[n6]) - 1;
            ++n6;
        }
        int n7 = raster.getMinY();
        int n8 = writableRaster.getMinY();
        int n9 = 0;
        while (n9 < n3) {
            int n10 = raster.getMinX();
            int n11 = writableRaster.getMinX();
            int n12 = 0;
            while (n12 < n4) {
                nArray = raster.getPixel(n10, n7, nArray);
                int n13 = 0;
                while (n13 < n) {
                    fArray[n13] = (float)nArray[n13] / fArray4[n13];
                    ++n13;
                }
                fArray3 = this.CSList[0].toCIEXYZ(fArray);
                fArray2 = this.CSList[1].fromCIEXYZ(fArray3);
                int n14 = 0;
                while (n14 < n2) {
                    nArray2[n14] = (int)(fArray2[n14] * fArray5[n14]);
                    ++n14;
                }
                writableRaster.setPixel(n11, n8, nArray2);
                ++n12;
                ++n10;
                ++n11;
            }
            ++n9;
            ++n7;
            ++n8;
        }
        return writableRaster;
    }
}

