/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.image.ColorModel;
import java.awt.image.ImageFilter;
import java.awt.image.IndexColorModel;

public abstract class RGBImageFilter
extends ImageFilter {
    protected ColorModel origmodel;
    protected ColorModel newmodel;
    protected boolean canFilterIndexColorModel;

    public IndexColorModel filterIndexColorModel(IndexColorModel indexColorModel) {
        int n = indexColorModel.getMapSize();
        byte[] byArray = new byte[n];
        byte[] byArray2 = new byte[n];
        byte[] byArray3 = new byte[n];
        byte[] byArray4 = new byte[n];
        indexColorModel.getReds(byArray);
        indexColorModel.getGreens(byArray2);
        indexColorModel.getBlues(byArray3);
        indexColorModel.getAlphas(byArray4);
        int n2 = indexColorModel.getTransparentPixel();
        boolean bl = false;
        int n3 = 0;
        while (n3 < n) {
            int n4 = this.filterRGB(-1, -1, indexColorModel.getRGB(n3));
            byArray4[n3] = (byte)(n4 >> 24);
            if (byArray4[n3] != -1 && n3 != n2) {
                bl = true;
            }
            byArray[n3] = (byte)(n4 >> 16);
            byArray2[n3] = (byte)(n4 >> 8);
            byArray3[n3] = (byte)n4;
            ++n3;
        }
        if (bl) {
            return new IndexColorModel(indexColorModel.getPixelSize(), n, byArray, byArray2, byArray3, byArray4);
        }
        return new IndexColorModel(indexColorModel.getPixelSize(), n, byArray, byArray2, byArray3, n2);
    }

    public abstract int filterRGB(int var1, int var2, int var3);

    public void filterRGBPixels(int n, int n2, int n3, int n4, int[] nArray, int n5, int n6) {
        int n7 = n5;
        int n8 = 0;
        while (n8 < n4) {
            int n9 = 0;
            while (n9 < n3) {
                nArray[n7] = this.filterRGB(n + n9, n2 + n8, nArray[n7]);
                ++n7;
                ++n9;
            }
            n7 += n6 - n3;
            ++n8;
        }
        this.consumer.setPixels(n, n2, n3, n4, ColorModel.getRGBdefault(), nArray, n5, n6);
    }

    public void setColorModel(ColorModel colorModel) {
        if (this.canFilterIndexColorModel && colorModel instanceof IndexColorModel) {
            IndexColorModel indexColorModel = this.filterIndexColorModel((IndexColorModel)colorModel);
            this.substituteColorModel(colorModel, indexColorModel);
            this.consumer.setColorModel(indexColorModel);
        } else {
            this.consumer.setColorModel(ColorModel.getRGBdefault());
        }
    }

    public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, byte[] byArray, int n5, int n6) {
        if (colorModel == this.origmodel) {
            this.consumer.setPixels(n, n2, n3, n4, this.newmodel, byArray, n5, n6);
        } else {
            int[] nArray = new int[n3];
            int n7 = n5;
            int n8 = 0;
            while (n8 < n4) {
                int n9 = 0;
                while (n9 < n3) {
                    nArray[n9] = colorModel.getRGB(byArray[n7] & 0xFF);
                    ++n7;
                    ++n9;
                }
                n7 += n6 - n3;
                this.filterRGBPixels(n, n2 + n8, n3, 1, nArray, 0, n3);
                ++n8;
            }
        }
    }

    public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, int[] nArray, int n5, int n6) {
        if (colorModel == this.origmodel) {
            this.consumer.setPixels(n, n2, n3, n4, this.newmodel, nArray, n5, n6);
        } else {
            int[] nArray2 = new int[n3];
            int n7 = n5;
            int n8 = 0;
            while (n8 < n4) {
                int n9 = 0;
                while (n9 < n3) {
                    nArray2[n9] = colorModel.getRGB(nArray[n7]);
                    ++n7;
                    ++n9;
                }
                n7 += n6 - n3;
                this.filterRGBPixels(n, n2 + n8, n3, 1, nArray2, 0, n3);
                ++n8;
            }
        }
    }

    public void substituteColorModel(ColorModel colorModel, ColorModel colorModel2) {
        this.origmodel = colorModel;
        this.newmodel = colorModel2;
    }
}

