/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.DataOutput;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UTFDataFormatException;

public class DataOutputStream
extends FilterOutputStream
implements DataOutput {
    protected int written;

    public DataOutputStream(OutputStream outputStream) {
        super(outputStream);
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    private void incCount(int n) {
        int n2 = this.written + n;
        if (n2 < 0) {
            n2 = Integer.MAX_VALUE;
        }
        this.written = n2;
    }

    public final int size() {
        return this.written;
    }

    public synchronized void write(int n) throws IOException {
        this.out.write(n);
        this.incCount(1);
    }

    public synchronized void write(byte[] byArray, int n, int n2) throws IOException {
        this.out.write(byArray, n, n2);
        this.incCount(n2);
    }

    public final void writeBoolean(boolean bl) throws IOException {
        this.out.write(bl ? 1 : 0);
        this.incCount(1);
    }

    public final void writeByte(int n) throws IOException {
        this.out.write(n);
        this.incCount(1);
    }

    public final void writeBytes(String string) throws IOException {
        OutputStream outputStream = this.out;
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            outputStream.write((byte)string.charAt(n2));
            ++n2;
        }
        this.incCount(n);
    }

    public final void writeChar(int n) throws IOException {
        OutputStream outputStream = this.out;
        outputStream.write(n >>> 8 & 0xFF);
        outputStream.write(n & 0xFF);
        this.incCount(2);
    }

    public final void writeChars(String string) throws IOException {
        OutputStream outputStream = this.out;
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            outputStream.write(c >>> 8 & 0xFF);
            outputStream.write(c & 0xFF);
            ++n2;
        }
        this.incCount(n * 2);
    }

    public final void writeDouble(double d) throws IOException {
        this.writeLong(Double.doubleToLongBits(d));
    }

    public final void writeFloat(float f) throws IOException {
        this.writeInt(Float.floatToIntBits(f));
    }

    public final void writeInt(int n) throws IOException {
        OutputStream outputStream = this.out;
        outputStream.write(n >>> 24 & 0xFF);
        outputStream.write(n >>> 16 & 0xFF);
        outputStream.write(n >>> 8 & 0xFF);
        outputStream.write(n & 0xFF);
        this.incCount(4);
    }

    public final void writeLong(long l) throws IOException {
        OutputStream outputStream = this.out;
        outputStream.write((int)(l >>> 56) & 0xFF);
        outputStream.write((int)(l >>> 48) & 0xFF);
        outputStream.write((int)(l >>> 40) & 0xFF);
        outputStream.write((int)(l >>> 32) & 0xFF);
        outputStream.write((int)(l >>> 24) & 0xFF);
        outputStream.write((int)(l >>> 16) & 0xFF);
        outputStream.write((int)(l >>> 8) & 0xFF);
        outputStream.write((int)l & 0xFF);
        this.incCount(8);
    }

    public final void writeShort(int n) throws IOException {
        OutputStream outputStream = this.out;
        outputStream.write(n >>> 8 & 0xFF);
        outputStream.write(n & 0xFF);
        this.incCount(2);
    }

    public final void writeUTF(String string) throws IOException {
        int n;
        OutputStream outputStream = this.out;
        int n2 = string.length();
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            n = string.charAt(n4);
            n3 = n >= 1 && n <= 127 ? ++n3 : (n > 2047 ? (n3 += 3) : (n3 += 2));
            ++n4;
        }
        if (n3 > 65535) {
            throw new UTFDataFormatException();
        }
        outputStream.write(n3 >>> 8 & 0xFF);
        outputStream.write(n3 & 0xFF);
        n = 0;
        while (n < n2) {
            char c = string.charAt(n);
            if (c >= '\u0001' && c <= '\u007f') {
                outputStream.write(c);
            } else if (c > '\u07ff') {
                outputStream.write(0xE0 | c >> 12 & 0xF);
                outputStream.write(0x80 | c >> 6 & 0x3F);
                outputStream.write(0x80 | c & 0x3F);
                this.incCount(2);
            } else {
                outputStream.write(0xC0 | c >> 6 & 0x1F);
                outputStream.write(0x80 | c & 0x3F);
                this.incCount(1);
            }
            ++n;
        }
        this.incCount(n2 + 2);
    }
}

