/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.PipedReader;
import java.io.Writer;

public class PipedWriter
extends Writer {
    private PipedReader sink;

    public PipedWriter() {
    }

    public PipedWriter(PipedReader pipedReader) throws IOException {
        this.connect(pipedReader);
    }

    public void close() throws IOException {
        if (this.sink != null) {
            this.sink.receivedLast();
        }
    }

    public synchronized void connect(PipedReader pipedReader) throws IOException {
        if (pipedReader == null) {
            throw new NullPointerException();
        }
        if (this.sink != null || pipedReader.connected) {
            throw new IOException("Already connected");
        }
        this.sink = pipedReader;
        pipedReader.in = -1;
        pipedReader.out = 0;
        pipedReader.connected = true;
    }

    public synchronized void flush() throws IOException {
        if (this.sink != null) {
            PipedReader pipedReader = this.sink;
            synchronized (pipedReader) {
                this.sink.notifyAll();
            }
        }
    }

    public void write(int n) throws IOException {
        if (this.sink == null) {
            throw new IOException("Pipe not connected");
        }
        this.sink.receive(n);
    }

    public void write(char[] cArray, int n, int n2) throws IOException {
        if (this.sink == null) {
            throw new IOException("Pipe not connected");
        }
        if (n < 0 || n > cArray.length || n2 < 0 || n + n2 > cArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        this.sink.receive(cArray, n, n2);
    }
}

