/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.Serializable;
import java.net.SocketPermission;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Enumeration;
import java.util.Vector;

final class SocketPermissionCollection
extends PermissionCollection
implements Serializable {
    private Vector permissions = new Vector();

    public void add(Permission permission) {
        if (!(permission instanceof SocketPermission)) {
            throw new IllegalArgumentException("invalid permission: " + permission);
        }
        if (this.isReadOnly()) {
            throw new SecurityException("attempt to add a Permission to a readonly PermissionCollection");
        }
        this.permissions.add(0, permission);
    }

    public Enumeration elements() {
        return this.permissions.elements();
    }

    public boolean implies(Permission permission) {
        if (!(permission instanceof SocketPermission)) {
            return false;
        }
        SocketPermission socketPermission = (SocketPermission)permission;
        int n = socketPermission.getMask();
        int n2 = 0;
        int n3 = n;
        Enumeration enumeration = this.permissions.elements();
        while (enumeration.hasMoreElements()) {
            SocketPermission socketPermission2 = (SocketPermission)enumeration.nextElement();
            if ((n3 & socketPermission2.getMask()) == 0 || !socketPermission2.impliesIgnoreMask(socketPermission)) continue;
            if (((n2 |= socketPermission2.getMask()) & n) == n) {
                return true;
            }
            n3 = n ^ n2;
        }
        return false;
    }
}

