/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.net.FactoryURLClassLoader;
import java.net.SocketPermission;
import java.net.URL;
import java.net.URLStreamHandlerFactory;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.SecureClassLoader;
import java.security.cert.Certificate;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import sun.misc.Resource;
import sun.misc.URLClassPath;

public class URLClassLoader
extends SecureClassLoader {
    private URLClassPath ucp;
    private AccessControlContext acc;

    public URLClassLoader(URL[] uRLArray) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkCreateClassLoader();
        }
        this.ucp = new URLClassPath(uRLArray);
        this.acc = AccessController.getContext();
    }

    public URLClassLoader(URL[] uRLArray, ClassLoader classLoader) {
        super(classLoader);
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkCreateClassLoader();
        }
        this.ucp = new URLClassPath(uRLArray);
        this.acc = AccessController.getContext();
    }

    public URLClassLoader(URL[] uRLArray, ClassLoader classLoader, URLStreamHandlerFactory uRLStreamHandlerFactory) {
        super(classLoader);
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkCreateClassLoader();
        }
        this.ucp = new URLClassPath(uRLArray, uRLStreamHandlerFactory);
        this.acc = AccessController.getContext();
    }

    protected void addURL(URL uRL) {
        this.ucp.addURL(uRL);
    }

    private Class defineClass(String string, Resource resource) throws IOException {
        Object object;
        Certificate[] certificateArray;
        Object object2;
        int n = string.lastIndexOf(46);
        URL uRL = resource.getCodeSourceURL();
        if (n != -1) {
            object2 = string.substring(0, n);
            certificateArray = this.getPackage((String)object2);
            object = resource.getManifest();
            if (certificateArray != null) {
                boolean bl;
                if (certificateArray.isSealed()) {
                    bl = certificateArray.isSealed(uRL);
                } else {
                    boolean bl2 = bl = object == null || !this.isSealed((String)object2, (Manifest)object);
                }
                if (!bl) {
                    throw new SecurityException("sealing violation");
                }
            } else if (object != null) {
                this.definePackage((String)object2, (Manifest)object, uRL);
            }
        }
        object2 = resource.getBytes();
        certificateArray = resource.getCertificates();
        object = new CodeSource(uRL, certificateArray);
        return this.defineClass(string, (byte[])object2, 0, ((byte[])object2).length, (CodeSource)object);
    }

    protected Package definePackage(String string, Manifest manifest, URL uRL) throws IllegalArgumentException {
        String string2 = string.replace('.', '/').concat("/");
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        String string9 = null;
        URL uRL2 = null;
        Attributes attributes = manifest.getAttributes(string2);
        if (attributes != null) {
            string3 = attributes.getValue(Attributes.Name.SPECIFICATION_TITLE);
            string4 = attributes.getValue(Attributes.Name.SPECIFICATION_VERSION);
            string5 = attributes.getValue(Attributes.Name.SPECIFICATION_VENDOR);
            string6 = attributes.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
            string7 = attributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
            string8 = attributes.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
            string9 = attributes.getValue(Attributes.Name.SEALED);
        }
        if ((attributes = manifest.getMainAttributes()) != null) {
            if (string3 == null) {
                string3 = attributes.getValue(Attributes.Name.SPECIFICATION_TITLE);
            }
            if (string4 == null) {
                string4 = attributes.getValue(Attributes.Name.SPECIFICATION_VERSION);
            }
            if (string5 == null) {
                string5 = attributes.getValue(Attributes.Name.SPECIFICATION_VENDOR);
            }
            if (string6 == null) {
                string6 = attributes.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
            }
            if (string7 == null) {
                string7 = attributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
            }
            if (string8 == null) {
                string8 = attributes.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
            }
            if (string9 == null) {
                string9 = attributes.getValue(Attributes.Name.SEALED);
            }
        }
        if ("true".equalsIgnoreCase(string9)) {
            uRL2 = uRL;
        }
        return this.definePackage(string, string3, string4, string5, string6, string7, string8, uRL2);
    }

    protected Class findClass(final String string) throws ClassNotFoundException {
        try {
            return (Class)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws ClassNotFoundException {
                    String string2 = string.replace('.', '/').concat(".class");
                    Resource resource = ucp.getResource(string2, false);
                    if (resource != null) {
                        try {
                            return this.defineClass(string, resource);
                        }
                        catch (IOException iOException) {
                            throw new ClassNotFoundException(string, iOException);
                        }
                    }
                    throw new ClassNotFoundException(string);
                }
            }, this.acc);
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (ClassNotFoundException)privilegedActionException.getException();
        }
    }

    public URL findResource(final String string) {
        Resource resource = (Resource)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return ucp.getResource(string, true);
            }
        }, this.acc);
        return resource != null ? this.ucp.checkURL(resource.getURL()) : null;
    }

    public Enumeration findResources(String string) throws IOException {
        final Enumeration enumeration = this.ucp.getResources(string, true);
        return new Enumeration(){
            private URL res;

            public boolean hasMoreElements() {
                Resource resource;
                if (this.res != null) {
                    return true;
                }
                while ((resource = (Resource)AccessController.doPrivileged(new PrivilegedAction(enumeration){
                    private final /* synthetic */ Enumeration val$e;
                    {
                        this.val$e = enumeration;
                    }

                    public Object run() {
                        if (!this.val$e.hasMoreElements()) {
                            return null;
                        }
                        return this.val$e.nextElement();
                    }
                }, acc)) != null) {
                    this.res = ucp.checkURL(resource.getURL());
                    if (this.res == null) continue;
                }
                return this.res != null;
            }

            public Object nextElement() {
                if (this.res == null) {
                    throw new NoSuchElementException();
                }
                URL uRL = this.res;
                this.res = null;
                return uRL;
            }
        };
    }

    protected PermissionCollection getPermissions(CodeSource codeSource) {
        Object object;
        Permission permission;
        PermissionCollection permissionCollection = super.getPermissions(codeSource);
        URL uRL = codeSource.getLocation();
        try {
            permission = uRL.openConnection().getPermission();
        }
        catch (IOException iOException) {
            permission = null;
        }
        if (permission instanceof FilePermission) {
            object = permission.getName();
            if (((String)object).endsWith(File.separator)) {
                object = String.valueOf(object) + "-";
                permission = new FilePermission((String)object, "read");
            }
        } else if (permission == null && uRL.getProtocol().equals("file")) {
            object = uRL.getFile().replace('/', File.separatorChar);
            if (((String)object).endsWith(File.separator)) {
                object = String.valueOf(object) + "-";
            }
            permission = new FilePermission((String)object, "read");
        } else {
            object = uRL.getHost();
            if (object == null) {
                object = "localhost";
            }
            permission = new SocketPermission((String)object, "connect, accept");
        }
        if (permission != null) {
            object = System.getSecurityManager();
            if (object != null) {
                final Permission permission2 = permission;
                AccessController.doPrivileged(new PrivilegedAction((SecurityManager)object){
                    private final /* synthetic */ SecurityManager val$sm;
                    {
                        this.val$sm = securityManager;
                    }

                    public Object run() throws SecurityException {
                        this.val$sm.checkPermission(permission2);
                        return null;
                    }
                }, this.acc);
            }
            permissionCollection.add(permission);
        }
        return permissionCollection;
    }

    public URL[] getURLs() {
        return this.ucp.getURLs();
    }

    private boolean isSealed(String string, Manifest manifest) {
        String string2 = string.replace('.', '/').concat("/");
        Attributes attributes = manifest.getAttributes(string2);
        String string3 = null;
        if (attributes != null) {
            string3 = attributes.getValue(Attributes.Name.SEALED);
        }
        if (string3 == null && (attributes = manifest.getMainAttributes()) != null) {
            string3 = attributes.getValue(Attributes.Name.SEALED);
        }
        return "true".equalsIgnoreCase(string3);
    }

    public static URLClassLoader newInstance(final URL[] uRLArray) {
        AccessControlContext accessControlContext = AccessController.getContext();
        URLClassLoader uRLClassLoader = (URLClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new FactoryURLClassLoader(uRLArray);
            }
        });
        uRLClassLoader.acc = accessControlContext;
        return uRLClassLoader;
    }

    public static URLClassLoader newInstance(final URL[] uRLArray, final ClassLoader classLoader) {
        AccessControlContext accessControlContext = AccessController.getContext();
        URLClassLoader uRLClassLoader = (URLClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new FactoryURLClassLoader(uRLArray, classLoader);
            }
        });
        uRLClassLoader.acc = accessControlContext;
        return uRLClassLoader;
    }
}

