/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.ProtectionDomain;
import java.util.Hashtable;
import sun.security.util.Debug;

public class SecureClassLoader
extends ClassLoader {
    private boolean initialized = false;
    private Hashtable pdcache = new Hashtable(11);
    private static final Debug debug = Debug.getInstance("scl");

    protected SecureClassLoader() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkCreateClassLoader();
        }
        this.initialized = true;
    }

    protected SecureClassLoader(ClassLoader classLoader) {
        super(classLoader);
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkCreateClassLoader();
        }
        this.initialized = true;
    }

    private void check() {
        if (!this.initialized) {
            throw new SecurityException("ClassLoader object not initialized");
        }
    }

    protected final Class defineClass(String string, byte[] byArray, int n, int n2, CodeSource codeSource) {
        if (codeSource == null) {
            return this.defineClass(string, byArray, n, n2);
        }
        return this.defineClass(string, byArray, n, n2, this.getProtectionDomain(codeSource));
    }

    protected PermissionCollection getPermissions(CodeSource codeSource) {
        this.check();
        Policy policy = Policy.getPolicyNoCheck();
        if (policy == null) {
            return null;
        }
        PermissionCollection permissionCollection = policy.getPermissions(codeSource);
        return permissionCollection;
    }

    private ProtectionDomain getProtectionDomain(CodeSource codeSource) {
        if (codeSource == null) {
            return null;
        }
        ProtectionDomain protectionDomain = (ProtectionDomain)this.pdcache.get(codeSource);
        if (protectionDomain == null) {
            Hashtable hashtable = this.pdcache;
            synchronized (hashtable) {
                protectionDomain = (ProtectionDomain)this.pdcache.get(codeSource);
                if (protectionDomain == null) {
                    PermissionCollection permissionCollection = this.getPermissions(codeSource);
                    if (debug != null) {
                        debug.println(" getPermissions " + codeSource);
                        debug.println("  " + permissionCollection);
                        debug.println("");
                    }
                    if ((protectionDomain = new ProtectionDomain(codeSource, permissionCollection)) != null) {
                        this.pdcache.put(codeSource, protectionDomain);
                    }
                }
            }
        }
        return protectionDomain;
    }
}

