/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.text.Utility;

final class CompactIntArray
implements Cloneable {
    public static final int UNICODECOUNT = 65536;
    private static final int BLOCKSHIFT = 7;
    private static final int BLOCKCOUNT = 128;
    private static final int INDEXSHIFT = 9;
    private static final int INDEXCOUNT = 512;
    private static final int BLOCKMASK = 127;
    private int[] values;
    private short[] indices;
    private boolean isCompact;
    private int[] hashes;

    public CompactIntArray() {
        this(0);
    }

    public CompactIntArray(int n) {
        this.values = new int[65536];
        this.indices = new short[512];
        this.hashes = new int[512];
        int n2 = 0;
        while (n2 < 65536) {
            this.values[n2] = n;
            ++n2;
        }
        n2 = 0;
        while (n2 < 512) {
            this.indices[n2] = (short)(n2 << 7);
            this.hashes[n2] = 0;
            ++n2;
        }
        this.isCompact = false;
    }

    public CompactIntArray(short[] sArray, int[] nArray) {
        if (sArray.length != 512) {
            throw new IllegalArgumentException("Index out of bounds.");
        }
        int n = 0;
        while (n < 512) {
            short s = sArray[n];
            if (s < 0 || s >= nArray.length + 128) {
                throw new IllegalArgumentException("Index out of bounds.");
            }
            ++n;
        }
        this.indices = sArray;
        this.values = nArray;
        this.isCompact = true;
    }

    private final boolean blockTouched(int n) {
        return this.hashes[n] != 0;
    }

    public Object clone() {
        try {
            CompactIntArray compactIntArray = (CompactIntArray)super.clone();
            compactIntArray.values = (int[])this.values.clone();
            compactIntArray.indices = (short[])this.indices.clone();
            if (this.hashes != null) {
                compactIntArray.hashes = (int[])this.hashes.clone();
            }
            return compactIntArray;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public void compact() {
        if (!this.isCompact) {
            int n;
            int n2 = 0;
            int n3 = 0;
            int n4 = -1;
            int n5 = 0;
            while (n5 < this.indices.length) {
                this.indices[n5] = -1;
                n = this.blockTouched(n5) ? 1 : 0;
                if (n == 0 && n4 != -1) {
                    this.indices[n5] = n4;
                } else {
                    int n6 = 0;
                    int n7 = 0;
                    n7 = 0;
                    while (n7 < n2) {
                        if (this.hashes[n5] == this.hashes[n7] && Utility.arrayRegionMatches(this.values, n3, this.values, n6, 128)) {
                            this.indices[n5] = (short)n6;
                            break;
                        }
                        ++n7;
                        n6 += 128;
                    }
                    if (this.indices[n5] == -1) {
                        System.arraycopy(this.values, n3, this.values, n6, 128);
                        this.indices[n5] = (short)n6;
                        this.hashes[n7] = this.hashes[n5];
                        ++n2;
                        if (n == 0) {
                            n4 = (short)n6;
                        }
                    }
                }
                ++n5;
                n3 += 128;
            }
            n = n2 * 128;
            int[] nArray = new int[n];
            System.arraycopy(this.values, 0, nArray, 0, n);
            this.values = nArray;
            this.isCompact = true;
            this.hashes = null;
        }
    }

    public int elementAt(char c) {
        return this.values[(this.indices[c >> 7] & 0xFFFF) + (c & 0x7F)];
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        CompactIntArray compactIntArray = (CompactIntArray)object;
        int n = 0;
        while (n < 65536) {
            if (this.elementAt((char)n) != compactIntArray.elementAt((char)n)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private void expand() {
        if (this.isCompact) {
            this.hashes = new int[512];
            int[] nArray = new int[65536];
            int n = 0;
            while (n < 65536) {
                int n2;
                nArray[n] = n2 = this.elementAt((char)n);
                this.touchBlock(n >> 7, n2);
                ++n;
            }
            n = 0;
            while (n < 512) {
                this.indices[n] = (short)(n << 7);
                ++n;
            }
            this.values = nArray;
            this.isCompact = false;
        }
    }

    public short[] getIndexArray() {
        return this.indices;
    }

    public int[] getStringArray() {
        return this.values;
    }

    public int hashCode() {
        int n = 0;
        int n2 = Math.min(3, this.values.length / 16);
        int n3 = 0;
        while (n3 < this.values.length) {
            n = n * 37 + this.values[n3];
            n3 += n2;
        }
        return n;
    }

    public void setElementAt(char n, char c, int n2) {
        if (this.isCompact) {
            this.expand();
        }
        int n3 = n;
        while (n3 <= c) {
            this.values[n3] = n2;
            this.touchBlock(n3 >> 7, n2);
            ++n3;
        }
    }

    public void setElementAt(char c, int n) {
        if (this.isCompact) {
            this.expand();
        }
        this.values[c] = n;
        this.touchBlock(c >> 7, n);
    }

    private final void touchBlock(int n, int n2) {
        this.hashes[n] = this.hashes[n] + (n2 << 1) | 1;
    }
}

