/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class SimpleTimeZone
extends TimeZone {
    private int startMonth;
    private int startDay;
    private int startDayOfWeek;
    private int startTime;
    private int endMonth;
    private int endDay;
    private int endDayOfWeek;
    private int endTime;
    private int startYear;
    private int rawOffset;
    private boolean useDaylight = false;
    private static final int millisPerHour = 3600000;
    private static final int millisPerDay = 86400000;
    private final byte[] monthLength = staticMonthLength;
    private static final byte[] staticMonthLength = new byte[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private static final byte[] staticLeapMonthLength = new byte[]{31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private transient int gregorianCutoverYear = 1582;
    private int startMode;
    private int endMode;
    private int dstSavings;
    private static final int DOM_MODE = 1;
    private static final int DOW_IN_MONTH_MODE = 2;
    private static final int DOW_GE_DOM_MODE = 3;
    private static final int DOW_LE_DOM_MODE = 4;
    static final long serialVersionUID = -403250971215465050L;
    static final int currentSerialVersion = 1;
    private int serialVersionOnStream = 1;

    public SimpleTimeZone(int n, String string) {
        this.rawOffset = n;
        this.setID(string);
        this.dstSavings = 3600000;
    }

    public SimpleTimeZone(int n, String string, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        this(n, string, n2, n3, n4, n5, n6, n7, n8, n9, 3600000);
    }

    public SimpleTimeZone(int n, String string, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
        this.setID(string);
        this.rawOffset = n;
        this.startMonth = n2;
        this.startDay = n3;
        this.startDayOfWeek = n4;
        this.startTime = n5;
        this.endMonth = n6;
        this.endDay = n7;
        this.endDayOfWeek = n8;
        this.endTime = n9;
        this.dstSavings = n10;
        this.decodeRules();
        if (n10 <= 0) {
            throw new IllegalArgumentException("Illegal DST savings");
        }
    }

    public Object clone() {
        return super.clone();
    }

    private static int compareToRule(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
        if (n < n7) {
            return -1;
        }
        if (n > n7) {
            return 1;
        }
        int n11 = 0;
        switch (n6) {
            case 1: {
                n11 = n9;
                break;
            }
            case 2: {
                if (n9 > 0) {
                    n11 = 1 + (n9 - 1) * 7 + (7 + n8 - (n4 - n3 + 1)) % 7;
                    break;
                }
                n11 = n2 + (n9 + 1) * 7 - (7 + (n4 + n2 - n3) - n8) % 7;
                break;
            }
            case 3: {
                n11 = n9 + (49 + n8 - n9 - n4 + n3) % 7;
                break;
            }
            case 4: {
                n11 = n9 - (49 - n8 + n9 + n4 - n3) % 7;
                break;
            }
        }
        if (n3 < n11) {
            return -1;
        }
        if (n3 > n11) {
            return 1;
        }
        if (n5 < n10) {
            return -1;
        }
        if (n5 > n10) {
            return 1;
        }
        return 0;
    }

    private void decodeEndRule() {
        boolean bl = this.useDaylight = this.startDay != 0 && this.endDay != 0;
        if (this.endDay != 0) {
            if (this.endMonth < 0 || this.endMonth > 11) {
                throw new IllegalArgumentException("Illegal end month " + this.endMonth);
            }
            if (this.endTime < 0 || this.endTime > 86400000) {
                throw new IllegalArgumentException("Illegal end time " + this.endTime);
            }
            if (this.endDayOfWeek == 0) {
                this.endMode = 1;
            } else {
                if (this.endDayOfWeek > 0) {
                    this.endMode = 2;
                } else {
                    this.endDayOfWeek = -this.endDayOfWeek;
                    if (this.endDay > 0) {
                        this.endMode = 3;
                    } else {
                        this.endDay = -this.endDay;
                        this.endMode = 4;
                    }
                }
                if (this.endDayOfWeek > 7) {
                    throw new IllegalArgumentException("Illegal end day of week " + this.endDayOfWeek);
                }
            }
            if (this.endMode == 2) {
                if (this.endDay < -5 || this.endDay > 5) {
                    throw new IllegalArgumentException("Illegal end day of week in month " + this.endDay);
                }
            } else if (this.endDay > staticMonthLength[this.endMonth]) {
                throw new IllegalArgumentException("Illegal end day " + this.endDay);
            }
        }
    }

    private void decodeRules() {
        this.decodeStartRule();
        this.decodeEndRule();
    }

    private void decodeStartRule() {
        boolean bl = this.useDaylight = this.startDay != 0 && this.endDay != 0;
        if (this.startDay != 0) {
            if (this.startMonth < 0 || this.startMonth > 11) {
                throw new IllegalArgumentException("Illegal start month " + this.startMonth);
            }
            if (this.startTime < 0 || this.startTime > 86400000) {
                throw new IllegalArgumentException("Illegal start time " + this.startTime);
            }
            if (this.startDayOfWeek == 0) {
                this.startMode = 1;
            } else {
                if (this.startDayOfWeek > 0) {
                    this.startMode = 2;
                } else {
                    this.startDayOfWeek = -this.startDayOfWeek;
                    if (this.startDay > 0) {
                        this.startMode = 3;
                    } else {
                        this.startDay = -this.startDay;
                        this.startMode = 4;
                    }
                }
                if (this.startDayOfWeek > 7) {
                    throw new IllegalArgumentException("Illegal start day of week " + this.startDayOfWeek);
                }
            }
            if (this.startMode == 2) {
                if (this.startDay < -5 || this.startDay > 5) {
                    throw new IllegalArgumentException("Illegal start day of week in month " + this.startDay);
                }
            } else if (this.startDay > staticMonthLength[this.startMonth]) {
                throw new IllegalArgumentException("Illegal start day " + this.startDay);
            }
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof SimpleTimeZone)) {
            return false;
        }
        SimpleTimeZone simpleTimeZone = (SimpleTimeZone)object;
        return this.getID().equals(simpleTimeZone.getID()) && this.hasSameRules(simpleTimeZone);
    }

    public int getDSTSavings() {
        return this.dstSavings;
    }

    public int getOffset(int n, int n2, int n3, int n4, int n5, int n6) {
        if (n3 < 0 || n3 > 11) {
            throw new IllegalArgumentException("Illegal month " + n3);
        }
        byte by = 0;
        by = n == 1 && this.isLeapYear(n2) ? staticLeapMonthLength[n3] : staticMonthLength[n3];
        return this.getOffset(n, n2, n3, n4, n5, n6, by);
    }

    int getOffset(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        if (n != 1 && n != 0 || n3 < 0 || n3 > 11 || n4 < 1 || n4 > n7 || n5 < 1 || n5 > 7 || n6 < 0 || n6 >= 86400000 || n7 < 28 || n7 > 31) {
            throw new IllegalArgumentException();
        }
        int n8 = this.rawOffset;
        if (!this.useDaylight || n2 < this.startYear || n != 1) {
            return n8;
        }
        boolean bl = this.startMonth > this.endMonth;
        int n9 = SimpleTimeZone.compareToRule(n3, n7, n4, n5, n6, this.startMode, this.startMonth, this.startDayOfWeek, this.startDay, this.startTime);
        int n10 = 0;
        if (bl != n9 >= 0) {
            n6 += this.dstSavings;
            while (n6 >= 86400000) {
                n6 -= 86400000;
                n5 = 1 + n5 % 7;
                if (++n4 <= n7) continue;
                n4 = 1;
                ++n3;
            }
            n10 = SimpleTimeZone.compareToRule(n3, n7, n4, n5, n6, this.endMode, this.endMonth, this.endDayOfWeek, this.endDay, this.endTime);
        }
        if (!bl && n9 >= 0 && n10 < 0 || bl && (n9 >= 0 || n10 < 0)) {
            n8 += this.dstSavings;
        }
        return n8;
    }

    public int getRawOffset() {
        return this.rawOffset;
    }

    public boolean hasSameRules(TimeZone timeZone) {
        if (this == timeZone) {
            return true;
        }
        if (!(timeZone instanceof SimpleTimeZone)) {
            return false;
        }
        SimpleTimeZone simpleTimeZone = (SimpleTimeZone)timeZone;
        return this.rawOffset == simpleTimeZone.rawOffset && this.useDaylight == simpleTimeZone.useDaylight && (!this.useDaylight || this.dstSavings == simpleTimeZone.dstSavings && this.startMode == simpleTimeZone.startMode && this.startMonth == simpleTimeZone.startMonth && this.startDay == simpleTimeZone.startDay && this.startDayOfWeek == simpleTimeZone.startDayOfWeek && this.startTime == simpleTimeZone.startTime && this.endMode == simpleTimeZone.endMode && this.endMonth == simpleTimeZone.endMonth && this.endDay == simpleTimeZone.endDay && this.endDayOfWeek == simpleTimeZone.endDayOfWeek && this.endTime == simpleTimeZone.endTime && this.startYear == simpleTimeZone.startYear);
    }

    public synchronized int hashCode() {
        return this.startMonth ^ this.startDay ^ this.startDayOfWeek ^ this.startTime ^ this.endMonth ^ this.endDay ^ this.endDayOfWeek ^ this.endTime ^ this.rawOffset;
    }

    public boolean inDaylightTime(Date date) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(this);
        gregorianCalendar.setTime(date);
        return gregorianCalendar.inDaylightTime();
    }

    private boolean isLeapYear(int n) {
        return n >= this.gregorianCutoverYear ? n % 4 == 0 && (n % 100 != 0 || n % 400 == 0) : n % 4 == 0;
    }

    private void makeRulesCompatible() {
        switch (this.startMode) {
            case 1: {
                this.startDay = 1 + this.startDay / 7;
                this.startDayOfWeek = 1;
                break;
            }
            case 3: {
                if (this.startDay == 1) break;
                this.startDay = 1 + this.startDay / 7;
                break;
            }
            case 4: {
                if (this.startDay >= 30) {
                    this.startDay = -1;
                    break;
                }
                this.startDay = 1 + this.startDay / 7;
                break;
            }
        }
        switch (this.endMode) {
            case 1: {
                this.endDay = 1 + this.endDay / 7;
                this.endDayOfWeek = 1;
                break;
            }
            case 3: {
                if (this.endDay == 1) break;
                this.endDay = 1 + this.endDay / 7;
                break;
            }
            case 4: {
                if (this.endDay >= 30) {
                    this.endDay = -1;
                    break;
                }
                this.endDay = 1 + this.endDay / 7;
                break;
            }
        }
    }

    private byte[] packRules() {
        byte[] byArray = new byte[]{(byte)this.startDay, (byte)this.startDayOfWeek, (byte)this.endDay, (byte)this.endDayOfWeek};
        return byArray;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.serialVersionOnStream < 1) {
            if (this.startDayOfWeek == 0) {
                this.startDayOfWeek = 1;
            }
            if (this.endDayOfWeek == 0) {
                this.endDayOfWeek = 1;
            }
            this.endMode = 2;
            this.startMode = 2;
            this.dstSavings = 3600000;
        } else {
            int n = objectInputStream.readInt();
            byte[] byArray = new byte[n];
            objectInputStream.readFully(byArray);
            this.unpackRules(byArray);
        }
        this.serialVersionOnStream = 1;
    }

    public void setDSTSavings(int n) {
        this.dstSavings = n;
        if (this.dstSavings <= 0) {
            throw new IllegalArgumentException("Illegal DST savings");
        }
    }

    public void setEndRule(int n, int n2, int n3) {
        this.setEndRule(n, n2, 0, n3);
    }

    public void setEndRule(int n, int n2, int n3, int n4) {
        this.endMonth = n;
        this.endDay = n2;
        this.endDayOfWeek = n3;
        this.endTime = n4;
        this.decodeEndRule();
    }

    public void setEndRule(int n, int n2, int n3, int n4, boolean bl) {
        if (bl) {
            this.setEndRule(n, n2, -n3, n4);
        } else {
            this.setEndRule(n, -n2, -n3, n4);
        }
    }

    public void setRawOffset(int n) {
        this.rawOffset = n;
    }

    public void setStartRule(int n, int n2, int n3) {
        this.setStartRule(n, n2, 0, n3);
    }

    public void setStartRule(int n, int n2, int n3, int n4) {
        this.startMonth = n;
        this.startDay = n2;
        this.startDayOfWeek = n3;
        this.startTime = n4;
        this.decodeStartRule();
    }

    public void setStartRule(int n, int n2, int n3, int n4, boolean bl) {
        if (bl) {
            this.setStartRule(n, n2, -n3, n4);
        } else {
            this.setStartRule(n, -n2, -n3, n4);
        }
    }

    public void setStartYear(int n) {
        this.startYear = n;
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[id=" + this.getID() + ",offset=" + this.rawOffset + ",dstSavings=" + this.dstSavings + ",useDaylight=" + this.useDaylight + ",startYear=" + this.startYear + ",startMode=" + this.startMode + ",startMonth=" + this.startMonth + ",startDay=" + this.startDay + ",startDayOfWeek=" + this.startDayOfWeek + ",startTime=" + this.startTime + ",endMode=" + this.endMode + ",endMonth=" + this.endMonth + ",endDay=" + this.endDay + ",endDayOfWeek=" + this.endDayOfWeek + ",endTime=" + this.endTime + ']';
    }

    private void unpackRules(byte[] byArray) {
        this.startDay = byArray[0];
        this.startDayOfWeek = byArray[1];
        this.endDay = byArray[2];
        this.endDayOfWeek = byArray[3];
    }

    public boolean useDaylightTime() {
        return this.useDaylight;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        byte[] byArray = this.packRules();
        this.makeRulesCompatible();
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(byArray.length);
        objectOutputStream.write(byArray);
        this.unpackRules(byArray);
    }
}

