/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.Serializable;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleValue;
import javax.swing.ButtonModel;
import javax.swing.GrayFilter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.OverlayLayout;
import javax.swing.SwingConstants;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ButtonUI;
import javax.swing.plaf.UIResource;

public abstract class AbstractButton
extends JComponent
implements ItemSelectable,
SwingConstants {
    public static final String MODEL_CHANGED_PROPERTY = "model";
    public static final String TEXT_CHANGED_PROPERTY = "text";
    public static final String MNEMONIC_CHANGED_PROPERTY = "mnemonic";
    public static final String MARGIN_CHANGED_PROPERTY = "margin";
    public static final String VERTICAL_ALIGNMENT_CHANGED_PROPERTY = "verticalAlignment";
    public static final String HORIZONTAL_ALIGNMENT_CHANGED_PROPERTY = "horizontalAlignment";
    public static final String VERTICAL_TEXT_POSITION_CHANGED_PROPERTY = "verticalTextPosition";
    public static final String HORIZONTAL_TEXT_POSITION_CHANGED_PROPERTY = "horizontalTextPosition";
    public static final String BORDER_PAINTED_CHANGED_PROPERTY = "borderPainted";
    public static final String FOCUS_PAINTED_CHANGED_PROPERTY = "focusPainted";
    public static final String ROLLOVER_ENABLED_CHANGED_PROPERTY = "rolloverEnabled";
    public static final String CONTENT_AREA_FILLED_CHANGED_PROPERTY = "contentAreaFilled";
    public static final String ICON_CHANGED_PROPERTY = "icon";
    public static final String PRESSED_ICON_CHANGED_PROPERTY = "pressedIcon";
    public static final String SELECTED_ICON_CHANGED_PROPERTY = "selectedIcon";
    public static final String ROLLOVER_ICON_CHANGED_PROPERTY = "rolloverIcon";
    public static final String ROLLOVER_SELECTED_ICON_CHANGED_PROPERTY = "rolloverSelectedIcon";
    public static final String DISABLED_ICON_CHANGED_PROPERTY = "disabledIcon";
    public static final String DISABLED_SELECTED_ICON_CHANGED_PROPERTY = "disabledSelectedIcon";
    protected ButtonModel model = null;
    private String text = "";
    private Insets margin = null;
    private Insets defaultMargin = null;
    private Icon defaultIcon = null;
    private Icon pressedIcon = null;
    private Icon disabledIcon = null;
    private Icon selectedIcon = null;
    private Icon disabledSelectedIcon = null;
    private Icon rolloverIcon = null;
    private Icon rolloverSelectedIcon = null;
    private boolean paintBorder = true;
    private boolean paintFocus = true;
    private boolean rolloverEnabled = false;
    private boolean contentAreaFilled = true;
    private int verticalAlignment = 0;
    private int horizontalAlignment = 0;
    private int verticalTextPosition = 0;
    private int horizontalTextPosition = 11;
    protected ChangeListener changeListener = null;
    protected ActionListener actionListener = null;
    protected ItemListener itemListener = null;
    protected transient ChangeEvent changeEvent;
    static /* synthetic */ Class class$javax$swing$event$ChangeListener;
    static /* synthetic */ Class class$java$awt$event$ActionListener;
    static /* synthetic */ Class class$java$awt$event$ItemListener;

    public void addActionListener(ActionListener actionListener) {
        this.listenerList.add(class$java$awt$event$ActionListener != null ? class$java$awt$event$ActionListener : (class$java$awt$event$ActionListener = AbstractButton.class$("java.awt.event.ActionListener")), actionListener);
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listenerList.add(class$javax$swing$event$ChangeListener != null ? class$javax$swing$event$ChangeListener : (class$javax$swing$event$ChangeListener = AbstractButton.class$("javax.swing.event.ChangeListener")), changeListener);
    }

    public void addItemListener(ItemListener itemListener) {
        this.listenerList.add(class$java$awt$event$ItemListener != null ? class$java$awt$event$ItemListener : (class$java$awt$event$ItemListener = AbstractButton.class$("java.awt.event.ItemListener")), itemListener);
    }

    protected int checkHorizontalKey(int n, String string) {
        if (n == 2 || n == 0 || n == 4 || n == 10 || n == 11) {
            return n;
        }
        throw new IllegalArgumentException(string);
    }

    protected int checkVerticalKey(int n, String string) {
        if (n == 1 || n == 0 || n == 3) {
            return n;
        }
        throw new IllegalArgumentException(string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected ActionListener createActionListener() {
        return new ForwardActionEvents();
    }

    protected ChangeListener createChangeListener() {
        return new ButtonChangeListener();
    }

    protected ItemListener createItemListener() {
        return new ForwardItemEvents();
    }

    public void doClick() {
        this.doClick(68);
    }

    public void doClick(int n) {
        Dimension dimension = this.getSize();
        this.model.setArmed(true);
        this.model.setPressed(true);
        this.paintImmediately(new Rectangle(0, 0, dimension.width, dimension.height));
        try {
            Thread.currentThread();
            Thread.sleep(n);
        }
        catch (InterruptedException interruptedException) {}
        this.model.setPressed(false);
        this.model.setArmed(false);
    }

    protected void fireActionPerformed(ActionEvent actionEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        ActionEvent actionEvent2 = null;
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$java$awt$event$ActionListener != null ? class$java$awt$event$ActionListener : AbstractButton.class$("java.awt.event.ActionListener"))) {
                if (actionEvent2 == null) {
                    String string = actionEvent.getActionCommand();
                    if (string == null) {
                        string = this.getActionCommand();
                    }
                    actionEvent2 = new ActionEvent(this, 1001, string, actionEvent.getModifiers());
                }
                ((ActionListener)objectArray[n + 1]).actionPerformed(actionEvent2);
            }
            n -= 2;
        }
    }

    protected void fireItemStateChanged(ItemEvent itemEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        ItemEvent itemEvent2 = null;
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$java$awt$event$ItemListener != null ? class$java$awt$event$ItemListener : AbstractButton.class$("java.awt.event.ItemListener"))) {
                if (itemEvent2 == null) {
                    itemEvent2 = new ItemEvent(this, 701, this, itemEvent.getStateChange());
                }
                ((ItemListener)objectArray[n + 1]).itemStateChanged(itemEvent2);
            }
            n -= 2;
        }
    }

    protected void fireStateChanged() {
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$javax$swing$event$ChangeListener != null ? class$javax$swing$event$ChangeListener : AbstractButton.class$("javax.swing.event.ChangeListener"))) {
                if (this.changeEvent == null) {
                    this.changeEvent = new ChangeEvent(this);
                }
                ((ChangeListener)objectArray[n + 1]).stateChanged(this.changeEvent);
            }
            n -= 2;
        }
    }

    public String getActionCommand() {
        String string = this.getModel().getActionCommand();
        if (string == null) {
            string = this.getText();
        }
        return string;
    }

    public Icon getDisabledIcon() {
        if (this.disabledIcon == null && this.defaultIcon != null && this.defaultIcon instanceof ImageIcon) {
            this.disabledIcon = new ImageIcon(GrayFilter.createDisabledImage(((ImageIcon)this.defaultIcon).getImage()));
        }
        return this.disabledIcon;
    }

    public Icon getDisabledSelectedIcon() {
        if (this.disabledSelectedIcon == null) {
            if (this.selectedIcon != null && this.selectedIcon instanceof ImageIcon) {
                this.disabledSelectedIcon = new ImageIcon(GrayFilter.createDisabledImage(((ImageIcon)this.selectedIcon).getImage()));
            } else {
                return this.disabledIcon;
            }
        }
        return this.disabledSelectedIcon;
    }

    public int getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public int getHorizontalTextPosition() {
        return this.horizontalTextPosition;
    }

    public Icon getIcon() {
        return this.defaultIcon;
    }

    public String getLabel() {
        return this.getText();
    }

    public Insets getMargin() {
        return this.margin;
    }

    public int getMnemonic() {
        return this.model.getMnemonic();
    }

    public ButtonModel getModel() {
        return this.model;
    }

    public Icon getPressedIcon() {
        return this.pressedIcon;
    }

    public Icon getRolloverIcon() {
        return this.rolloverIcon;
    }

    public Icon getRolloverSelectedIcon() {
        return this.rolloverSelectedIcon;
    }

    public Icon getSelectedIcon() {
        return this.selectedIcon;
    }

    public synchronized Object[] getSelectedObjects() {
        if (!this.isSelected()) {
            return null;
        }
        Object[] objectArray = new Object[]{this.getText()};
        return objectArray;
    }

    public String getText() {
        return this.text;
    }

    public ButtonUI getUI() {
        return (ButtonUI)this.ui;
    }

    public int getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public int getVerticalTextPosition() {
        return this.verticalTextPosition;
    }

    protected void init(String string, Icon icon) {
        this.setLayout(new OverlayLayout(this));
        if (string != null) {
            this.setText(string);
        }
        if (icon != null) {
            this.setIcon(icon);
        }
        this.updateUI();
        this.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
                if (AbstractButton.this.accessibleContext != null) {
                    AbstractButton.this.accessibleContext.firePropertyChange("AccessibleState", null, AccessibleState.FOCUSED);
                }
            }

            public void focusLost(FocusEvent focusEvent) {
                if (AbstractButton.this.accessibleContext != null) {
                    AbstractButton.this.accessibleContext.firePropertyChange("AccessibleState", null, AccessibleState.FOCUSED);
                }
                if (AbstractButton.this.isFocusPainted()) {
                    AbstractButton.this.repaint();
                }
            }
        });
        this.setAlignmentX(0.0f);
        this.setAlignmentY(0.5f);
    }

    public boolean isBorderPainted() {
        return this.paintBorder;
    }

    public boolean isContentAreaFilled() {
        return this.contentAreaFilled;
    }

    public boolean isFocusPainted() {
        return this.paintFocus;
    }

    public boolean isRolloverEnabled() {
        return this.rolloverEnabled;
    }

    public boolean isSelected() {
        return this.model.isSelected();
    }

    protected void paintBorder(Graphics graphics) {
        if (this.isBorderPainted()) {
            super.paintBorder(graphics);
        }
    }

    protected String paramString() {
        String string = this.defaultIcon != null ? this.defaultIcon.toString() : "";
        String string2 = this.pressedIcon != null ? this.pressedIcon.toString() : "";
        String string3 = this.disabledIcon != null ? this.disabledIcon.toString() : "";
        String string4 = this.selectedIcon != null ? this.selectedIcon.toString() : "";
        String string5 = this.disabledSelectedIcon != null ? this.disabledSelectedIcon.toString() : "";
        String string6 = this.rolloverIcon != null ? this.rolloverIcon.toString() : "";
        String string7 = this.rolloverSelectedIcon != null ? this.rolloverSelectedIcon.toString() : "";
        String string8 = this.paintBorder ? "true" : "false";
        String string9 = this.paintFocus ? "true" : "false";
        String string10 = this.rolloverEnabled ? "true" : "false";
        return String.valueOf(super.paramString()) + ",defaultIcon=" + string + ",disabledIcon=" + string3 + ",disabledSelectedIcon=" + string5 + ",margin=" + this.margin + ",paintBorder=" + string8 + ",paintFocus=" + string9 + ",pressedIcon=" + string2 + ",rolloverEnabled=" + string10 + ",rolloverIcon=" + string6 + ",rolloverSelectedIcon=" + string7 + ",selectedIcon=" + string4 + ",text=" + this.text;
    }

    public void removeActionListener(ActionListener actionListener) {
        this.listenerList.remove(class$java$awt$event$ActionListener != null ? class$java$awt$event$ActionListener : (class$java$awt$event$ActionListener = AbstractButton.class$("java.awt.event.ActionListener")), actionListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listenerList.remove(class$javax$swing$event$ChangeListener != null ? class$javax$swing$event$ChangeListener : (class$javax$swing$event$ChangeListener = AbstractButton.class$("javax.swing.event.ChangeListener")), changeListener);
    }

    public void removeItemListener(ItemListener itemListener) {
        this.listenerList.remove(class$java$awt$event$ItemListener != null ? class$java$awt$event$ItemListener : (class$java$awt$event$ItemListener = AbstractButton.class$("java.awt.event.ItemListener")), itemListener);
    }

    public void setActionCommand(String string) {
        this.getModel().setActionCommand(string);
    }

    public void setBorderPainted(boolean bl) {
        boolean bl2 = this.paintBorder;
        this.paintBorder = bl;
        this.firePropertyChange(BORDER_PAINTED_CHANGED_PROPERTY, bl2, this.paintBorder);
        if (bl != bl2) {
            this.revalidate();
            this.repaint();
        }
    }

    public void setContentAreaFilled(boolean bl) {
        boolean bl2 = this.contentAreaFilled;
        this.contentAreaFilled = bl;
        this.firePropertyChange(CONTENT_AREA_FILLED_CHANGED_PROPERTY, bl2, this.contentAreaFilled);
        if (bl != bl2) {
            this.repaint();
        }
    }

    public void setDisabledIcon(Icon icon) {
        Icon icon2 = this.disabledIcon;
        this.disabledIcon = icon;
        this.firePropertyChange(DISABLED_ICON_CHANGED_PROPERTY, icon2, icon);
        if (this.accessibleContext != null) {
            this.accessibleContext.firePropertyChange("AccessibleVisibleData", icon2, icon);
        }
        if (icon != icon2 && !this.isEnabled()) {
            this.repaint();
        }
    }

    public void setDisabledSelectedIcon(Icon icon) {
        Icon icon2 = this.disabledSelectedIcon;
        this.disabledSelectedIcon = icon;
        this.firePropertyChange(DISABLED_SELECTED_ICON_CHANGED_PROPERTY, icon2, icon);
        if (this.accessibleContext != null) {
            this.accessibleContext.firePropertyChange("AccessibleVisibleData", icon2, icon);
        }
        if (icon != icon2) {
            if (icon == null || icon2 == null || icon.getIconWidth() != icon2.getIconWidth() || icon.getIconHeight() != icon2.getIconHeight()) {
                this.revalidate();
            }
            if (!this.isEnabled() && this.isSelected()) {
                this.repaint();
            }
        }
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.model.setEnabled(bl);
    }

    public void setFocusPainted(boolean bl) {
        boolean bl2 = this.paintFocus;
        this.paintFocus = bl;
        this.firePropertyChange(FOCUS_PAINTED_CHANGED_PROPERTY, bl2, this.paintFocus);
        if (bl != bl2 && this.hasFocus()) {
            this.revalidate();
            this.repaint();
        }
    }

    public void setHorizontalAlignment(int n) {
        if (n == this.horizontalAlignment) {
            return;
        }
        int n2 = this.horizontalAlignment;
        this.horizontalAlignment = this.checkHorizontalKey(n, HORIZONTAL_ALIGNMENT_CHANGED_PROPERTY);
        this.firePropertyChange(HORIZONTAL_ALIGNMENT_CHANGED_PROPERTY, n2, this.horizontalAlignment);
        this.repaint();
    }

    public void setHorizontalTextPosition(int n) {
        if (n == this.horizontalTextPosition) {
            return;
        }
        int n2 = this.horizontalTextPosition;
        this.horizontalTextPosition = this.checkHorizontalKey(n, HORIZONTAL_TEXT_POSITION_CHANGED_PROPERTY);
        this.firePropertyChange(HORIZONTAL_TEXT_POSITION_CHANGED_PROPERTY, n2, this.horizontalTextPosition);
        this.repaint();
    }

    public void setIcon(Icon icon) {
        Icon icon2 = this.defaultIcon;
        this.defaultIcon = icon;
        this.firePropertyChange(ICON_CHANGED_PROPERTY, icon2, icon);
        if (this.accessibleContext != null) {
            this.accessibleContext.firePropertyChange("AccessibleVisibleData", icon2, icon);
        }
        if (icon != icon2) {
            if (icon == null || icon2 == null || icon.getIconWidth() != icon2.getIconWidth() || icon.getIconHeight() != icon2.getIconHeight()) {
                this.revalidate();
            }
            this.repaint();
        }
    }

    public void setLabel(String string) {
        this.setText(string);
    }

    public void setMargin(Insets insets) {
        if (insets instanceof UIResource) {
            this.defaultMargin = insets;
        } else if (this.margin instanceof UIResource) {
            this.defaultMargin = this.margin;
        }
        if (insets == null && this.defaultMargin != null) {
            insets = this.defaultMargin;
        }
        Insets insets2 = this.margin;
        this.margin = insets;
        this.firePropertyChange(MARGIN_CHANGED_PROPERTY, insets2, insets);
        if (insets2 == null || !insets.equals(insets2)) {
            this.revalidate();
            this.repaint();
        }
    }

    public void setMnemonic(char n) {
        int n2 = n;
        if (n2 >= 97 && n2 <= 122) {
            n2 -= 32;
        }
        this.setMnemonic(n2);
    }

    public void setMnemonic(int n) {
        int n2 = this.getMnemonic();
        this.model.setMnemonic(n);
        this.firePropertyChange(MNEMONIC_CHANGED_PROPERTY, n2, n);
        if (n != n2) {
            this.revalidate();
            this.repaint();
        }
    }

    public void setModel(ButtonModel buttonModel) {
        ButtonModel buttonModel2 = this.getModel();
        if (buttonModel2 != null) {
            buttonModel2.removeChangeListener(this.changeListener);
            buttonModel2.removeActionListener(this.actionListener);
            this.changeListener = null;
            this.actionListener = null;
        }
        this.model = buttonModel;
        if (buttonModel != null) {
            this.changeListener = this.createChangeListener();
            this.actionListener = this.createActionListener();
            this.itemListener = this.createItemListener();
            buttonModel.addChangeListener(this.changeListener);
            buttonModel.addActionListener(this.actionListener);
            buttonModel.addItemListener(this.itemListener);
        }
        this.firePropertyChange(MODEL_CHANGED_PROPERTY, buttonModel2, buttonModel);
        if (buttonModel != buttonModel2) {
            this.revalidate();
            this.repaint();
        }
    }

    public void setPressedIcon(Icon icon) {
        Icon icon2 = this.pressedIcon;
        this.pressedIcon = icon;
        this.firePropertyChange(PRESSED_ICON_CHANGED_PROPERTY, icon2, icon);
        if (this.accessibleContext != null) {
            this.accessibleContext.firePropertyChange("AccessibleVisibleData", icon2, this.defaultIcon);
        }
        if (icon != icon2 && this.getModel().isPressed()) {
            this.repaint();
        }
    }

    public void setRolloverEnabled(boolean bl) {
        boolean bl2 = this.rolloverEnabled;
        this.rolloverEnabled = bl;
        this.firePropertyChange(ROLLOVER_ENABLED_CHANGED_PROPERTY, bl2, this.rolloverEnabled);
        if (bl != bl2) {
            this.repaint();
        }
    }

    public void setRolloverIcon(Icon icon) {
        Icon icon2 = this.rolloverIcon;
        this.rolloverIcon = icon;
        this.firePropertyChange(ROLLOVER_ICON_CHANGED_PROPERTY, icon2, icon);
        if (this.accessibleContext != null) {
            this.accessibleContext.firePropertyChange("AccessibleVisibleData", icon2, icon);
        }
        this.setRolloverEnabled(true);
        if (icon != icon2) {
            this.repaint();
        }
    }

    public void setRolloverSelectedIcon(Icon icon) {
        Icon icon2 = this.rolloverSelectedIcon;
        this.rolloverSelectedIcon = icon;
        this.firePropertyChange(ROLLOVER_SELECTED_ICON_CHANGED_PROPERTY, icon2, icon);
        if (this.accessibleContext != null) {
            this.accessibleContext.firePropertyChange("AccessibleVisibleData", icon2, icon);
        }
        if (icon != icon2 && this.isSelected()) {
            this.repaint();
        }
    }

    public void setSelected(boolean bl) {
        boolean bl2 = this.isSelected();
        if (this.accessibleContext != null && bl2 != bl) {
            if (bl) {
                this.accessibleContext.firePropertyChange("AccessibleState", null, AccessibleState.SELECTED);
            } else {
                this.accessibleContext.firePropertyChange("AccessibleState", AccessibleState.SELECTED, null);
            }
        }
        this.model.setSelected(bl);
    }

    public void setSelectedIcon(Icon icon) {
        Icon icon2 = this.selectedIcon;
        this.selectedIcon = icon;
        this.firePropertyChange(SELECTED_ICON_CHANGED_PROPERTY, icon2, icon);
        if (this.accessibleContext != null) {
            this.accessibleContext.firePropertyChange("AccessibleVisibleData", icon2, icon);
        }
        if (icon != icon2 && this.isSelected()) {
            this.repaint();
        }
    }

    public void setText(String string) {
        String string2 = this.text;
        this.text = string;
        this.firePropertyChange(TEXT_CHANGED_PROPERTY, string2, string);
        if (this.accessibleContext != null) {
            this.accessibleContext.firePropertyChange("AccessibleVisibleData", string2, string);
        }
        if (string == null || string2 == null || !string.equals(string2)) {
            this.revalidate();
            this.repaint();
        }
    }

    public void setUI(ButtonUI buttonUI) {
        super.setUI(buttonUI);
    }

    public void setVerticalAlignment(int n) {
        if (n == this.verticalAlignment) {
            return;
        }
        int n2 = this.verticalAlignment;
        this.verticalAlignment = this.checkVerticalKey(n, VERTICAL_ALIGNMENT_CHANGED_PROPERTY);
        this.firePropertyChange(VERTICAL_ALIGNMENT_CHANGED_PROPERTY, n2, this.verticalAlignment);
        this.repaint();
    }

    public void setVerticalTextPosition(int n) {
        if (n == this.verticalTextPosition) {
            return;
        }
        int n2 = this.verticalTextPosition;
        this.verticalTextPosition = this.checkVerticalKey(n, VERTICAL_TEXT_POSITION_CHANGED_PROPERTY);
        this.firePropertyChange(VERTICAL_TEXT_POSITION_CHANGED_PROPERTY, n2, this.verticalTextPosition);
        this.repaint();
    }

    public void updateUI() {
    }

    protected class ButtonChangeListener
    implements ChangeListener,
    Serializable {
        ButtonChangeListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            AbstractButton.this.fireStateChanged();
            AbstractButton.this.repaint();
        }
    }

    private class ForwardActionEvents
    implements ActionListener,
    Serializable {
        ForwardActionEvents() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AbstractButton.this.fireActionPerformed(actionEvent);
        }
    }

    private class ForwardItemEvents
    implements ItemListener,
    Serializable {
        ForwardItemEvents() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            AbstractButton.this.fireItemStateChanged(itemEvent);
        }
    }

    protected abstract class AccessibleAbstractButton
    extends JComponent.AccessibleJComponent
    implements AccessibleAction,
    AccessibleValue {
        protected AccessibleAbstractButton() {
        }

        public boolean doAccessibleAction(int n) {
            if (n == 0) {
                AbstractButton.this.doClick();
                return true;
            }
            return false;
        }

        public AccessibleAction getAccessibleAction() {
            return this;
        }

        public int getAccessibleActionCount() {
            return 1;
        }

        public String getAccessibleActionDescription(int n) {
            if (n == 0) {
                return new String("click");
            }
            return null;
        }

        public String getAccessibleName() {
            if (this.accessibleName != null) {
                return this.accessibleName;
            }
            if (AbstractButton.this.getText() == null) {
                return super.getAccessibleName();
            }
            return AbstractButton.this.getText();
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            if (AbstractButton.this.getModel().isArmed()) {
                accessibleStateSet.add(AccessibleState.ARMED);
            }
            if (AbstractButton.this.hasFocus()) {
                accessibleStateSet.add(AccessibleState.FOCUSED);
            }
            if (AbstractButton.this.getModel().isPressed()) {
                accessibleStateSet.add(AccessibleState.PRESSED);
            }
            if (AbstractButton.this.isSelected()) {
                accessibleStateSet.add(AccessibleState.CHECKED);
            }
            return accessibleStateSet;
        }

        public AccessibleValue getAccessibleValue() {
            return this;
        }

        public Number getCurrentAccessibleValue() {
            if (AbstractButton.this.isSelected()) {
                return new Integer(1);
            }
            return new Integer(0);
        }

        public Number getMaximumAccessibleValue() {
            return new Integer(1);
        }

        public Number getMinimumAccessibleValue() {
            return new Integer(0);
        }

        public boolean setCurrentAccessibleValue(Number number) {
            if (number instanceof Integer) {
                int n = number.intValue();
                if (n == 0) {
                    AbstractButton.this.setSelected(false);
                } else {
                    AbstractButton.this.setSelected(true);
                }
                return true;
            }
            return false;
        }
    }
}

