/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.EventObject;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;
import javax.swing.table.TableCellEditor;
import javax.swing.tree.TreeCellEditor;

public class DefaultCellEditor
implements TableCellEditor,
TreeCellEditor,
Serializable {
    protected EventListenerList listenerList = new EventListenerList();
    protected transient ChangeEvent changeEvent = null;
    protected JComponent editorComponent;
    protected EditorDelegate delegate;
    protected int clickCountToStart = 1;
    static /* synthetic */ Class class$javax$swing$event$CellEditorListener;

    public DefaultCellEditor(final JCheckBox jCheckBox) {
        this.editorComponent = jCheckBox;
        this.delegate = new EditorDelegate(this){

            public Object getCellEditorValue() {
                return new Boolean(jCheckBox.isSelected());
            }

            public void setValue(Object object) {
                boolean bl = false;
                if (object instanceof Boolean) {
                    bl = (Boolean)object;
                } else if (object instanceof String) {
                    bl = object.equals("true");
                }
                jCheckBox.setSelected(bl);
            }
        };
        jCheckBox.addActionListener(this.delegate);
    }

    public DefaultCellEditor(final JComboBox jComboBox) {
        this.editorComponent = jComboBox;
        jComboBox.putClientProperty("JComboBox.lightweightKeyboardNavigation", "Lightweight");
        this.delegate = new EditorDelegate(this){

            public Object getCellEditorValue() {
                return jComboBox.getSelectedItem();
            }

            public void setValue(Object object) {
                jComboBox.setSelectedItem(object);
            }

            boolean shouldSelectCell(EventObject eventObject) {
                if (eventObject instanceof MouseEvent) {
                    MouseEvent mouseEvent = (MouseEvent)eventObject;
                    return mouseEvent.getID() != 506;
                }
                return true;
            }
        };
        jComboBox.addActionListener(this.delegate);
    }

    public DefaultCellEditor(final JTextField jTextField) {
        this.editorComponent = jTextField;
        this.clickCountToStart = 2;
        this.delegate = new EditorDelegate(this){

            public Object getCellEditorValue() {
                return jTextField.getText();
            }

            public void setValue(Object object) {
                jTextField.setText(object != null ? object.toString() : "");
            }
        };
        jTextField.addActionListener(this.delegate);
    }

    public void addCellEditorListener(CellEditorListener cellEditorListener) {
        this.listenerList.add(class$javax$swing$event$CellEditorListener != null ? class$javax$swing$event$CellEditorListener : (class$javax$swing$event$CellEditorListener = DefaultCellEditor.class$("javax.swing.event.CellEditorListener")), cellEditorListener);
    }

    public void cancelCellEditing() {
        this.fireEditingCanceled();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected void fireEditingCanceled() {
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$javax$swing$event$CellEditorListener != null ? class$javax$swing$event$CellEditorListener : DefaultCellEditor.class$("javax.swing.event.CellEditorListener"))) {
                if (this.changeEvent == null) {
                    this.changeEvent = new ChangeEvent(this);
                }
                ((CellEditorListener)objectArray[n + 1]).editingCanceled(this.changeEvent);
            }
            n -= 2;
        }
    }

    protected void fireEditingStopped() {
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$javax$swing$event$CellEditorListener != null ? class$javax$swing$event$CellEditorListener : DefaultCellEditor.class$("javax.swing.event.CellEditorListener"))) {
                if (this.changeEvent == null) {
                    this.changeEvent = new ChangeEvent(this);
                }
                ((CellEditorListener)objectArray[n + 1]).editingStopped(this.changeEvent);
            }
            n -= 2;
        }
    }

    public Object getCellEditorValue() {
        return this.delegate.getCellEditorValue();
    }

    public int getClickCountToStart() {
        return this.clickCountToStart;
    }

    public Component getComponent() {
        return this.editorComponent;
    }

    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        this.delegate.setValue(object);
        return this.editorComponent;
    }

    public Component getTreeCellEditorComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n) {
        String string = jTree.convertValueToText(object, bl, bl2, bl3, n, false);
        this.delegate.setValue(string);
        return this.editorComponent;
    }

    public boolean isCellEditable(EventObject eventObject) {
        if (eventObject instanceof MouseEvent) {
            return ((MouseEvent)eventObject).getClickCount() >= this.clickCountToStart;
        }
        return true;
    }

    public void removeCellEditorListener(CellEditorListener cellEditorListener) {
        this.listenerList.remove(class$javax$swing$event$CellEditorListener != null ? class$javax$swing$event$CellEditorListener : (class$javax$swing$event$CellEditorListener = DefaultCellEditor.class$("javax.swing.event.CellEditorListener")), cellEditorListener);
    }

    public void setClickCountToStart(int n) {
        this.clickCountToStart = n;
    }

    public boolean shouldSelectCell(EventObject eventObject) {
        return this.delegate.shouldSelectCell(eventObject);
    }

    public boolean stopCellEditing() {
        this.fireEditingStopped();
        return true;
    }

    protected class EditorDelegate
    implements ActionListener,
    ItemListener,
    Serializable {
        protected Object value;

        protected EditorDelegate() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DefaultCellEditor.this.fireEditingStopped();
        }

        public void cancelCellEditing() {
        }

        public Object getCellEditorValue() {
            return null;
        }

        public boolean isCellEditable(EventObject eventObject) {
            return true;
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            DefaultCellEditor.this.fireEditingStopped();
        }

        public void setValue(Object object) {
        }

        boolean shouldSelectCell(EventObject eventObject) {
            return true;
        }

        public boolean startCellEditing(EventObject eventObject) {
            return true;
        }

        public boolean stopCellEditing() {
            return true;
        }
    }
}

