/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.peer.LightweightPeer;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectInputValidation;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.swing.Action;
import javax.swing.AncestorNotifier;
import javax.swing.Autoscroller;
import javax.swing.CellRendererPane;
import javax.swing.DebugGraphics;
import javax.swing.DefaultFocusManager;
import javax.swing.FocusManager;
import javax.swing.JInternalFrame;
import javax.swing.JRootPane;
import javax.swing.JToolTip;
import javax.swing.KeyStroke;
import javax.swing.KeyboardManager;
import javax.swing.RepaintManager;
import javax.swing.SwingGraphics;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.AncestorListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.SwingPropertyChangeSupport;
import javax.swing.plaf.ComponentUI;

public abstract class JComponent
extends Container
implements Serializable {
    private static final String uiClassID = "ComponentUI";
    private static final Hashtable readObjectCallbacks = new Hashtable(1);
    private Dimension preferredSize;
    private Dimension minimumSize;
    private Dimension maximumSize;
    private Float alignmentX;
    private Float alignmentY;
    private AncestorNotifier ancestorNotifier;
    Rectangle _bounds = new Rectangle();
    protected transient ComponentUI ui;
    protected EventListenerList listenerList = new EventListenerList();
    private Hashtable clientProperties;
    private VetoableChangeSupport vetoableChangeSupport;
    private Autoscroller autoscroller;
    private Border border;
    private int flags;
    private transient Rectangle tmpRect;
    transient Component paintingChild;
    public static final int WHEN_FOCUSED = 0;
    public static final int WHEN_ANCESTOR_OF_FOCUSED_COMPONENT = 1;
    public static final int WHEN_IN_FOCUSED_WINDOW = 2;
    public static final int UNDEFINED_CONDITION = -1;
    private static final String KEYBOARD_BINDINGS_KEY = "_KeyboardBindings";
    public static final String TOOL_TIP_TEXT_KEY = "ToolTipText";
    private static final String NEXT_FOCUS = "nextFocus";
    private static final int REQUEST_FOCUS_DISABLED = 0;
    private static final int IS_DOUBLE_BUFFERED = 1;
    private static final int ANCESTOR_USING_BUFFER = 2;
    private static final int IS_PAINTING_TILE = 3;
    private static final int HAS_FOCUS = 4;
    private static final int IS_OPAQUE = 5;
    private static final int IS_PRINTING = 12;
    private static final int IS_PRINTING_ALL = 13;
    protected AccessibleContext accessibleContext = null;
    private SwingPropertyChangeSupport changeSupport;
    private Rectangle paintImmediatelyClip = new Rectangle(0, 0, 0, 0);
    static /* synthetic */ Class class$javax$swing$JComponent$KeyboardState;

    public JComponent() {
        this.enableEvents(4L);
        this.enableSerialization();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void _paintImmediately(int n, int n2, int n3, int n4) {
        Throwable throwable2;
        Vector vector;
        block27: {
            int n5;
            block28: {
                Object object;
                int n6;
                JComponent jComponent;
                block26: {
                    int n7 = 0;
                    int n8 = 0;
                    boolean bl = false;
                    JComponent jComponent2 = null;
                    jComponent = this;
                    RepaintManager repaintManager = RepaintManager.currentManager(this);
                    vector = new Vector(7);
                    n6 = -1;
                    int n9 = 0;
                    int n10 = 0;
                    int n11 = 0;
                    int n12 = 0;
                    int n13 = 0;
                    this.paintImmediatelyClip.x = n;
                    this.paintImmediatelyClip.y = n2;
                    this.paintImmediatelyClip.width = n3;
                    this.paintImmediatelyClip.height = n4;
                    boolean bl2 = this.alwaysOnTop() && this.isOpaque();
                    Container container = this;
                    while (true) {
                        if (container == null || container instanceof Window || container instanceof Applet) {
                            if (container == null) return;
                            if (container.getPeer() != null) break;
                            return;
                        }
                        vector.addElement(container);
                        if (!bl2 && container instanceof JComponent && !((JComponent)container).isOptimizedDrawingEnabled()) {
                            jComponent = container;
                            n6 = n9;
                            n8 = 0;
                            n7 = 0;
                            bl = false;
                        }
                        ++n9;
                        if (repaintManager.isDoubleBufferingEnabled() && container instanceof JComponent && ((JComponent)container).isDoubleBuffered()) {
                            bl = true;
                            jComponent2 = (JComponent)container;
                        }
                        if (!bl2) {
                            Rectangle rectangle = container instanceof JComponent ? ((JComponent)container)._bounds : container.getBounds();
                            n11 = rectangle.width;
                            n10 = rectangle.height;
                            SwingUtilities.computeIntersection(n13, n12, n11, n10, this.paintImmediatelyClip);
                            this.paintImmediatelyClip.x += rectangle.x;
                            this.paintImmediatelyClip.y += rectangle.y;
                            n7 += rectangle.x;
                            n8 += rectangle.y;
                        }
                        container = container.getParent();
                    }
                    if (this.paintImmediatelyClip.width <= 0) return;
                    if (this.paintImmediatelyClip.height <= 0) {
                        return;
                    }
                    this.paintImmediatelyClip.x -= n7;
                    this.paintImmediatelyClip.y -= n8;
                    if (jComponent != this) {
                        int n14 = n6;
                        while (n14 > 0) {
                            Component component = (Component)vector.elementAt(n14);
                            if (component instanceof JComponent) {
                                ((JComponent)component).setPaintingChild((Component)vector.elementAt(n14 - 1));
                            }
                            --n14;
                        }
                    }
                    try {
                        Graphics graphics;
                        try {
                            object = jComponent.getGraphics();
                            graphics = SwingGraphics.createSwingGraphics((Graphics)object);
                            ((Graphics)object).dispose();
                        }
                        catch (NullPointerException nullPointerException) {
                            graphics = null;
                            nullPointerException.printStackTrace();
                        }
                        if (graphics == null) {
                            System.err.println("In paintImmediately null graphics");
                            Object var23_22 = null;
                            if (jComponent != this) {
                                int n15 = n6;
                                while (n15 > 0) {
                                    object = (Component)vector.elementAt(n15);
                                    if (object instanceof JComponent) {
                                        ((JComponent)object).setPaintingChild(null);
                                    }
                                    --n15;
                                }
                            }
                            vector.removeAllElements();
                            return;
                        }
                        if (bl && (object = repaintManager.getOffscreenBuffer(jComponent2, this.paintImmediatelyClip.width, this.paintImmediatelyClip.height)) != null && ((Image)object).getWidth(null) > 0 && ((Image)object).getHeight(null) > 0) {
                            this.paintWithBuffer(jComponent, graphics, this.paintImmediatelyClip, (Image)object);
                            graphics.dispose();
                            break block26;
                        }
                        graphics.setClip(this.paintImmediatelyClip.x, this.paintImmediatelyClip.y, this.paintImmediatelyClip.width, this.paintImmediatelyClip.height);
                        try {
                            jComponent.paint(graphics);
                        }
                        finally {
                            Object var26_35 = null;
                            graphics.dispose();
                        }
                    }
                    catch (Throwable throwable2) {
                        Object var23_24 = null;
                        if (jComponent == this) break block27;
                        n5 = n6;
                        break block28;
                    }
                }
                Object var23_23 = null;
                if (jComponent != this) {
                    int n16 = n6;
                    while (n16 > 0) {
                        object = (Component)vector.elementAt(n16);
                        if (object instanceof JComponent) {
                            ((JComponent)object).setPaintingChild(null);
                        }
                        --n16;
                    }
                }
                vector.removeAllElements();
                return;
            }
            while (n5 > 0) {
                Component component = (Component)vector.elementAt(n5);
                if (component instanceof JComponent) {
                    ((JComponent)component).setPaintingChild(null);
                }
                --n5;
            }
        }
        vector.removeAllElements();
        throw throwable2;
    }

    public void addAncestorListener(AncestorListener ancestorListener) {
        if (this.ancestorNotifier == null) {
            this.ancestorNotifier = new AncestorNotifier(this);
        }
        this.ancestorNotifier.addAncestorListener(ancestorListener);
    }

    public void addNotify() {
        super.addNotify();
        this.firePropertyChange("ancestor", null, this.getParent());
        Hashtable hashtable = (Hashtable)this.getClientProperty(KEYBOARD_BINDINGS_KEY);
        if (hashtable == null) {
            return;
        }
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            KeyStroke keyStroke = (KeyStroke)enumeration.nextElement();
            KeyboardBinding keyboardBinding = (KeyboardBinding)hashtable.get(keyStroke);
            if (keyboardBinding.condition != 2) continue;
            this.registerWithKeyboardManager(keyStroke);
        }
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.changeSupport == null) {
            this.changeSupport = new SwingPropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            return;
        }
        if (this.changeSupport == null) {
            this.changeSupport = new SwingPropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(string, propertyChangeListener);
    }

    public synchronized void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (this.vetoableChangeSupport == null) {
            this.vetoableChangeSupport = new VetoableChangeSupport(this);
        }
        this.vetoableChangeSupport.addVetoableChangeListener(vetoableChangeListener);
    }

    private void adjustPaintFlags() {
        JComponent jComponent = null;
        Container container = this.getParent();
        while (container != null) {
            if (container instanceof JComponent) {
                jComponent = (JComponent)container;
                if (jComponent.getFlag(2)) {
                    this.setFlag(2, true);
                }
                if (jComponent.getFlag(3)) {
                    this.setFlag(3, true);
                }
                if (jComponent.getFlag(12)) {
                    this.setFlag(12, true);
                }
                if (!jComponent.getFlag(13)) break;
                this.setFlag(13, true);
                break;
            }
            container = container.getParent();
        }
    }

    boolean alwaysOnTop() {
        return false;
    }

    KeyboardBinding bindingForKeyStroke(KeyStroke keyStroke, int n) {
        KeyboardBinding keyboardBinding;
        KeyboardBinding keyboardBinding2 = null;
        Hashtable hashtable = (Hashtable)this.getClientProperty(KEYBOARD_BINDINGS_KEY);
        if (hashtable != null && (keyboardBinding = (KeyboardBinding)hashtable.get(keyStroke)) != null) {
            ActionListener actionListener = keyboardBinding.getAction();
            if (actionListener instanceof Action && !((Action)actionListener).isEnabled()) {
                actionListener = null;
            }
            if (actionListener != null) {
                switch (keyboardBinding.getCondition()) {
                    case 0: {
                        if (n != 0) break;
                        keyboardBinding2 = keyboardBinding;
                        break;
                    }
                    case 1: {
                        if (n != 0 && n != 1) break;
                        keyboardBinding2 = keyboardBinding;
                        break;
                    }
                    case 2: {
                        if (n != 0 && n != 2 && n != 1) break;
                        keyboardBinding2 = keyboardBinding;
                        break;
                    }
                }
            }
        }
        return keyboardBinding2;
    }

    boolean checkIfChildObscuredBySibling() {
        return true;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static final void computeVisibleRect(Component component, Rectangle rectangle) {
        Container container = component.getParent();
        Rectangle rectangle2 = component.getBounds();
        if (container == null || container instanceof Window || container instanceof Applet) {
            rectangle.setBounds(0, 0, rectangle2.width, rectangle2.height);
        } else {
            JComponent.computeVisibleRect(container, rectangle);
            rectangle.x -= rectangle2.x;
            rectangle.y -= rectangle2.y;
            SwingUtilities.computeIntersection(0, 0, rectangle2.width, rectangle2.height, rectangle);
        }
    }

    public void computeVisibleRect(Rectangle rectangle) {
        JComponent.computeVisibleRect(this, rectangle);
    }

    public boolean contains(int n, int n2) {
        return this.ui != null ? this.ui.contains(this, n, n2) : super.contains(n, n2);
    }

    public JToolTip createToolTip() {
        JToolTip jToolTip = new JToolTip();
        jToolTip.setComponent(this);
        return jToolTip;
    }

    void enableSerialization() {
        this.addFocusListener(new EnableSerializationFocusListener());
    }

    public void firePropertyChange(String string, byte by, byte by2) {
        if (this.changeSupport != null && by != by2) {
            this.changeSupport.firePropertyChange(string, new Byte(by), new Byte(by2));
        }
    }

    public void firePropertyChange(String string, char c, char c2) {
        if (this.changeSupport != null && c != c2) {
            this.changeSupport.firePropertyChange(string, new Character(c), new Character(c2));
        }
    }

    public void firePropertyChange(String string, double d, double d2) {
        if (this.changeSupport != null && d != d2) {
            this.changeSupport.firePropertyChange(string, new Double(d), new Double(d2));
        }
    }

    public void firePropertyChange(String string, float f, float f2) {
        if (this.changeSupport != null && f != f2) {
            this.changeSupport.firePropertyChange(string, new Float(f), new Float(f2));
        }
    }

    public void firePropertyChange(String string, int n, int n2) {
        if (this.changeSupport != null && n != n2) {
            this.changeSupport.firePropertyChange(string, new Integer(n), new Integer(n2));
        }
    }

    public void firePropertyChange(String string, long l, long l2) {
        if (this.changeSupport != null && l != l2) {
            this.changeSupport.firePropertyChange(string, new Long(l), new Long(l2));
        }
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        if (this.changeSupport != null) {
            this.changeSupport.firePropertyChange(string, object, object2);
        }
    }

    public void firePropertyChange(String string, short s, short s2) {
        if (this.changeSupport != null && s != s2) {
            this.changeSupport.firePropertyChange(string, new Short(s), new Short(s2));
        }
    }

    public void firePropertyChange(String string, boolean bl, boolean bl2) {
        if (this.changeSupport != null && bl != bl2) {
            this.changeSupport.firePropertyChange(string, new Boolean(bl), new Boolean(bl2));
        }
    }

    protected void fireVetoableChange(String string, Object object, Object object2) throws PropertyVetoException {
        if (this.vetoableChangeSupport == null) {
            return;
        }
        this.vetoableChangeSupport.fireVetoableChange(string, object, object2);
    }

    public AccessibleContext getAccessibleContext() {
        return this.accessibleContext;
    }

    public ActionListener getActionForKeyStroke(KeyStroke keyStroke) {
        Hashtable hashtable = this.keyboardBindings();
        if (hashtable == null) {
            return null;
        }
        Hashtable hashtable2 = hashtable;
        synchronized (hashtable2) {
            KeyboardBinding keyboardBinding = (KeyboardBinding)hashtable.get(keyStroke);
            if (keyboardBinding != null) {
                ActionListener actionListener = keyboardBinding.getAction();
                Object var5_6 = null;
                return actionListener;
            }
        }
        return null;
    }

    public float getAlignmentX() {
        return this.alignmentX != null ? this.alignmentX.floatValue() : super.getAlignmentX();
    }

    public float getAlignmentY() {
        return this.alignmentY != null ? this.alignmentY.floatValue() : super.getAlignmentY();
    }

    public boolean getAutoscrolls() {
        return this.autoscroller != null;
    }

    public Border getBorder() {
        return this.border;
    }

    public Rectangle getBounds(Rectangle rectangle) {
        if (rectangle == null) {
            return new Rectangle(this.getX(), this.getY(), this.getWidth(), this.getHeight());
        }
        rectangle.setBounds(this.getX(), this.getY(), this.getWidth(), this.getHeight());
        return rectangle;
    }

    private Dictionary getClientProperties() {
        if (this.clientProperties == null) {
            this.clientProperties = new Hashtable(2);
        }
        return this.clientProperties;
    }

    public final Object getClientProperty(Object object) {
        if (this.clientProperties == null) {
            return null;
        }
        return this.getClientProperties().get(object);
    }

    protected Graphics getComponentGraphics(Graphics graphics) {
        Graphics graphics2 = graphics;
        if (this.ui != null && DebugGraphics.debugComponentCount() != 0 && this.shouldDebugGraphics() != 0 && !(graphics instanceof DebugGraphics)) {
            if (graphics instanceof SwingGraphics) {
                if (!(((SwingGraphics)graphics).subGraphics() instanceof DebugGraphics)) {
                    graphics2 = new DebugGraphics(((SwingGraphics)graphics).subGraphics(), this);
                    graphics2 = SwingGraphics.createSwingGraphics(graphics2);
                }
            } else {
                graphics2 = new DebugGraphics(graphics, this);
            }
        }
        graphics2.setColor(this.getForeground());
        graphics2.setFont(this.getFont());
        return graphics2;
    }

    public int getConditionForKeyStroke(KeyStroke keyStroke) {
        Hashtable hashtable = this.keyboardBindings();
        if (hashtable == null) {
            return -1;
        }
        Hashtable hashtable2 = hashtable;
        synchronized (hashtable2) {
            KeyboardBinding keyboardBinding = (KeyboardBinding)hashtable.get(keyStroke);
            if (keyboardBinding != null) {
                int n = keyboardBinding.getCondition();
                Object var5_6 = null;
                return n;
            }
        }
        return -1;
    }

    public int getDebugGraphicsOptions() {
        return DebugGraphics.getDebugOptions(this);
    }

    private boolean getFlag(int n) {
        int n2 = 1 << n;
        return (this.flags & n2) == n2;
    }

    public Graphics getGraphics() {
        if (this.shouldDebugGraphics() != 0) {
            DebugGraphics debugGraphics = new DebugGraphics(super.getGraphics(), this);
            return debugGraphics;
        }
        return super.getGraphics();
    }

    public int getHeight() {
        return this._bounds.height;
    }

    public Insets getInsets() {
        if (this.border != null) {
            return this.border.getBorderInsets(this);
        }
        return super.getInsets();
    }

    public Insets getInsets(Insets insets) {
        if (this.border != null) {
            if (this.border instanceof AbstractBorder) {
                return ((AbstractBorder)this.border).getBorderInsets(this, insets);
            }
            return this.border.getBorderInsets(this);
        }
        insets.bottom = 0;
        insets.right = 0;
        insets.top = 0;
        insets.left = 0;
        return insets;
    }

    public Point getLocation(Point point) {
        if (point == null) {
            return new Point(this.getX(), this.getY());
        }
        point.setLocation(this.getX(), this.getY());
        return point;
    }

    public Dimension getMaximumSize() {
        if (this.maximumSize != null) {
            return this.maximumSize;
        }
        Dimension dimension = null;
        if (this.ui != null) {
            dimension = this.ui.getMaximumSize(this);
        }
        return dimension != null ? dimension : super.getMaximumSize();
    }

    public Dimension getMinimumSize() {
        if (this.minimumSize != null) {
            return this.minimumSize;
        }
        Dimension dimension = null;
        if (this.ui != null) {
            dimension = this.ui.getMinimumSize(this);
        }
        return dimension != null ? dimension : super.getMinimumSize();
    }

    public Component getNextFocusableComponent() {
        return (Component)this.getClientProperty(NEXT_FOCUS);
    }

    public Dimension getPreferredSize() {
        if (this.preferredSize != null) {
            return this.preferredSize;
        }
        Dimension dimension = null;
        if (this.ui != null) {
            dimension = this.ui.getPreferredSize(this);
        }
        return dimension != null ? dimension : super.getPreferredSize();
    }

    public KeyStroke[] getRegisteredKeyStrokes() {
        KeyStroke[] keyStrokeArray;
        Hashtable hashtable = this.keyboardBindings();
        if (hashtable == null) {
            return new KeyStroke[0];
        }
        Hashtable hashtable2 = hashtable;
        synchronized (hashtable2) {
            keyStrokeArray = new KeyStroke[hashtable.size()];
            int n = 0;
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                keyStrokeArray[n++] = (KeyStroke)enumeration.nextElement();
            }
        }
        return keyStrokeArray;
    }

    public JRootPane getRootPane() {
        return SwingUtilities.getRootPane(this);
    }

    public Dimension getSize(Dimension dimension) {
        if (dimension == null) {
            return new Dimension(this.getWidth(), this.getHeight());
        }
        dimension.setSize(this.getWidth(), this.getHeight());
        return dimension;
    }

    public Point getToolTipLocation(MouseEvent mouseEvent) {
        return null;
    }

    public String getToolTipText() {
        return (String)this.getClientProperty(TOOL_TIP_TEXT_KEY);
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        return this.getToolTipText();
    }

    public Container getTopLevelAncestor() {
        Container container = this;
        while (container != null) {
            if (container instanceof Window || container instanceof Applet) {
                return container;
            }
            container = container.getParent();
        }
        return null;
    }

    public String getUIClassID() {
        return uiClassID;
    }

    public Rectangle getVisibleRect() {
        Rectangle rectangle = new Rectangle();
        this.computeVisibleRect(rectangle);
        return rectangle;
    }

    public int getWidth() {
        return this._bounds.width;
    }

    public int getX() {
        return this._bounds.x;
    }

    public int getY() {
        return this._bounds.y;
    }

    public void grabFocus() {
        super.requestFocus();
    }

    public boolean hasFocus() {
        return this.getFlag(4);
    }

    public boolean isDoubleBuffered() {
        return this.getFlag(1);
    }

    public boolean isFocusCycleRoot() {
        return false;
    }

    public boolean isFocusTraversable() {
        Hashtable hashtable;
        boolean bl = false;
        Serializable serializable = this;
        synchronized (serializable) {
            hashtable = (Hashtable)this.getClientProperty(KEYBOARD_BINDINGS_KEY);
        }
        if (hashtable != null) {
            serializable = hashtable;
            synchronized (serializable) {
                Enumeration enumeration = hashtable.keys();
                while (enumeration.hasMoreElements()) {
                    KeyboardBinding keyboardBinding = (KeyboardBinding)hashtable.get(enumeration.nextElement());
                    if (keyboardBinding.getCondition() != 0) continue;
                    bl = true;
                    break;
                }
            }
        }
        return bl;
    }

    public static boolean isLightweightComponent(Component component) {
        return component.getPeer() instanceof LightweightPeer;
    }

    public boolean isManagingFocus() {
        return false;
    }

    public boolean isOpaque() {
        return this.getFlag(5);
    }

    public boolean isOptimizedDrawingEnabled() {
        return true;
    }

    public boolean isPaintingTile() {
        return this.getFlag(3);
    }

    public boolean isRequestFocusEnabled() {
        return !this.getFlag(0);
    }

    public boolean isValidateRoot() {
        return false;
    }

    private Hashtable keyboardBindings() {
        Hashtable hashtable;
        JComponent jComponent = this;
        synchronized (jComponent) {
            hashtable = (Hashtable)this.getClientProperty(KEYBOARD_BINDINGS_KEY);
        }
        return hashtable;
    }

    public void paint(Graphics graphics) {
        Graphics graphics2;
        boolean bl;
        block21: {
            bl = false;
            if (this.getWidth() <= 0 || this.getHeight() <= 0) {
                return;
            }
            Graphics graphics3 = this.getComponentGraphics(graphics);
            graphics2 = SwingGraphics.createSwingGraphics(graphics3);
            try {
                int n;
                int n2;
                boolean bl2;
                int n3;
                int n4;
                int n5;
                int n6;
                Image image = null;
                RepaintManager repaintManager = RepaintManager.currentManager(this);
                Rectangle rectangle = graphics2.getClipBounds();
                if (rectangle == null) {
                    n6 = 0;
                    n5 = 0;
                    n4 = this._bounds.width;
                    n3 = this._bounds.height;
                } else {
                    n5 = rectangle.x;
                    n6 = rectangle.y;
                    n4 = rectangle.width;
                    n3 = rectangle.height;
                }
                if (n4 > this.getWidth()) {
                    n4 = this.getWidth();
                }
                if (n3 > this.getHeight()) {
                    n3 = this.getHeight();
                }
                if (this.getParent() != null && !(this.getParent() instanceof JComponent)) {
                    this.adjustPaintFlags();
                    bl = true;
                }
                if (!(bl2 = this.getFlag(12)) && repaintManager.isDoubleBufferingEnabled() && !this.getFlag(2) && this.isDoubleBuffered() && (image = repaintManager.getOffscreenBuffer(this, n4, n3)) != null && (n2 = image.getWidth(null)) > 0 && (n = image.getHeight(null)) > 0) {
                    Graphics graphics4 = SwingGraphics.createSwingGraphics(image.getGraphics());
                    try {
                        graphics4.translate(-n5, -n6);
                        n2 = image.getWidth(null);
                        n = image.getHeight(null);
                        if (n2 > n4) {
                            n2 = n4;
                        }
                        if (n > n3) {
                            n = n3;
                        }
                        this.setFlag(2, true);
                        this.setFlag(3, true);
                        int n7 = 0;
                        int n8 = n4;
                        while (n7 < n8) {
                            int n9 = 0;
                            int n10 = n3;
                            while (n9 < n10) {
                                if (n9 + n >= n10 && n7 + n2 >= n8) {
                                    this.setFlag(3, false);
                                }
                                graphics4.translate(-n7, -n9);
                                graphics4.setClip(n5 + n7, n6 + n9, n2, n);
                                if (!this.rectangleIsObscured(n5, n6, n2, n)) {
                                    this.paintComponent(graphics4);
                                    this.paintBorder(graphics4);
                                }
                                this.paintChildren(graphics4);
                                graphics2.drawImage(image, n5 + n7, n6 + n9, this);
                                graphics4.translate(n7, n9);
                                n9 += n;
                            }
                            n7 += n2;
                        }
                        break block21;
                    }
                    finally {
                        Object var23_20 = null;
                        this.setFlag(2, false);
                        this.setFlag(3, false);
                        graphics4.dispose();
                    }
                }
                if (!this.rectangleIsObscured(n5, n6, n4, n3)) {
                    this.paintComponent(graphics2);
                    this.paintBorder(graphics2);
                }
                this.paintChildren(graphics2);
            }
            catch (Throwable throwable) {
                Object var6_24 = null;
                graphics2.dispose();
                if (bl) {
                    this.setFlag(2, false);
                    this.setFlag(3, false);
                    this.setFlag(12, false);
                    this.setFlag(13, false);
                }
                throw throwable;
            }
        }
        Object var6_23 = null;
        graphics2.dispose();
        if (bl) {
            this.setFlag(2, false);
            this.setFlag(3, false);
            this.setFlag(12, false);
            this.setFlag(13, false);
        }
    }

    protected void paintBorder(Graphics graphics) {
        Border border = this.getBorder();
        if (border != null) {
            border.paintBorder(this, graphics, 0, 0, this.getWidth(), this.getHeight());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void paintChildren(Graphics graphics) {
        Graphics graphics2;
        block29: {
            graphics2 = null;
            try {
                Object object = this.getTreeLock();
                synchronized (object) {
                    block28: {
                        boolean bl = this.getFlag(12);
                        int n = this.getComponentCount() - 1;
                        if (n < 0) {
                            Object var7_6 = null;
                            break block28;
                        }
                        graphics2 = SwingGraphics.createSwingGraphics(graphics);
                        if (this.paintingChild != null && this.paintingChild instanceof JComponent && ((JComponent)this.paintingChild).isOpaque()) {
                            while (n >= 0 && this.getComponent(n) != this.paintingChild) {
                                --n;
                            }
                        }
                        if (this.tmpRect == null) {
                            this.tmpRect = new Rectangle();
                        }
                        boolean bl2 = !this.isOptimizedDrawingEnabled() && this.checkIfChildObscuredBySibling();
                        Rectangle rectangle = null;
                        if (bl2 && (rectangle = graphics2.getClipBounds()) == null) {
                            rectangle = new Rectangle(0, 0, this._bounds.width, this._bounds.height);
                        }
                        while (true) {
                            block31: {
                                Graphics graphics3;
                                int n2;
                                Component component;
                                block30: {
                                    Rectangle rectangle2;
                                    boolean bl3;
                                    block32: {
                                        if (n < 0) {
                                            break block29;
                                        }
                                        component = this.getComponent(n);
                                        if (component == null || !JComponent.isLightweightComponent(component) || !component.isVisible()) break block31;
                                        bl3 = component instanceof JComponent;
                                        if (bl3) {
                                            rectangle2 = this.tmpRect;
                                            ((JComponent)component).getBounds(rectangle2);
                                        } else {
                                            rectangle2 = component.getBounds();
                                        }
                                        boolean bl4 = graphics.hitClip(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                                        if (!bl4) break block31;
                                        if (!bl2 || n <= 0) break block32;
                                        int n3 = rectangle2.x;
                                        n2 = rectangle2.y;
                                        int n4 = rectangle2.width;
                                        int n5 = rectangle2.height;
                                        SwingUtilities.computeIntersection(rectangle.x, rectangle.y, rectangle.width, rectangle.height, rectangle2);
                                        if (this.rectangleIsObscuredBySibling(n, rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height)) break block31;
                                        rectangle2.x = n3;
                                        rectangle2.y = n2;
                                        rectangle2.width = n4;
                                        rectangle2.height = n5;
                                    }
                                    graphics3 = SwingGraphics.createSwingGraphics(graphics2, rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                                    graphics3.setColor(component.getForeground());
                                    graphics3.setFont(component.getFont());
                                    n2 = 0;
                                    try {
                                        if (bl3) {
                                            if (this.getFlag(2)) {
                                                ((JComponent)component).setFlag(2, true);
                                                n2 = 1;
                                            }
                                            if (this.getFlag(3)) {
                                                ((JComponent)component).setFlag(3, true);
                                                n2 = 1;
                                            }
                                            if (!bl) {
                                                ((JComponent)component).paint(graphics3);
                                                break block30;
                                            }
                                            if (!this.getFlag(13)) {
                                                component.print(graphics3);
                                                break block30;
                                            } else {
                                                component.printAll(graphics3);
                                            }
                                            break block30;
                                        }
                                        if (!bl) {
                                            component.paint(graphics3);
                                            break block30;
                                        }
                                        if (!this.getFlag(13)) {
                                            component.print(graphics3);
                                        } else {
                                            component.printAll(graphics3);
                                        }
                                    }
                                    catch (Throwable throwable) {
                                        Object var18_23 = null;
                                        graphics3.dispose();
                                        if (n2 == 0) throw throwable;
                                        ((JComponent)component).setFlag(2, false);
                                        ((JComponent)component).setFlag(3, false);
                                        throw throwable;
                                    }
                                }
                                Object var18_22 = null;
                                graphics3.dispose();
                                if (n2 != 0) {
                                    ((JComponent)component).setFlag(2, false);
                                    ((JComponent)component).setFlag(3, false);
                                }
                            }
                            --n;
                        }
                    }
                }
                Object var5_7 = null;
                if (graphics2 == null) return;
                graphics2.dispose();
                return;
            }
            catch (Throwable throwable) {
                Object var5_9 = null;
                if (graphics2 == null) throw throwable;
                graphics2.dispose();
                throw throwable;
            }
        }
        Object var5_8 = null;
        if (graphics2 == null) return;
        graphics2.dispose();
    }

    protected void paintComponent(Graphics graphics) {
        if (this.ui != null) {
            Graphics graphics2 = SwingGraphics.createSwingGraphics(graphics);
            try {
                this.ui.update(graphics2, this);
            }
            finally {
                Object var4_3 = null;
                graphics2.dispose();
            }
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void paintImmediately(int var1_1, int var2_2, int var3_3, int var4_4) {
        var5_5 /* !! */  = this;
        if (this.isShowing()) ** GOTO lbl10
        return;
        while ((var6_6 = var5_5 /* !! */ .getParent()) != null) {
            var7_7 = var5_5 /* !! */  instanceof JComponent != false ? var5_5 /* !! */ ._bounds : var5_5 /* !! */ .getBounds();
            var1_1 += var7_7.x;
            var2_2 += var7_7.y;
            var5_5 /* !! */  = var6_6;
            if (!(var5_5 /* !! */  instanceof JComponent)) break;
lbl10:
            // 2 sources

            if (!var5_5 /* !! */ .isOpaque()) continue;
        }
        if (var5_5 /* !! */  instanceof JComponent) {
            var5_5 /* !! */ ._paintImmediately(var1_1, var2_2, var3_3, var4_4);
        } else {
            var5_5 /* !! */ .repaint(var1_1, var2_2, var3_3, var4_4);
        }
    }

    public void paintImmediately(Rectangle rectangle) {
        this.paintImmediately(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    private void paintWithBuffer(JComponent jComponent, Graphics graphics, Rectangle rectangle, Image image) {
        Graphics graphics2 = SwingGraphics.createSwingGraphics(image.getGraphics());
        int n = image.getWidth(null);
        int n2 = image.getHeight(null);
        if (n > rectangle.width) {
            n = rectangle.width;
        }
        if (n2 > rectangle.height) {
            n2 = rectangle.height;
        }
        try {
            jComponent.setFlag(2, true);
            jComponent.setFlag(3, true);
            int n3 = rectangle.x;
            int n4 = rectangle.x + rectangle.width;
            while (n3 < n4) {
                int n5 = rectangle.y;
                int n6 = rectangle.y + rectangle.height;
                while (n5 < n6) {
                    if (n5 + n2 >= n6 && n3 + n >= n4) {
                        jComponent.setFlag(3, false);
                    }
                    graphics2.translate(-n3, -n5);
                    graphics2.setClip(n3, n5, n, n2);
                    jComponent.paint(graphics2);
                    graphics.setClip(n3, n5, n, n2);
                    graphics.drawImage(image, n3, n5, jComponent);
                    graphics2.translate(n3, n5);
                    n5 += n2;
                }
                n3 += n;
            }
        }
        finally {
            Object var13_12 = null;
            jComponent.setFlag(2, false);
            jComponent.setFlag(3, false);
            graphics2.dispose();
        }
    }

    protected String paramString() {
        String string = this.preferredSize != null ? this.preferredSize.toString() : "";
        String string2 = this.minimumSize != null ? this.minimumSize.toString() : "";
        String string3 = this.maximumSize != null ? this.maximumSize.toString() : "";
        String string4 = this.border != null ? this.border.toString() : "";
        return String.valueOf(super.paramString()) + ",alignmentX=" + this.alignmentX + ",alignmentY=" + this.alignmentY + ",border=" + string4 + ",flags=" + this.flags + ",maximumSize=" + string3 + ",minimumSize=" + string2 + ",preferredSize=" + string;
    }

    public void print(Graphics graphics) {
        this.setFlag(12, true);
        try {
            this.paint(graphics);
        }
        finally {
            Object var3_2 = null;
            this.setFlag(12, false);
        }
    }

    public void printAll(Graphics graphics) {
        this.setFlag(13, true);
        try {
            this.print(graphics);
        }
        finally {
            Object var3_2 = null;
            this.setFlag(13, false);
        }
    }

    protected void processComponentKeyEvent(KeyEvent keyEvent) {
    }

    protected void processFocusEvent(FocusEvent focusEvent) {
        switch (focusEvent.getID()) {
            case 1004: {
                this.setFlag(4, true);
                break;
            }
            case 1005: {
                this.setFlag(4, false);
                break;
            }
        }
        super.processFocusEvent(focusEvent);
    }

    boolean processKeyBinding(KeyEvent keyEvent, int n, boolean bl) {
        boolean bl2 = !bl;
        KeyboardBinding keyboardBinding = null;
        if (this.isEnabled()) {
            ActionListener actionListener;
            if (keyEvent.getID() == 400) {
                KeyStroke keyStroke = KeyStroke.getKeyStroke(keyEvent.getKeyChar());
                keyboardBinding = this.bindingForKeyStroke(keyStroke, n);
            } else {
                KeyStroke keyStroke = KeyStroke.getKeyStroke(keyEvent.getKeyCode(), keyEvent.getModifiers(), bl2);
                keyboardBinding = this.bindingForKeyStroke(keyStroke, n);
            }
            if (keyboardBinding != null && (actionListener = keyboardBinding.getAction()) != null) {
                actionListener.actionPerformed(new ActionEvent(this, 1001, keyboardBinding.getCommand()));
                return true;
            }
        }
        return false;
    }

    boolean processKeyBindings(KeyEvent keyEvent, boolean bl) {
        if (this.processKeyBinding(keyEvent, 0, bl)) {
            return true;
        }
        Container container = this.getParent();
        while (!(container == null || container instanceof Window || container instanceof Applet || container instanceof JInternalFrame)) {
            if (container instanceof JComponent && ((JComponent)container).processKeyBinding(keyEvent, 1, bl)) {
                return true;
            }
            container = container.getParent();
        }
        if (container != null) {
            return JComponent.processKeyBindingsForAllComponents(keyEvent, container, bl);
        }
        return false;
    }

    static boolean processKeyBindingsForAllComponents(KeyEvent keyEvent, Container container, boolean bl) {
        return KeyboardManager.getCurrentManager().fireKeyboardAction(keyEvent, bl, container);
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        boolean bl;
        boolean bl2 = false;
        if (FocusManager.isFocusManagerEnabled()) {
            FocusManager focusManager = FocusManager.getCurrentManager();
            focusManager.processKeyEvent(this, keyEvent);
            if (keyEvent.isConsumed()) {
                return;
            }
        }
        super.processKeyEvent(keyEvent);
        if (!keyEvent.isConsumed()) {
            this.processComponentKeyEvent(keyEvent);
        }
        if (keyEvent.getID() == 401) {
            bl2 = true;
            if (!KeyboardState.keyIsPressed(keyEvent.getKeyCode())) {
                KeyboardState.registerKeyPressed(keyEvent.getKeyCode());
            }
        } else if (keyEvent.getID() == 402) {
            if (KeyboardState.keyIsPressed(keyEvent.getKeyCode())) {
                bl2 = true;
                KeyboardState.registerKeyReleased(keyEvent.getKeyCode());
            }
        } else if (keyEvent.getID() == 400) {
            bl2 = true;
        }
        if (keyEvent.isConsumed()) {
            return;
        }
        if (bl2 && keyEvent.getID() == 401) {
            boolean bl3 = this.processKeyBindings(keyEvent, true);
            if (bl3) {
                keyEvent.consume();
            }
        } else if (bl2 && keyEvent.getID() == 402) {
            boolean bl4 = this.processKeyBindings(keyEvent, false);
            if (bl4) {
                keyEvent.consume();
            }
        } else if (bl2 && keyEvent.getID() == 400 && (bl = this.processKeyBindings(keyEvent, false))) {
            keyEvent.consume();
        }
    }

    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
        boolean bl = true;
        if (this.autoscroller != null && mouseEvent.getID() == 506) {
            bl = this.autoscroller.timer.isRunning() ^ true;
            this.autoscroller.mouseDragged(mouseEvent);
        }
        if (bl) {
            super.processMouseMotionEvent(mouseEvent);
        }
    }

    public final void putClientProperty(Object object, Object object2) {
        Object object3 = this.getClientProperties().get(object);
        if (object2 != null) {
            this.getClientProperties().put(object, object2);
        } else {
            this.getClientProperties().remove(object);
        }
        this.firePropertyChange(object.toString(), object3, object2);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        ReadObjectCallback readObjectCallback = (ReadObjectCallback)readObjectCallbacks.get(objectInputStream);
        if (readObjectCallback == null) {
            try {
                readObjectCallback = new ReadObjectCallback(objectInputStream);
                readObjectCallbacks.put(objectInputStream, readObjectCallback);
            }
            catch (Exception exception) {
                throw new IOException(exception.toString());
            }
        }
        readObjectCallback.registerComponent(this);
        if (this.getToolTipText() != null) {
            ToolTipManager.sharedInstance().registerComponent(this);
        }
    }

    boolean rectangleIsObscured(int n, int n2, int n3, int n4) {
        int n5 = this.getComponentCount();
        int n6 = 0;
        while (n6 < n5) {
            Component component = this.getComponent(n6);
            Rectangle rectangle = component instanceof JComponent ? ((JComponent)component)._bounds : component.getBounds();
            if (n >= rectangle.x && n + n3 <= rectangle.x + rectangle.width && n2 >= rectangle.y && n2 + n4 <= rectangle.y + rectangle.height && component.isVisible()) {
                if (component instanceof JComponent) {
                    return ((JComponent)component).isOpaque();
                }
                return false;
            }
            ++n6;
        }
        return false;
    }

    boolean rectangleIsObscuredBySibling(int n, int n2, int n3, int n4, int n5) {
        int n6 = n - 1;
        while (n6 >= 0) {
            block2: {
                Rectangle rectangle;
                block4: {
                    Component component;
                    block3: {
                        component = this.getComponent(n6);
                        if (!component.isVisible()) break block2;
                        if (!(component instanceof JComponent)) break block3;
                        if (!((JComponent)component).isOpaque()) break block2;
                        rectangle = ((JComponent)component).getBounds(this.tmpRect);
                        break block4;
                    }
                    rectangle = component.getBounds();
                }
                if (n2 >= rectangle.x && n2 + n4 <= rectangle.x + rectangle.width && n3 >= rectangle.y && n3 + n5 <= rectangle.y + rectangle.height) {
                    return true;
                }
            }
            --n6;
        }
        return false;
    }

    public void registerKeyboardAction(ActionListener actionListener, String string, KeyStroke keyStroke, int n) {
        Hashtable hashtable;
        boolean bl = false;
        Serializable serializable = this;
        synchronized (serializable) {
            hashtable = (Hashtable)this.getClientProperty(KEYBOARD_BINDINGS_KEY);
            if (hashtable == null) {
                hashtable = new Hashtable();
                this.putClientProperty(KEYBOARD_BINDINGS_KEY, hashtable);
                bl = true;
            }
        }
        serializable = hashtable;
        synchronized (serializable) {
            hashtable.put(keyStroke, new KeyboardBinding(actionListener, string, keyStroke, n));
        }
        if (bl) {
            this.enableEvents(8L);
        }
        if (this.getParent() != null && n == 2) {
            this.registerWithKeyboardManager(keyStroke);
        }
    }

    public void registerKeyboardAction(ActionListener actionListener, KeyStroke keyStroke, int n) {
        this.registerKeyboardAction(actionListener, null, keyStroke, n);
    }

    void registerWithKeyboardManager(KeyStroke keyStroke) {
        KeyboardManager.getCurrentManager().registerKeyStroke(keyStroke, this);
    }

    public void removeAncestorListener(AncestorListener ancestorListener) {
        if (this.ancestorNotifier == null) {
            return;
        }
        this.ancestorNotifier.removeAncestorListener(ancestorListener);
        if (this.ancestorNotifier.listenerList.getListenerList().length == 0) {
            this.ancestorNotifier.removeAllListeners();
            this.ancestorNotifier = null;
        }
    }

    public void removeNotify() {
        super.removeNotify();
        this.firePropertyChange("ancestor", this.getParent(), null);
        Hashtable hashtable = (Hashtable)this.getClientProperty(KEYBOARD_BINDINGS_KEY);
        if (hashtable == null) {
            return;
        }
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            KeyStroke keyStroke = (KeyStroke)enumeration.nextElement();
            KeyboardBinding keyboardBinding = (KeyboardBinding)hashtable.get(keyStroke);
            if (keyboardBinding.condition != 2) continue;
            this.unregisterWithKeyboardManager(keyStroke);
        }
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.changeSupport != null) {
            this.changeSupport.removePropertyChangeListener(propertyChangeListener);
        }
    }

    public synchronized void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            return;
        }
        if (this.changeSupport == null) {
            return;
        }
        this.changeSupport.removePropertyChangeListener(string, propertyChangeListener);
    }

    public synchronized void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (this.vetoableChangeSupport == null) {
            return;
        }
        this.vetoableChangeSupport.removeVetoableChangeListener(vetoableChangeListener);
    }

    public void repaint(long l, int n, int n2, int n3, int n4) {
        RepaintManager.currentManager(this).addDirtyRegion(this, n, n2, n3, n4);
    }

    public void repaint(Rectangle rectangle) {
        this.repaint(0L, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public boolean requestDefaultFocus() {
        Component[] componentArray = this.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            if (componentArray[n].isFocusTraversable()) {
                if (componentArray[n] instanceof JComponent) {
                    ((JComponent)componentArray[n]).grabFocus();
                } else {
                    componentArray[n].requestFocus();
                }
                return true;
            }
            if (componentArray[n] instanceof JComponent && !((JComponent)componentArray[n]).isManagingFocus() && ((JComponent)componentArray[n]).requestDefaultFocus()) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void requestFocus() {
        FocusManager focusManager = FocusManager.getCurrentManager();
        if (focusManager instanceof DefaultFocusManager) {
            ((DefaultFocusManager)focusManager).clearHistory();
        }
        if (this.isRequestFocusEnabled()) {
            super.requestFocus();
        }
    }

    public void resetKeyboardActions() {
        JComponent jComponent = this;
        synchronized (jComponent) {
            Hashtable hashtable = (Hashtable)this.getClientProperty(KEYBOARD_BINDINGS_KEY);
            if (hashtable != null) {
                hashtable.clear();
            }
        }
    }

    public void reshape(int n, int n2, int n3, int n4) {
        if (this.isShowing()) {
            if (this._bounds.x + this._bounds.width > n && this._bounds.y + this._bounds.height > n2 && this._bounds.x < n + n3 && this._bounds.y < n2 + n4) {
                Rectangle[] rectangleArray = SwingUtilities.computeDifference(this.getBounds(), new Rectangle(n, n2, n3, n4));
                Container container = this.getParent();
                int n5 = 0;
                int n6 = rectangleArray.length;
                while (n5 < n6) {
                    container.repaint(rectangleArray[n5].x, rectangleArray[n5].y, rectangleArray[n5].width, rectangleArray[n5].height);
                    ++n5;
                }
            } else {
                this.getParent().repaint(this._bounds.x, this._bounds.y, this._bounds.width, this._bounds.height);
            }
        }
        this._bounds.setBounds(n, n2, n3, n4);
        super.reshape(n, n2, n3, n4);
    }

    public void revalidate() {
        if (this.getParent() == null) {
            this.invalidate();
        } else if (SwingUtilities.isEventDispatchThread()) {
            this.invalidate();
            RepaintManager.currentManager(this).addInvalidComponent(this);
        } else {
            Runnable runnable = new Runnable(){

                public void run() {
                    JComponent.this.revalidate();
                }
            };
            SwingUtilities.invokeLater(runnable);
        }
    }

    public void scrollRectToVisible(Rectangle rectangle) {
        int n = this.getX();
        int n2 = this.getY();
        Container container = this.getParent();
        while (container != null && !(container instanceof JComponent) && !(container instanceof CellRendererPane)) {
            Rectangle rectangle2 = container.getBounds();
            n += rectangle2.x;
            n2 += rectangle2.y;
            container = container.getParent();
        }
        if (container != null && !(container instanceof CellRendererPane)) {
            rectangle.x += n;
            rectangle.y += n2;
            ((JComponent)container).scrollRectToVisible(rectangle);
            rectangle.x -= n;
            rectangle.y -= n2;
        }
    }

    public void setAlignmentX(float f) {
        this.alignmentX = new Float(f > 1.0f ? 1.0f : (f < 0.0f ? 0.0f : f));
    }

    public void setAlignmentY(float f) {
        this.alignmentY = new Float(f > 1.0f ? 1.0f : (f < 0.0f ? 0.0f : f));
    }

    public void setAutoscrolls(boolean bl) {
        if (bl) {
            if (this.autoscroller == null) {
                this.autoscroller = new Autoscroller(this);
            }
        } else if (this.autoscroller != null) {
            this.autoscroller.dispose();
            this.autoscroller = null;
        }
    }

    public void setBackground(Color color) {
        block7: {
            Color color2;
            block6: {
                boolean bl;
                block5: {
                    block4: {
                        color2 = this.getBackground();
                        super.setBackground(color);
                        if (color2 == null) break block4;
                        bl = color2.equals(color) ^ true;
                        break block5;
                    }
                    if (color != null && !color.equals(color2)) break block6;
                    bl = false;
                }
                if (!bl) break block7;
            }
            if (!SwingUtilities.is1dot2) {
                this.firePropertyChange("background", color2, color);
            }
            this.repaint();
        }
    }

    public void setBorder(Border border) {
        Border border2 = this.border;
        this.border = border;
        this.firePropertyChange("border", border2, border);
        if (border != border2) {
            if (border == null || border2 == null || !border.getBorderInsets(this).equals(border2.getBorderInsets(this))) {
                this.revalidate();
            }
            this.repaint();
        }
    }

    public void setDebugGraphicsOptions(int n) {
        DebugGraphics.setDebugOptions(this, n);
    }

    public void setDoubleBuffered(boolean bl) {
        this.setFlag(1, bl);
    }

    public void setEnabled(boolean bl) {
        boolean bl2 = this.isEnabled();
        super.setEnabled(bl);
        if (!bl && this.hasFocus()) {
            FocusManager.getCurrentManager().focusPreviousComponent(this);
        }
        this.firePropertyChange("enabled", bl2, bl);
        if (bl != bl2) {
            this.repaint();
        }
    }

    private void setFlag(int n, boolean bl) {
        this.flags = bl ? (this.flags |= 1 << n) : (this.flags &= ~(1 << n));
    }

    public void setFont(Font font) {
        Font font2 = this.getFont();
        super.setFont(font);
        if (!SwingUtilities.is1dot2) {
            this.firePropertyChange("font", font2, font);
        }
        if (font != font2) {
            this.revalidate();
            this.repaint();
        }
    }

    public void setForeground(Color color) {
        block7: {
            Color color2;
            block6: {
                boolean bl;
                block5: {
                    block4: {
                        color2 = this.getForeground();
                        super.setForeground(color);
                        if (color2 == null) break block4;
                        bl = color2.equals(color) ^ true;
                        break block5;
                    }
                    if (color != null && !color.equals(color2)) break block6;
                    bl = false;
                }
                if (!bl) break block7;
            }
            if (!SwingUtilities.is1dot2) {
                this.firePropertyChange("foreground", color2, color);
            }
            this.repaint();
        }
    }

    public void setMaximumSize(Dimension dimension) {
        Dimension dimension2 = this.maximumSize;
        this.maximumSize = dimension;
        this.firePropertyChange("maximumSize", dimension2, dimension);
    }

    public void setMinimumSize(Dimension dimension) {
        Dimension dimension2 = this.minimumSize;
        this.minimumSize = dimension;
        this.firePropertyChange("minimumSize", dimension2, dimension);
    }

    public void setNextFocusableComponent(Component component) {
        this.putClientProperty(NEXT_FOCUS, component);
    }

    public void setOpaque(boolean bl) {
        boolean bl2 = this.getFlag(5);
        this.setFlag(5, bl);
        this.firePropertyChange("opaque", bl2, bl);
    }

    void setPaintingChild(Component component) {
        this.paintingChild = component;
    }

    public void setPreferredSize(Dimension dimension) {
        Dimension dimension2 = this.preferredSize;
        this.preferredSize = dimension;
        this.firePropertyChange("preferredSize", dimension2, dimension);
    }

    public void setRequestFocusEnabled(boolean bl) {
        this.setFlag(0, !bl);
    }

    public void setToolTipText(String string) {
        this.putClientProperty(TOOL_TIP_TEXT_KEY, string);
        ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
        if (string != null) {
            toolTipManager.registerComponent(this);
        } else {
            toolTipManager.unregisterComponent(this);
        }
    }

    protected void setUI(ComponentUI componentUI) {
        if (this.ui != null) {
            this.ui.uninstallUI(this);
        }
        ComponentUI componentUI2 = this.ui;
        this.ui = componentUI;
        if (this.ui != null) {
            this.ui.installUI(this);
        }
        this.firePropertyChange("UI", componentUI2, componentUI);
        this.revalidate();
        this.repaint();
    }

    public void setVisible(boolean bl) {
        if (bl != this.isVisible()) {
            super.setVisible(bl);
            Container container = this.getParent();
            if (container != null) {
                Rectangle rectangle = this.getBounds();
                container.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
            this.revalidate();
            if (this.accessibleContext != null) {
                if (bl) {
                    this.accessibleContext.firePropertyChange("AccessibleState", null, AccessibleState.VISIBLE);
                } else {
                    this.accessibleContext.firePropertyChange("AccessibleState", AccessibleState.VISIBLE, null);
                }
            }
        }
    }

    int shouldDebugGraphics() {
        return DebugGraphics.shouldComponentDebug(this);
    }

    void superProcessMouseMotionEvent(MouseEvent mouseEvent) {
        super.processMouseMotionEvent(mouseEvent);
    }

    public void unregisterKeyboardAction(KeyStroke keyStroke) {
        KeyboardBinding keyboardBinding;
        Hashtable hashtable = this.keyboardBindings();
        if (hashtable == null) {
            return;
        }
        Hashtable hashtable2 = hashtable;
        synchronized (hashtable2) {
            keyboardBinding = (KeyboardBinding)hashtable.remove(keyStroke);
        }
        hashtable.size();
        if (keyboardBinding != null && keyboardBinding.condition == 2) {
            this.unregisterWithKeyboardManager(keyStroke);
        }
    }

    void unregisterWithKeyboardManager(KeyStroke keyStroke) {
        KeyboardManager.getCurrentManager().unregisterKeyStroke(keyStroke, this);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void updateUI() {
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.ui != null && this.getUIClassID().equals(uiClassID)) {
            this.ui.installUI(this);
        }
    }

    static class KeyboardBinding
    implements Serializable {
        ActionListener action;
        String command;
        KeyStroke keyStroke;
        int condition;

        KeyboardBinding(ActionListener actionListener, String string, KeyStroke keyStroke, int n) {
            this.action = actionListener;
            this.command = string;
            this.keyStroke = keyStroke;
            this.condition = n;
        }

        ActionListener getAction() {
            return this.action;
        }

        String getCommand() {
            return this.command;
        }

        int getCondition() {
            return this.condition;
        }

        KeyStroke getKeyStroke() {
            return this.keyStroke;
        }

        public String toString() {
            return "KeyBinding (" + this.action + "," + this.keyStroke + "," + this.condition + ")";
        }
    }

    static final class IntVector {
        int[] array = null;
        int count = 0;
        int capacity = 0;

        IntVector() {
        }

        void addElement(int n) {
            if (this.count == this.capacity) {
                this.capacity = (this.capacity + 2) * 2;
                int[] nArray = new int[this.capacity];
                if (this.count > 0) {
                    System.arraycopy(this.array, 0, nArray, 0, this.count);
                }
                this.array = nArray;
            }
            this.array[this.count++] = n;
        }

        int elementAt(int n) {
            return this.array[n];
        }

        void setElementAt(int n, int n2) {
            this.array[n2] = n;
        }

        int size() {
            return this.count;
        }
    }

    static class KeyboardState
    implements Serializable {
        private static final Object keyCodesKey = class$javax$swing$JComponent$KeyboardState != null ? class$javax$swing$JComponent$KeyboardState : (class$javax$swing$JComponent$KeyboardState = JComponent.class$("javax.swing.JComponent$KeyboardState"));

        KeyboardState() {
        }

        static IntVector getKeyCodeArray() {
            IntVector intVector = (IntVector)SwingUtilities.appContextGet(keyCodesKey);
            if (intVector == null) {
                intVector = new IntVector();
                SwingUtilities.appContextPut(keyCodesKey, intVector);
            }
            return intVector;
        }

        static boolean keyIsPressed(int n) {
            IntVector intVector = KeyboardState.getKeyCodeArray();
            int n2 = intVector.size();
            int n3 = 0;
            while (n3 < n2) {
                if (intVector.elementAt(n3) == n) {
                    return true;
                }
                ++n3;
            }
            return false;
        }

        static void registerKeyPressed(int n) {
            IntVector intVector = KeyboardState.getKeyCodeArray();
            int n2 = intVector.size();
            int n3 = 0;
            while (n3 < n2) {
                if (intVector.elementAt(n3) == -1) {
                    intVector.setElementAt(n, n3);
                    return;
                }
                ++n3;
            }
            intVector.addElement(n);
        }

        static void registerKeyReleased(int n) {
            IntVector intVector = KeyboardState.getKeyCodeArray();
            int n2 = intVector.size();
            int n3 = 0;
            while (n3 < n2) {
                if (intVector.elementAt(n3) == n) {
                    intVector.setElementAt(-1, n3);
                    return;
                }
                ++n3;
            }
        }
    }

    public abstract class AccessibleJComponent
    extends AccessibleContext
    implements Serializable,
    AccessibleComponent {
        protected ContainerListener accessibleContainerHandler = null;

        protected AccessibleJComponent() {
        }

        public void addFocusListener(FocusListener focusListener) {
            JComponent.this.addFocusListener(focusListener);
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            if (this.accessibleContainerHandler == null) {
                this.accessibleContainerHandler = new AccessibleContainerHandler();
                JComponent.this.addContainerListener(this.accessibleContainerHandler);
            }
            super.addPropertyChangeListener(propertyChangeListener);
        }

        public boolean contains(Point point) {
            return JComponent.this.contains(point);
        }

        public Accessible getAccessibleAt(Point point) {
            return SwingUtilities.getAccessibleAt(JComponent.this, point);
        }

        public Accessible getAccessibleChild(int n) {
            if (JComponent.this.ui != null) {
                return JComponent.this.ui.getAccessibleChild(JComponent.this, n);
            }
            return SwingUtilities.getAccessibleChild(JComponent.this, n);
        }

        public int getAccessibleChildrenCount() {
            if (JComponent.this.ui != null) {
                return JComponent.this.ui.getAccessibleChildrenCount(JComponent.this);
            }
            return SwingUtilities.getAccessibleChildrenCount(JComponent.this);
        }

        public AccessibleComponent getAccessibleComponent() {
            return this;
        }

        public String getAccessibleDescription() {
            AccessibleContext accessibleContext;
            Object object;
            String string = this.accessibleDescription;
            if (string == null) {
                try {
                    string = JComponent.this.getToolTipText(null);
                }
                catch (Exception exception) {}
            }
            if (string == null && (object = JComponent.this.getClientProperty("labeledBy")) instanceof Accessible && (accessibleContext = ((Accessible)object).getAccessibleContext()) != null) {
                string = accessibleContext.getAccessibleDescription();
            }
            return string;
        }

        public int getAccessibleIndexInParent() {
            return SwingUtilities.getAccessibleIndexInParent(JComponent.this);
        }

        public String getAccessibleName() {
            AccessibleContext accessibleContext;
            Object object;
            String string = this.accessibleName;
            if (string == null) {
                string = this.getBorderTitle(JComponent.this.getBorder());
            }
            if (string == null && (object = JComponent.this.getClientProperty("labeledBy")) instanceof Accessible && (accessibleContext = ((Accessible)object).getAccessibleContext()) != null) {
                string = accessibleContext.getAccessibleName();
            }
            return string;
        }

        public Accessible getAccessibleParent() {
            if (this.accessibleParent != null) {
                return this.accessibleParent;
            }
            Container container = JComponent.this.getParent();
            if (container instanceof Accessible) {
                return (Accessible)((Object)container);
            }
            return null;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.SWING_COMPONENT;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            return SwingUtilities.getAccessibleStateSet(JComponent.this);
        }

        public Color getBackground() {
            return JComponent.this.getBackground();
        }

        protected String getBorderTitle(Border border) {
            if (border instanceof TitledBorder) {
                return ((TitledBorder)border).getTitle();
            }
            if (border instanceof CompoundBorder) {
                String string = this.getBorderTitle(((CompoundBorder)border).getInsideBorder());
                if (string == null) {
                    string = this.getBorderTitle(((CompoundBorder)border).getOutsideBorder());
                }
                return string;
            }
            return null;
        }

        public Rectangle getBounds() {
            return JComponent.this.getBounds();
        }

        public Cursor getCursor() {
            return JComponent.this.getCursor();
        }

        public Font getFont() {
            return JComponent.this.getFont();
        }

        public FontMetrics getFontMetrics(Font font) {
            return JComponent.this.getFontMetrics(font);
        }

        public Color getForeground() {
            return JComponent.this.getForeground();
        }

        public Locale getLocale() {
            return JComponent.this.getLocale();
        }

        public Point getLocation() {
            return JComponent.this.getLocation();
        }

        public Point getLocationOnScreen() {
            if (JComponent.this.isShowing()) {
                return JComponent.this.getLocationOnScreen();
            }
            return null;
        }

        public Dimension getSize() {
            return JComponent.this.getSize();
        }

        public boolean isEnabled() {
            return JComponent.this.isEnabled();
        }

        public boolean isFocusTraversable() {
            return JComponent.this.isFocusTraversable();
        }

        public boolean isShowing() {
            return JComponent.this.isShowing();
        }

        public boolean isVisible() {
            return JComponent.this.isVisible();
        }

        public void removeFocusListener(FocusListener focusListener) {
            JComponent.this.removeFocusListener(focusListener);
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            if (this.accessibleContainerHandler == null) {
                JComponent.this.removeContainerListener(this.accessibleContainerHandler);
            }
            super.removePropertyChangeListener(propertyChangeListener);
        }

        public void requestFocus() {
            JComponent.this.requestFocus();
        }

        public void setBackground(Color color) {
            JComponent.this.setBackground(color);
        }

        public void setBounds(Rectangle rectangle) {
            JComponent.this.setBounds(rectangle);
        }

        public void setCursor(Cursor cursor) {
            JComponent.this.setCursor(cursor);
        }

        public void setEnabled(boolean bl) {
            boolean bl2 = JComponent.this.isEnabled();
            JComponent.this.setEnabled(bl);
            if (bl != bl2 && JComponent.this.accessibleContext != null) {
                if (bl) {
                    JComponent.this.accessibleContext.firePropertyChange("AccessibleState", null, AccessibleState.ENABLED);
                } else {
                    JComponent.this.accessibleContext.firePropertyChange("AccessibleState", AccessibleState.ENABLED, null);
                }
            }
        }

        public void setFont(Font font) {
            JComponent.this.setFont(font);
        }

        public void setForeground(Color color) {
            JComponent.this.setForeground(color);
        }

        public void setLocation(Point point) {
            JComponent.this.setLocation(point);
        }

        public void setSize(Dimension dimension) {
            JComponent.this.setSize(dimension);
        }

        public void setVisible(boolean bl) {
            boolean bl2 = JComponent.this.isVisible();
            JComponent.this.setVisible(bl);
            if (bl != bl2 && JComponent.this.accessibleContext != null) {
                if (bl) {
                    JComponent.this.accessibleContext.firePropertyChange("AccessibleState", null, AccessibleState.VISIBLE);
                } else {
                    JComponent.this.accessibleContext.firePropertyChange("AccessibleState", AccessibleState.VISIBLE, null);
                }
            }
        }

        protected class AccessibleContainerHandler
        implements ContainerListener {
            protected AccessibleContainerHandler() {
            }

            public void componentAdded(ContainerEvent containerEvent) {
                Component component = containerEvent.getChild();
                if (component != null && component instanceof Accessible) {
                    AccessibleJComponent.this.firePropertyChange("AccessibleChild", null, ((Accessible)((Object)component)).getAccessibleContext());
                }
            }

            public void componentRemoved(ContainerEvent containerEvent) {
                Component component = containerEvent.getChild();
                if (component != null && component instanceof Accessible) {
                    AccessibleJComponent.this.firePropertyChange("AccessibleChild", ((Accessible)((Object)component)).getAccessibleContext(), null);
                }
            }
        }
    }

    private class EnableSerializationFocusListener
    implements FocusListener,
    Serializable {
        EnableSerializationFocusListener() {
        }

        public void focusGained(FocusEvent focusEvent) {
        }

        public void focusLost(FocusEvent focusEvent) {
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            boolean bl = false;
            boolean bl2 = false;
            JInternalFrame jInternalFrame = null;
            objectOutputStream.defaultWriteObject();
            if (JComponent.this.ui != null) {
                if (JComponent.this instanceof JInternalFrame) {
                    jInternalFrame = (JInternalFrame)JComponent.this;
                    bl = true;
                    bl2 = jInternalFrame.isRootPaneCheckingEnabled();
                    jInternalFrame.setRootPaneCheckingEnabled(false);
                }
                JComponent.this.ui.uninstallUI(JComponent.this);
                if (bl) {
                    jInternalFrame.setRootPaneCheckingEnabled(bl2);
                    jInternalFrame = null;
                }
            }
            if (JComponent.this.getToolTipText() != null) {
                ToolTipManager.sharedInstance().unregisterComponent(JComponent.this);
            }
        }
    }

    private class ReadObjectCallback
    implements ObjectInputValidation {
        private final Vector roots = new Vector(1);
        private final ObjectInputStream inputStream;

        ReadObjectCallback(ObjectInputStream objectInputStream) throws Exception {
            this.inputStream = objectInputStream;
            objectInputStream.registerValidation(this, 0);
        }

        private void registerComponent(JComponent jComponent) {
            Container container;
            int n = 0;
            while (n < this.roots.size()) {
                JComponent jComponent2 = (JComponent)this.roots.elementAt(n);
                container = jComponent;
                while (container != null) {
                    if (container == jComponent2) {
                        return;
                    }
                    container = container.getParent();
                }
                ++n;
            }
            int n2 = 0;
            while (n2 < this.roots.size()) {
                container = (JComponent)this.roots.elementAt(n2);
                Container container2 = container.getParent();
                while (container2 != null) {
                    if (container2 == jComponent) {
                        this.roots.removeElementAt(n2--);
                        break;
                    }
                    container2 = container2.getParent();
                }
                ++n2;
            }
            this.roots.addElement(jComponent);
        }

        public void validateObject() throws InvalidObjectException {
            try {
                int n = 0;
                while (n < this.roots.size()) {
                    JComponent jComponent = (JComponent)this.roots.elementAt(n);
                    SwingUtilities.updateComponentTreeUI(jComponent);
                    ++n;
                }
            }
            finally {
                Object var2_3 = null;
                readObjectCallbacks.remove(this.inputStream);
            }
        }
    }
}

