/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.UIManager;

public class ProgressMonitor {
    private ProgressMonitor root;
    private JDialog dialog;
    private JOptionPane pane;
    private JProgressBar myBar;
    private JLabel noteLabel;
    private Component parentComponent;
    private String note;
    private Object[] cancelOption = null;
    private Object message;
    private long T0;
    private int millisToDecideToPopup = 500;
    private int millisToPopup = 2000;
    private int min;
    private int max;
    private int v;
    private int lastDisp;
    private int reportDelta;

    public ProgressMonitor(Component component, Object object, String string, int n, int n2) {
        this(component, object, string, n, n2, null);
    }

    private ProgressMonitor(Component component, Object object, String string, int n, int n2, ProgressMonitor progressMonitor) {
        this.min = n;
        this.max = n2;
        this.parentComponent = component;
        this.cancelOption = new Object[1];
        this.cancelOption[0] = UIManager.getString("OptionPane.cancelButtonText");
        this.reportDelta = (n2 - n) / 100;
        if (this.reportDelta < 1) {
            this.reportDelta = 1;
        }
        this.v = n;
        this.message = object;
        this.note = string;
        if (progressMonitor != null) {
            this.root = progressMonitor.root != null ? progressMonitor.root : progressMonitor;
            this.T0 = this.root.T0;
            this.dialog = this.root.dialog;
        } else {
            this.T0 = System.currentTimeMillis();
        }
    }

    public void close() {
        if (this.dialog != null) {
            this.dialog.setVisible(false);
            this.dialog.dispose();
            this.dialog = null;
            this.pane = null;
            this.myBar = null;
        }
    }

    public int getMaximum() {
        return this.max;
    }

    public int getMillisToDecideToPopup() {
        return this.millisToDecideToPopup;
    }

    public int getMillisToPopup() {
        return this.millisToPopup;
    }

    public int getMinimum() {
        return this.min;
    }

    public String getNote() {
        return this.note;
    }

    public boolean isCanceled() {
        if (this.pane == null) {
            return false;
        }
        Object object = this.pane.getValue();
        return object != null && this.cancelOption.length == 1 && object.equals(this.cancelOption[0]);
    }

    public void setMaximum(int n) {
        this.max = n;
    }

    public void setMillisToDecideToPopup(int n) {
        this.millisToDecideToPopup = n;
    }

    public void setMillisToPopup(int n) {
        this.millisToPopup = n;
    }

    public void setMinimum(int n) {
        this.min = n;
    }

    public void setNote(String string) {
        this.note = string;
        if (this.noteLabel != null) {
            this.noteLabel.setText(string);
        }
    }

    public void setProgress(int n) {
        this.v = n;
        if (n >= this.max) {
            this.close();
        } else if (n >= this.lastDisp + this.reportDelta) {
            this.lastDisp = n;
            if (this.myBar != null) {
                this.myBar.setValue(n);
            } else {
                int n2;
                long l = System.currentTimeMillis();
                long l2 = (int)(l - this.T0);
                if (l2 >= (long)this.millisToDecideToPopup && (n2 = n > this.min ? (int)(l2 * (long)(this.max - this.min) / (long)(n - this.min)) : this.millisToPopup) >= this.millisToPopup) {
                    this.myBar = new JProgressBar();
                    this.myBar.setMinimum(this.min);
                    this.myBar.setMaximum(this.max);
                    this.myBar.setValue(n);
                    if (this.note != null) {
                        this.noteLabel = new JLabel(this.note);
                    }
                    this.pane = new ProgressOptionPane(new Object[]{this.message, this.noteLabel, this.myBar});
                    this.dialog = this.pane.createDialog(this.parentComponent, "Progress...");
                    this.dialog.show();
                }
            }
        }
    }

    private class ProgressOptionPane
    extends JOptionPane {
        ProgressOptionPane(Object object) {
            super(object, 1, -1, null, ProgressMonitor.this.cancelOption, null);
        }

        public JDialog createDialog(Component component, String string) {
            Frame frame = JOptionPane.getFrameForComponent(component);
            JDialog jDialog = new JDialog(frame, string, false);
            Container container = jDialog.getContentPane();
            container.setLayout(new BorderLayout());
            container.add((Component)this, "Center");
            jDialog.pack();
            jDialog.setLocationRelativeTo(component);
            jDialog.addWindowListener(new WindowAdapter(this){
                private final /* synthetic */ ProgressOptionPane this$1;
                boolean gotFocus;
                {
                    this.this$1 = progressOptionPane;
                    this.gotFocus = false;
                }

                public void windowActivated(WindowEvent windowEvent) {
                    if (!this.gotFocus) {
                        this.this$1.selectInitialValue();
                        this.gotFocus = true;
                    }
                }

                public void windowClosing(WindowEvent windowEvent) {
                    this.this$1.setValue(null);
                }
            });
            this.addPropertyChangeListener(new PropertyChangeListener(jDialog, this){
                private final /* synthetic */ ProgressOptionPane this$1;
                private final /* synthetic */ JDialog val$dialog;
                {
                    this.val$dialog = jDialog;
                    this.this$1 = progressOptionPane;
                }

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (this.val$dialog.isVisible() && propertyChangeEvent.getSource() == this.this$1 && (propertyChangeEvent.getPropertyName().equals("value") || propertyChangeEvent.getPropertyName().equals("inputValue"))) {
                        this.val$dialog.setVisible(false);
                        this.val$dialog.dispose();
                    }
                }
            });
            return jDialog;
        }

        public int getMaxCharactersPerLineCount() {
            return 60;
        }
    }
}

