/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.undo;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.StateEditable;

public class StateEdit
extends AbstractUndoableEdit {
    protected static final String RCSID = "$Id: StateEdit.java,v 1.1.1.1 1998/10/28 06:43:54 sbb Exp $";
    protected StateEditable object;
    protected Hashtable preState;
    protected Hashtable postState;
    protected String undoRedoName;

    public StateEdit(StateEditable stateEditable) {
        this.init(stateEditable, null);
    }

    public StateEdit(StateEditable stateEditable, String string) {
        this.init(stateEditable, string);
    }

    public void end() {
        this.postState = new Hashtable(11);
        this.object.storeState(this.postState);
        this.removeRedundantState();
    }

    public String getPresentationName() {
        return this.undoRedoName;
    }

    protected void init(StateEditable stateEditable, String string) {
        this.object = stateEditable;
        this.preState = new Hashtable(11);
        this.object.storeState(this.preState);
        this.postState = null;
        this.undoRedoName = string;
    }

    public void redo() {
        super.redo();
        this.object.restoreState(this.postState);
    }

    protected void removeRedundantState() {
        Vector vector = new Vector();
        Enumeration enumeration = this.preState.keys();
        while (enumeration.hasMoreElements()) {
            Object object = enumeration.nextElement();
            if (!this.postState.containsKey(object) || !this.postState.get(object).equals(this.preState.get(object))) continue;
            vector.addElement(object);
        }
        int n = vector.size() - 1;
        while (n >= 0) {
            Object object = vector.elementAt(n);
            this.preState.remove(object);
            this.postState.remove(object);
            --n;
        }
    }

    public void undo() {
        super.undo();
        this.object.restoreState(this.preState);
    }
}

