/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.Serializable;

public class VerticalBagLayout
implements LayoutManager {
    int vgap;

    public VerticalBagLayout() {
        this(0);
    }

    public VerticalBagLayout(int n) {
        this.vgap = n;
    }

    public void addLayoutComponent(String string, Component component) {
    }

    public void layoutContainer(Container container) {
        Insets insets = container.insets();
        int n = insets.top;
        int n2 = container.size().height - insets.bottom;
        int n3 = insets.left;
        int n4 = container.size().width - insets.right;
        int n5 = container.countComponents();
        int n6 = 0;
        while (n6 < n5) {
            Component component = container.getComponent(n6);
            if (component.isVisible()) {
                int n7 = component.size().height;
                component.resize(n4 - n3, n7);
                Dimension dimension = component.preferredSize();
                component.reshape(n3, n, n4 - n3, dimension.height);
                n += dimension.height + this.vgap;
            }
            ++n6;
        }
    }

    public Dimension minimumLayoutSize(Container container) {
        Serializable serializable;
        Dimension dimension = new Dimension();
        int n = container.countComponents();
        int n2 = 0;
        while (n2 < n) {
            serializable = container.getComponent(n2);
            if (((Component)serializable).isVisible()) {
                Dimension dimension2 = ((Component)serializable).minimumSize();
                dimension.width = Math.max(dimension2.width, dimension.width);
                dimension.height += dimension2.height + this.vgap;
            }
            ++n2;
        }
        serializable = container.insets();
        dimension.width += ((Insets)serializable).left + ((Insets)serializable).right;
        dimension.height += ((Insets)serializable).top + ((Insets)serializable).bottom;
        return dimension;
    }

    public Dimension preferredLayoutSize(Container container) {
        Serializable serializable;
        Dimension dimension = new Dimension();
        int n = container.countComponents();
        int n2 = 0;
        while (n2 < n) {
            serializable = container.getComponent(n2);
            Dimension dimension2 = ((Component)serializable).preferredSize();
            dimension.width = Math.max(dimension2.width, dimension.width);
            dimension.height += dimension2.height + this.vgap;
            ++n2;
        }
        serializable = container.insets();
        dimension.width += ((Insets)serializable).left + ((Insets)serializable).right;
        dimension.height += ((Insets)serializable).top + ((Insets)serializable).bottom;
        return dimension;
    }

    public void removeLayoutComponent(Component component) {
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[vgap=" + this.vgap + "]";
    }
}

