/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.im;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.InputMethodEvent;
import java.awt.event.KeyEvent;
import java.awt.font.TextHitInfo;
import java.awt.im.InputMethodRequests;
import java.text.AttributedCharacterIterator;
import sun.awt.im.CompositionArea;
import sun.awt.im.InputContext;
import sun.awt.im.InputMethodManager;

public class InputMethodContext
extends InputContext
implements InputMethodRequests {
    private boolean dispatchingCommittedText;
    private CompositionArea inputArea = null;

    public InputMethodContext() {
        InputMethodManager.getInstance().add(this);
    }

    public AttributedCharacterIterator cancelLatestCommittedText(AttributedCharacterIterator.Attribute[] attributeArray) {
        return this.getReq().cancelLatestCommittedText(attributeArray);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    synchronized void dispatchCommittedText(Component component, AttributedCharacterIterator attributedCharacterIterator, int n) {
        if (n == 0) return;
        if (attributedCharacterIterator.getEndIndex() <= attributedCharacterIterator.getBeginIndex()) {
            return;
        }
        long l = System.currentTimeMillis();
        this.dispatchingCommittedText = true;
        try {
            char c = attributedCharacterIterator.first();
            while (n-- > 0 && c != '\uffff') {
                KeyEvent keyEvent = new KeyEvent(component, 400, l, 0, 0, c);
                component.dispatchEvent(keyEvent);
                c = attributedCharacterIterator.next();
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.dispatchingCommittedText = false;
            throw throwable;
        }
        Object var7_7 = null;
        this.dispatchingCommittedText = false;
    }

    public void dispatchEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof InputMethodEvent) {
            if (((Component)aWTEvent.getSource()).getInputMethodRequests() == null) {
                this.getInputArea().dispatchEvent(aWTEvent);
            }
        } else if (!this.dispatchingCommittedText) {
            super.dispatchEvent(aWTEvent);
        }
    }

    public void dispatchInputMethodEvent(int n, AttributedCharacterIterator attributedCharacterIterator, int n2, TextHitInfo textHitInfo, TextHitInfo textHitInfo2) {
        Component component = this.getClientComponent();
        Component component2 = this.haveActiveClient() ? component : this.getInputArea();
        InputMethodEvent inputMethodEvent = new InputMethodEvent(component, n, attributedCharacterIterator, n2, textHitInfo, textHitInfo2);
        component2.dispatchEvent(inputMethodEvent);
    }

    public AttributedCharacterIterator getCommittedText(int n, int n2, AttributedCharacterIterator.Attribute[] attributeArray) {
        return this.getReq().getCommittedText(n, n2, attributeArray);
    }

    public int getCommittedTextLength() {
        return this.getReq().getCommittedTextLength();
    }

    private synchronized Component getInputArea() {
        if (this.inputArea == null) {
            this.inputArea = new CompositionArea(this);
        }
        this.inputArea.setTarget(this.getClientComponent());
        return this.inputArea;
    }

    public int getInsertPositionOffset() {
        return this.getReq().getInsertPositionOffset();
    }

    public TextHitInfo getLocationOffset(int n, int n2) {
        return this.getReq().getLocationOffset(n, n2);
    }

    private InputMethodRequests getReq() {
        if (this.inputArea != null && this.inputArea.getParent().isVisible()) {
            return this.inputArea.getInputMethodRequests();
        }
        return this.getClientComponent().getInputMethodRequests();
    }

    public AttributedCharacterIterator getSelectedText(AttributedCharacterIterator.Attribute[] attributeArray) {
        return this.getReq().getSelectedText(attributeArray);
    }

    public Rectangle getTextLocation(TextHitInfo textHitInfo) {
        return this.getReq().getTextLocation(textHitInfo);
    }

    private boolean haveActiveClient() {
        Component component = this.getClientComponent();
        return component != null && component.getInputMethodRequests() != null;
    }
}

