/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.image;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Vector;
import sun.awt.AppContext;
import sun.awt.image.FetcherInfo;
import sun.awt.image.ImageFetchable;

class ImageFetcher
extends Thread {
    static final int HIGH_PRIORITY = 8;
    static final int LOW_PRIORITY = 3;
    static final int ANIM_PRIORITY = 2;
    static final int TIMEOUT = 5000;

    private ImageFetcher(ThreadGroup threadGroup, int n) {
        super(threadGroup, "Image Fetcher " + n);
        this.setDaemon(true);
    }

    /* synthetic */ ImageFetcher(2 var1_1, ThreadGroup threadGroup, int n) {
        this(threadGroup, n);
    }

    public static void add(ImageFetchable imageFetchable) {
        final FetcherInfo fetcherInfo = FetcherInfo.getFetcherInfo();
        Vector vector = fetcherInfo.waitList;
        synchronized (vector) {
            if (!fetcherInfo.waitList.contains(imageFetchable)) {
                fetcherInfo.waitList.addElement(imageFetchable);
                if (fetcherInfo.numWaiting == 0 && fetcherInfo.numFetchers < fetcherInfo.fetchers.length) {
                    ThreadGroup threadGroup;
                    ThreadGroup threadGroup2;
                    AppContext appContext = AppContext.getAppContext();
                    ThreadGroup threadGroup3 = appContext.getThreadGroup();
                    try {
                        if (threadGroup3.getParent() != null) {
                            threadGroup2 = threadGroup3;
                        } else {
                            threadGroup3 = Thread.currentThread().getThreadGroup();
                            threadGroup = threadGroup3.getParent();
                            while (threadGroup != null && threadGroup.getParent() != null) {
                                threadGroup3 = threadGroup;
                                threadGroup = threadGroup3.getParent();
                            }
                            threadGroup2 = threadGroup3;
                        }
                    }
                    catch (SecurityException securityException) {
                        threadGroup2 = appContext.getThreadGroup();
                    }
                    threadGroup = threadGroup2;
                    AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            int n = 0;
                            while (n < fetcherInfo.fetchers.length) {
                                if (fetcherInfo.fetchers[n] == null) {
                                    class Sun_awt_image_ImageFetcher$2 {
                                        /* synthetic */ Sun_awt_image_ImageFetcher$2() {
                                        }
                                    }
                                    fetcherInfo.fetchers[n] = new ImageFetcher(null, threadGroup, n);
                                    fetcherInfo.fetchers[n].start();
                                    ++fetcherInfo.numFetchers;
                                    break;
                                }
                                ++n;
                            }
                            return null;
                        }
                    });
                }
                fetcherInfo.waitList.notify();
            }
        }
    }

    public static boolean amFetcher() {
        return ImageFetcher.isFetcher(Thread.currentThread());
    }

    private void fetchloop() {
        Thread thread = Thread.currentThread();
        while (ImageFetcher.isFetcher(thread)) {
            if (Thread.interrupted()) {
                return;
            }
            thread.setPriority(8);
            ImageFetchable imageFetchable = ImageFetcher.nextImage();
            if (imageFetchable == null) {
                return;
            }
            try {
                imageFetchable.doFetch();
            }
            catch (Exception exception) {
                System.err.println("Uncaught error fetching image:");
                exception.printStackTrace();
            }
            ImageFetcher.stoppingAnimation(thread);
        }
    }

    public static boolean isFetcher(Thread thread) {
        FetcherInfo fetcherInfo = FetcherInfo.getFetcherInfo();
        Vector vector = fetcherInfo.waitList;
        synchronized (vector) {
            int n = 0;
            while (n < fetcherInfo.fetchers.length) {
                if (fetcherInfo.fetchers[n] == thread) {
                    boolean bl = true;
                    Object var4_5 = null;
                    return bl;
                }
                ++n;
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private static ImageFetchable nextImage() {
        FetcherInfo fetcherInfo = FetcherInfo.getFetcherInfo();
        Vector vector = fetcherInfo.waitList;
        // MONITORENTER : vector
        ImageFetchable imageFetchable = null;
        long l = System.currentTimeMillis() + 5000L;
        block7: while (true) {
            if (imageFetchable != null) break;
            while (true) {
                Object var10_5;
                if (fetcherInfo.waitList.size() != 0) {
                    imageFetchable = (ImageFetchable)fetcherInfo.waitList.elementAt(0);
                    fetcherInfo.waitList.removeElement(imageFetchable);
                    continue block7;
                }
                long l2 = System.currentTimeMillis();
                if (l2 >= l) {
                    ImageFetchable imageFetchable2 = null;
                    Object var3_9 = null;
                    // MONITOREXIT : vector
                    return imageFetchable2;
                }
                try {
                    try {
                        ++fetcherInfo.numWaiting;
                        fetcherInfo.waitList.wait(l - l2);
                    }
                    catch (InterruptedException interruptedException) {
                        ImageFetchable imageFetchable3 = null;
                        var10_5 = null;
                        --fetcherInfo.numWaiting;
                        Object var3_10 = null;
                        // MONITOREXIT : vector
                        return imageFetchable3;
                    }
                    var10_5 = null;
                    --fetcherInfo.numWaiting;
                }
                catch (Throwable throwable) {
                    var10_5 = null;
                    --fetcherInfo.numWaiting;
                    throw throwable;
                }
            }
            break;
        }
        ImageFetchable imageFetchable4 = imageFetchable;
        Object var3_11 = null;
        // MONITOREXIT : vector
        return imageFetchable4;
    }

    public static void remove(ImageFetchable imageFetchable) {
        FetcherInfo fetcherInfo = FetcherInfo.getFetcherInfo();
        Vector vector = fetcherInfo.waitList;
        synchronized (vector) {
            if (fetcherInfo.waitList.contains(imageFetchable)) {
                fetcherInfo.waitList.removeElement(imageFetchable);
            }
        }
    }

    public void run() {
        Vector vector;
        FetcherInfo fetcherInfo = FetcherInfo.getFetcherInfo();
        try {
            try {
                this.fetchloop();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            Object var3_5 = null;
            vector = fetcherInfo.waitList;
        }
        catch (Throwable throwable) {
            Object var3_6 = null;
            Vector vector2 = fetcherInfo.waitList;
            synchronized (vector2) {
                Thread thread = Thread.currentThread();
                int n = 0;
                while (n < fetcherInfo.fetchers.length) {
                    if (fetcherInfo.fetchers[n] == thread) {
                        fetcherInfo.fetchers[n] = null;
                        --fetcherInfo.numFetchers;
                    }
                    ++n;
                }
            }
        }
        synchronized (vector) {
            Thread thread = Thread.currentThread();
            int n = 0;
            while (n < fetcherInfo.fetchers.length) {
                if (fetcherInfo.fetchers[n] == thread) {
                    fetcherInfo.fetchers[n] = null;
                    --fetcherInfo.numFetchers;
                }
                ++n;
            }
        }
        throw throwable;
    }

    static void startingAnimation() {
        FetcherInfo fetcherInfo = FetcherInfo.getFetcherInfo();
        Thread thread = Thread.currentThread();
        Vector vector = fetcherInfo.waitList;
        synchronized (vector) {
            int n = 0;
            while (n < fetcherInfo.fetchers.length) {
                if (fetcherInfo.fetchers[n] == thread) {
                    fetcherInfo.fetchers[n] = null;
                    --fetcherInfo.numFetchers;
                    thread.setName("Image Animator " + n);
                    Object var3_4 = null;
                    return;
                }
                ++n;
            }
        }
        thread.setPriority(2);
        thread.setName("Image Animator");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void stoppingAnimation(Thread thread) {
        FetcherInfo fetcherInfo = FetcherInfo.getFetcherInfo();
        Vector vector = fetcherInfo.waitList;
        synchronized (vector) {
            int n = -1;
            int n2 = 0;
            while (n2 < fetcherInfo.fetchers.length) {
                if (fetcherInfo.fetchers[n2] == thread) {
                    return;
                }
                if (fetcherInfo.fetchers[n2] == null) {
                    n = n2;
                }
                ++n2;
            }
            if (n < 0) return;
            fetcherInfo.fetchers[n] = thread;
            ++fetcherInfo.numFetchers;
            thread.setName("Image Fetcher " + n);
            return;
        }
    }
}

