/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.image;

import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.util.Hashtable;
import sun.awt.image.ImageFetcher;
import sun.misc.Ref;

public abstract class PixelStore
extends Ref {
    int width;
    int height;
    ColorModel colormodel;
    Hashtable properties;
    boolean[] seen;
    int numlines;
    int availinfo;
    int hints;
    static final int NO_BITS_YET = 0;
    static final int BITS_ALLOCATED = 1;
    static final int BITS_LOST = 2;
    int bit_state = 0;
    int[] offsets;

    public PixelStore() {
    }

    public PixelStore(int n, int n2) {
        this.setDimensions(n, n2);
    }

    public PixelStore(int n, int n2, ColorModel colorModel) {
        this.setDimensions(n, n2);
        this.setColorModel(colorModel);
    }

    abstract Object allocateLines(int var1);

    public synchronized int getBitState() {
        if (this.bit_state == 1 && this.numlines > 0) {
            Object object = this.get();
        }
        return this.bit_state;
    }

    public synchronized ColorModel getColorModel() {
        return this.colormodel;
    }

    public synchronized int getHeight() {
        return this.height;
    }

    public synchronized int getWidth() {
        return this.width;
    }

    public synchronized void imageComplete() {
        if (this.get() != null && this.bit_state == 1) {
            this.hints = 30;
            this.availinfo |= 0x20;
        }
    }

    public Object reconstitute() {
        Object[] objectArray = null;
        if (this.bit_state == 0) {
            if ((this.availinfo & 2) == 0 || (this.availinfo & 1) == 0 || this.colormodel == null) {
                return null;
            }
            this.bit_state = 1;
            objectArray = new Object[this.height];
            this.offsets = new int[this.height];
            int n = 0;
            while (n < this.height) {
                int n2 = this.height - n;
                Object object = null;
                while (object == null && n2 > 0) {
                    try {
                        object = this.allocateLines(n2);
                        if (object != null) continue;
                        break;
                    }
                    catch (OutOfMemoryError outOfMemoryError) {
                        object = null;
                        n2 /= 2;
                    }
                }
                if (object == null) {
                    this.bit_state = 2;
                    return null;
                }
                int n3 = 0;
                while (n2 > 0) {
                    objectArray[n] = object;
                    this.offsets[n] = n3;
                    n3 += this.width;
                    ++n;
                    --n2;
                }
            }
        } else if (this.bit_state == 1) {
            this.bit_state = 2;
        }
        return objectArray;
    }

    protected void recordPixels(int n, int n2, int n3, int n4) {
        this.numlines = Math.max(this.numlines, n2 + n4);
        if ((this.hints & 2) == 0) {
            if (this.seen == null) {
                this.seen = new boolean[this.height];
            }
            int n5 = 0;
            while (n5 < n4) {
                this.seen[n2 + n5] = true;
                ++n5;
            }
        }
    }

    public synchronized boolean replay(ImageProducer imageProducer, ImageConsumer imageConsumer) {
        return this.replay(imageProducer, imageConsumer, true);
    }

    public synchronized boolean replay(ImageProducer imageProducer, ImageConsumer imageConsumer, boolean bl) {
        if (bl && (this.availinfo & 1) != 0 && (this.availinfo & 2) != 0) {
            imageConsumer.setDimensions(this.width, this.height);
            if (!imageProducer.isConsumer(imageConsumer)) {
                return true;
            }
        }
        if (bl && (this.availinfo & 4) != 0) {
            imageConsumer.setProperties(this.properties);
        }
        if (bl && this.colormodel != null) {
            imageConsumer.setColorModel(this.colormodel);
            if (!imageProducer.isConsumer(imageConsumer)) {
                return true;
            }
        }
        if (this.hints != 0) {
            imageConsumer.setHints(this.hints & 0x1E);
            if (!imageProducer.isConsumer(imageConsumer)) {
                return true;
            }
        }
        Object[] objectArray = null;
        if (this.bit_state == 1 && this.numlines > 0) {
            objectArray = (Object[])this.get();
        }
        if (this.bit_state == 2) {
            return false;
        }
        Thread thread = Thread.currentThread();
        if (ImageFetcher.isFetcher(thread) && thread.getPriority() > 3) {
            thread.setPriority(3);
        }
        if (objectArray != null) {
            Object object = null;
            int n = 0;
            int n2 = 0;
            while (n2 < this.numlines) {
                if (this.seen != null && !this.seen[n2]) {
                    if (object != null) {
                        this.replayLines(imageConsumer, n2 - n, n, object);
                        if (!imageProducer.isConsumer(imageConsumer)) {
                            return true;
                        }
                        object = null;
                        n = 0;
                    }
                } else {
                    Object object2 = objectArray[n2];
                    if (object != object2 && object != null) {
                        this.replayLines(imageConsumer, n2 - n, n, object);
                        if (!imageProducer.isConsumer(imageConsumer)) {
                            return true;
                        }
                        n = 0;
                    }
                    object = object2;
                    ++n;
                }
                ++n2;
            }
            if (object != null) {
                this.replayLines(imageConsumer, this.numlines - n, n, object);
                if (!imageProducer.isConsumer(imageConsumer)) {
                    return true;
                }
            }
        }
        if (bl && this.bit_state == 1 && (this.availinfo & 0x20) != 0) {
            imageConsumer.imageComplete(3);
        }
        return true;
    }

    abstract void replayLines(ImageConsumer var1, int var2, int var3, Object var4);

    public synchronized void setColorModel(ColorModel colorModel) {
        this.colormodel = colorModel;
    }

    public synchronized void setDimensions(int n, int n2) {
        this.width = n;
        this.height = n2;
        this.availinfo |= 3;
    }

    public synchronized void setHints(int n) {
        this.hints = n;
    }

    public synchronized boolean setPixels(int n, int n2, int n3, int n4, byte[] byArray, int n5, int n6) {
        this.recordPixels(n, n2, n3, n4);
        Object[] objectArray = (Object[])this.get();
        if (objectArray != null) {
            int n7 = n5;
            int n8 = n2;
            while (n8 < n2 + n4) {
                byte[] byArray2 = (byte[])objectArray[n8];
                int n9 = this.offsets[n8] + n;
                System.arraycopy(byArray, n7, byArray2, n9, n3);
                n7 += n6;
                ++n8;
            }
            this.availinfo |= 8;
        }
        return objectArray != null;
    }

    public synchronized boolean setPixels(int n, int n2, int n3, int n4, int[] nArray, int n5, int n6) {
        this.recordPixels(n, n2, n3, n4);
        Object[] objectArray = (Object[])this.get();
        if (objectArray != null) {
            int n7 = n5;
            int n8 = n2;
            while (n8 < n2 + n4) {
                int[] nArray2 = (int[])objectArray[n8];
                int n9 = this.offsets[n8] + n;
                System.arraycopy(nArray, n7, nArray2, n9, n3);
                n7 += n6;
                ++n8;
            }
            this.availinfo |= 8;
        }
        return objectArray != null;
    }

    public synchronized void setProperties(Hashtable hashtable) {
        this.properties = hashtable;
        this.availinfo |= 4;
    }
}

