/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.motif;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.dnd.peer.DragSourceContextPeer;
import java.awt.event.InputEvent;
import java.awt.peer.ComponentPeer;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.rmi.MarshalledObject;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sun.awt.motif.MDragSourceContextPeerBuffer;
import sun.awt.motif.MDragSourceContextPeerDispatcher;
import sun.awt.motif.MDropTargetContextPeer;
import sun.awt.motif.MToolkit;

final class MDragSourceContextPeer
implements DragSourceContextPeer {
    private static MDragSourceContextPeerDispatcher listenerDispatcher = new MDragSourceContextPeerDispatcher();
    private DragSource dragSource;
    private Component component;
    private DragGestureEvent trigger;
    private Cursor cursor;
    private int actions;
    private Component nativeCont;
    private long nativeCtxt;
    private DragSourceContext dragSourceContext;
    private boolean dropOccurred = false;
    private int dropOperation = 0;
    private boolean dropSuccess = false;
    private HashMap transfers = new HashMap();
    private boolean inValidSite = false;
    static /* synthetic */ Class class$java$lang$String;

    private MDragSourceContextPeer(DragGestureEvent dragGestureEvent) {
        this.trigger = dragGestureEvent;
        this.component = dragGestureEvent.getComponent();
        this.dragSource = dragGestureEvent.getDragSource();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private MDragSourceContextPeerBuffer convertData(String string, int n, long l) {
        MDragSourceContextPeerBuffer mDragSourceContextPeerBuffer;
        Long l2 = new Long(l);
        MDragSourceContextPeerBuffer mDragSourceContextPeerBuffer2 = mDragSourceContextPeerBuffer = l == 0L ? null : (MDragSourceContextPeerBuffer)this.transfers.get(l2);
        if (mDragSourceContextPeerBuffer == null) {
            Class clazz;
            Map map = this.dragSource.getFlavorMap().getFlavorsForNatives(new String[]{string});
            if (map == null || map.isEmpty()) {
                return null;
            }
            DataFlavor dataFlavor = (DataFlavor)map.get(string);
            Object object = null;
            if (dataFlavor == null) {
                return null;
            }
            try {
                object = this.dragSourceContext.getTransferable().getTransferData(dataFlavor);
            }
            catch (IOException iOException) {
                return null;
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                return null;
            }
            if (dataFlavor.isRepresentationClassInputStream()) {
                try {
                    mDragSourceContextPeerBuffer = new MDragSourceContextPeerBuffer(l2, (InputStream)object);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    return null;
                }
            }
            if (dataFlavor.isRepresentationClassRemote()) {
                try {
                    mDragSourceContextPeerBuffer = new MDragSourceContextPeerBuffer(l2, new MarshalledObject(object));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    return null;
                }
            }
            if (dataFlavor.isRepresentationClassSerializable()) {
                try {
                    mDragSourceContextPeerBuffer = new MDragSourceContextPeerBuffer(l2, object);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    return null;
                }
            }
            if ((class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = MDragSourceContextPeer.class$("java.lang.String"))).equals(clazz = dataFlavor.getRepresentationClass())) {
                try {
                    mDragSourceContextPeerBuffer = new MDragSourceContextPeerBuffer(l2, (String)object);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    return null;
                }
            }
            if (mDragSourceContextPeerBuffer != null && l != 0L) {
                this.transfers.put(l2, mDragSourceContextPeerBuffer);
            }
        }
        return mDragSourceContextPeerBuffer;
    }

    private String[] convertFileList(String string) {
        String[] stringArray;
        List list;
        Map map = this.dragSource.getFlavorMap().getFlavorsForNatives(new String[]{string});
        if (map == null || map.isEmpty()) {
            return null;
        }
        DataFlavor dataFlavor = (DataFlavor)map.get(string);
        if (dataFlavor == null) {
            return null;
        }
        try {
            list = (List)this.dragSourceContext.getTransferable().getTransferData(dataFlavor);
        }
        catch (IOException iOException) {
            return null;
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            return null;
        }
        catch (ClassCastException classCastException) {
            return null;
        }
        if (list.isEmpty()) {
            return null;
        }
        int n = 0;
        int n2 = 0;
        while (n2 < list.size()) {
            stringArray = list.get(n2);
            if (stringArray instanceof File || stringArray instanceof String) {
                ++n;
            }
            ++n2;
        }
        if (n == 0) {
            return null;
        }
        stringArray = new String[n];
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    int n = 0;
                    while (n < list.size()) {
                        Object object = list.get(n);
                        if (object instanceof File) {
                            stringArray[n] = ((File)list.get(n)).getCanonicalPath();
                        } else if (object instanceof String) {
                            stringArray[n] = (String)object;
                        }
                        ++n;
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            return null;
        }
        return stringArray;
    }

    private void dragDropFinished() {
        DragSourceDropEvent dragSourceDropEvent = this.dropOccurred ? new DragSourceDropEvent(this.dragSourceContext, this.dropOperation, this.dropSuccess) : new DragSourceDropEvent(this.dragSourceContext);
        listenerDispatcher.deliverDropFinish(this.dragSourceContext, dragSourceDropEvent);
        MDropTargetContextPeer.setCurrentJVMLocalSourceTransferable(null);
    }

    private int dragEnter(int n, int n2, int n3, boolean bl) {
        this.inValidSite = bl;
        if (this.inValidSite) {
            listenerDispatcher.deliverEnter(this.dragSourceContext, new DragSourceDragEvent(this.dragSourceContext, this.mapOperation(n), n2, n3));
        }
        return this.actions;
    }

    private void dragExit(int n) {
        if (this.inValidSite) {
            listenerDispatcher.deliverExit(this.dragSourceContext, new DragSourceEvent(this.dragSourceContext));
            this.inValidSite = false;
        }
    }

    private int dragMotion(int n, int n2, int n3, boolean bl) {
        if (!bl) {
            this.dragExit(n3);
        } else {
            if (!this.inValidSite) {
                return this.dragEnter(n, n2, n3, bl);
            }
            if (this.inValidSite) {
                listenerDispatcher.deliverMotion(this.dragSourceContext, new DragSourceDragEvent(this.dragSourceContext, this.mapOperation(n), n2, n3));
            }
        }
        return this.actions;
    }

    private void dropFinished(boolean bl) {
        this.dropSuccess = bl;
    }

    private void dropStart(int n, boolean bl, boolean bl2) {
        if (bl) {
            this.dropOccurred = true;
            this.dropOperation = n;
        }
    }

    void freeBuffer(MDragSourceContextPeerBuffer mDragSourceContextPeerBuffer) {
        try {
            mDragSourceContextPeerBuffer.close();
        }
        catch (IOException iOException) {}
        if (mDragSourceContextPeerBuffer.getRequestorID() != 0L) {
            this.transfers.remove(mDragSourceContextPeerBuffer.getRequestorID());
        }
    }

    public Cursor getCursor() {
        return this.cursor;
    }

    static DragSourceContextPeer getDragSourceContextPeer(DragGestureEvent dragGestureEvent) {
        return new MDragSourceContextPeer(dragGestureEvent);
    }

    public DragGestureEvent getTrigger() {
        return this.trigger;
    }

    private int mapOperation(int n) {
        int[] nArray = new int[]{2, 1, 0x40000000};
        n &= 0x40000003;
        int n2 = 0;
        while (n2 < nArray.length) {
            if ((n & nArray[n2]) == nArray[n2]) {
                return nArray[n2];
            }
            ++n2;
        }
        return 0;
    }

    private int operationChanged(int n, int n2, int n3, boolean bl) {
        listenerDispatcher.deliverGestureChanged(this.dragSourceContext, new DragSourceDragEvent(this.dragSourceContext, this.mapOperation(n), n2, n3));
        return this.actions;
    }

    private native void setCursor(long var1, Cursor var3, int var4);

    public void setCursor(Cursor cursor) throws InvalidDnDOperationException {
        if (this.cursor == null || !this.cursor.equals(cursor)) {
            this.cursor = cursor;
            if (this.nativeCtxt != 0L) {
                this.setCursor(this.nativeCtxt, cursor, cursor == null ? 0 : cursor.getType());
            }
        }
    }

    public void startDrag(DragSourceContext dragSourceContext, Cursor cursor, Image image, Point point) throws InvalidDnDOperationException {
        this.dragSourceContext = dragSourceContext;
        this.cursor = cursor;
        this.actions = this.trigger.getSourceAsDragGestureRecognizer().getSourceActions();
        DataFlavor[] dataFlavorArray = dragSourceContext.getTransferable().getTransferDataFlavors();
        Map map = this.dragSource.getFlavorMap().getNativesForFlavors(dataFlavorArray);
        int n = 0;
        while (n < dataFlavorArray.length) {
            if (!(dataFlavorArray[n].isRepresentationClassInputStream() || dataFlavorArray[n].isRepresentationClassSerializable() || dataFlavorArray[n].isRepresentationClassRemote() || DataFlavor.javaFileListFlavor.equals(dataFlavorArray[n]))) {
                map.remove(dataFlavorArray[n]);
            }
            ++n;
        }
        try {
            this.nativeCtxt = this.startDrag(MToolkit.getNativeContainer(dragSourceContext.getComponent()).getPeer(), this.trigger.getTriggerEvent(), this.cursor, this.cursor == null ? 0 : this.cursor.getType(), dragSourceContext.getSourceActions(), map.values().toArray());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new InvalidDnDOperationException();
        }
        if (this.nativeCtxt == 0L) {
            throw new InvalidDnDOperationException();
        }
        MDropTargetContextPeer.setCurrentJVMLocalSourceTransferable(dragSourceContext.getTransferable());
    }

    private native long startDrag(ComponentPeer var1, InputEvent var2, Cursor var3, int var4, int var5, Object[] var6);

    public void transferablesFlavorsChanged() {
    }
}

