/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.motif;

import java.awt.AWTException;
import java.awt.Button;
import java.awt.Canvas;
import java.awt.Checkbox;
import java.awt.CheckboxMenuItem;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Label;
import java.awt.List;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.PrintJob;
import java.awt.ScrollPane;
import java.awt.Scrollbar;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.dnd.peer.DragSourceContextPeer;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.peer.ButtonPeer;
import java.awt.peer.CanvasPeer;
import java.awt.peer.CheckboxMenuItemPeer;
import java.awt.peer.CheckboxPeer;
import java.awt.peer.ChoicePeer;
import java.awt.peer.DialogPeer;
import java.awt.peer.FileDialogPeer;
import java.awt.peer.FontPeer;
import java.awt.peer.FramePeer;
import java.awt.peer.LabelPeer;
import java.awt.peer.ListPeer;
import java.awt.peer.MenuBarPeer;
import java.awt.peer.MenuItemPeer;
import java.awt.peer.MenuPeer;
import java.awt.peer.PanelPeer;
import java.awt.peer.PopupMenuPeer;
import java.awt.peer.ScrollPanePeer;
import java.awt.peer.ScrollbarPeer;
import java.awt.peer.TextAreaPeer;
import java.awt.peer.TextFieldPeer;
import java.awt.peer.WindowPeer;
import java.util.Properties;
import sun.awt.SunToolkit;
import sun.awt.X11GraphicsConfig;
import sun.awt.im.InputMethod;
import sun.awt.im.InputMethodHighlightMapping;
import sun.awt.image.ImageRepresentation;
import sun.awt.motif.MButtonPeer;
import sun.awt.motif.MCanvasPeer;
import sun.awt.motif.MCheckboxMenuItemPeer;
import sun.awt.motif.MCheckboxPeer;
import sun.awt.motif.MChoicePeer;
import sun.awt.motif.MDialogPeer;
import sun.awt.motif.MDragSourceContextPeer;
import sun.awt.motif.MEmbeddedFrame;
import sun.awt.motif.MEmbeddedFramePeer;
import sun.awt.motif.MFileDialogPeer;
import sun.awt.motif.MFontPeer;
import sun.awt.motif.MFramePeer;
import sun.awt.motif.MLabelPeer;
import sun.awt.motif.MListPeer;
import sun.awt.motif.MMenuBarPeer;
import sun.awt.motif.MMenuItemPeer;
import sun.awt.motif.MMenuPeer;
import sun.awt.motif.MMouseDragGestureRecognizer;
import sun.awt.motif.MPanelPeer;
import sun.awt.motif.MPopupMenuPeer;
import sun.awt.motif.MRobotPeer;
import sun.awt.motif.MScrollPanePeer;
import sun.awt.motif.MScrollbarPeer;
import sun.awt.motif.MTextAreaPeer;
import sun.awt.motif.MTextFieldPeer;
import sun.awt.motif.MWindowPeer;
import sun.awt.motif.PSPrintControl;
import sun.awt.motif.X11Clipboard;
import sun.awt.motif.X11CustomCursor;
import sun.awt.motif.X11FontMetrics;
import sun.awt.motif.X11Image;
import sun.awt.motif.X11InputMethod;
import sun.awt.robot.RobotPeer;
import sun.java2d.loops.RasterOutputManager;

public class MToolkit
extends SunToolkit
implements Runnable {
    static final boolean useMotifChoiceWidget = true;
    X11Clipboard clipboard;
    static X11GraphicsConfig config = (X11GraphicsConfig)GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
    static ColorModel screenmodel;
    private static final String prefix = "DnD.Cursor.";
    private static final String postfix = ".32x32";
    static /* synthetic */ Class class$java$awt$dnd$MouseDragGestureRecognizer;

    public MToolkit() {
        this.init();
        new Thread(this, "AWT-Motif").start();
    }

    public native void beep();

    public int checkImage(Image image, int n, int n2, ImageObserver imageObserver) {
        return MToolkit.checkScrImage(image, n, n2, imageObserver);
    }

    static int checkScrImage(Image image, int n, int n2, ImageObserver imageObserver) {
        if (!(image instanceof X11Image)) {
            return 32;
        }
        X11Image x11Image = (X11Image)image;
        int n3 = n == 0 || n2 == 0 ? 32 : x11Image.getImageRep().check(imageObserver);
        return x11Image.check(imageObserver) | n3;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public ButtonPeer createButton(Button button) {
        MButtonPeer mButtonPeer = new MButtonPeer(button);
        SunToolkit.peerMap.put(button, mButtonPeer);
        return mButtonPeer;
    }

    public CanvasPeer createCanvas(Canvas canvas) {
        MCanvasPeer mCanvasPeer = new MCanvasPeer(canvas);
        SunToolkit.peerMap.put(canvas, mCanvasPeer);
        return mCanvasPeer;
    }

    public CheckboxPeer createCheckbox(Checkbox checkbox) {
        MCheckboxPeer mCheckboxPeer = new MCheckboxPeer(checkbox);
        SunToolkit.peerMap.put(checkbox, mCheckboxPeer);
        return mCheckboxPeer;
    }

    public CheckboxMenuItemPeer createCheckboxMenuItem(CheckboxMenuItem checkboxMenuItem) {
        MCheckboxMenuItemPeer mCheckboxMenuItemPeer = new MCheckboxMenuItemPeer(checkboxMenuItem);
        SunToolkit.peerMap.put(checkboxMenuItem, mCheckboxMenuItemPeer);
        return mCheckboxMenuItemPeer;
    }

    public ChoicePeer createChoice(Choice choice) {
        MChoicePeer mChoicePeer = null;
        mChoicePeer = new MChoicePeer(choice);
        SunToolkit.peerMap.put(choice, mChoicePeer);
        return mChoicePeer;
    }

    public Cursor createCustomCursor(Image image, Point point, String string) throws IndexOutOfBoundsException {
        return new X11CustomCursor(image, point, string);
    }

    public DialogPeer createDialog(Dialog dialog) {
        MDialogPeer mDialogPeer = new MDialogPeer(dialog);
        SunToolkit.peerMap.put(dialog, mDialogPeer);
        return mDialogPeer;
    }

    public DragGestureRecognizer createDragGestureRecognizer(Class clazz, DragSource dragSource, Component component, int n, DragGestureListener dragGestureListener) {
        if ((class$java$awt$dnd$MouseDragGestureRecognizer != null ? class$java$awt$dnd$MouseDragGestureRecognizer : (class$java$awt$dnd$MouseDragGestureRecognizer = MToolkit.class$("java.awt.dnd.MouseDragGestureRecognizer"))).equals(clazz)) {
            return new MMouseDragGestureRecognizer(dragSource, component, n, dragGestureListener);
        }
        return null;
    }

    public DragSourceContextPeer createDragSourceContextPeer(DragGestureEvent dragGestureEvent) throws InvalidDnDOperationException {
        return MDragSourceContextPeer.getDragSourceContextPeer(dragGestureEvent);
    }

    public MEmbeddedFramePeer createEmbeddedFrame(MEmbeddedFrame mEmbeddedFrame, int n) {
        MEmbeddedFramePeer mEmbeddedFramePeer = new MEmbeddedFramePeer(mEmbeddedFrame, n);
        SunToolkit.peerMap.put(mEmbeddedFrame, mEmbeddedFramePeer);
        return mEmbeddedFramePeer;
    }

    public FileDialogPeer createFileDialog(FileDialog fileDialog) {
        MFileDialogPeer mFileDialogPeer = new MFileDialogPeer(fileDialog);
        SunToolkit.peerMap.put(fileDialog, mFileDialogPeer);
        return mFileDialogPeer;
    }

    public FramePeer createFrame(Frame frame) {
        MFramePeer mFramePeer = new MFramePeer(frame);
        SunToolkit.peerMap.put(frame, mFramePeer);
        return mFramePeer;
    }

    public Image createImage(ImageProducer imageProducer) {
        return new X11Image(imageProducer);
    }

    public LabelPeer createLabel(Label label) {
        MLabelPeer mLabelPeer = new MLabelPeer(label);
        SunToolkit.peerMap.put(label, mLabelPeer);
        return mLabelPeer;
    }

    public ListPeer createList(List list) {
        MListPeer mListPeer = new MListPeer(list);
        SunToolkit.peerMap.put(list, mListPeer);
        return mListPeer;
    }

    public MenuPeer createMenu(Menu menu) {
        MMenuPeer mMenuPeer = new MMenuPeer(menu);
        SunToolkit.peerMap.put(menu, mMenuPeer);
        return mMenuPeer;
    }

    public MenuBarPeer createMenuBar(MenuBar menuBar) {
        MMenuBarPeer mMenuBarPeer = new MMenuBarPeer(menuBar);
        SunToolkit.peerMap.put(menuBar, mMenuBarPeer);
        return mMenuBarPeer;
    }

    public MenuItemPeer createMenuItem(MenuItem menuItem) {
        MMenuItemPeer mMenuItemPeer = new MMenuItemPeer(menuItem);
        SunToolkit.peerMap.put(menuItem, mMenuItemPeer);
        return mMenuItemPeer;
    }

    public PanelPeer createPanel(Panel panel) {
        MPanelPeer mPanelPeer = new MPanelPeer(panel);
        SunToolkit.peerMap.put(panel, mPanelPeer);
        return mPanelPeer;
    }

    public PopupMenuPeer createPopupMenu(PopupMenu popupMenu) {
        MPopupMenuPeer mPopupMenuPeer = new MPopupMenuPeer(popupMenu);
        SunToolkit.peerMap.put(popupMenu, mPopupMenuPeer);
        return mPopupMenuPeer;
    }

    protected RobotPeer createRobotPeer() {
        return new MRobotPeer();
    }

    public ScrollPanePeer createScrollPane(ScrollPane scrollPane) {
        MScrollPanePeer mScrollPanePeer = new MScrollPanePeer(scrollPane);
        SunToolkit.peerMap.put(scrollPane, mScrollPanePeer);
        return mScrollPanePeer;
    }

    public ScrollbarPeer createScrollbar(Scrollbar scrollbar) {
        MScrollbarPeer mScrollbarPeer = new MScrollbarPeer(scrollbar);
        SunToolkit.peerMap.put(scrollbar, mScrollbarPeer);
        return mScrollbarPeer;
    }

    public TextAreaPeer createTextArea(TextArea textArea) {
        MTextAreaPeer mTextAreaPeer = new MTextAreaPeer(textArea);
        SunToolkit.peerMap.put(textArea, mTextAreaPeer);
        return mTextAreaPeer;
    }

    public TextFieldPeer createTextField(TextField textField) {
        MTextFieldPeer mTextFieldPeer = new MTextFieldPeer(textField);
        SunToolkit.peerMap.put(textField, mTextFieldPeer);
        return mTextFieldPeer;
    }

    public WindowPeer createWindow(Window window) {
        MWindowPeer mWindowPeer = new MWindowPeer(window);
        SunToolkit.peerMap.put(window, mWindowPeer);
        return mWindowPeer;
    }

    public Dimension getBestCursorSize(int n, int n2) {
        return X11CustomCursor.getBestCursorSize(n, n2);
    }

    public ColorModel getColorModel() {
        return MToolkit.getStaticColorModel();
    }

    public FontMetrics getFontMetrics(Font font) {
        if (!RasterOutputManager.usesPlatformFont()) {
            return super.getFontMetrics(font);
        }
        return X11FontMetrics.getFontMetrics(font);
    }

    public FontPeer getFontPeer(String string, int n) {
        return new MFontPeer(string, n);
    }

    public InputMethod getInputMethodAdapter() throws AWTException {
        return new X11InputMethod();
    }

    public InputMethodHighlightMapping getInputMethodHighlightMapping() {
        return X11InputMethod.getInputMethodHighlightMapping();
    }

    public int getMaximumCursorColors() {
        return 2;
    }

    public static Container getNativeContainer(Component component) {
        return Toolkit.getNativeContainer(component);
    }

    public PrintJob getPrintJob(Frame frame, String string, Properties properties) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPrintJobAccess();
        }
        PSPrintControl pSPrintControl = new PSPrintControl(frame);
        return pSPrintControl.initJob(string, properties, true);
    }

    protected native int getScreenHeight();

    public native int getScreenResolution();

    protected native int getScreenWidth();

    static ColorModel getStaticColorModel() {
        if (screenmodel == null) {
            screenmodel = config.getColorModel();
        }
        return screenmodel;
    }

    public Clipboard getSystemClipboard() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSystemClipboardAccess();
        }
        if (this.clipboard == null) {
            this.clipboard = new X11Clipboard("System");
        }
        return this.clipboard;
    }

    public native void init();

    protected void initializeDesktopProperties() {
        this.desktopProperties.put("DnD.Autoscroll.initialDelay", new Integer(50));
        this.desktopProperties.put("DnD.Autoscroll.interval", new Integer(50));
        this.desktopProperties.put("DnD.Autoscroll.cursorHysteresis", new Integer(5));
    }

    protected Object lazilyLoadDesktopProperty(String string) {
        if (string.startsWith(prefix)) {
            String string2 = String.valueOf(string.substring(prefix.length(), string.length())) + postfix;
            try {
                return Cursor.getSystemCustomCursor(string2);
            }
            catch (AWTException aWTException) {
                System.err.println("cannot load system cursor: " + string2);
                return null;
            }
        }
        return super.lazilyLoadDesktopProperty(string);
    }

    public native void loadSystemColors(int[] var1);

    static native ColorModel makeColorModel();

    public boolean prepareImage(Image image, int n, int n2, ImageObserver imageObserver) {
        return MToolkit.prepareScrImage(image, n, n2, imageObserver);
    }

    static boolean prepareScrImage(Image image, int n, int n2, ImageObserver imageObserver) {
        if (n == 0 || n2 == 0) {
            return true;
        }
        if (!(image instanceof X11Image)) {
            return true;
        }
        X11Image x11Image = (X11Image)image;
        if (x11Image.hasError()) {
            if (imageObserver != null) {
                imageObserver.imageUpdate(image, 192, -1, -1, -1, -1);
            }
            return false;
        }
        ImageRepresentation imageRepresentation = x11Image.getImageRep();
        return imageRepresentation.prepare(imageObserver);
    }

    public native void run();

    public native void sync();

    public static final void targetDisposedPeer(Object object, Object object2) {
        SunToolkit.targetDisposedPeer(object, object2);
    }

    public static final Object targetToPeer(Object object) {
        return SunToolkit.targetToPeer(object);
    }
}

