/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.motif;

import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.TextArea;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.awt.peer.WindowPeer;
import java.util.Vector;
import sun.awt.motif.MComponentPeer;
import sun.awt.motif.MPanelPeer;

class MWindowPeer
extends MPanelPeer
implements WindowPeer {
    Insets insets = new Insets(0, 0, 0, 0);
    static Vector allWindows = new Vector();

    static {
        MWindowPeer.initIDs();
    }

    MWindowPeer(Window window) {
        Color color;
        this.init(window);
        allWindows.addElement(this);
        Font font = window.getFont();
        if (font == null) {
            font = new Font("Dialog", 0, 12);
            window.setFont(font);
            this.setFont(font);
        }
        if ((color = window.getBackground()) == null) {
            window.setBackground(SystemColor.window);
            this.setBackground(SystemColor.window);
        }
        if ((color = window.getForeground()) == null) {
            window.setForeground(SystemColor.windowText);
            this.setForeground(SystemColor.windowText);
        }
    }

    native void create(MComponentPeer var1);

    protected void disposeImpl() {
        allWindows.removeElement(this);
        super.disposeImpl();
    }

    public Insets getInsets() {
        return this.insets;
    }

    public void handleDeiconify() {
        this.postEvent(new WindowEvent((Window)this.target, 204));
    }

    public int handleFocusTraversalEvent(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() != 9 || keyEvent.getSource() instanceof TextArea) {
            return 0;
        }
        if ((keyEvent.getModifiers() & 0xFFFFFFFE) > 0) {
            return 0;
        }
        int n = keyEvent.getID();
        if (n == 402 || n == 400) {
            return 1;
        }
        if (keyEvent.isShiftDown()) {
            return 3;
        }
        return 2;
    }

    public void handleIconify() {
        this.postEvent(new WindowEvent((Window)this.target, 203));
    }

    public void handleQuit() {
        this.postEvent(new WindowEvent((Window)this.target, 201));
    }

    public synchronized void handleResize(int n, int n2) {
        this.postEvent(new ComponentEvent(this.target, 101));
    }

    private static native void initIDs();

    public Insets insets() {
        return this.getInsets();
    }

    native void pDispose();

    native void pHide();

    native void pReshape(int var1, int var2, int var3, int var4);

    native void pShow();

    public native void toBack();

    public void toFront() {
        this.pShow();
    }
}

