/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.motif;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.PathIterator;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterJob;
import sun.awt.motif.PSPrinterJob;
import sun.java2d.PathGraphics;

class PSPathGraphics
extends PathGraphics {
    PSPathGraphics(Graphics2D graphics2D, PrinterJob printerJob, Printable printable, PageFormat pageFormat, int n) {
        super(graphics2D, printerJob, printable, pageFormat, n);
    }

    private void convertToPSPath(PathIterator pathIterator) {
        float[] fArray = new float[6];
        PSPrinterJob pSPrinterJob = (PSPrinterJob)this.getPrinterJob();
        int n = pathIterator.getWindingRule() == 0 ? 1 : 2;
        pSPrinterJob.setFillMode(n);
        pSPrinterJob.beginPath();
        while (!pathIterator.isDone()) {
            int n2 = pathIterator.currentSegment(fArray);
            switch (n2) {
                case 0: {
                    pSPrinterJob.moveTo(fArray[0], fArray[1]);
                    break;
                }
                case 1: {
                    pSPrinterJob.lineTo(fArray[0], fArray[1]);
                    break;
                }
                case 2: {
                    float f = pSPrinterJob.getPenX();
                    float f2 = pSPrinterJob.getPenY();
                    float f3 = f + (fArray[0] - f) * 2.0f / 3.0f;
                    float f4 = f2 + (fArray[1] - f2) * 2.0f / 3.0f;
                    float f5 = fArray[2] - (fArray[2] - fArray[0]) * 2.0f / 3.0f;
                    float f6 = fArray[3] - (fArray[3] - fArray[1]) * 2.0f / 3.0f;
                    pSPrinterJob.bezierTo(f3, f4, f5, f6, fArray[2], fArray[3]);
                    break;
                }
                case 3: {
                    pSPrinterJob.bezierTo(fArray[0], fArray[1], fArray[2], fArray[3], fArray[4], fArray[5]);
                    break;
                }
                case 4: {
                    pSPrinterJob.closeSubpath();
                    break;
                }
            }
            pathIterator.next();
        }
    }

    public Graphics create() {
        return new PSPathGraphics((Graphics2D)this.getDelegate().create(), this.getPrinterJob(), this.getPrintable(), this.getPageFormat(), this.getPageIndex());
    }

    protected void deviceClip(PathIterator pathIterator) {
        PSPrinterJob pSPrinterJob = (PSPrinterJob)this.getPrinterJob();
        pSPrinterJob.grestore();
        pSPrinterJob.gsave();
        this.convertToPSPath(pathIterator);
        pSPrinterJob.selectClipPath();
    }

    protected void deviceFill(PathIterator pathIterator, Color color) {
        PSPrinterJob pSPrinterJob = (PSPrinterJob)this.getPrinterJob();
        this.convertToPSPath(pathIterator);
        pSPrinterJob.setColor(color);
        pSPrinterJob.fillPath();
    }
}

