/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.motif;

import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.PrintJob;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import sun.awt.motif.CheckExitCodeRunnable;
import sun.awt.motif.NullProcess;
import sun.awt.motif.PSGraphics;
import sun.awt.motif.PSPrintJob;
import sun.awt.motif.PrintControl;
import sun.awt.motif.PrintStatusDialog;
import sun.awt.motif.UPrintDialog;

public class PSPrintControl
implements PrintControl {
    public static final String DEST_PROP = "awt.print.destination";
    public static final String PRINTER = "printer";
    public static final String FILE = "file";
    public static final String PRINTER_PROP = "awt.print.printer";
    public static final String FILENAME_PROP = "awt.print.fileName";
    public static final String NUMCOPIES_PROP = "awt.print.numCopies";
    public static final String OPTIONS_PROP = "awt.print.options";
    public static final String ORIENT_PROP = "awt.print.orientation";
    public static final String PORTRAIT = "portrait";
    public static final String LANDSCAPE = "landscape";
    public static final String PAPERSIZE_PROP = "awt.print.paperSize";
    public static final String LETTER = "letter";
    public static final String LEGAL = "legal";
    public static final String EXECUTIVE = "executive";
    public static final String A4 = "a4";
    private static ResourceBundle messageRB;
    private UPrintDialog printDialog;
    private Frame parentFrame;
    private Hashtable procTable = new Hashtable();
    private String destStr;
    private String copiesStr;
    private String bannerStr;
    private String orientStr;
    private String paperStr;
    private String printerName;
    private String fileName = null;
    private String lpOptions = null;
    private int destType = 0;
    private int orient = 1;
    private int paperSize = 0;
    private int numCopies = 1;

    public PSPrintControl(final Frame frame) {
        this.printDialog = (UPrintDialog)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new UPrintDialog(frame);
            }
        });
        this.parentFrame = frame;
    }

    public PrintJob createPrintJob(int n, String string, String string2, String string3, int n2, int n3, int n4) {
        Serializable serializable;
        OutputStream outputStream = null;
        Process process = null;
        String[] stringArray = new String[1];
        String string4 = null;
        this.destType = n;
        this.bannerStr = string3;
        this.numCopies = n4;
        this.orient = n3;
        switch (n) {
            case 0: {
                this.printerName = string;
                this.lpOptions = string2;
                try {
                    stringArray = this.printExecCmd(string, string2, string3, n4);
                    process = Runtime.getRuntime().exec(stringArray);
                    outputStream = process.getOutputStream();
                }
                catch (IOException iOException) {
                    string4 = String.valueOf(PSPrintControl.getMsg("error_msg.exec_print")) + stringArray;
                }
                break;
            }
            case 1: {
                this.fileName = string;
                serializable = new File(this.fileName);
                String string5 = "";
                try {
                    string5 = (String)AccessController.doPrivileged(new PrivilegedExceptionAction((File)serializable){
                        private final /* synthetic */ File val$destFile;
                        {
                            this.val$destFile = file;
                        }

                        public Object run() throws IOException {
                            return this.val$destFile.getCanonicalPath();
                        }
                    });
                    if (((File)serializable).exists()) {
                        String string6 = PSPrintControl.getMsg("warning_button.cancel");
                        String string7 = PSPrintControl.getMsg("warning_button.overwrite");
                        PrintStatusDialog printStatusDialog = new PrintStatusDialog(this.parentFrame, PSPrintControl.getMsg("warning_dialog.title"), String.valueOf(PSPrintControl.getMsg("warning_msg.file_exists")) + this.fileName, string7, string6);
                        printStatusDialog.show();
                        if (printStatusDialog.getCommand().equals(string6)) {
                            return null;
                        }
                    }
                    outputStream = new FileOutputStream((File)serializable);
                }
                catch (PrivilegedActionException privilegedActionException) {
                    string4 = String.valueOf(PSPrintControl.getMsg("error_msg.create_file")) + string5;
                }
                catch (IOException iOException) {
                    string4 = String.valueOf(PSPrintControl.getMsg("error_msg.create_file")) + string5;
                }
                break;
            }
            default: {
                return null;
            }
        }
        if (string4 != null) {
            serializable = new PrintStatusDialog(this.parentFrame, PSPrintControl.getMsg("error_dialog.title"), string4, PSPrintControl.getMsg("error_button.ok"));
            ((Dialog)serializable).show();
            return null;
        }
        switch (n2) {
            case 1: {
                serializable = PSGraphics.Legal;
                break;
            }
            case 2: {
                serializable = PSGraphics.Executive;
                break;
            }
            case 3: {
                serializable = PSGraphics.A4;
                break;
            }
            default: {
                serializable = PSGraphics.Letter;
            }
        }
        if (n3 == 0) {
            serializable = new Dimension(((Dimension)serializable).height, ((Dimension)serializable).width);
        }
        PSPrintJob pSPrintJob = new PSPrintJob(new PrintStream(new BufferedOutputStream(outputStream), false), string3, (Dimension)serializable, 72, this);
        this.procTable.put(pSPrintJob, process == null ? new NullProcess() : process);
        return pSPrintJob;
    }

    private String escapeString(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\"\\", true);
        if (stringTokenizer.countTokens() == 1) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length() * 2);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.length() == 1) {
                char c = string2.charAt(0);
                if (c == '\"' || c == '\\') {
                    stringBuffer.append('\\');
                }
                stringBuffer.append(c);
                continue;
            }
            stringBuffer.append(string2);
        }
        return new String(stringBuffer);
    }

    public void finishedPrinting(PSPrintJob pSPrintJob) {
        Process process = (Process)this.procTable.get(pSPrintJob);
        new Thread(new CheckExitCodeRunnable(process, this.parentFrame)).start();
    }

    static synchronized String getMsg(String string) {
        if (messageRB == null) {
            PSPrintControl.initResource();
        }
        try {
            return messageRB.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            throw new Error("Fatal: Resource for PSPrintControl is broken, There is no " + string + " key in resource");
        }
    }

    public PSPrintJob initJob(String string, Properties properties, boolean bl) {
        PSPrintJob pSPrintJob = null;
        this.readProps(properties);
        this.printDialog.setDocumentTitle(string);
        this.printDialog.setNumCopies(this.numCopies);
        this.printDialog.setDestType(this.destType);
        this.printDialog.setDestString(0, this.printerName != null ? this.printerName : "lp");
        this.printDialog.setDestString(1, this.fileName != null ? this.fileName : "");
        this.printDialog.setOptionsString(this.lpOptions != null ? this.lpOptions : "");
        this.printDialog.setBannerString(string);
        this.printDialog.setOrientation(this.orient);
        this.printDialog.setPaperSize(this.paperSize);
        pSPrintJob = (PSPrintJob)this.printDialog.getPrintJob(this);
        if (pSPrintJob != null && bl) {
            this.writeProps(properties);
        }
        return pSPrintJob;
    }

    static void initResource() {
        try {
            messageRB = ResourceBundle.getBundle("sun.awt.motif.resources.printcontrol");
        }
        catch (MissingResourceException missingResourceException) {
            throw new Error("Fatal: Resource for PSPrintControl is missing.");
        }
    }

    private String[] printExecCmd(String string, String string2, String string3, int n) {
        int n2 = 1;
        int n3 = 2;
        int n4 = 4;
        int n5 = 8;
        int n6 = 0;
        int n7 = 1;
        int n8 = 0;
        if (string != null && !string.equals("") && !string.equals("lp")) {
            n6 |= n2;
            ++n7;
        }
        if (string2 != null && !string2.equals("")) {
            n6 |= n3;
            ++n7;
        }
        if (string3 != null && !string3.equals("")) {
            n6 |= n4;
            ++n7;
        }
        if (n > 1) {
            n6 |= n5;
            ++n7;
        }
        String[] stringArray = new String[n7];
        if (new File("/usr/bin/lpr").exists()) {
            stringArray[n8++] = "/usr/bin/lpr";
            if ((n6 & n2) != 0) {
                stringArray[n8++] = new String("-P" + string);
            }
            if ((n6 & n4) != 0) {
                stringArray[n8++] = new String("-T" + this.escapeString(string3));
            }
            if ((n6 & n5) != 0) {
                stringArray[n8++] = new String("-#" + new Integer(n).toString());
            }
            if ((n6 & n3) != 0) {
                stringArray[n8++] = new String(string2);
            }
        } else {
            stringArray[n8++] = "/usr/bin/lp";
            if ((n6 & n2) != 0) {
                stringArray[n8++] = new String("-d" + string);
            }
            if ((n6 & n4) != 0) {
                stringArray[n8++] = new String("-t" + this.escapeString(string3));
            }
            if ((n6 & n5) != 0) {
                stringArray[n8++] = new String("-n" + new Integer(n).toString());
            }
            if ((n6 & n3) != 0) {
                stringArray[n8++] = new String("-o" + string2);
            }
        }
        return stringArray;
    }

    private void readProps(Properties properties) {
        if (properties == null) {
            return;
        }
        this.destStr = properties.getProperty(DEST_PROP);
        if (this.destStr != null) {
            this.destType = this.destStr.equals(FILE) ? 1 : 0;
        }
        this.printerName = properties.getProperty(PRINTER_PROP);
        this.fileName = properties.getProperty(FILENAME_PROP);
        this.lpOptions = properties.getProperty(OPTIONS_PROP);
        this.orientStr = properties.getProperty(ORIENT_PROP);
        if (this.orientStr != null) {
            int n = this.orient = this.orientStr.equals(LANDSCAPE) ? 0 : 1;
        }
        if ((this.paperStr = properties.getProperty(PAPERSIZE_PROP)) != null) {
            if (this.paperStr.equals(LETTER)) {
                this.paperSize = 0;
            } else if (this.paperStr.equals(LEGAL)) {
                this.paperSize = 1;
            } else if (this.paperStr.equals(EXECUTIVE)) {
                this.paperSize = 2;
            } else if (this.paperStr.equals(A4)) {
                this.paperSize = 3;
            }
        }
        if ((this.copiesStr = properties.getProperty(NUMCOPIES_PROP)) != null) {
            Integer n = new Integer(this.copiesStr);
            this.numCopies = n;
        }
    }

    private void writeProps(Properties properties) {
        if (properties == null) {
            return;
        }
        properties.put(DEST_PROP, this.destType == 0 ? PRINTER : FILE);
        if (this.printerName != null && !this.printerName.equals("") && !this.printerName.equals("lp")) {
            properties.put(PRINTER_PROP, this.printerName);
        }
        if (this.fileName != null && !this.fileName.equals("")) {
            properties.put(FILENAME_PROP, this.fileName);
        }
        if (this.lpOptions != null && !this.lpOptions.equals("")) {
            properties.put(OPTIONS_PROP, this.lpOptions);
        }
        properties.put(ORIENT_PROP, this.orient == 1 ? PORTRAIT : LANDSCAPE);
        switch (this.paperSize) {
            case 1: {
                this.paperStr = LEGAL;
                break;
            }
            case 2: {
                this.paperStr = EXECUTIVE;
                break;
            }
            case 3: {
                this.paperStr = A4;
                break;
            }
            default: {
                this.paperStr = LETTER;
            }
        }
        properties.put(PAPERSIZE_PROP, this.paperStr);
        if (this.numCopies > 0) {
            properties.put(NUMCOPIES_PROP, new Integer(this.numCopies).toString());
        }
    }
}

