/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.motif;

import java.awt.Color;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import sun.awt.motif.PSPathGraphics;
import sun.awt.motif.PrintStatusDialog;
import sun.awt.motif.UPrinterDialog;
import sun.java2d.PeekGraphics;
import sun.java2d.PeekMetrics;
import sun.java2d.RasterPrinterJob;

public class PSPrinterJob
extends RasterPrinterJob {
    protected static final int FILL_EVEN_ODD = 1;
    protected static final int FILL_WINDING = 2;
    private static final int MAX_PSSTR = 65535;
    private static final int RED_MASK = 0xFF0000;
    private static final int GREEN_MASK = 65280;
    private static final int BLUE_MASK = 255;
    private static final int RED_SHIFT = 16;
    private static final int GREEN_SHIFT = 8;
    private static final int BLUE_SHIFT = 0;
    private static final int LOWNIBBLE_MASK = 15;
    private static final int HINIBBLE_MASK = 240;
    private static final int HINIBBLE_SHIFT = 4;
    private static final byte[] hexDigits = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};
    private static final int PS_XRES = 300;
    private static final int PS_YRES = 300;
    private static final String ADOBE_PS_STR = "%!PS-Adobe-3.0";
    private static final String EOF_COMMENT = "%%EOF";
    private static final String PAGE_COMMENT = "%%Page: ";
    private static final String READIMAGEPROC = "/imStr 0 def /heximageSrc{currentfile imStr readhexstring pop} def";
    private static final String COPIES = "/#copies exch def";
    private static final String SHOWPAGE = "showpage";
    private static final String IMAGE_SAVE = "/imSave save def";
    private static final String IMAGE_STR = " string /imStr exch def";
    private static final String IMAGE_RESTORE = "imSave restore";
    private static final String COORD_PREP = " 0 exch translate 1 -1 scale[72 300 div 0 0 72 300 div 0 0]concat";
    private static final String EVEN_ODD_FILL_STR = "eofill";
    private static final String WINDING_FILL_STR = "fill";
    private static final String EVEN_ODD_CLIP_STR = "eoclip";
    private static final String WINDING_CLIP_STR = "clip";
    private static final String MOVETO_STR = " moveto";
    private static final String LINETO_STR = " lineto";
    private static final String CURVETO_STR = " curveto";
    private static final String GRESTORE_STR = "grestore";
    private static final String GSAVE_STR = "gsave";
    private static final String NEWPATH_STR = "newpath";
    private static final String CLOSEPATH_STR = "closepath";
    private static final String SETRGBCOLOR_STR = " setrgbcolor";
    private static final String SETGRAY_STR = " setgray";
    private static ResourceBundle messageRB;
    int mDestType;
    String mDestination = "lp";
    String mOptions;
    String mBanner;
    PrintStream mPSStream;
    private String mFillOpStr = "fill";
    private String mClipOpStr = "clip";
    private int mGStateCount;
    private float mPenX;
    private float mPenY;
    private float mStartPathX;
    private float mStartPathY;

    protected void beginPath() {
        this.mPSStream.println(NEWPATH_STR);
        this.mPenX = 0.0f;
        this.mPenY = 0.0f;
    }

    protected void bezierTo(float f, float f2, float f3, float f4, float f5, float f6) {
        this.mPSStream.println(String.valueOf(f) + " " + f2 + " " + f3 + " " + f4 + " " + f5 + " " + f6 + CURVETO_STR);
        this.mPenX = f5;
        this.mPenY = f6;
    }

    protected void closeSubpath() {
        this.mPSStream.println(CLOSEPATH_STR);
        this.mPenX = this.mStartPathX;
        this.mPenY = this.mStartPathY;
    }

    protected Graphics2D createPathGraphics(PeekGraphics peekGraphics, PrinterJob printerJob, Printable printable, PageFormat pageFormat, int n) {
        PSPathGraphics pSPathGraphics;
        PeekMetrics peekMetrics = peekGraphics.getMetrics();
        if (peekMetrics.hasNonSolidColors() || peekMetrics.hasCompositing() || peekMetrics.hasImages()) {
            pSPathGraphics = null;
        } else {
            BufferedImage bufferedImage = new BufferedImage(8, 8, 1);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            pSPathGraphics = new PSPathGraphics(graphics2D, printerJob, printable, pageFormat, n);
        }
        return pSPathGraphics;
    }

    public PageFormat defaultPage(PageFormat pageFormat) {
        return pageFormat;
    }

    protected void endDoc() throws PrinterException {
        if (this.mPSStream != null) {
            this.mPSStream.println(EOF_COMMENT);
            this.mPSStream.close();
        }
    }

    protected void endPage(PageFormat pageFormat, Printable printable, int n) throws PrinterException {
        this.mPSStream.println(SHOWPAGE);
    }

    protected void fillPath() {
        this.mPSStream.println(this.mFillOpStr);
    }

    static String getMsg(String string) {
        if (messageRB == null) {
            PSPrinterJob.initResource();
        }
        try {
            return messageRB.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            throw new Error("Fatal: Resource for PSPrinterJob is broken, There is no " + string + " key in resource");
        }
    }

    protected int getNoncollatedCopies() {
        return 1;
    }

    protected float getPenX() {
        return this.mPenX;
    }

    protected float getPenY() {
        return this.mPenY;
    }

    protected double getXRes() {
        return 300.0;
    }

    protected double getYRes() {
        return 300.0;
    }

    protected void grestore() {
        if (this.mGStateCount > 0) {
            this.mPSStream.println(GRESTORE_STR);
            --this.mGStateCount;
        }
    }

    protected void gsave() {
        this.mPSStream.println(GSAVE_STR);
        ++this.mGStateCount;
    }

    static void initResource() {
        try {
            messageRB = ResourceBundle.getBundle("sun.awt.motif.resources.printcontrol");
        }
        catch (MissingResourceException missingResourceException) {
            throw new Error("Fatal: Resource for PSPrintControl is missing.");
        }
    }

    protected void lineTo(float f, float f2) {
        this.mPSStream.println(String.valueOf(f) + " " + f2 + LINETO_STR);
        this.mPenX = f;
        this.mPenY = f2;
    }

    protected void moveTo(float f, float f2) {
        this.mPSStream.println(String.valueOf(f) + " " + f2 + MOVETO_STR);
        this.mStartPathX = f;
        this.mStartPathY = f2;
        this.mPenX = f;
        this.mPenY = f2;
    }

    private boolean okayToCreateFile(Frame frame, String string) {
        boolean bl = true;
        File file = new File(string);
        if (file.exists()) {
            String string2 = PSPrinterJob.getMsg("warning_button.cancel");
            String string3 = PSPrinterJob.getMsg("warning_button.overwrite");
            PrintStatusDialog printStatusDialog = new PrintStatusDialog(frame, PSPrinterJob.getMsg("warning_dialog.title"), String.valueOf(PSPrinterJob.getMsg("warning_msg.file_exists")) + string, string3, string2);
            printStatusDialog.show();
            if (printStatusDialog.getCommand().equals(string2)) {
                bl = false;
            }
        }
        return bl;
    }

    public PageFormat pageDialog(PageFormat pageFormat) {
        return pageFormat;
    }

    protected void printBand(int[] nArray, int n, int n2, int n3, int n4) throws PrinterException {
        this.mPSStream.println(IMAGE_SAVE);
        int n5 = 3 * n3;
        while (n5 > 65535) {
            n5 /= 2;
        }
        this.mPSStream.println(String.valueOf(n5) + IMAGE_STR);
        this.mPSStream.println("[" + n3 + " 0 " + "0 " + n4 + " " + n + " " + n2 + "]concat");
        this.mPSStream.println(String.valueOf(n3) + " " + n4 + " " + 8 + "[" + n3 + " 0 " + "0 " + -n4 + " 0 " + n4 + "]" + "/heximageSrc load false 3 colorimage");
        int n6 = 0;
        byte[] byArray = new byte[n3 * 6];
        try {
            int n7 = 0;
            while (n7 < n4) {
                n6 = PSPrinterJob.toHex(nArray, n6, byArray);
                this.mPSStream.write(byArray);
                this.mPSStream.println("");
                ++n7;
            }
        }
        catch (IOException iOException) {
            throw new PrinterException(iOException.toString());
        }
        this.mPSStream.println(IMAGE_RESTORE);
    }

    public boolean printDialog() {
        Boolean bl = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Frame frame = new Frame();
                UPrinterDialog uPrinterDialog = new UPrinterDialog(frame, "Print");
                uPrinterDialog.setCopies(PSPrinterJob.this.getCopies());
                uPrinterDialog.show();
                if (uPrinterDialog.getPrintStatus() != 1) {
                    return Boolean.FALSE;
                }
                PSPrinterJob.this.mDestType = uPrinterDialog.getDestType();
                PSPrinterJob.this.mDestination = uPrinterDialog.getDestString(PSPrinterJob.this.mDestType);
                PSPrinterJob.this.mOptions = uPrinterDialog.getOptionsString();
                PSPrinterJob.this.mBanner = uPrinterDialog.getBannerString();
                PSPrinterJob.this.setCopies(uPrinterDialog.getCopies());
                PSPrinterJob.this.setCollated(false);
                if (PSPrinterJob.this.mDestType == 1) {
                    return new Boolean(PSPrinterJob.this.okayToCreateFile(frame, PSPrinterJob.this.mDestination));
                }
                return Boolean.TRUE;
            }
        });
        return bl;
    }

    private String[] printExecCmd(String string, String string2, String string3, int n) {
        int n2 = 1;
        int n3 = 2;
        int n4 = 4;
        int n5 = 8;
        int n6 = 0;
        int n7 = 1;
        int n8 = 0;
        if (string != null && !string.equals("") && !string.equals("lp")) {
            n6 |= n2;
            ++n7;
        }
        if (string2 != null && !string2.equals("")) {
            n6 |= n3;
            ++n7;
        }
        if (string3 != null && !string3.equals("")) {
            n6 |= n4;
            ++n7;
        }
        if (n > 1) {
            n6 |= n5;
            ++n7;
        }
        String[] stringArray = new String[n7];
        stringArray[n8++] = "/usr/bin/lpr";
        if ((n6 & n2) != 0) {
            stringArray[n8++] = new String("-P" + string);
        }
        if ((n6 & n4) != 0) {
            stringArray[n8++] = new String("-T" + string3);
        }
        if ((n6 & n5) != 0) {
            stringArray[n8++] = new String("-#" + new Integer(n).toString());
        }
        if ((n6 & n3) != 0) {
            stringArray[n8++] = new String(string2);
        }
        return stringArray;
    }

    protected void selectClipPath() {
        this.mPSStream.println(this.mClipOpStr);
    }

    public void setCollated(boolean bl) {
        super.setCollated(bl);
    }

    protected void setColor(Color color) {
        float[] fArray = color.getColorComponents(null);
        if (fArray[0] == fArray[1] && fArray[1] == fArray[2]) {
            this.mPSStream.println(String.valueOf(fArray[0]) + SETGRAY_STR);
        } else {
            this.mPSStream.println(String.valueOf(fArray[0]) + " " + fArray[1] + " " + fArray[2] + " " + SETRGBCOLOR_STR);
        }
    }

    protected void setFillMode(int n) {
        switch (n) {
            case 1: {
                this.mFillOpStr = EVEN_ODD_FILL_STR;
                this.mClipOpStr = EVEN_ODD_CLIP_STR;
                break;
            }
            case 2: {
                this.mFillOpStr = WINDING_FILL_STR;
                this.mClipOpStr = WINDING_CLIP_STR;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    protected void startDoc() throws PrinterException {
        PrinterOpener printerOpener = new PrinterOpener();
        AccessController.doPrivileged(printerOpener);
        if (printerOpener.pex != null) {
            throw printerOpener.pex;
        }
        OutputStream outputStream = printerOpener.result;
        this.mPSStream = new PrintStream(new BufferedOutputStream(outputStream));
        this.mPSStream.println(ADOBE_PS_STR);
        this.mPSStream.println(READIMAGEPROC);
        int n = this.isCollated() ? 1 : this.getCopies();
        this.mPSStream.println(String.valueOf(n) + COPIES);
    }

    protected void startPage(PageFormat pageFormat, Printable printable, int n) throws PrinterException {
        double d = pageFormat.getPaper().getHeight();
        int n2 = n + 1;
        this.mPSStream.println(PAGE_COMMENT + n2 + " " + n2);
        this.mPSStream.println(String.valueOf(d) + COORD_PREP);
    }

    private static int toHex(int[] nArray, int n, byte[] byArray) {
        int n2 = 0;
        while (n < nArray.length && n2 < byArray.length) {
            int n3 = nArray[n++];
            int n4 = (n3 & 0xFF0000) >>> 16;
            byArray[n2++] = hexDigits[(n4 & 0xF0) >>> 4];
            byArray[n2++] = hexDigits[n4 & 0xF];
            n4 = (n3 & 0xFF00) >>> 8;
            byArray[n2++] = hexDigits[(n4 & 0xF0) >>> 4];
            byArray[n2++] = hexDigits[n4 & 0xF];
            n4 = n3 & 0xFF;
            byArray[n2++] = hexDigits[(n4 & 0xF0) >>> 4];
            byArray[n2++] = hexDigits[n4 & 0xF];
        }
        return n;
    }

    public PageFormat validatePage(PageFormat pageFormat) {
        return pageFormat;
    }

    private class PrinterOpener
    implements PrivilegedAction {
        PrinterException pex;
        OutputStream result;

        PrinterOpener() {
        }

        public Object run() {
            try {
                if (PSPrinterJob.this.mDestType == 1) {
                    File file = new File(PSPrinterJob.this.mDestination);
                    this.result = new FileOutputStream(file);
                } else {
                    String[] stringArray = PSPrinterJob.this.printExecCmd(PSPrinterJob.this.mDestination, PSPrinterJob.this.mOptions, PSPrinterJob.this.mBanner, PSPrinterJob.this.getCopies());
                    Process process = Runtime.getRuntime().exec(stringArray);
                    this.result = process.getOutputStream();
                }
            }
            catch (IOException iOException) {
                this.pex = new PrinterException(iOException.toString());
            }
            return null;
        }
    }
}

