/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.motif;

import java.awt.AWTEvent;
import java.awt.AWTException;
import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.awt.event.InputMethodEvent;
import java.awt.font.TextAttribute;
import java.awt.font.TextHitInfo;
import java.awt.im.InputMethodHighlight;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import sun.awt.SunToolkit;
import sun.awt.im.InputMethodAdapter;
import sun.awt.im.InputMethodHighlightMapping;
import sun.awt.motif.MComponentPeer;
import sun.awt.motif.MInputMethodControl;
import sun.awt.motif.MToolkit;

public class X11InputMethod
extends InputMethodAdapter {
    private static final int XIMReverse = 1;
    private static final int XIMUnderline = 2;
    private static final int XIMHighlight = 4;
    private static final int XIMPrimary = 32;
    private static final int XIMSecondary = 64;
    private static final int XIMTertiary = 128;
    private static final int XIMVisibleToForward = 256;
    private static final int XIMVisibleToBackward = 512;
    private static final int XIMVisibleCenter = 1024;
    private static final int XIMVisibleMask = 1792;
    private Locale locale = Locale.getDefault();
    private static boolean isXIMOpened = false;
    private Container clientComponentWindow = null;
    private Component compositionArea;
    private boolean createXICFailed = false;
    private Component focussedComponent = null;
    private boolean isActiveClient = false;
    private static XIMHighlightMapping highlightMapping = new XIMHighlightMapping();
    private static HashMap mappingTable;
    private boolean disposed = false;
    private boolean needResetXIC = false;
    private Component needResetXICClient = null;
    private String committedText = null;
    private StringBuffer composedText = null;
    private IntBuffer rawFeedbacks;
    private transient long pData = 0L;
    private boolean waitingPreeditCompletion = false;
    private static final int INITIAL_SIZE = 64;

    static {
        HashMap hashMap = new HashMap();
        HashMap hashMap2 = new HashMap();
        hashMap2.put(InputMethodHighlightMapping.InputMethodHighlightAttribute.INPUT_METHOD_UNDERLINE, InputMethodHighlightMapping.InputMethodHighlightAttribute.UNDERLINE_LOW_ONE_PIXEL);
        hashMap.put(InputMethodHighlight.UNSELECTED_CONVERTED_TEXT_HIGHLIGHT, hashMap2);
        hashMap2 = new HashMap();
        hashMap2.put(TextAttribute.SWAP_COLORS, TextAttribute.SWAP_COLORS_ON);
        hashMap.put(InputMethodHighlight.SELECTED_CONVERTED_TEXT_HIGHLIGHT, hashMap2);
        hashMap2 = new HashMap();
        hashMap2.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
        hashMap.put(InputMethodHighlight.UNSELECTED_RAW_TEXT_HIGHLIGHT, hashMap2);
        hashMap2 = new HashMap();
        hashMap2.put(TextAttribute.SWAP_COLORS, TextAttribute.SWAP_COLORS_ON);
        hashMap.put(InputMethodHighlight.SELECTED_RAW_TEXT_HIGHLIGHT, hashMap2);
        mappingTable = hashMap;
        X11InputMethod.initIDs();
    }

    public X11InputMethod() throws AWTException {
        if (!this.initXIM()) {
            throw new AWTException("cannot open XIM");
        }
    }

    public synchronized void activate() {
        if (this.createXICFailed) {
            return;
        }
        this.resetXICifneeded();
        this.clientComponentWindow = this.getClientComponentWindow();
        if (this.clientComponentWindow == null) {
            return;
        }
        Component component = this.getFocussedComponent();
        if (this.focussedComponent != null) {
            if (this.focussedComponent != component && this.pData != 0L) {
                this.setXICFocus(this.getPeer(this.focussedComponent), false, this.isActiveClient, this.pData);
            }
            this.focussedComponent = null;
        }
        if (this.pData == 0L) {
            MComponentPeer mComponentPeer = this.getPeer(this.clientComponentWindow);
            boolean bl = false;
            if (mComponentPeer instanceof MInputMethodControl) {
                bl = ((MInputMethodControl)((Object)mComponentPeer)).hasTextComponents();
            }
            this.pData = this.createXICNative(mComponentPeer, bl);
            if (this.pData == 0L) {
                this.createXICFailed = true;
                return;
            }
            this.disposed = false;
            if (mComponentPeer instanceof MInputMethodControl) {
                ((MInputMethodControl)((Object)mComponentPeer)).addInputMethod(this);
            }
        }
        this.setXICFocus(this.getPeer(component), true, this.haveActiveClient(), this.pData);
    }

    private native void closeXIM();

    void configureStatus() {
        if (this.pData == 0L) {
            return;
        }
        MComponentPeer mComponentPeer = this.getPeer((Window)this.clientComponentWindow);
        if (((MInputMethodControl)((Object)mComponentPeer)).hasTextComponents()) {
            this.configureStatusAreaNative(this.pData);
        }
    }

    private native void configureStatusAreaNative(long var1);

    private InputMethodHighlight convertVisualFeedbackToHighlight(int n) {
        InputMethodHighlight inputMethodHighlight;
        switch (n) {
            case 2: {
                inputMethodHighlight = InputMethodHighlight.UNSELECTED_CONVERTED_TEXT_HIGHLIGHT;
                break;
            }
            case 1: {
                inputMethodHighlight = InputMethodHighlight.SELECTED_CONVERTED_TEXT_HIGHLIGHT;
                break;
            }
            case 4: {
                inputMethodHighlight = InputMethodHighlight.SELECTED_RAW_TEXT_HIGHLIGHT;
                break;
            }
            case 32: {
                inputMethodHighlight = InputMethodHighlight.UNSELECTED_CONVERTED_TEXT_HIGHLIGHT;
                break;
            }
            case 64: {
                inputMethodHighlight = InputMethodHighlight.SELECTED_CONVERTED_TEXT_HIGHLIGHT;
                break;
            }
            case 128: {
                inputMethodHighlight = InputMethodHighlight.SELECTED_RAW_TEXT_HIGHLIGHT;
                break;
            }
            default: {
                inputMethodHighlight = InputMethodHighlight.SELECTED_RAW_TEXT_HIGHLIGHT;
            }
        }
        return inputMethodHighlight;
    }

    private native long createXICNative(MComponentPeer var1, boolean var2);

    public synchronized void deactivate(boolean bl) {
        if (this.pData != 0L) {
            Component component = this.getFocussedComponent();
            boolean bl2 = this.haveActiveClient();
            if (bl) {
                this.focussedComponent = component;
                this.isActiveClient = bl2;
                return;
            }
            this.setXICFocus(this.getPeer(component), false, bl2, this.pData);
            this.focussedComponent = null;
        }
    }

    synchronized void dispatchCommittedText(String string) {
        if (string == null) {
            return;
        }
        if (this.composedText == null) {
            AttributedString attributedString = new AttributedString(string);
            this.postInputMethodEvent(1100, attributedString.getIterator(), string.length(), null, null);
        } else {
            this.committedText = string;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void dispatchComposedText(String string, int[] nArray, int n, int n2, int n3) {
        if (this.pData == 0L) {
            return;
        }
        if (string == null && nArray == null && n == 0 && n2 == 0 && n3 == 0 && this.composedText == null && this.committedText == null) {
            return;
        }
        X11InputMethod x11InputMethod = this;
        synchronized (x11InputMethod) {
            AttributedString attributedString;
            int n4;
            if (this.composedText == null) {
                this.composedText = new StringBuffer(64);
                this.rawFeedbacks = new IntBuffer(64);
            }
            if (n2 > 0) {
                if (string == null && nArray != null) {
                    this.rawFeedbacks.replace(n, nArray);
                } else if (n2 == this.composedText.length()) {
                    this.composedText = new StringBuffer(64);
                    this.rawFeedbacks = new IntBuffer(64);
                } else if (this.composedText.length() > 0) {
                    if (n + n2 < this.composedText.length()) {
                        String string2 = this.composedText.toString().substring(n + n2, this.composedText.length());
                        this.composedText.setLength(n);
                        this.composedText.append(string2);
                    } else {
                        this.composedText.setLength(n);
                    }
                    this.rawFeedbacks.remove(n, n2);
                }
            }
            if (string != null) {
                this.composedText.insert(n, string);
                if (nArray != null) {
                    this.rawFeedbacks.insert(n, nArray);
                }
            }
            if (this.composedText.length() == 0) {
                this.composedText = null;
                this.rawFeedbacks = null;
                if (this.committedText != null) {
                    this.dispatchCommittedText(this.committedText);
                    this.committedText = null;
                    return;
                }
                this.postInputMethodEvent(1100, null, 0, null, null);
                this.notifyPreeditCompletion();
                return;
            }
            if (this.committedText != null) {
                n4 = this.committedText.length();
                attributedString = new AttributedString(String.valueOf(this.committedText) + this.composedText);
                this.committedText = null;
            } else {
                n4 = 0;
                attributedString = new AttributedString(this.composedText.toString());
            }
            int n5 = 0;
            int n6 = 0;
            TextHitInfo textHitInfo = null;
            this.rawFeedbacks.rewind();
            int n7 = this.rawFeedbacks.getNext();
            this.rawFeedbacks.unget();
            while (true) {
                int n8;
                int n9;
                if ((n9 = this.rawFeedbacks.getNext()) == -1) {
                    n8 = this.rawFeedbacks.getOffset();
                    if (n8 >= 0) {
                        attributedString.addAttribute(TextAttribute.INPUT_METHOD_HIGHLIGHT, this.convertVisualFeedbackToHighlight(n7), n4 + n5, n4 + n8);
                    }
                    this.postInputMethodEvent(1100, attributedString.getIterator(), n4, TextHitInfo.leading(n3), textHitInfo);
                    this.notifyPreeditCompletion();
                    return;
                }
                if (n6 == 0 && (n6 = n9 & 0x700) != 0) {
                    int n10 = this.rawFeedbacks.getOffset() - 1;
                    textHitInfo = n6 == 512 ? TextHitInfo.leading(n10) : TextHitInfo.trailing(n10);
                }
                if (n7 == (n9 &= 0xFFFFF8FF)) continue;
                this.rawFeedbacks.unget();
                n8 = this.rawFeedbacks.getOffset();
                attributedString.addAttribute(TextAttribute.INPUT_METHOD_HIGHLIGHT, this.convertVisualFeedbackToHighlight(n7), n4 + n5, n4 + n8);
                n5 = n8;
                n7 = n9;
            }
        }
    }

    public void dispatchEvent(AWTEvent aWTEvent) {
    }

    public final void dispose() {
        boolean bl = false;
        if (!this.disposed) {
            X11InputMethod x11InputMethod = this;
            synchronized (x11InputMethod) {
                if (!this.disposed) {
                    bl = true;
                    this.disposed = true;
                }
            }
        }
        if (bl) {
            this.disposeImpl();
        }
    }

    protected synchronized void disposeImpl() {
        if (this.pData != 0L) {
            long l = this.pData;
            this.pData = 0L;
            if (this.clientComponentWindow != null) {
                MComponentPeer mComponentPeer = this.getPeer(this.clientComponentWindow);
                ((MInputMethodControl)((Object)mComponentPeer)).removeInputMethod(this);
                this.clientComponentWindow = null;
            }
            this.disposeXIC(l);
            this.composedText = null;
            this.committedText = null;
            this.rawFeedbacks = null;
            this.focussedComponent = null;
        }
    }

    private native void disposeXIC(long var1);

    public void endComposition() {
        if (this.pData == 0L) {
            return;
        }
        if (this.haveActiveClient() && this.composedText == null && this.committedText == null) {
            this.needResetXIC = true;
            this.needResetXICClient = this.getClientComponent();
            return;
        }
        String string = this.resetXIC(this.pData);
        this.needResetXIC = false;
        this.waitForPreeditCompletion();
        if (string != null && string.length() > 0) {
            this.dispatchCommittedText(string);
        }
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    private Window getClientComponentWindow() {
        Component component = this.getClientComponent();
        Container container = component instanceof Container ? (Container)component : MComponentPeer.getParent_NoClientCode(component);
        while (container != null && !(container instanceof Window)) {
            container = MComponentPeer.getParent_NoClientCode(container);
        }
        return (Window)container;
    }

    public Object getControlObject() {
        return null;
    }

    Component getFocussedComponent() {
        if (this.compositionArea != null) {
            return this.compositionArea;
        }
        return this.getClientComponent();
    }

    public static InputMethodHighlightMapping getInputMethodHighlightMapping() {
        return highlightMapping;
    }

    private MComponentPeer getPeer(Component component) {
        MComponentPeer mComponentPeer = (MComponentPeer)MToolkit.targetToPeer(component);
        if (mComponentPeer != null) {
            return mComponentPeer;
        }
        Container container = MToolkit.getNativeContainer(component);
        mComponentPeer = (MComponentPeer)MToolkit.targetToPeer(container);
        return mComponentPeer;
    }

    private static native void initIDs();

    private synchronized boolean initXIM() {
        if (!isXIMOpened) {
            isXIMOpened = this.openXIM();
        }
        return isXIMOpened;
    }

    private synchronized void notifyPreeditCompletion() {
        if (this.waitingPreeditCompletion) {
            this.waitingPreeditCompletion = false;
            this.notify();
        }
    }

    private native boolean openXIM();

    private void postInputMethodEvent(int n, AttributedCharacterIterator attributedCharacterIterator, int n2, TextHitInfo textHitInfo, TextHitInfo textHitInfo2) {
        Component component = this.getClientComponent();
        InputMethodEvent inputMethodEvent = new InputMethodEvent(component, n, attributedCharacterIterator, n2, textHitInfo, textHitInfo2);
        SunToolkit.postEvent(SunToolkit.targetToAppContext(component), inputMethodEvent);
    }

    synchronized void reconfigureXIC(MInputMethodControl mInputMethodControl) {
        if (this.pData != 0L) {
            this.endComposition();
            this.resetXICifneeded();
            this.pData = this.reconfigureXICNative((MComponentPeer)((Object)mInputMethodControl), mInputMethodControl.hasTextComponents(), this.pData);
        }
    }

    private native long reconfigureXICNative(MComponentPeer var1, boolean var2, long var3);

    public synchronized void removeNotify() {
        this.dispose();
    }

    private native String resetXIC(long var1);

    private final void resetXICifneeded() {
        if (this.needResetXIC) {
            if (this.getClientComponent() != this.needResetXICClient) {
                this.resetXIC(this.pData);
            }
            this.needResetXICClient = null;
            this.needResetXIC = false;
        }
    }

    public void setCharacterSubsets(Character.Subset[] subsetArray) {
    }

    protected void setCompositionArea(Component component) {
        this.compositionArea = component;
    }

    public boolean setLocale(Locale locale) {
        return locale != null && this.locale.equals(locale);
    }

    private native void setXICFocus(MComponentPeer var1, boolean var2, boolean var3, long var4);

    private synchronized void waitForPreeditCompletion() {
        block3: {
            if (this.composedText == null) break block3;
            this.waitingPreeditCompletion = true;
            try {
                while (this.waitingPreeditCompletion) {
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                this.composedText = null;
            }
        }
    }

    private static final class XIMHighlightMapping
    implements InputMethodHighlightMapping {
        XIMHighlightMapping() {
        }

        public Map mapHighlight(InputMethodHighlight inputMethodHighlight) {
            HashMap hashMap = (HashMap)mappingTable.get(inputMethodHighlight);
            return (Map)hashMap.clone();
        }
    }

    private final class IntBuffer {
        private int[] intArray;
        private int size;
        private int index;

        IntBuffer(int n) {
            this.intArray = new int[n];
            this.size = 0;
            this.index = 0;
        }

        int getNext() {
            if (this.index == this.size) {
                return -1;
            }
            return this.intArray[this.index++];
        }

        int getOffset() {
            return this.index;
        }

        void insert(int n, int[] nArray) {
            int n2 = this.size + nArray.length;
            if (this.intArray.length < n2) {
                int[] nArray2 = new int[n2 * 2];
                System.arraycopy(this.intArray, 0, nArray2, 0, this.size);
                this.intArray = nArray2;
            }
            System.arraycopy(this.intArray, n, this.intArray, n + nArray.length, this.size - n);
            System.arraycopy(nArray, 0, this.intArray, n, nArray.length);
            this.size += nArray.length;
            if (this.index > n) {
                this.index = n;
            }
        }

        void remove(int n, int n2) {
            if (n + n2 != this.size) {
                System.arraycopy(this.intArray, n + n2, this.intArray, n, this.size - n - n2);
            }
            this.size -= n2;
            if (this.index > n) {
                this.index = n;
            }
        }

        void removeAll() {
            this.size = 0;
            this.index = 0;
        }

        void replace(int n, int[] nArray) {
            System.arraycopy(nArray, 0, this.intArray, n, nArray.length);
        }

        void rewind() {
            this.index = 0;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while (n < this.size) {
                stringBuffer.append(this.intArray[n++]);
                if (n >= this.size) continue;
                stringBuffer.append(",");
            }
            return stringBuffer.toString();
        }

        void unget() {
            if (this.index != 0) {
                --this.index;
            }
        }
    }
}

