/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.motif;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.io.StringBufferInputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Vector;
import sun.awt.motif.SelectionThread;
import sun.awt.motif.Target;
import sun.awt.motif.X11SelectionHolder;

public class X11Selection
implements Transferable {
    static Vector selections;
    static Vector targetMap;
    int atom;
    X11SelectionHolder holder;
    Transferable contents;
    String dataString;
    int[] targetArray;
    Object data;
    private boolean disposed = false;

    static {
        X11Selection.initIDs();
        X11Selection.init();
        selections = new Vector();
        X11Selection.registerTargetForFlavor(DataFlavor.stringFlavor, "STRING");
        X11Selection.registerTargetForFlavor(DataFlavor.plainTextFlavor, "STRING");
        targetMap = new Vector();
        Target target = new Target("STRING");
        target.addFlavorMap(DataFlavor.stringFlavor);
        target.addFlavorMap(DataFlavor.plainTextFlavor);
        targetMap.addElement(target);
        target = new Target("COMPOUND_TEXT");
        target.addFlavorMap(DataFlavor.stringFlavor);
        target.addFlavorMap(DataFlavor.plainTextFlavor);
        targetMap.addElement(target);
    }

    public X11Selection(String string) {
        this.create(string);
        selections.addElement(this);
    }

    static int[] convertFlavorToTargets(DataFlavor dataFlavor) {
        int n;
        Object object;
        int[] nArray = new int[24];
        int n2 = 0;
        int n3 = 0;
        while (n3 < targetMap.size()) {
            object = (Target)targetMap.elementAt(n3);
            n = 0;
            while (n < object.flavors.size()) {
                DataFlavor dataFlavor2 = (DataFlavor)object.flavors.elementAt(n);
                if (dataFlavor2.equals(dataFlavor)) {
                    nArray[n2++] = object.atom;
                    break;
                }
                ++n;
            }
            ++n3;
        }
        object = new int[n2];
        n = 0;
        while (n < n2) {
            object[n] = nArray[n];
            ++n;
        }
        return object;
    }

    static DataFlavor[] convertTargetsToFlavors(int[] nArray) {
        Vector vector = new Vector();
        int n = 0;
        while (n < nArray.length) {
            int n2 = 0;
            if (n2 < targetMap.size()) {
                Target target = (Target)targetMap.elementAt(n2);
                if (target.atom == nArray[n]) {
                    int n3 = 0;
                    while (n3 < target.flavors.size()) {
                        DataFlavor dataFlavor = (DataFlavor)target.flavors.elementAt(n3);
                        boolean bl = false;
                        int n4 = 0;
                        while (n4 < vector.size()) {
                            if (dataFlavor.equals((DataFlavor)vector.elementAt(n4))) {
                                bl = true;
                                break;
                            }
                            ++n4;
                        }
                        if (!bl) {
                            vector.addElement(dataFlavor);
                        }
                        ++n3;
                    }
                }
            }
            ++n;
        }
        DataFlavor[] dataFlavorArray = new DataFlavor[vector.size()];
        int n5 = 0;
        while (n5 < vector.size()) {
            dataFlavorArray[n5] = (DataFlavor)vector.elementAt(n5);
            ++n5;
        }
        return dataFlavorArray;
    }

    native void create(String var1);

    public final void dispose() {
        boolean bl = false;
        if (!this.disposed) {
            X11Selection x11Selection = this;
            synchronized (x11Selection) {
                if (!this.disposed) {
                    bl = true;
                    this.disposed = true;
                }
            }
        }
        if (bl) {
            this.disposeImpl();
        }
    }

    protected void disposeImpl() {
        selections.removeElement(this);
        this.pDispose();
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    static native int getAtomForTarget(String var0);

    boolean getSelectionOwnership(Transferable transferable, X11SelectionHolder x11SelectionHolder) {
        this.holder = x11SelectionHolder;
        this.contents = transferable;
        if (this.pGetSelectionOwnership()) {
            return true;
        }
        this.holder = null;
        this.contents = null;
        return false;
    }

    public String getStringDataFromOwner(DataFlavor dataFlavor) {
        block4: {
            if (this.contents == null) break block4;
            Class clazz = dataFlavor.getRepresentationClass();
            try {
                if (clazz == Class.forName("java.lang.String")) {
                    this.dataString = (String)this.contents.getTransferData(dataFlavor);
                    return this.dataString;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (Exception exception) {}
        }
        return null;
    }

    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        this.data = null;
        final int[] nArray = X11Selection.convertFlavorToTargets(dataFlavor);
        if (nArray.length == 0) {
            throw new UnsupportedFlavorException(dataFlavor);
        }
        SelectionThread selectionThread = (SelectionThread)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new SelectionThread(this, nArray);
            }
        });
        Object object = selectionThread;
        synchronized (object) {
            try {
                selectionThread.start();
                selectionThread.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.data == null) {
            throw new IOException("could not get transfer data");
        }
        if (dataFlavor.equals(DataFlavor.plainTextFlavor)) {
            return new StringBufferInputStream((String)this.data);
        }
        object = dataFlavor.getRepresentationClass();
        try {
            if (object == Class.forName("java.io.InputStream")) {
                throw new IOException("can't deal with InputStream yet");
            }
            return this.data;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IOException("couldn't get representation class");
        }
    }

    public DataFlavor[] getTransferDataFlavors() {
        SelectionThread selectionThread;
        this.targetArray = null;
        SelectionThread selectionThread2 = selectionThread = (SelectionThread)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new SelectionThread(X11Selection.this, null);
            }
        });
        synchronized (selectionThread2) {
            try {
                selectionThread.start();
                selectionThread.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.targetArray == null || this.targetArray.length == 0) {
            return null;
        }
        return X11Selection.convertTargetsToFlavors(this.targetArray);
    }

    static native void init();

    private static native void initIDs();

    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        DataFlavor[] dataFlavorArray = this.getTransferDataFlavors();
        if (dataFlavorArray == null) {
            return false;
        }
        int n = 0;
        while (n < dataFlavorArray.length) {
            if (dataFlavorArray[n].equals(dataFlavor)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    void lostSelectionOwnership() {
        this.holder.lostSelectionOwnership();
        this.holder = null;
        this.contents = null;
    }

    native void pDispose();

    native boolean pGetSelectionOwnership();

    native void pGetTransferData(int[] var1);

    native void pGetTransferTargets();

    static native void registerTargetForFlavor(DataFlavor var0, String var1);
}

