/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.robot;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.Random;
import java.util.StringTokenizer;
import sun.awt.robot.Robot;
import sun.awt.robot.RobotPeer;
import sun.awt.robot.probe.EventProbe;
import sun.awt.robot.probe.ProbeBuffer;
import sun.awt.robot.probe.ProbeMonitor;
import sun.awt.robot.probe.ProbeObject;
import sun.awt.robot.probe.ProbePrinter;
import sun.awt.robot.probe.WrapComponent;

public class ProbeRobot {
    private static final int MAX_DELAY = 5000;
    private Robot robot;
    private RobotPeer peer;
    private Random generator;
    public ProbeMonitor monitor;
    public EventProbe evProbe;
    public ProbeBuffer buffer;
    public WrapComponent wrapper;
    public ProbePrinter printer;
    public int defaultWait = 0;
    public int defaultSpeed = 20;
    public short defaultButton = 1;

    public ProbeRobot(Robot robot) {
        this.robot = robot;
        this.peer = robot.getPeer();
        this.generator = new Random();
        if (robot != null) {
            this.monitor = new ProbeMonitor();
            this.monitor.dispatch = true;
            this.evProbe = new EventProbe(this.monitor);
            this.buffer = new ProbeBuffer(this.monitor);
            this.printer = new ProbePrinter(this.monitor, false);
            this.wrapper = new WrapComponent(this.monitor);
        } else {
            this.monitor = null;
            this.evProbe = null;
            this.buffer = null;
            this.printer = null;
            this.wrapper = null;
        }
    }

    public void awtEventsQuiet() {
        if (this.evProbe != null) {
            this.evProbe.disconnect();
        }
    }

    public void awtEventsVerbose() {
        if (this.evProbe != null) {
            this.evProbe.connect();
        }
    }

    public void buttonPress() {
        this.buttonPress(this.defaultWait, this.defaultButton);
    }

    public void buttonPress(int n) {
        this.buttonPress(n, this.defaultButton);
    }

    public void buttonPress(int n, short s) {
        this.robot.mousePress(this.mouseButton(s));
        this.pause(n);
    }

    public void buttonPress(short s) {
        this.buttonPress(this.defaultWait, s);
    }

    public void buttonPresser(boolean bl, boolean bl2, boolean bl3) {
        long l = 0L;
        l |= (long)(bl ? this.mouseButton(1) : 0);
        l |= (long)(bl2 ? this.mouseButton(2) : 0);
        this.mousePress(l |= (long)(bl3 ? this.mouseButton(3) : 0));
    }

    public void buttonRelease() {
        this.buttonRelease(this.defaultWait, this.defaultButton);
    }

    public void buttonRelease(int n) {
        this.buttonRelease(n, this.defaultButton);
    }

    public void buttonRelease(int n, short s) {
        this.robot.mouseRelease(this.mouseButton(s));
        this.pause(n);
    }

    public void buttonRelease(short s) {
        this.buttonRelease(this.defaultWait, s);
    }

    public void buttonReleaser(boolean bl, boolean bl2, boolean bl3) {
        long l = 0L;
        l |= (long)(bl ? this.mouseButton(1) : 0);
        l |= (long)(bl2 ? this.mouseButton(2) : 0);
        this.mouseRelease(l |= (long)(bl3 ? this.mouseButton(3) : 0));
    }

    public void click() {
        this.click(this.defaultSpeed, this.defaultButton);
    }

    public void click(int n, int n2, short s) {
        this.buttonPress(n, s);
        this.buttonRelease(n2, s);
    }

    public void click(int n, short s) {
        this.buttonPress(this.defaultWait, s);
        this.buttonRelease(n, s);
    }

    public void click(short s) {
        this.click(this.defaultSpeed, s);
    }

    public void doCommand(String string) {
        String string2;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        try {
            string2 = stringTokenizer.nextToken();
        }
        catch (Exception exception) {
            System.err.println("Could not get command in " + string);
            System.err.println(exception);
            return;
        }
        if (string2.equals("move")) {
            try {
                Integer n = new Integer(stringTokenizer.nextToken());
                Integer n2 = new Integer(stringTokenizer.nextToken());
                this.mouseMove((int)n, n2);
            }
            catch (Exception exception) {
                System.err.println("USAGE: move x y");
                System.err.println(exception);
            }
            return;
        }
        if (string2.equals("print")) {
            try {
                this.printerStart();
            }
            catch (Exception exception) {
                System.err.println("USAGE: print");
                System.err.println(exception);
            }
            return;
        }
        if (string2.equals("noprint")) {
            try {
                this.printerStop();
            }
            catch (Exception exception) {
                System.err.println("USAGE: noprint");
                System.err.println(exception);
            }
            return;
        }
        if (string2.equals("setspeed")) {
            try {
                this.defaultSpeed = new Integer(stringTokenizer.nextToken());
            }
            catch (Exception exception) {
                System.err.println("USAGE: setspeed newspeed");
                System.err.println(exception);
            }
            return;
        }
        if (string2.equals("setwait")) {
            try {
                this.defaultWait = new Integer(stringTokenizer.nextToken());
            }
            catch (Exception exception) {
                System.err.println("USAGE: setwait newwait");
                System.err.println(exception);
            }
            return;
        }
        if (string2.equals("bpress")) {
            try {
                Integer n = new Integer(stringTokenizer.nextToken());
                this.buttonPress(n);
            }
            catch (Exception exception) {
                System.err.println("USAGE: bpress button");
                System.err.println(exception);
            }
            return;
        }
        if (string2.equals("brelease")) {
            try {
                Integer n = new Integer(stringTokenizer.nextToken());
                this.buttonRelease(n);
            }
            catch (Exception exception) {
                System.err.println("USAGE: brelease button");
                System.err.println(exception);
            }
            return;
        }
        if (string2.equals("click")) {
            try {
                Integer n = new Integer(stringTokenizer.nextToken());
                this.click((short)n.intValue());
            }
            catch (Exception exception) {
                System.err.println("USAGE: click button");
                System.err.println(exception);
            }
            return;
        }
        if (string2.equals("glide")) {
            try {
                Integer n = new Integer(stringTokenizer.nextToken());
                Integer n3 = new Integer(stringTokenizer.nextToken());
                Integer n4 = new Integer(stringTokenizer.nextToken());
                Integer n5 = new Integer(stringTokenizer.nextToken());
                Integer n6 = new Integer(stringTokenizer.nextToken());
                this.glide(new Point(n, n3), new Point(n4, n5), (short)n6.intValue(), this.defaultSpeed);
            }
            catch (Exception exception) {
                System.err.println("USAGE: glide x1 y1 x2 y2 nSteps");
                System.err.println(exception);
            }
            return;
        }
    }

    public RobotPeer getPeer() {
        return this.peer;
    }

    public Color getPixelColor(int n, int n2) {
        return this.robot.getPixelColor(n, n2);
    }

    public void glide(Point point, Point point2) {
        this.glide(point, point2, (short)10, this.defaultSpeed);
    }

    public void glide(Point point, Point point2, short s) {
        this.glide(point, point2, s, this.defaultSpeed);
    }

    public void glide(Point point, Point point2, short n, int n2) {
        double d = point2.x - point.x;
        double d2 = point2.y - point.y;
        double d3 = d / (double)n;
        double d4 = d2 / (double)n;
        this.mouseMove(n2, point);
        double d5 = point.x;
        double d6 = point.y;
        Point point3 = new Point();
        int n3 = 0;
        while (n3 < n) {
            point3.x = (int)(d5 += d3);
            point3.y = (int)(d6 += d4);
            this.mouseMove(n2, point3);
            ++n3;
        }
        this.mouseMove(n2, point2);
    }

    public void keyPress(int n) {
        this.keyPress(this.defaultWait, n);
    }

    public void keyPress(int n, int n2) {
        this.robot.keyPress(n2);
        this.pause(n);
    }

    public void keyRelease(int n) {
        this.keyRelease(this.defaultWait, n);
    }

    public void keyRelease(int n, int n2) {
        this.robot.keyPress(n2);
        this.pause(n);
    }

    public void monitorPost(ProbeObject probeObject) {
        if (this.monitor != null) {
            this.monitor.post(probeObject);
        }
    }

    private int mouseButton(int n) {
        return this.mouseButton((short)n);
    }

    private int mouseButton(short s) {
        switch (s) {
            case 1: {
                return 16;
            }
            case 2: {
                return 8;
            }
            case 3: {
                return 4;
            }
        }
        return 0;
    }

    public void mouseMove(int n, int n2) {
        this.mouseMove(this.defaultWait, n, n2);
    }

    public void mouseMove(int n, int n2, int n3) {
        this.robot.mouseMove(n2, n3);
        this.pause(n);
    }

    public void mouseMove(int n, Point point) {
        this.mouseMove(n, point.x, point.y);
    }

    public void mouseMove(Point point) {
        this.mouseMove(this.defaultWait, point.x, point.y);
    }

    public void mousePress(long l) {
        this.robot.mousePress(l);
        this.pause(this.defaultWait);
    }

    public void mouseRelease(long l) {
        this.robot.mouseRelease(l);
        this.pause(this.defaultWait);
    }

    public void pause() {
        this.pause(this.defaultWait);
    }

    public void pause(int n) {
        this.robot.delay(n);
    }

    public void pressAlt() {
        this.keyPress(this.defaultWait, 18);
    }

    public void pressAltGraph() {
        this.keyPress(this.defaultWait, 65406);
    }

    public void pressCapsLock() {
        this.keyPress(this.defaultWait, 20);
    }

    public void pressControl() {
        this.keyPress(this.defaultWait, 17);
    }

    public void pressMeta() {
        this.keyPress(this.defaultWait, 157);
    }

    public void pressShift() {
        this.keyPress(this.defaultWait, 16);
    }

    public void printerOutput(PrintStream printStream) {
        this.printer.setOutput(printStream);
    }

    public void printerStart() {
        if (this.printer != null) {
            this.printer.startPrinting();
        }
    }

    public void printerStop() {
        if (this.printer != null) {
            this.printer.stopPrinting();
        }
    }

    public void processInput(InputStream inputStream) {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        String string = null;
        try {
            while ((string = bufferedReader.readLine()) != null) {
                this.doCommand(string);
            }
        }
        catch (Exception exception) {
            System.err.println("Error in command loop ... exiting ");
            exception.printStackTrace();
        }
    }

    public void recorderClear() {
        if (this.buffer != null) {
            this.buffer.clear();
        }
    }

    public ProbeObject recorderElement(int n) {
        if (this.buffer != null) {
            return this.buffer.elementAt(n);
        }
        return null;
    }

    public Iterator recorderIterator() {
        if (this.buffer != null) {
            return this.buffer.listIterator();
        }
        return null;
    }

    public int recorderSize() {
        if (this.buffer != null) {
            return this.buffer.size();
        }
        return -1;
    }

    public void recorderStart() {
        if (this.buffer != null) {
            this.buffer.startRecording();
        }
    }

    public void recorderStop() {
        if (this.buffer != null) {
            this.buffer.stopRecording();
        }
    }

    public void releaseAlt() {
        this.keyRelease(this.defaultWait, 18);
    }

    public void releaseAltGraph() {
        this.keyRelease(this.defaultWait, 65406);
    }

    public void releaseCapsLock() {
        this.keyRelease(this.defaultSpeed, 20);
    }

    public void releaseControl() {
        this.keyRelease(this.defaultWait, 17);
    }

    public void releaseMeta() {
        this.keyRelease(this.defaultWait, 157);
    }

    public void releaseShift() {
        this.keyRelease(this.defaultWait, 16);
    }

    public Point targetCenter(Component component) {
        int n = component.getWidth();
        int n2 = component.getHeight();
        Point point = component.getLocationOnScreen();
        point.x += n / 2;
        point.y += n2 / 2;
        return point;
    }

    public Point targetOrigin(Component component) {
        return component.getLocationOnScreen();
    }

    public void type(int n) {
        this.keyPress(this.defaultWait, n);
        this.keyRelease(this.defaultSpeed, n);
    }

    public void type(int n, int n2) {
        this.keyPress(this.defaultWait, n2);
        this.keyRelease(n, n2);
    }

    public void type(int n, int n2, int n3) {
        this.keyPress(n, n3);
        this.keyRelease(n2, n3);
    }

    public void type(String string) {
        int n = 0;
        while (n < string.length()) {
            if (Character.isLowerCase(string.charAt(n))) {
                this.type(Character.getNumericValue(string.charAt(n)) + 55);
            } else {
                this.keyPress(16);
                this.type(Character.getNumericValue(string.charAt(n)) + 55);
                this.keyRelease(16);
            }
            ++n;
        }
    }

    public void type(int[] nArray) {
        int n = nArray.length;
        int n2 = 0;
        n2 = 0;
        while (n2 < n) {
            this.type(nArray[n2]);
            ++n2;
        }
    }

    public void type(int[][] nArray) {
        int n = nArray.length;
        int n2 = 0;
        n2 = 0;
        while (n2 < n) {
            this.type(nArray[n2][0], nArray[n2][1], nArray[n2][2]);
            ++n2;
        }
    }

    public void unwrap(Component component) {
        if (this.wrapper != null) {
            this.wrapper.unwrap(component);
        }
    }

    public void unwrap(Container container) {
        if (this.wrapper != null) {
            this.wrapper.unwrap(container);
        }
    }

    public void walkDrunkenMouse(int[][] nArray, int n) {
        int n2 = nArray.length;
        int n3 = 0;
        while (n3 < n) {
            int n4 = this.generator.nextInt(n2);
            this.mouseMove(nArray[n4][0], nArray[n4][1]);
            ++n3;
        }
    }

    public void walkMouse(int[][] nArray) {
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            this.mouseMove(nArray[n2][0], nArray[n2][1]);
            ++n2;
        }
    }

    public void wiggle(Point point, Point point2, Point point3, int n, int n2) {
        int n3 = 0;
        this.mouseMove(n2, point);
        while (n3 < n) {
            this.mouseMove(n2, point2);
            this.mouseMove(n2, point3);
            ++n3;
        }
        this.mouseMove(n2, point);
    }

    public void wrap(Component component) {
        if (this.wrapper != null) {
            this.wrapper.wrap(component);
        }
    }

    public void wrap(Container container) {
        if (this.wrapper != null) {
            this.wrapper.wrap(container);
        }
    }
}

