/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d;

import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.awt.print.PrinterGraphics;
import java.awt.print.PrinterJob;
import java.text.AttributedCharacterIterator;
import java.util.Map;
import sun.java2d.PeekMetrics;
import sun.java2d.Spans;

public class PeekGraphics
extends Graphics2D
implements PrinterGraphics,
ImageObserver,
Cloneable {
    Graphics2D mGraphics;
    PrinterJob mPrinterJob;
    private Spans mDrawingArea = new Spans();
    private PeekMetrics mPrintMetrics = new PeekMetrics();

    public PeekGraphics(Graphics2D graphics2D, PrinterJob printerJob) {
        this.mGraphics = graphics2D;
        this.mPrinterJob = printerJob;
    }

    private void addDrawingRect(float f, float f2, float f3, float f4) {
        Rectangle2D.Float float_ = new Rectangle2D.Float(f, f2, f3, f4);
        this.addDrawingRect(float_);
    }

    private void addDrawingRect(Rectangle2D rectangle2D) {
        Rectangle rectangle = this.mGraphics.getClipBounds();
        Rectangle2D rectangle2D2 = ((Rectangle2D)rectangle).createIntersection(rectangle2D);
        AffineTransform affineTransform = this.getTransform();
        Shape shape = affineTransform.createTransformedShape(rectangle2D);
        Rectangle2D rectangle2D3 = shape.getBounds2D();
        this.mDrawingArea.add((float)rectangle2D3.getMinY(), (float)rectangle2D3.getMaxY());
    }

    private void addDrawingRect(Rectangle2D rectangle2D, float f, float f2) {
        this.addDrawingRect((float)(rectangle2D.getX() + (double)f), (float)(rectangle2D.getY() + (double)f2), (float)rectangle2D.getWidth(), (float)rectangle2D.getHeight());
    }

    public void addRenderingHints(Map map) {
        this.mGraphics.addRenderingHints(map);
    }

    private void addStrokeShape(Shape shape) {
        Shape shape2 = this.getStroke().createStrokedShape(shape);
        this.addDrawingRect(shape2.getBounds2D());
    }

    public void clearRect(int n, int n2, int n3, int n4) {
        Rectangle2D.Float float_ = new Rectangle2D.Float(n, n2, n3, n4);
        this.addDrawingRect(float_);
        this.mPrintMetrics.clear(this);
    }

    public void clip(Shape shape) {
        this.mGraphics.clip(shape);
    }

    public void clipRect(int n, int n2, int n3, int n4) {
        this.mGraphics.clipRect(n, n2, n3, n4);
    }

    public void copyArea(int n, int n2, int n3, int n4, int n5, int n6) {
    }

    public Graphics create() {
        PeekGraphics peekGraphics = null;
        try {
            peekGraphics = (PeekGraphics)this.clone();
            peekGraphics.mGraphics = (Graphics2D)this.mGraphics.create();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        return peekGraphics;
    }

    public void dispose() {
        this.mGraphics.dispose();
    }

    public void draw(Shape shape) {
        this.addStrokeShape(shape);
        this.mPrintMetrics.draw(this);
    }

    public void drawArc(int n, int n2, int n3, int n4, int n5, int n6) {
        this.addStrokeShape(new Rectangle2D.Float(n, n2, n3, n4));
        this.mPrintMetrics.draw(this);
    }

    public void drawGlyphVector(GlyphVector glyphVector, float f, float f2) {
        Rectangle2D rectangle2D = glyphVector.getLogicalBounds();
        this.addDrawingRect(rectangle2D, f, f2);
        this.mPrintMetrics.drawText(this);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Color color, ImageObserver imageObserver) {
        int n9 = n3 - n;
        int n10 = n4 - n2;
        this.addDrawingRect(n, n2, n9, n10);
        this.mPrintMetrics.drawImage((Graphics2D)this, image);
        return this.mGraphics.drawImage(image, n, n2, n3, n4, n5, n6, n7, n8, color, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, ImageObserver imageObserver) {
        int n9 = n3 - n;
        int n10 = n4 - n2;
        this.addDrawingRect(n, n2, n9, n10);
        this.mPrintMetrics.drawImage((Graphics2D)this, image);
        return this.mGraphics.drawImage(image, n, n2, n3, n4, n5, n6, n7, n8, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, Color color, ImageObserver imageObserver) {
        this.addDrawingRect(n, n2, n3, n4);
        this.mPrintMetrics.drawImage((Graphics2D)this, image);
        return this.mGraphics.drawImage(image, n, n2, n3, n4, color, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, ImageObserver imageObserver) {
        this.addDrawingRect(n, n2, n3, n4);
        this.mPrintMetrics.drawImage((Graphics2D)this, image);
        return this.mGraphics.drawImage(image, n, n2, n3, n4, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, Color color, ImageObserver imageObserver) {
        ImageWaiter imageWaiter = new ImageWaiter(image);
        this.addDrawingRect(n, n2, imageWaiter.getWidth(), imageWaiter.getHeight());
        this.mPrintMetrics.drawImage((Graphics2D)this, image);
        return this.mGraphics.drawImage(image, n, n2, color, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, ImageObserver imageObserver) {
        ImageWaiter imageWaiter = new ImageWaiter(image);
        this.addDrawingRect(n, n2, imageWaiter.getWidth(), imageWaiter.getHeight());
        this.mPrintMetrics.drawImage((Graphics2D)this, image);
        return this.mGraphics.drawImage(image, n, n2, imageObserver);
    }

    public boolean drawImage(Image image, AffineTransform affineTransform, ImageObserver imageObserver) {
        this.mDrawingArea.addInfinite();
        this.mPrintMetrics.drawImage((Graphics2D)this, image);
        return this.mGraphics.drawImage(image, affineTransform, imageObserver);
    }

    public void drawImage(BufferedImage bufferedImage, BufferedImageOp bufferedImageOp, int n, int n2) {
        this.mPrintMetrics.drawImage((Graphics2D)this, (RenderableImage)((Object)bufferedImage));
        this.mDrawingArea.addInfinite();
    }

    public void drawLine(int n, int n2, int n3, int n4) {
        this.addStrokeShape(new Line2D.Float(n, n2, n3, n4));
        this.mPrintMetrics.draw(this);
    }

    public void drawOval(int n, int n2, int n3, int n4) {
        this.addStrokeShape(new Rectangle2D.Float(n, n2, n3, n4));
        this.mPrintMetrics.draw(this);
    }

    public void drawPolygon(int[] nArray, int[] nArray2, int n) {
        if (n > 0) {
            this.drawPolyline(nArray, nArray2, n);
            this.drawLine(nArray[n - 1], nArray2[n - 1], nArray[0], nArray2[0]);
        }
    }

    public void drawPolyline(int[] nArray, int[] nArray2, int n) {
        if (n > 0) {
            int n2 = nArray[0];
            int n3 = nArray2[0];
            int n4 = 1;
            while (n4 < n) {
                this.drawLine(n2, n3, nArray[n4], nArray2[n4]);
                n2 = nArray[n4];
                n3 = nArray2[n4];
                ++n4;
            }
        }
    }

    public void drawRenderableImage(RenderableImage renderableImage, AffineTransform affineTransform) {
        this.mPrintMetrics.drawImage((Graphics2D)this, renderableImage);
        this.mDrawingArea.addInfinite();
    }

    public void drawRenderedImage(RenderedImage renderedImage, AffineTransform affineTransform) {
        this.mPrintMetrics.drawImage((Graphics2D)this, renderedImage);
        this.mDrawingArea.addInfinite();
    }

    public void drawRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        this.addStrokeShape(new RoundRectangle2D.Float(n, n2, n3, n4, n5, n6));
        this.mPrintMetrics.draw(this);
    }

    public void drawString(String string, float f, float f2) {
        this.drawTextLayout(new TextLayout(string, this.getFont(), this.getFontRenderContext()), f, f2);
    }

    public void drawString(String string, int n, int n2) {
        this.drawTextLayout(new TextLayout(string, this.getFont(), this.getFontRenderContext()), n, n2);
    }

    public void drawString(AttributedCharacterIterator attributedCharacterIterator, float f, float f2) {
        this.drawTextLayout(new TextLayout(attributedCharacterIterator, this.getFontRenderContext()), f, f2);
    }

    public void drawString(AttributedCharacterIterator attributedCharacterIterator, int n, int n2) {
        this.drawTextLayout(new TextLayout(attributedCharacterIterator, this.getFontRenderContext()), n, n2);
    }

    void drawTextLayout(TextLayout textLayout, float f, float f2) {
        this.addDrawingRect(textLayout.getBounds(), f, f2);
        this.mPrintMetrics.drawText(this, textLayout);
    }

    public void fill(Shape shape) {
        this.addDrawingRect(shape.getBounds());
        this.mPrintMetrics.fill(this);
    }

    public void fillArc(int n, int n2, int n3, int n4, int n5, int n6) {
        Rectangle2D.Float float_ = new Rectangle2D.Float(n, n2, n3, n4);
        this.addDrawingRect(float_);
        this.mPrintMetrics.fill(this);
    }

    public void fillOval(int n, int n2, int n3, int n4) {
        Rectangle2D.Float float_ = new Rectangle2D.Float(n, n2, n3, n4);
        this.addDrawingRect(float_);
        this.mPrintMetrics.fill(this);
    }

    public void fillPolygon(int[] nArray, int[] nArray2, int n) {
        if (n > 0) {
            int n2 = nArray[0];
            int n3 = nArray2[0];
            int n4 = nArray[0];
            int n5 = nArray2[0];
            int n6 = 1;
            while (n6 < n) {
                if (nArray[n6] < n2) {
                    n2 = nArray[n6];
                } else if (nArray[n6] > n4) {
                    n4 = nArray[n6];
                }
                if (nArray2[n6] < n3) {
                    n3 = nArray2[n6];
                } else if (nArray2[n6] > n5) {
                    n5 = nArray2[n6];
                }
                ++n6;
            }
            this.addDrawingRect(n2, n3, n4 - n2, n5 - n3);
        }
        this.mPrintMetrics.fill(this);
    }

    public void fillRect(int n, int n2, int n3, int n4) {
        this.addDrawingRect(new Rectangle2D.Float(n, n2, n3, n4));
        this.mPrintMetrics.fill(this);
    }

    public void fillRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        Rectangle2D.Float float_ = new Rectangle2D.Float(n, n2, n3, n4);
        this.addDrawingRect(float_);
        this.mPrintMetrics.fill(this);
    }

    public Color getBackground() {
        return this.mGraphics.getBackground();
    }

    public Shape getClip() {
        return this.mGraphics.getClip();
    }

    public Rectangle getClipBounds() {
        return this.mGraphics.getClipBounds();
    }

    public Color getColor() {
        return this.mGraphics.getColor();
    }

    public Composite getComposite() {
        return this.mGraphics.getComposite();
    }

    public Graphics2D getDelegate() {
        return this.mGraphics;
    }

    public GraphicsConfiguration getDeviceConfiguration() {
        return this.mGraphics.getDeviceConfiguration();
    }

    public Spans getDrawingArea() {
        return this.mDrawingArea;
    }

    public Font getFont() {
        return this.mGraphics.getFont();
    }

    public FontMetrics getFontMetrics(Font font) {
        return this.mGraphics.getFontMetrics(font);
    }

    public FontRenderContext getFontRenderContext() {
        return this.mGraphics.getFontRenderContext();
    }

    private synchronized int getImageHeight(Image image) {
        while (image.getHeight(this) == -1) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        return image.getHeight(this);
    }

    private synchronized int getImageWidth(Image image) {
        while (image.getWidth(this) == -1) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        return image.getWidth(this);
    }

    public PeekMetrics getMetrics() {
        return this.mPrintMetrics;
    }

    public Paint getPaint() {
        return this.mGraphics.getPaint();
    }

    public PrinterJob getPrinterJob() {
        return this.mPrinterJob;
    }

    public Object getRenderingHint(RenderingHints.Key key) {
        return this.mGraphics.getRenderingHint(key);
    }

    public RenderingHints getRenderingHints() {
        return this.mGraphics.getRenderingHints();
    }

    public Stroke getStroke() {
        return this.mGraphics.getStroke();
    }

    public AffineTransform getTransform() {
        return this.mGraphics.getTransform();
    }

    public boolean hit(Rectangle rectangle, Shape shape, boolean bl) {
        return this.mGraphics.hit(rectangle, shape, bl);
    }

    public boolean hitsDrawingArea(Rectangle rectangle) {
        return this.mDrawingArea.intersects((float)rectangle.getMinY(), (float)rectangle.getMaxY());
    }

    public synchronized boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        boolean bl = false;
        if ((n & 3) != 0) {
            bl = true;
            this.notify();
        }
        return bl;
    }

    public void rotate(double d) {
        this.mGraphics.rotate(d);
    }

    public void rotate(double d, double d2, double d3) {
        this.mGraphics.rotate(d, d2, d3);
    }

    public void scale(double d, double d2) {
        this.mGraphics.scale(d, d2);
    }

    public void setBackground(Color color) {
        this.mGraphics.setBackground(color);
    }

    public void setClip(int n, int n2, int n3, int n4) {
        this.mGraphics.setClip(n, n2, n3, n4);
    }

    public void setClip(Shape shape) {
        this.mGraphics.setClip(shape);
    }

    public void setColor(Color color) {
        this.mGraphics.setColor(color);
    }

    public void setComposite(Composite composite) {
        this.mGraphics.setComposite(composite);
    }

    public void setDelegate(Graphics2D graphics2D) {
        this.mGraphics = graphics2D;
    }

    public void setFont(Font font) {
        this.mGraphics.setFont(font);
    }

    public void setPaint(Paint paint) {
        this.mGraphics.setPaint(paint);
    }

    public void setPaintMode() {
        this.mGraphics.setPaintMode();
    }

    public void setRenderingHint(RenderingHints.Key key, Object object) {
        this.mGraphics.setRenderingHint(key, object);
    }

    public void setRenderingHints(Map map) {
        this.mGraphics.setRenderingHints(map);
    }

    public void setStroke(Stroke stroke) {
        this.mGraphics.setStroke(stroke);
    }

    public void setTransform(AffineTransform affineTransform) {
        this.mGraphics.setTransform(affineTransform);
    }

    public void setXORMode(Color color) {
        this.mGraphics.setXORMode(color);
    }

    public void shear(double d, double d2) {
        this.mGraphics.shear(d, d2);
    }

    public void transform(AffineTransform affineTransform) {
        this.mGraphics.transform(affineTransform);
    }

    public void translate(double d, double d2) {
        this.mGraphics.translate(d, d2);
    }

    public void translate(int n, int n2) {
        this.mGraphics.translate(n, n2);
    }

    protected class ImageWaiter
    implements ImageObserver {
        private int mWidth;
        private int mHeight;

        ImageWaiter(Image image) {
            this.waitForDimensions(image);
        }

        public int getHeight() {
            return this.mHeight;
        }

        public int getWidth() {
            return this.mWidth;
        }

        public synchronized boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
            boolean bl;
            boolean bl2 = bl = (n & 0xC2) != 0;
            if (bl) {
                this.notify();
            }
            return bl;
        }

        private synchronized void waitForDimensions(Image image) {
            this.mHeight = image.getHeight(null);
            this.mWidth = image.getWidth(null);
            if (this.mWidth < 0 || this.mHeight < 0) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
                this.mHeight = image.getHeight(null);
                this.mWidth = image.getWidth(null);
            }
        }
    }
}

