/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterAbortException;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import sun.awt.image.IntegerComponentRaster;
import sun.java2d.OpenBook;
import sun.java2d.PeekGraphics;
import sun.java2d.ProxyGraphics2D;

public abstract class RasterPrinterJob
extends PrinterJob {
    private static final int MAX_BAND_SIZE = 524288;
    private int mNumCopies = 1;
    private boolean mCollate = false;
    private int mFirstPage = -1;
    private int mLastPage = -1;
    private Pageable mDocument = new Book();
    private String mDocName = new String("");

    public void cancel() {
    }

    protected Graphics2D createPathGraphics(PeekGraphics peekGraphics, PrinterJob printerJob, Printable printable, PageFormat pageFormat, int n) {
        return null;
    }

    protected PeekGraphics createPeekGraphics(Graphics2D graphics2D, PrinterJob printerJob) {
        return new PeekGraphics(graphics2D, printerJob);
    }

    public PageFormat defaultPage(PageFormat pageFormat) {
        return pageFormat;
    }

    protected abstract void endDoc() throws PrinterException;

    protected abstract void endPage(PageFormat var1, Printable var2, int var3) throws PrinterException;

    protected int getCollatedCopies() {
        return this.isCollated() ? this.getCopies() : 1;
    }

    public int getCopies() {
        return this.mNumCopies;
    }

    protected int getFirstPage() {
        return this.mFirstPage == -1 ? 0 : this.mFirstPage;
    }

    public String getJobName() {
        return this.mDocName;
    }

    protected int getLastPage() {
        return this.mLastPage;
    }

    protected int getNoncollatedCopies() {
        return this.isCollated() ? 1 : this.getCopies();
    }

    protected Pageable getPageable() {
        return this.mDocument;
    }

    public String getUserName() {
        return System.getProperty("user.name");
    }

    protected abstract double getXRes();

    protected abstract double getYRes();

    void initPrinterGraphics(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        graphics2D.setClip(rectangle2D);
        graphics2D.setPaint(Color.black);
    }

    public boolean isCancelled() {
        return false;
    }

    protected boolean isCollated() {
        return this.mCollate;
    }

    public void print() throws PrinterException {
        int n;
        int n2 = this.getCollatedCopies();
        int n3 = this.getNoncollatedCopies();
        int n4 = this.mDocument.getNumberOfPages();
        int n5 = this.getFirstPage();
        int n6 = this.getLastPage();
        if (n6 == -1 && (n = this.mDocument.getNumberOfPages()) != -1) {
            n6 = this.mDocument.getNumberOfPages() - 1;
        }
        try {
            this.startDoc();
            if (this.isCancelled()) {
                throw new PrinterAbortException();
            }
            int n7 = 0;
            while (n7 < n2) {
                int n8 = n5;
                int n9 = 0;
                while ((n8 <= n6 || n6 == -1) && n9 == 0) {
                    int n10 = 0;
                    while (n10 < n3 && n9 == 0) {
                        if (this.isCancelled()) {
                            throw new PrinterAbortException();
                        }
                        n9 = this.printPage(this.mDocument, n8);
                        ++n10;
                    }
                    ++n8;
                }
                ++n7;
            }
            if (this.isCancelled()) {
                throw new PrinterAbortException();
            }
            Object var7_12 = null;
        }
        catch (Throwable throwable) {
            Object var7_13 = null;
            this.endDoc();
            throw throwable;
        }
        this.endDoc();
    }

    protected abstract void printBand(int[] var1, int var2, int var3, int var4, int var5) throws PrinterException;

    protected int printPage(Pageable pageable, int n) throws PrinterException {
        PageFormat pageFormat = pageable.getPageFormat(n);
        Printable printable = pageable.getPrintable(n);
        Paper paper = pageFormat.getPaper();
        double d = this.getXRes() / 72.0;
        double d2 = this.getYRes() / 72.0;
        Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, paper.getImageableWidth() * d, paper.getImageableHeight() * d2);
        AffineTransform affineTransform = new AffineTransform();
        AffineTransform affineTransform2 = new AffineTransform();
        affineTransform2.scale(d, d2);
        int n2 = (int)((RectangularShape)double_).getWidth();
        int n3 = (int)((RectangularShape)double_).getHeight();
        int n4 = 524288 / n3 / 4;
        int n5 = (int)(paper.getImageableX() * d);
        int n6 = (int)(paper.getImageableY() * d2);
        AffineTransform affineTransform3 = new AffineTransform();
        affineTransform3.translate(-n5, n6);
        affineTransform3.translate(0.0, n4);
        affineTransform3.scale(1.0, -1.0);
        BufferedImage bufferedImage = new BufferedImage(n2, n4, 1);
        PeekGraphics peekGraphics = this.createPeekGraphics(bufferedImage.createGraphics(), this);
        Rectangle2D.Double double_2 = new Rectangle2D.Double(pageFormat.getImageableX(), pageFormat.getImageableY(), pageFormat.getImageableWidth(), pageFormat.getImageableHeight());
        this.initPrinterGraphics(peekGraphics, double_2);
        int n7 = printable.print(peekGraphics, pageFormat, n);
        if (n7 == 0) {
            this.startPage(pageFormat, printable, n);
            Graphics2D graphics2D = this.createPathGraphics(peekGraphics, this, printable, pageFormat, n);
            if (graphics2D != null) {
                graphics2D.transform(affineTransform2);
                graphics2D.transform(new AffineTransform(pageFormat.getMatrix()));
                this.initPrinterGraphics(graphics2D, double_2);
                printable.print(graphics2D, pageFormat, n);
            } else {
                Graphics2D graphics2D2 = bufferedImage.createGraphics();
                Rectangle2D.Double double_3 = new Rectangle2D.Double(0.0, 0.0, n2, n4);
                this.initPrinterGraphics(graphics2D2, double_3);
                ProxyGraphics2D proxyGraphics2D = new ProxyGraphics2D(graphics2D2, this);
                Graphics2D graphics2D3 = bufferedImage.createGraphics();
                graphics2D3.setColor(Color.white);
                IntegerComponentRaster integerComponentRaster = (IntegerComponentRaster)bufferedImage.getRaster();
                int[] nArray = integerComponentRaster.getDataStorage();
                int n8 = n6 + n3;
                int n9 = 0;
                while (n9 <= n3) {
                    graphics2D3.fillRect(0, 0, n2, n4);
                    graphics2D2.setTransform(affineTransform);
                    graphics2D2.transform(affineTransform3);
                    affineTransform3.translate(0.0, -n4);
                    graphics2D2.transform(affineTransform2);
                    graphics2D2.transform(new AffineTransform(pageFormat.getMatrix()));
                    Rectangle rectangle = graphics2D2.getClipBounds();
                    if (peekGraphics.hitsDrawingArea(rectangle)) {
                        proxyGraphics2D.setDelegate((Graphics2D)graphics2D2.create());
                        printable.print(proxyGraphics2D, pageFormat, n);
                        proxyGraphics2D.dispose();
                        this.printBand(nArray, n5, n6 + n9, n2, n4);
                    }
                    n9 += n4;
                }
                graphics2D3.dispose();
                graphics2D2.dispose();
            }
            this.endPage(pageFormat, printable, n);
        }
        return n7;
    }

    protected void setCollated(boolean bl) {
        this.mCollate = bl;
    }

    public void setCopies(int n) {
        this.mNumCopies = n;
    }

    public void setJobName(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        this.mDocName = string;
    }

    protected void setPageRange(int n, int n2) {
        if (n >= 0 && n2 >= 0) {
            this.mFirstPage = n;
            this.mLastPage = n2;
            if (this.mLastPage < this.mFirstPage) {
                this.mLastPage = this.mFirstPage;
            }
        } else {
            this.mFirstPage = -1;
            this.mLastPage = -1;
        }
    }

    public void setPageable(Pageable pageable) throws NullPointerException {
        if (pageable == null) {
            throw new NullPointerException();
        }
        this.mDocument = pageable;
    }

    public void setPrintable(Printable printable) {
        this.setPageable(new OpenBook(this.defaultPage(new PageFormat()), printable));
    }

    public void setPrintable(Printable printable, PageFormat pageFormat) {
        this.setPageable(new OpenBook(pageFormat, printable));
    }

    protected abstract void startDoc() throws PrinterException;

    protected abstract void startPage(PageFormat var1, Printable var2, int var3) throws PrinterException;

    public PageFormat validatePage(PageFormat pageFormat) {
        return pageFormat;
    }
}

