/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d;

import java.awt.AWTPermission;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.awt.image.renderable.RenderContext;
import java.awt.image.renderable.RenderableImage;
import java.security.Permission;
import java.text.AttributedCharacterIterator;
import java.util.Iterator;
import java.util.Map;
import sun.awt.ConstrainableGraphics;
import sun.awt.SunHints;
import sun.awt.font.FontDesignMetrics;
import sun.awt.font.NativeFontWrapper;
import sun.awt.font.ShapingException;
import sun.java2d.OutputManager;
import sun.java2d.loops.ImageData;
import sun.java2d.loops.RasterOutputManager;
import sun.java2d.loops.XORComposite;
import sun.java2d.pipe.CompositePipe;
import sun.java2d.pipe.PixelDrawPipe;
import sun.java2d.pipe.PixelFillPipe;
import sun.java2d.pipe.Region;
import sun.java2d.pipe.RegionIterator;
import sun.java2d.pipe.ShapeDrawPipe;
import sun.java2d.pipe.ShapeSpanIterator;
import sun.java2d.pipe.TextPipe;
import sun.java2d.pipe.ValidatePipe;

public abstract class SunGraphics2D
extends Graphics2D
implements ConstrainableGraphics,
Cloneable {
    public static final ColorModel XRGBModel = new DirectColorModel(24, 0xFF0000, 65280, 255);
    public static final int LOCK_OK = 1;
    public static final int UNLOCK_OK = 2;
    public static final int LOCK_FORMAT_PROBLEM = 3;
    public static final int LOCK_GEOMETRY_PROBLEM = 4;
    public static final int LOCK_DATA_STRUCT_PROBLEM = 5;
    public static final int LOCK_NOT_LOCKED = 6;
    public static final int LOCK_ALREADY_LOCKED = 7;
    public static final int LOCK_FASTEST_UNAVAILABLE = 8;
    public static final int PAINT_TILE = 2;
    public static final int PAINT_SINGLECOLOR = 1;
    public static final int PAINT_SOLIDCOLOR = 0;
    public static final int COMP_CUSTOM = 3;
    public static final int COMP_XOR = 2;
    public static final int COMP_ALPHA = 1;
    public static final int COMP_ISCOPY = 0;
    public static final int STROKE_CUSTOM = 1;
    public static final int STROKE_BASIC = 0;
    public static final int TRANSFORM_GENERIC = 2;
    public static final int TRANSFORM_TRANSLATEONLY = 1;
    public static final int TRANSFORM_ISIDENT = 0;
    public static final int CLIP_SHAPE = 2;
    public static final int CLIP_RECTANGULAR = 1;
    public static final int CLIP_DEVICE = 0;
    public static final int XOR_MODE = 1;
    public static final int PAINT_MODE = 0;
    public int paintState;
    public int compositeState;
    public int strokeState;
    public int transformState;
    public int clipState;
    public int modeState;
    protected static final Color nullXORColor = new Color(0, 0, 0, 0);
    public Color foregroundColor = Color.white;
    public Color backgroundColor = Color.black;
    public Color xorColor = nullXORColor;
    public AffineTransform transform = new AffineTransform();
    public int transX;
    public int transY;
    public boolean complexTransform;
    protected static final Stroke defaultStroke = new BasicStroke();
    protected static final Composite defaultComposite = AlphaComposite.SrcOver;
    public Stroke stroke = defaultStroke;
    public Composite composite = defaultComposite;
    public Paint paint = this.foregroundColor;
    public int renderHint = 0;
    public int antialiasHint = 1;
    private int textAntialiasHint = 0;
    private int fractionalMetricsHint = 1;
    private int interpolationHint = -1;
    protected Font font;
    protected FontMetrics fontMetrics;
    public RenderingHints hints;
    public Rectangle constrainClip;
    public int constrainX;
    public int constrainY;
    public Region clipRegion;
    public Shape usrClip;
    protected Rectangle devClip;
    protected Rectangle compBounds;
    protected static ValidatePipe invalidpipe = new ValidatePipe();
    public PixelDrawPipe drawpipe;
    public PixelFillPipe fillpipe;
    public ShapeDrawPipe shapepipe;
    public TextPipe textpipe;
    public CompositePipe alphapipe;
    private Object copyAreaStateCache;
    private Object rpics;
    public boolean simpleText = true;
    private Object dscc;
    private Object dvcc;
    private Object dccc;
    private Object dbcc;
    private static final float[] metrics = new float[4];
    public static CachedMetrics[] metricscache = new CachedMetrics[5];
    static Permission compPermission;
    static final int NON_RECTILINEAR_TRANSFORM_MASK = 48;

    protected SunGraphics2D() {
        this.invalidatePipe();
    }

    public void addRenderingHints(Map map) {
        boolean bl = false;
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (object == SunHints.KEY_RENDERING || object == SunHints.KEY_ANTIALIASING || object == SunHints.KEY_TEXT_ANTIALIASING || object == SunHints.KEY_FRACTIONALMETRICS || object == SunHints.KEY_INTERPOLATION) {
                this.setRenderingHint((RenderingHints.Key)object, map.get(object));
                continue;
            }
            bl = true;
        }
        if (bl) {
            if (this.hints == null) {
                this.hints = this.makeHints(map);
            } else {
                this.hints.putAll(map);
            }
        }
    }

    protected void checkCustomComposite() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            if (compPermission == null) {
                compPermission = new AWTPermission("readDisplayPixels");
            }
            securityManager.checkPermission(compPermission);
        }
    }

    public void clearRect(int n, int n2, int n3, int n4) {
        Composite composite = this.composite;
        Paint paint = this.paint;
        Color color = this.xorColor;
        boolean bl = this.modeState == 1;
        this.setComposite(AlphaComposite.Src);
        this.setColor(this.getBackground());
        if (bl) {
            this.setPaintMode();
        }
        this.validatePipe();
        this.fillRect(n, n2, n3, n4);
        if (bl) {
            this.setXORMode(color);
        }
        this.setPaint(paint);
        this.setComposite(composite);
    }

    public void clip(Shape shape) {
        shape = this.transformShape(shape);
        if (this.usrClip != null) {
            shape = this.intersectShapes(this.usrClip, shape, true, true);
        }
        this.usrClip = shape;
        this.invalidateClip();
    }

    public void clipRect(int n, int n2, int n3, int n4) {
        this.clip(new Rectangle(n, n2, n3, n4));
    }

    protected Object clone() {
        try {
            SunGraphics2D sunGraphics2D = (SunGraphics2D)super.clone();
            sunGraphics2D.transform = new AffineTransform(this.transform);
            if (this.hints != null) {
                sunGraphics2D.hints = (RenderingHints)this.hints.clone();
            }
            sunGraphics2D.invalidatePipe();
            return sunGraphics2D;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    protected static Shape cloneShape(Shape shape) {
        return new GeneralPath(shape);
    }

    public AffineTransform cloneTransform() {
        return new AffineTransform(this.transform);
    }

    public void constrain(int n, int n2, int n3, int n4) {
        Cloneable cloneable;
        Rectangle rectangle = this.constrainClip;
        if (rectangle != null && (n | n2) == 0 && rectangle.x >= this.constrainX && rectangle.y >= this.constrainY && this.constrainX + n3 >= rectangle.x + rectangle.width && this.constrainY + n4 >= rectangle.y + rectangle.height) {
            return;
        }
        if ((n | n2) != 0) {
            this.constrainX += n;
            this.constrainY += n2;
            if (this.transformState == 2) {
                cloneable = AffineTransform.getTranslateInstance(n, n2);
                this.transform.preConcatenate((AffineTransform)cloneable);
                this.invalidateTransform();
            } else {
                this.translate(n, n2);
            }
        }
        cloneable = new Rectangle(this.constrainX, this.constrainY, n3, n4);
        if (rectangle != null) {
            if (cloneable.contains(rectangle)) {
                return;
            }
            cloneable = cloneable.intersection(rectangle);
        }
        this.constrainClip = cloneable;
        if (!cloneable.contains(this.devClip)) {
            this.devClip = this.devClip.intersection((Rectangle)cloneable);
            this.invalidateClip();
        }
    }

    protected BufferedImage convertCM(BufferedImage bufferedImage, ColorModel colorModel) {
        WritableRaster writableRaster = colorModel.createCompatibleWritableRaster(bufferedImage.getWidth(), bufferedImage.getHeight());
        BufferedImage bufferedImage2 = new BufferedImage(colorModel, writableRaster, bufferedImage.isAlphaPremultiplied(), null);
        int n = 0;
        while (n < bufferedImage.getHeight()) {
            int n2 = 0;
            while (n2 < bufferedImage.getWidth()) {
                bufferedImage2.setRGB(n2, n, bufferedImage.getRGB(n2, n));
                ++n2;
            }
            ++n;
        }
        return bufferedImage2;
    }

    public WritableRaster convertRaster(Raster raster, ColorModel colorModel, ColorModel colorModel2) {
        if (colorModel instanceof IndexColorModel && (colorModel2.equals(ColorModel.getRGBdefault()) || colorModel2.equals(XRGBModel))) {
            IndexColorModel indexColorModel = (IndexColorModel)colorModel;
            BufferedImage bufferedImage = indexColorModel.convertToIntDiscrete(raster, false);
            return bufferedImage.getRaster();
        }
        BufferedImage bufferedImage = new BufferedImage(colorModel2, colorModel2.createCompatibleWritableRaster(raster.getWidth(), raster.getHeight()), colorModel2.isAlphaPremultiplied(), null);
        Object object = raster.getDataElements(0, 0, null);
        int n = 0;
        while (n < bufferedImage.getHeight()) {
            int n2 = 0;
            while (n2 < bufferedImage.getWidth()) {
                bufferedImage.setRGB(n2, n, colorModel.getRGB(raster.getDataElements(n2, n, object)));
                ++n2;
            }
            ++n;
        }
        return bufferedImage.getRaster();
    }

    public void copyArea(int n, int n2, int n3, int n4, int n5, int n6) {
        Rectangle rectangle = new Rectangle(n, n2, n3, n4);
        rectangle = this.transformBounds(rectangle, this.transform);
        Point2D point2D = new Point2D.Float(n5, n6);
        Point2D point2D2 = new Point2D.Float(0.0f, 0.0f);
        point2D = this.transform.transform(point2D, point2D);
        point2D2 = this.transform.transform(point2D2, point2D2);
        int n7 = (int)(point2D.getX() - point2D2.getX());
        int n8 = (int)(point2D.getY() - point2D2.getY());
        Rectangle rectangle2 = this.getCompBounds().intersection(rectangle.getBounds());
        if (rectangle2.isEmpty()) {
            return;
        }
        boolean bl = true;
        Object var14_14 = null;
        if (this.clipState == 2) {
            int[] nArray = new int[4];
            this.clipRegion.getBounds(nArray);
            Rectangle rectangle3 = new Rectangle(nArray[0], nArray[1], nArray[2] - nArray[0], nArray[3] - nArray[1]);
            if (!rectangle3.isEmpty()) {
                OutputManager outputManager = this.getOutputManager();
                RegionIterator regionIterator = this.clipRegion.getIterator();
                while (regionIterator.nextYRange(nArray)) {
                    int n9 = nArray[0];
                    int n10 = nArray[1] - n9;
                    while (regionIterator.nextXBand(nArray)) {
                        int n11 = nArray[2];
                        int n12 = nArray[3] - n11;
                        this.copyAreaStateCache = outputManager.copyArea(this, null, n12, 0, n11, n9, n12, n10, n7, n8, this.copyAreaStateCache);
                    }
                }
            }
            return;
        }
        this.copyAreaStateCache = this.getOutputManager().copyArea(this, null, rectangle2.width, 0, rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height, n7, n8, this.copyAreaStateCache);
    }

    public Graphics create() {
        return (Graphics)this.clone();
    }

    public void draw(Shape shape) {
        this.shapepipe.draw(this, shape);
    }

    public void drawArc(int n, int n2, int n3, int n4, int n5, int n6) {
        this.drawpipe.drawArc(this, n, n2, n3, n4, n5, n6);
    }

    public Object drawBytes(SunGraphics2D sunGraphics2D, byte[] byArray, int n, int n2, int n3, int n4, Object object) {
        return RasterOutputManager.getManager().drawBytes(sunGraphics2D, byArray, n, n2, n3, n4, object);
    }

    public void drawBytes(byte[] byArray, int n, int n2, int n3, int n4) {
        if (byArray == null) {
            throw new NullPointerException("byte data is null");
        }
        try {
            this.dbcc = this.textpipe.drawBytes(this, byArray, n, n2, n3, n4, this.dbcc);
        }
        catch (ShapingException shapingException) {
            TextLayout textLayout = new TextLayout(new String(byArray, 0, n, n2), this.getFont(), this.getFontRenderContext());
            textLayout.draw(this, n3, n4);
        }
    }

    public Object drawChars(SunGraphics2D sunGraphics2D, char[] cArray, int n, int n2, int n3, int n4, Object object) {
        return RasterOutputManager.getManager().drawChars(sunGraphics2D, cArray, n, n2, n3, n4, object);
    }

    public void drawChars(char[] cArray, int n, int n2, int n3, int n4) {
        if (cArray == null) {
            throw new NullPointerException("char data is null");
        }
        try {
            this.dccc = this.textpipe.drawChars(this, cArray, n, n2, n3, n4, this.dccc);
        }
        catch (ShapingException shapingException) {
            TextLayout textLayout = new TextLayout(new String(cArray, n, n2), this.getFont(), this.getFontRenderContext());
            textLayout.draw(this, n3, n4);
        }
    }

    public void drawGlyphVector(GlyphVector glyphVector, float f, float f2) {
        if (glyphVector == null) {
            throw new NullPointerException("glyphvector is null");
        }
        this.dvcc = this.textpipe.drawGlyphVector(this, glyphVector, f, f2, this.dvcc);
    }

    public Object drawGlyphVector(SunGraphics2D sunGraphics2D, GlyphVector glyphVector, float f, float f2, Object object) {
        return RasterOutputManager.getManager().drawGlyphVector(sunGraphics2D, glyphVector, f, f2, object);
    }

    protected boolean drawImage(BufferedImage bufferedImage, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Color color, ImageObserver imageObserver) {
        Object object;
        int n9;
        int n10;
        int n11;
        int n12;
        if (n == n3 || n2 == n4) {
            return true;
        }
        if (n5 == n7 || n6 == n8) {
            return true;
        }
        if (n8 > n6) {
            n12 = n8 - n6;
            n11 = n6;
        } else {
            n12 = n6 - n8;
            n11 = n8;
        }
        if (n7 > n5) {
            n10 = n7 - n5;
            n9 = n5;
        } else {
            n10 = n5 - n7;
            n9 = n7;
        }
        if (n3 > n) {
            int n13 = n;
        } else {
            int n14 = n3;
        }
        if (n4 > n2) {
            int n15 = n2;
        } else {
            int n16 = n4;
        }
        if (n10 <= 0 || n12 <= 0) {
            return true;
        }
        if (n9 >= 0 && n11 >= 0) {
            object = bufferedImage.getRaster();
            int n17 = ((Raster)object).getWidth();
            int n18 = ((Raster)object).getHeight();
            if (n9 + n10 > n17) {
                n10 = n17 - n9;
            }
            if (n11 + n12 > n18) {
                n12 = n18 - n11;
            }
            bufferedImage = bufferedImage.getSubimage(n9 + bufferedImage.getMinX(), n11 + bufferedImage.getMinY(), n10, n12);
        }
        object = new AffineTransform();
        ((AffineTransform)object).translate(n, n2);
        if (n3 - n != n7 - n5 || n4 - n2 != n8 - n6) {
            double d = (double)(n3 - n) / (double)(n7 - n5);
            double d2 = (double)(n4 - n2) / (double)(n8 - n6);
            ((AffineTransform)object).scale(d, d2);
        }
        ((AffineTransform)object).translate(n9 - n5, n11 - n6);
        return this.drawImage(bufferedImage, (AffineTransform)object, 0, 0, color, imageObserver);
    }

    protected boolean drawImage(BufferedImage bufferedImage, int n, int n2, int n3, int n4, Color color, ImageObserver imageObserver) {
        if (n3 == 0 || n4 == 0) {
            return true;
        }
        AffineTransform affineTransform = null;
        if (n3 != bufferedImage.getWidth() || n4 != bufferedImage.getHeight()) {
            affineTransform = new AffineTransform();
            affineTransform.scale((double)n3 / (double)bufferedImage.getWidth(), (double)n4 / (double)bufferedImage.getHeight());
        }
        return this.drawImage(bufferedImage, affineTransform, n, n2, color, imageObserver);
    }

    protected boolean drawImage(BufferedImage bufferedImage, int n, int n2, Color color, ImageObserver imageObserver) {
        this.renderingPipeImage(bufferedImage, n, n2, null, null, color);
        return true;
    }

    protected boolean drawImage(BufferedImage bufferedImage, AffineTransform affineTransform, int n, int n2, Color color, ImageObserver imageObserver) {
        this.renderingPipeImage(bufferedImage, n, n2, null, affineTransform, color);
        return true;
    }

    public void drawImage(BufferedImage bufferedImage, BufferedImageOp bufferedImageOp, int n, int n2) {
        this.renderingPipeImage(bufferedImage, n, n2, bufferedImageOp, null, null);
    }

    public void drawLine(int n, int n2, int n3, int n4) {
        this.drawpipe.drawLine(this, n, n2, n3, n4);
    }

    public void drawOval(int n, int n2, int n3, int n4) {
        this.drawpipe.drawOval(this, n, n2, n3, n4);
    }

    public void drawPolygon(int[] nArray, int[] nArray2, int n) {
        this.drawpipe.drawPolygon(this, nArray, nArray2, n);
    }

    public void drawPolyline(int[] nArray, int[] nArray2, int n) {
        this.drawpipe.drawPolyline(this, nArray, nArray2, n);
    }

    public void drawRect(int n, int n2, int n3, int n4) {
        this.drawpipe.drawRect(this, n, n2, n3, n4);
    }

    public void drawRenderableImage(RenderableImage renderableImage, AffineTransform affineTransform) {
        AffineTransform affineTransform2;
        AffineTransform affineTransform3 = this.transform;
        AffineTransform affineTransform4 = new AffineTransform(affineTransform);
        affineTransform4.concatenate(affineTransform3);
        RenderContext renderContext = new RenderContext(affineTransform4);
        try {
            affineTransform2 = affineTransform3.createInverse();
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            renderContext = new RenderContext(affineTransform3);
            affineTransform2 = new AffineTransform();
        }
        RenderedImage renderedImage = renderableImage.createRendering(renderContext);
        this.drawRenderedImage(renderedImage, affineTransform2);
    }

    public void drawRenderedImage(RenderedImage renderedImage, AffineTransform affineTransform) {
        Raster raster;
        Object object;
        ColorModel colorModel = renderedImage.getColorModel();
        if (renderedImage instanceof BufferedImage) {
            BufferedImage bufferedImage = (BufferedImage)renderedImage;
            this.drawImage(bufferedImage, affineTransform, null);
            return;
        }
        Rectangle rectangle = this.getCompBounds();
        int n = 0;
        int n2 = 0;
        try {
            double d;
            double d2;
            object = new double[8];
            object[0] = object[2] = (double)rectangle.x;
            object[4] = object[6] = (double)(rectangle.x + rectangle.width);
            object[1] = object[5] = (double)rectangle.y;
            object[3] = object[7] = (double)(rectangle.y + rectangle.height);
            this.transform.inverseTransform((double[])object, 0, (double[])object, 0, 4);
            affineTransform.inverseTransform((double[])object, 0, (double[])object, 0, 4);
            double d3 = d2 = object[0];
            double d4 = d = object[1];
            int n3 = 2;
            while (n3 < 8) {
                int n4 = n3++;
                double d5 = object[n4];
                if (d5 < d3) {
                    d3 = d5;
                } else if (d5 > d2) {
                    d2 = d5;
                }
                d5 = object[n3++];
                if (d5 < d4) {
                    d4 = d5;
                    continue;
                }
                if (!(d5 > d)) continue;
                d = d5;
            }
            int n5 = (int)(d3 - 3.0);
            int n6 = (int)(d2 - d3 + 6.0);
            int n7 = (int)(d4 - 3.0);
            int n8 = (int)(d - d4 + 6.0);
            Rectangle rectangle2 = new Rectangle(n5, n7, n6, n8);
            Rectangle rectangle3 = new Rectangle(renderedImage.getMinX(), renderedImage.getMinY(), renderedImage.getWidth(), renderedImage.getHeight());
            Rectangle rectangle4 = rectangle2.intersection(rectangle3);
            n = (int)(rectangle3.getX() - rectangle4.getX());
            n2 = (int)(rectangle3.getY() - rectangle4.getY());
            if (rectangle4.width <= 0 || rectangle4.height <= 0) {
                return;
            }
            raster = renderedImage.getData(rectangle4);
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            raster = renderedImage.getData();
        }
        object = Raster.createWritableRaster(raster.getSampleModel(), raster.getDataBuffer(), null);
        AffineTransform affineTransform2 = (AffineTransform)affineTransform.clone();
        affineTransform2.translate(raster.getMinX() + n, raster.getMinY() + n2);
        BufferedImage bufferedImage = new BufferedImage(colorModel, (WritableRaster)object, false, null);
        this.drawImage(bufferedImage, affineTransform2, null);
    }

    public void drawRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        this.drawpipe.drawRoundRect(this, n, n2, n3, n4, n5, n6);
    }

    public void drawString(String string, float f, float f2) {
        if (string == null) {
            throw new NullPointerException("string is null");
        }
        try {
            this.dscc = this.textpipe.drawString(this, string, f, f2, this.dscc);
        }
        catch (ShapingException shapingException) {
            TextLayout textLayout = new TextLayout(string, this.getFont(), this.getFontRenderContext());
            textLayout.draw(this, f, f2);
        }
    }

    public void drawString(String string, int n, int n2) {
        if (string == null) {
            throw new NullPointerException("string is null");
        }
        try {
            this.dscc = this.textpipe.drawString(this, string, n, n2, this.dscc);
        }
        catch (ShapingException shapingException) {
            TextLayout textLayout = new TextLayout(string, this.getFont(), this.getFontRenderContext());
            textLayout.draw(this, n, n2);
        }
    }

    public void drawString(AttributedCharacterIterator attributedCharacterIterator, float f, float f2) {
        if (attributedCharacterIterator == null) {
            throw new NullPointerException("attributedcharacteriterator is null");
        }
        TextLayout textLayout = new TextLayout(attributedCharacterIterator, this.getFontRenderContext());
        textLayout.draw(this, f, f2);
    }

    public void drawString(AttributedCharacterIterator attributedCharacterIterator, int n, int n2) {
        if (attributedCharacterIterator == null) {
            throw new NullPointerException("attributedcharacteriterator is null");
        }
        TextLayout textLayout = new TextLayout(attributedCharacterIterator, this.getFontRenderContext());
        textLayout.draw(this, n, n2);
    }

    public Object drawString(SunGraphics2D sunGraphics2D, String string, float f, float f2, Object object) {
        return RasterOutputManager.getManager().drawString(sunGraphics2D, string, f, f2, object);
    }

    public void fill(Shape shape) {
        this.shapepipe.fill(this, shape);
    }

    public void fillArc(int n, int n2, int n3, int n4, int n5, int n6) {
        this.fillpipe.fillArc(this, n, n2, n3, n4, n5, n6);
    }

    public void fillOval(int n, int n2, int n3, int n4) {
        this.fillpipe.fillOval(this, n, n2, n3, n4);
    }

    public void fillPolygon(int[] nArray, int[] nArray2, int n) {
        this.fillpipe.fillPolygon(this, nArray, nArray2, n);
    }

    public void fillRect(int n, int n2, int n3, int n4) {
        this.fillpipe.fillRect(this, n, n2, n3, n4);
    }

    public void fillRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        this.fillpipe.fillRoundRect(this, n, n2, n3, n4, n5, n6);
    }

    public Color getBackground() {
        return this.backgroundColor;
    }

    public Shape getClip() {
        return this.untransformShape(this.usrClip);
    }

    public Rectangle getClipBounds() {
        Shape shape = this.getClip();
        if (shape != null) {
            return shape.getBounds();
        }
        return null;
    }

    public Color getColor() {
        return this.foregroundColor;
    }

    public Rectangle getCompBounds() {
        Rectangle rectangle = this.compBounds;
        if (rectangle == null) {
            switch (this.clipState) {
                case 0: {
                    rectangle = this.devClip;
                    break;
                }
                case 1: {
                    if (this.usrClip instanceof Rectangle) {
                        rectangle = this.devClip.intersection((Rectangle)this.usrClip);
                        break;
                    }
                    rectangle = this.devClip.intersection(this.usrClip.getBounds());
                    break;
                }
                case 2: {
                    PathIterator pathIterator = this.usrClip.getPathIterator(null);
                    int[] nArray = new int[4];
                    ShapeSpanIterator shapeSpanIterator = new ShapeSpanIterator();
                    shapeSpanIterator.setOutputArea(this.devClip);
                    shapeSpanIterator.appendPath(pathIterator);
                    shapeSpanIterator.getPathBox(nArray);
                    rectangle = new Rectangle(nArray[0], nArray[1], nArray[2] - nArray[0], nArray[3] - nArray[1]);
                    rectangle = rectangle.intersection(this.devClip);
                    Region region = new Region();
                    region.setOutputArea(rectangle);
                    region.appendSpans(shapeSpanIterator);
                    this.clipRegion = region;
                    break;
                }
            }
            this.compBounds = rectangle;
        }
        return rectangle;
    }

    public Composite getComposite() {
        return this.composite;
    }

    public String getDevID() {
        return null;
    }

    public abstract ColorModel getDeviceColorModel();

    public abstract GraphicsConfiguration getDeviceConfiguration();

    public Font getFont() {
        if (this.font == null) {
            this.font = new Font("Dialog", 10, 0);
        }
        return this.font;
    }

    public FontMetrics getFontMetrics(Font font) {
        if (this.fontMetrics != null && font == this.font) {
            return this.fontMetrics;
        }
        float f = font.getSize2D();
        AffineTransform affineTransform = font.getTransform();
        affineTransform.scale(f, f);
        double[] dArray = new double[4];
        affineTransform.getMatrix(dArray);
        int n = this.textAntialiasHint == 0 ? this.antialiasHint : this.textAntialiasHint;
        FontMetrics fontMetrics = SunGraphics2D.makeFontMetrics(font, dArray, n == 2, this.fractionalMetricsHint == 2);
        if (this.font == font) {
            this.fontMetrics = fontMetrics;
        }
        return fontMetrics;
    }

    public FontRenderContext getFontRenderContext() {
        int n = this.textAntialiasHint == 0 ? this.antialiasHint : this.textAntialiasHint;
        return new FontRenderContext(this.getDeviceConfiguration().getDefaultTransform(), n == 2, this.fractionalMetricsHint == 2);
    }

    public abstract OutputManager getOutputManager();

    public Paint getPaint() {
        return this.paint;
    }

    public Object getRenderingHint(RenderingHints.Key key) {
        if (this.hints != null) {
            return this.hints.get(key);
        }
        if (!(key instanceof SunHints.Key)) {
            return null;
        }
        int n = ((SunHints.Key)key).getIndex();
        switch (n) {
            case 0: {
                return SunHints.Value.get(0, this.renderHint);
            }
            case 1: {
                return SunHints.Value.get(1, this.antialiasHint);
            }
            case 2: {
                return SunHints.Value.get(2, this.textAntialiasHint);
            }
            case 3: {
                return SunHints.Value.get(3, this.fractionalMetricsHint);
            }
            case 5: {
                switch (this.interpolationHint) {
                    case 1: {
                        return SunHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR;
                    }
                    case 2: {
                        return SunHints.VALUE_INTERPOLATION_BILINEAR;
                    }
                }
                return null;
            }
        }
        return null;
    }

    public RenderingHints getRenderingHints() {
        if (this.hints == null) {
            return this.makeHints(null);
        }
        return (RenderingHints)this.hints.clone();
    }

    public Stroke getStroke() {
        return this.stroke;
    }

    public AffineTransform getTransform() {
        if ((this.constrainX | this.constrainY) == 0) {
            return new AffineTransform(this.transform);
        }
        AffineTransform affineTransform = AffineTransform.getTranslateInstance(-this.constrainX, -this.constrainY);
        affineTransform.concatenate(this.transform);
        return affineTransform;
    }

    private ColorModel getTransformColorModel(BufferedImage bufferedImage, AffineTransform affineTransform) {
        Object object;
        boolean bl;
        ColorModel colorModel;
        ColorModel colorModel2 = colorModel = bufferedImage.getColorModel();
        if (affineTransform.isIdentity()) {
            return colorModel2;
        }
        int n = affineTransform.getType();
        boolean bl2 = bl = (n & 0x38) != 0;
        if (!bl && n != 1 && n != 0) {
            object = new double[4];
            affineTransform.getMatrix((double[])object);
            boolean bl3 = bl = object[0] != (double)((int)object[0]) || object[3] != (double)((int)object[3]);
        }
        if (this.renderHint != 2) {
            if (colorModel instanceof IndexColorModel) {
                object = bufferedImage.getRaster();
                IndexColorModel indexColorModel = (IndexColorModel)colorModel;
                if (bl && colorModel.getTransparency() == 1) {
                    double[] dArray = new double[6];
                    affineTransform.getMatrix(dArray);
                    if (dArray[1] != 0.0 || dArray[2] != 0.0 || dArray[4] != 0.0 || dArray[5] != 0.0) {
                        int n2 = indexColorModel.getMapSize();
                        if (n2 < 256) {
                            int[] nArray = new int[n2 + 1];
                            indexColorModel.getRGBs(nArray);
                            nArray[n2] = 0;
                            colorModel2 = new IndexColorModel(indexColorModel.getPixelSize(), n2 + 1, nArray, 0, true, n2, 0);
                        } else {
                            colorModel2 = ColorModel.getRGBdefault();
                        }
                    }
                }
            } else if (bl && colorModel.getTransparency() == 1) {
                colorModel2 = ColorModel.getRGBdefault();
            }
        } else if (colorModel instanceof IndexColorModel || bl && colorModel.getTransparency() == 1) {
            colorModel2 = ColorModel.getRGBdefault();
        }
        return colorModel2;
    }

    public boolean hit(Rectangle rectangle, Shape shape, boolean bl) {
        if (bl) {
            shape = this.stroke.createStrokedShape(shape);
        }
        shape = this.transformShape(shape);
        if ((this.constrainX | this.constrainY) != 0) {
            rectangle = new Rectangle(rectangle);
            rectangle.translate(this.constrainX, this.constrainY);
        }
        return shape.intersects(rectangle);
    }

    Shape intersectByArea(Shape shape, Shape shape2, boolean bl, boolean bl2) {
        Area area;
        if (!bl && shape instanceof Area) {
            area = (Area)shape;
        } else if (!bl2 && shape2 instanceof Area) {
            area = (Area)shape2;
            shape2 = shape;
        } else {
            area = new Area(shape);
        }
        Area area2 = shape2 instanceof Area ? (Area)shape2 : new Area(shape2);
        area.intersect(area2);
        if (area.isRectangular()) {
            return area.getBounds();
        }
        return area;
    }

    Shape intersectRectShape(Rectangle2D rectangle2D, Shape shape, boolean bl, boolean bl2) {
        if (shape instanceof Rectangle2D) {
            Rectangle2D rectangle2D2 = (Rectangle2D)shape;
            Rectangle2D rectangle2D3 = !bl ? rectangle2D : (!bl2 ? rectangle2D2 : new Rectangle2D.Float());
            double d = Math.max(rectangle2D.getX(), rectangle2D2.getX());
            double d2 = Math.min(rectangle2D.getX() + rectangle2D.getWidth(), rectangle2D2.getX() + rectangle2D2.getWidth());
            double d3 = Math.max(rectangle2D.getY(), rectangle2D2.getY());
            double d4 = Math.min(rectangle2D.getY() + rectangle2D.getHeight(), rectangle2D2.getY() + rectangle2D2.getHeight());
            if (d2 - d < 0.0 || d4 - d3 < 0.0) {
                rectangle2D3.setFrameFromDiagonal(0.0, 0.0, 0.0, 0.0);
            } else {
                rectangle2D3.setFrameFromDiagonal(d, d3, d2, d4);
            }
            return rectangle2D3;
        }
        if (rectangle2D.contains(shape.getBounds2D())) {
            if (bl2) {
                shape = SunGraphics2D.cloneShape(shape);
            }
            return shape;
        }
        return this.intersectByArea(rectangle2D, shape, bl, bl2);
    }

    Shape intersectShapes(Shape shape, Shape shape2, boolean bl, boolean bl2) {
        if (shape instanceof Rectangle && shape2 instanceof Rectangle) {
            return ((Rectangle)shape).intersection((Rectangle)shape2);
        }
        if (shape instanceof Rectangle2D) {
            return this.intersectRectShape((Rectangle2D)shape, shape2, bl, bl2);
        }
        if (shape2 instanceof Rectangle2D) {
            return this.intersectRectShape((Rectangle2D)shape2, shape, bl2, bl);
        }
        return this.intersectByArea(shape, shape2, bl, bl2);
    }

    protected void invalidateClip() {
        this.compBounds = null;
        this.clipRegion = null;
        this.clipState = this.usrClip == null ? 0 : (this.usrClip instanceof Rectangle2D ? 1 : 2);
        this.invalidatePipe();
    }

    protected void invalidatePipe() {
        this.drawpipe = invalidpipe;
        this.fillpipe = invalidpipe;
        this.shapepipe = invalidpipe;
        this.textpipe = invalidpipe;
        this.alphapipe = null;
        this.dscc = null;
        this.dbcc = null;
        this.dccc = null;
        this.dvcc = null;
    }

    protected void invalidateTransform() {
        this.complexTransform = true;
        int n = this.transform.getType();
        if (n == 0) {
            this.transformState = 0;
            this.complexTransform = false;
            this.transY = 0;
            this.transX = 0;
        } else if (n == 1) {
            this.transformState = 1;
            this.transX = (int)this.transform.getTranslateX();
            this.transY = (int)this.transform.getTranslateY();
        } else {
            this.transformState = 2;
            this.transY = 0;
            this.transX = 0;
        }
        this.invalidatePipe();
    }

    public abstract ImageData lock(int var1, int var2, int var3, int var4, int var5);

    public static synchronized FontMetrics makeFontMetrics(Font font, double[] dArray, boolean bl, boolean bl2) {
        Object object;
        int n = 0;
        while (n < metricscache.length) {
            object = metricscache[n];
            if (object == null) break;
            if (((CachedMetrics)object).matches(font, dArray, bl, bl2)) {
                if (n > 1) {
                    System.arraycopy(metricscache, 0, metricscache, 1, n);
                    SunGraphics2D.metricscache[0] = object;
                }
                return ((CachedMetrics)object).fm;
            }
            ++n;
        }
        NativeFontWrapper.getFontMetrics(font, dArray, bl, bl2, metrics);
        object = new FontDesignMetrics(font, metrics[0], metrics[1], metrics[2], metrics[3]);
        if (n == metricscache.length) {
            System.arraycopy(metricscache, 0, metricscache, 1, n - 1);
            n = 0;
        }
        SunGraphics2D.metricscache[n] = new CachedMetrics(font, dArray, bl, bl2, (FontMetrics)object);
        return object;
    }

    RenderingHints makeHints(Map map) {
        Object object;
        RenderingHints renderingHints = new RenderingHints(map);
        renderingHints.put(SunHints.KEY_RENDERING, SunHints.Value.get(0, this.renderHint));
        renderingHints.put(SunHints.KEY_ANTIALIASING, SunHints.Value.get(1, this.antialiasHint));
        renderingHints.put(SunHints.KEY_TEXT_ANTIALIASING, SunHints.Value.get(2, this.textAntialiasHint));
        renderingHints.put(SunHints.KEY_FRACTIONALMETRICS, SunHints.Value.get(3, this.fractionalMetricsHint));
        switch (this.interpolationHint) {
            case 1: {
                object = SunHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR;
                break;
            }
            case 2: {
                object = SunHints.VALUE_INTERPOLATION_BILINEAR;
                break;
            }
            default: {
                return renderingHints;
            }
        }
        renderingHints.put(SunHints.KEY_INTERPOLATION, object);
        return renderingHints;
    }

    private void renderingPipeImage(BufferedImage bufferedImage, int n, int n2, BufferedImageOp bufferedImageOp, AffineTransform affineTransform, Color color) {
        BufferedImage bufferedImage2;
        Object object;
        Object object2;
        Object object3;
        Rectangle rectangle = this.getCompBounds();
        int n3 = this.interpolationHint;
        if (bufferedImageOp == null && (affineTransform == null || affineTransform.isIdentity()) && this.clipState != 2 && this.transformState != 2) {
            int n4 = rectangle.x;
            int n5 = rectangle.y;
            int n6 = rectangle.width;
            int n7 = rectangle.height;
            int n8 = n;
            int n9 = n2;
            if (this.transformState == 1) {
                n8 = (int)((double)n8 + this.transform.getTranslateX());
                n9 = (int)((double)n9 + this.transform.getTranslateY());
            }
            int n10 = n8 + bufferedImage.getWidth();
            int n11 = n9 + bufferedImage.getHeight();
            if (n8 > n4) {
                n6 = n6 + n4 - n8;
                n4 = n8;
            }
            if (n9 > n5) {
                n7 = n7 + n5 - n9;
                n5 = n9;
            }
            if (n10 < n4 + n6) {
                n6 = n10 - n4;
            }
            if (n11 < n5 + n7) {
                n7 = n11 - n5;
            }
            if (n6 <= 0 || n7 <= 0) {
                return;
            }
            if (n4 > n8 || n5 > n9) {
                bufferedImage = bufferedImage.getSubimage(bufferedImage.getMinX() + (n4 - n8), bufferedImage.getMinY() + (n5 - n9), n6, n7);
            }
            this.rpics = RasterOutputManager.getManager().renderImage(this, bufferedImage, color, n4, n5, n6, n7, null, n6, this.rpics);
            return;
        }
        AffineTransform affineTransform2 = null;
        if (bufferedImageOp != null) {
            if (bufferedImageOp instanceof AffineTransformOp) {
                AffineTransformOp affineTransformOp = (AffineTransformOp)bufferedImageOp;
                affineTransform2 = affineTransformOp.getTransform();
                n3 = affineTransformOp.getInterpolationType();
            } else {
                bufferedImage = bufferedImageOp.filter(bufferedImage, null);
            }
        }
        int n12 = bufferedImage.getWidth();
        int n13 = bufferedImage.getHeight();
        AffineTransform affineTransform3 = new AffineTransform(this.transform);
        affineTransform3.translate(n, n2);
        if (affineTransform != null && !affineTransform.isIdentity()) {
            affineTransform3.concatenate(affineTransform);
        }
        if (affineTransform2 != null && !affineTransform2.isIdentity()) {
            affineTransform3.concatenate(affineTransform2);
        }
        double[] dArray = new double[6];
        affineTransform3.getMatrix(dArray);
        if (dArray[0] == 1.0 && dArray[1] == 0.0 && dArray[2] == 0.0 && dArray[3] == 1.0) {
            n = (int)Math.round(dArray[4]);
            object3 = new Rectangle(n, n2 = (int)Math.round(dArray[5]), n12, n13);
            if ((rectangle = rectangle.intersection((Rectangle)object3)).isEmpty()) {
                return;
            }
            if (!rectangle.equals(object3)) {
                bufferedImage = bufferedImage.getSubimage(rectangle.x - n, rectangle.y - n2, rectangle.width, rectangle.height);
                n12 = rectangle.width;
                n13 = rectangle.height;
            }
        } else {
            object3 = this.getTransformColorModel(bufferedImage, affineTransform3);
            int n14 = n3;
            if (n3 == -1) {
                int n4 = n14 = this.renderHint == 2 ? 2 : 1;
            }
            if ((rectangle = rectangle.intersection((Rectangle)(object2 = ((AffineTransformOp)(object = new AffineTransformOp(affineTransform3, n14))).getBounds2D(bufferedImage).getBounds()))).isEmpty()) {
                return;
            }
            n = rectangle.x;
            n2 = rectangle.y;
            n12 = rectangle.width;
            n13 = rectangle.height;
            if (n != 0 || n2 != 0) {
                affineTransform3.preConcatenate(new AffineTransform(1.0, 0.0, 0.0, 1.0, (double)(-n), (double)(-n2)));
                object = new AffineTransformOp(affineTransform3, n14);
            }
            if ((bufferedImage = ((AffineTransformOp)object).filter(bufferedImage, bufferedImage2 = new BufferedImage((ColorModel)object3, ((ColorModel)object3).createCompatibleWritableRaster(n12, n13), false, null))) == null) {
                return;
            }
        }
        if (this.clipState == 2) {
            object3 = new int[4];
            this.clipRegion.getBounds((int[])object3);
            Rectangle rectangle2 = new Rectangle((int)object3[0], (int)object3[1], (int)(object3[2] - object3[0]), (int)(object3[3] - object3[1]));
            rectangle2 = rectangle2.intersection(rectangle);
            if (!rectangle2.isEmpty()) {
                object = this.getOutputManager();
                object2 = this.clipRegion.getIterator();
                int n16 = rectangle.x;
                int n17 = rectangle.y;
                int n18 = n16 + rectangle.width;
                int n19 = n17 + rectangle.height;
                block0: while (((RegionIterator)object2).nextYRange((int[])object3)) {
                    Object object4 = object3[0];
                    if (object4 > n19) break;
                    Object object5 = object3[1];
                    if (object5 < n17) continue;
                    if (object4 < n17) {
                        object4 = n17;
                    }
                    if (object5 > n19) {
                        object5 = n19;
                    }
                    reference var25_35 = object5 - object4;
                    while (((RegionIterator)object2).nextXBand((int[])object3)) {
                        Object object6 = object3[2];
                        if (object6 > n18) continue block0;
                        Object object7 = object3[3];
                        if (object7 < n16) continue;
                        if (object6 < n16) {
                            object6 = n16;
                        }
                        if (object7 > n18) {
                            object7 = n18;
                        }
                        reference var28_38 = object7 - object6;
                        bufferedImage2 = bufferedImage.getSubimage((int)(object6 - n16), (int)(object4 - n17), (int)var28_38, (int)var25_35);
                        object.renderImage(this, bufferedImage2, color, (int)object6, (int)object4, (int)var28_38, (int)var25_35, null, (int)var28_38, null);
                    }
                }
            }
            return;
        }
        this.getOutputManager().renderImage(this, bufferedImage, color, rectangle.x, rectangle.y, rectangle.width, rectangle.height, null, rectangle.width, null);
    }

    public void rotate(double d) {
        this.transform.rotate(d);
        this.invalidateTransform();
    }

    public void rotate(double d, double d2, double d3) {
        this.transform.rotate(d, d2, d3);
        this.invalidateTransform();
    }

    public void scale(double d, double d2) {
        this.transform.scale(d, d2);
        this.invalidateTransform();
    }

    public void setBackground(Color color) {
        this.backgroundColor = color;
    }

    public void setClip(int n, int n2, int n3, int n4) {
        this.setClip(new Rectangle(n, n2, n3, n4));
    }

    public void setClip(Shape shape) {
        this.usrClip = this.transformShape(shape);
        this.invalidateClip();
    }

    public void setColor(Color color) {
        if (this.paint != color) {
            this.setPaint(color);
        }
    }

    public void setComposite(Composite composite) {
        int n;
        int n2;
        if (composite == null) {
            throw new IllegalArgumentException("null Composite");
        }
        if (composite instanceof AlphaComposite) {
            n2 = 0;
            AlphaComposite alphaComposite = (AlphaComposite)composite;
            n = alphaComposite.getAlpha() >= 1.0f && (alphaComposite.getRule() == 2 || alphaComposite.getRule() == 3) ? 0 : 1;
        } else if (composite instanceof XORComposite) {
            n2 = 1;
            n = 2;
        } else {
            this.checkCustomComposite();
            n2 = 0;
            n = 3;
        }
        if (this.compositeState != n || this.modeState != n2) {
            this.compositeState = n;
            this.modeState = n2;
            this.invalidatePipe();
        } else {
            this.dscc = null;
            this.dbcc = null;
            this.dccc = null;
            this.dvcc = null;
        }
        this.composite = composite;
    }

    public void setDevClip(int n, int n2, int n3, int n4) {
        Rectangle rectangle = new Rectangle(n, n2, n3, n4);
        Rectangle rectangle2 = this.constrainClip;
        this.devClip = rectangle2 == null ? rectangle : rectangle.intersection(rectangle2);
        this.invalidateClip();
    }

    public void setFont(Font font) {
        if (font != null && font != this.font) {
            this.font = font;
            this.fontMetrics = null;
            this.dscc = null;
            this.dbcc = null;
            this.dccc = null;
            this.dvcc = null;
        }
    }

    public void setPaint(Paint paint) {
        if (paint == null) {
            return;
        }
        int n = this.paintState;
        this.paint = paint;
        if (paint instanceof Color) {
            this.foregroundColor = (Color)paint;
            this.paintState = this.foregroundColor.getAlpha() == 255 ? 0 : 1;
        } else {
            this.paintState = 2;
        }
        if (this.paintState != n) {
            this.invalidatePipe();
        } else {
            this.dscc = null;
            this.dbcc = null;
            this.dccc = null;
            this.dvcc = null;
        }
    }

    public void setPaintMode() {
        this.modeState = 0;
        this.xorColor = nullXORColor;
        this.setComposite(AlphaComposite.SrcOver);
    }

    public void setRenderingHint(RenderingHints.Key key, Object object) {
        if (!key.isCompatibleValue(object)) {
            throw new IllegalArgumentException(String.valueOf(String.valueOf(object)) + " is not compatible with " + key);
        }
        if (key instanceof SunHints.Key) {
            boolean bl;
            boolean bl2 = true;
            SunHints.Key key2 = (SunHints.Key)key;
            int n = ((SunHints.Value)object).getIndex();
            switch (key2.getIndex()) {
                case 0: {
                    bl = this.renderHint != n;
                    this.renderHint = n;
                    break;
                }
                case 1: {
                    bl = this.antialiasHint != n;
                    this.antialiasHint = n;
                    break;
                }
                case 2: {
                    boolean bl3 = bl = this.textAntialiasHint != n;
                    if (bl) {
                        this.fontMetrics = null;
                    }
                    this.textAntialiasHint = n;
                    break;
                }
                case 3: {
                    boolean bl4 = bl = this.fractionalMetricsHint != n;
                    if (bl) {
                        this.fontMetrics = null;
                    }
                    this.fractionalMetricsHint = n;
                    break;
                }
                case 5: {
                    switch (n) {
                        case 1: 
                        case 2: {
                            n = 2;
                            break;
                        }
                        default: {
                            n = 1;
                        }
                    }
                    bl = this.interpolationHint != n;
                    this.interpolationHint = n;
                    break;
                }
                default: {
                    bl2 = false;
                    bl = false;
                }
            }
            if (bl2) {
                if (bl) {
                    this.invalidatePipe();
                }
                if (this.hints != null) {
                    this.hints.put(key, object);
                }
                return;
            }
        }
        if (this.hints == null) {
            this.hints = this.makeHints(null);
        }
        this.hints.put(key, object);
    }

    public void setRenderingHints(Map map) {
        this.hints = null;
        this.renderHint = 0;
        this.antialiasHint = 1;
        this.textAntialiasHint = 0;
        this.fractionalMetricsHint = 1;
        this.interpolationHint = -1;
        boolean bl = false;
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (object == SunHints.KEY_RENDERING || object == SunHints.KEY_ANTIALIASING || object == SunHints.KEY_TEXT_ANTIALIASING || object == SunHints.KEY_FRACTIONALMETRICS || object == SunHints.KEY_INTERPOLATION) {
                this.setRenderingHint((RenderingHints.Key)object, map.get(object));
                continue;
            }
            bl = true;
        }
        if (bl) {
            this.hints = this.makeHints(map);
        }
        this.invalidatePipe();
    }

    public void setStroke(Stroke stroke) {
        if (stroke == null) {
            throw new IllegalArgumentException("null Stroke");
        }
        int n = this.strokeState;
        boolean bl = this.stroke.equals(stroke) ^ true;
        this.stroke = stroke;
        if (stroke instanceof BasicStroke) {
            this.strokeState = 0;
        } else {
            bl = true;
            this.strokeState = 1;
        }
        if (bl) {
            this.invalidatePipe();
        }
    }

    public void setTransform(AffineTransform affineTransform) {
        if ((this.constrainX | this.constrainY) == 0) {
            this.transform.setTransform(affineTransform);
        } else {
            this.transform.setToTranslation(this.constrainX, this.constrainY);
            this.transform.concatenate(affineTransform);
        }
        this.invalidateTransform();
    }

    public void setXORMode(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("null XORColor");
        }
        this.modeState = 1;
        this.xorColor = color;
        this.setComposite(new XORComposite(color));
    }

    public void shear(double d, double d2) {
        this.transform.shear(d, d2);
        this.invalidateTransform();
    }

    public void transform(AffineTransform affineTransform) {
        this.transform.concatenate(affineTransform);
        this.invalidateTransform();
    }

    protected Rectangle transformBounds(Rectangle rectangle, AffineTransform affineTransform) {
        if (affineTransform.isIdentity()) {
            return rectangle;
        }
        Shape shape = SunGraphics2D.transformShape(affineTransform, rectangle);
        return shape.getBounds();
    }

    protected static Shape transformShape(int n, int n2, Shape shape) {
        if (shape == null) {
            return null;
        }
        if (shape instanceof Rectangle) {
            Rectangle rectangle = shape.getBounds();
            rectangle.translate(n, n2);
            return rectangle;
        }
        if (shape instanceof Rectangle2D) {
            Rectangle2D rectangle2D = (Rectangle2D)shape;
            return new Rectangle2D.Double(rectangle2D.getX() + (double)n2, rectangle2D.getY() + (double)n2, rectangle2D.getWidth(), rectangle2D.getHeight());
        }
        if (n == 0 && n2 == 0) {
            return SunGraphics2D.cloneShape(shape);
        }
        AffineTransform affineTransform = AffineTransform.getTranslateInstance(n, n2);
        return affineTransform.createTransformedShape(shape);
    }

    protected Shape transformShape(Shape shape) {
        if (shape == null) {
            return null;
        }
        if (this.complexTransform) {
            return SunGraphics2D.transformShape(this.transform, shape);
        }
        return SunGraphics2D.transformShape(this.transX, this.transY, shape);
    }

    protected static Shape transformShape(AffineTransform affineTransform, Shape shape) {
        if (shape == null) {
            return null;
        }
        if (shape instanceof Rectangle2D && (affineTransform.getType() & 0x30) == 0) {
            double[] dArray;
            Rectangle2D rectangle2D = (Rectangle2D)shape;
            dArray = new double[]{rectangle2D.getX(), rectangle2D.getY(), dArray[0] + rectangle2D.getWidth(), dArray[1] + rectangle2D.getHeight()};
            affineTransform.transform(dArray, 0, dArray, 0, 2);
            rectangle2D = new Rectangle2D.Float();
            rectangle2D.setFrameFromDiagonal(dArray[0], dArray[1], dArray[2], dArray[3]);
            return rectangle2D;
        }
        if (affineTransform.isIdentity()) {
            return SunGraphics2D.cloneShape(shape);
        }
        return affineTransform.createTransformedShape(shape);
    }

    public void translate(double d, double d2) {
        this.transform.translate(d, d2);
        this.invalidateTransform();
    }

    public void translate(int n, int n2) {
        this.transform.translate(n, n2);
        if (!this.complexTransform) {
            this.transX += n;
            this.transY += n2;
            this.transformState = this.transX == 0 && this.transY == 0 ? 0 : 1;
            this.invalidatePipe();
        } else {
            this.invalidateTransform();
        }
    }

    public abstract int unlock(ImageData var1);

    protected Shape untransformShape(Shape shape) {
        if (shape == null) {
            return null;
        }
        if (this.complexTransform) {
            try {
                return SunGraphics2D.transformShape(this.transform.createInverse(), shape);
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                return null;
            }
        }
        return SunGraphics2D.transformShape(-this.transX, -this.transY, shape);
    }

    public void validatePipe() {
        this.getOutputManager().validatePipe(this);
    }

    private static float veclength(float f, float f2) {
        return (float)Math.sqrt(f * f + f2 * f2);
    }

    private static class CachedMetrics {
        public Font font;
        public double[] matrix;
        public boolean isAA;
        public boolean isFract;
        public FontMetrics fm;

        public CachedMetrics(Font font, double[] dArray, boolean bl, boolean bl2, FontMetrics fontMetrics) {
            this.font = font;
            this.matrix = dArray;
            this.isAA = bl;
            this.isFract = bl2;
            this.fm = fontMetrics;
        }

        public final boolean matches(Font font, double[] dArray, boolean bl, boolean bl2) {
            return this.font == font && this.isAA == bl && this.isFract == bl2 && this.matrix[0] == dArray[0] && this.matrix[1] == dArray[1] && this.matrix[2] == dArray[2] && this.matrix[3] == dArray[3];
        }
    }
}

