/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.loops;

public abstract class GraphicsPrimitive {
    public static final int TYPE_CUSTOM = 0;
    public static final int TYPE_INT_RGB = 1;
    public static final int TYPE_INT_ARGB = 2;
    public static final int TYPE_INT_ARGB_PRE = 3;
    public static final int TYPE_INT_BGR = 4;
    public static final int TYPE_3BYTE_BGR = 5;
    public static final int TYPE_4BYTE_ABGR = 6;
    public static final int TYPE_4BYTE_ABGR_PRE = 7;
    public static final int TYPE_SHORT_565_RGB = 8;
    public static final int TYPE_SHORT_555_RGB = 9;
    public static final int TYPE_BYTE_GRAY = 10;
    public static final int TYPE_USHORT_GRAY = 11;
    public static final int TYPE_BINARY = 12;
    public static final int TYPE_BYTE_INDEXED = 13;
    public static final int TYPE_ANY_UNARY = -1;
    public static final int TYPE_ANY_BINARY = -2;
    public static final int TYPE_INT_UNARY = -3;
    public static final int TYPE_INT_BINARY = -4;
    public static final int TYPE_SHORT_UNARY = -5;
    public static final int TYPE_SHORT_BINARY = -6;
    public static final int TYPE_BYTE_UNARY = -7;
    public static final int TYPE_BYTE_BINARY = -8;
    public static final int TYPE_INT_RGBx = -10;
    public static final int TYPE_INT_BGRx = -11;
    public static final int TYPE_24BIT_RGB = -12;
    public static final int TYPE_DIB_xRGB = -13;
    public static final int TYPE_INT_ARGB_BM = -14;
    public static final int TYPE_INT_ARGB_PRE_BM = -15;
    public static final int TYPE_BYTE_INDEXED_BM = -16;
    public static final int TYPE_INDEX8_GRAY = -17;
    public static final int TYPE_INDEX12_GRAY = -18;
    private int[] surfaceTypes;
    private int[] lockFlags;
    private String methodSignature;
    public static final int LOCK_FOR_READ = 1;
    public static final int LOCK_FOR_WRITE = 2;
    public static final int LOCK_FOR_NOOP = 4;
    public static final int LOCK_FASTEST_ONLY = 8;

    protected GraphicsPrimitive(int[] nArray, int[] nArray2, String string) {
        this.surfaceTypes = nArray;
        this.lockFlags = nArray2;
        this.methodSignature = string;
    }

    public final int[] getLockFlags() {
        return this.lockFlags;
    }

    final boolean satisfies(String string, int[] nArray) {
        if (string != this.methodSignature) {
            return false;
        }
        if (nArray.length != this.surfaceTypes.length) {
            return false;
        }
        int n = 0;
        while (n < this.surfaceTypes.length) {
            if (nArray[n] != this.surfaceTypes[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    final boolean satisfiesSameAs(GraphicsPrimitive graphicsPrimitive) {
        return this.satisfies(graphicsPrimitive.methodSignature, graphicsPrimitive.surfaceTypes);
    }

    public static String typeStr(int n) {
        switch (n) {
            case 0: {
                return "TYPE_CUSTOM";
            }
            case 1: {
                return "TYPE_INT_RGB";
            }
            case 2: {
                return "TYPE_INT_ARGB";
            }
            case 3: {
                return "TYPE_INT_ARGB_PRE";
            }
            case 4: {
                return "TYPE_INT_BGR";
            }
            case 5: {
                return "TYPE_3BYTE_BGR";
            }
            case 6: {
                return "TYPE_4BYTE_ABGR";
            }
            case 7: {
                return "TYPE_4BYTE_ABGR_PRE";
            }
            case 8: {
                return "TYPE_SHORT_565_RGB";
            }
            case 9: {
                return "TYPE_SHORT_555_RGB";
            }
            case 10: {
                return "TYPE_BYTE_GRAY";
            }
            case 11: {
                return "TYPE_USHORT_GRAY";
            }
            case 12: {
                return "TYPE_BINARY";
            }
            case 13: {
                return "TYPE_BYTE_INDEXED";
            }
            case -1: {
                return "TYPE_ANY_UNARY";
            }
            case -2: {
                return "TYPE_ANY_BINARY";
            }
            case -3: {
                return "TYPE_INT_UNARY";
            }
            case -4: {
                return "TYPE_INT_BINARY";
            }
            case -5: {
                return "TYPE_SHORT_UNARY";
            }
            case -6: {
                return "TYPE_SHORT_BINARY";
            }
            case -7: {
                return "TYPE_BYTE_UNARY";
            }
            case -8: {
                return "TYPE_BYTE_BINARY";
            }
            case -10: {
                return "TYPE_INT_RGBx";
            }
            case -11: {
                return "TYPE_INT_BGRx";
            }
            case -12: {
                return "TYPE_24BIT_RGB";
            }
            case -13: {
                return "TYPE_DIB_xRGB";
            }
            case -14: {
                return "TYPE_INT_ARGB_BM";
            }
            case -15: {
                return "TYPE_INT_ARGB_PRE_BM";
            }
            case -16: {
                return "TYPE_BYTE_INDEXED_BM";
            }
            case -17: {
                return "TYPE_INDEX8_GRAY";
            }
            case -18: {
                return "TYPE_INDEX12_GRAY";
            }
        }
        return "TYPE_UNKNOWN";
    }
}

