/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.loops;

import java.awt.Color;
import java.awt.image.ColorModel;
import sun.java2d.loops.DrawBytes;
import sun.java2d.loops.DrawChars;
import sun.java2d.loops.DrawGlyphVector;
import sun.java2d.loops.DrawString;
import sun.java2d.loops.GraphicsPrimitive;
import sun.java2d.loops.GraphicsPrimitiveProxy;
import sun.java2d.loops.GraphicsPrimitives;

public class TextRendering
implements GraphicsPrimitives {
    static int[] ST_INT_ARGB = new int[]{2};
    static int[] ST_INT_RGB = new int[]{1};
    static int[] ST_INT_BGR = new int[]{4};
    static int[] ST_SHORT_555_RGB = new int[]{9};
    static int[] ST_SHORT_565_RGB = new int[]{8};
    static int[] ST_BYTE_INDEXED = new int[]{13};
    static int[] ST_BYTE_GRAY = new int[]{10};
    static int[] ST_INDEX8_GRAY = new int[]{-17};
    static int[] ST_3BYTE_BGR = new int[]{5};
    static int[] ST_24BIT_RGB = new int[]{-12};

    public final GraphicsPrimitive[] getPrimitives() {
        GraphicsPrimitive[] graphicsPrimitiveArray = new GraphicsPrimitive[]{new GraphicsPrimitiveProxy(this, "drawStringARGB", ST_INT_ARGB, DrawString.getMethodSignature()), new GraphicsPrimitiveProxy(this, "drawCharsARGB", ST_INT_ARGB, DrawChars.getMethodSignature()), new GraphicsPrimitiveProxy(this, "drawBytesARGB", ST_INT_ARGB, DrawBytes.getMethodSignature()), new GraphicsPrimitiveProxy(this, "drawGlyphVectorARGB", ST_INT_ARGB, DrawGlyphVector.getMethodSignature()), new GraphicsPrimitiveProxy(this, "drawStringRGB", ST_INT_RGB, DrawString.getMethodSignature()), new GraphicsPrimitiveProxy(this, "drawCharsRGB", ST_INT_RGB, DrawChars.getMethodSignature()), new GraphicsPrimitiveProxy(this, "drawBytesRGB", ST_INT_RGB, DrawBytes.getMethodSignature()), new GraphicsPrimitiveProxy(this, "drawGlyphVectorRGB", ST_INT_RGB, DrawGlyphVector.getMethodSignature()), new GraphicsPrimitiveProxy(this, "drawStringBGR", ST_INT_BGR, DrawString.getMethodSignature()), new GraphicsPrimitiveProxy(this, "drawCharsBGR", ST_INT_BGR, DrawChars.getMethodSignature()), new GraphicsPrimitiveProxy(this, "drawBytesBGR", ST_INT_BGR, DrawBytes.getMethodSignature()), new GraphicsPrimitiveProxy(this, "drawGlyphVectorBGR", ST_INT_BGR, DrawGlyphVector.getMethodSignature()), new GraphicsPrimitiveProxy(this, "drawString555", ST_SHORT_555_RGB, DrawString.getMethodSignature()), new GraphicsPrimitiveProxy(this, "drawChars555", ST_SHORT_555_RGB, DrawChars.getMethodSignature()), new GraphicsPrimitiveProxy(this, "drawBytes555", ST_SHORT_555_RGB, DrawBytes.getMethodSignature()), new GraphicsPrimitiveProxy(this, "drawGlyphVector555", ST_SHORT_555_RGB, DrawGlyphVector.getMethodSignature()), new GraphicsPrimitiveProxy(this, "drawString565", ST_SHORT_565_RGB, DrawString.getMethodSignature()), new GraphicsPrimitiveProxy(this, "drawChars565", ST_SHORT_565_RGB, DrawChars.getMethodSignature()), new GraphicsPrimitiveProxy(this, "drawBytes565", ST_SHORT_565_RGB, DrawBytes.getMethodSignature()), new GraphicsPrimitiveProxy(this, "drawGlyphVector565", ST_SHORT_565_RGB, DrawGlyphVector.getMethodSignature()), new GraphicsPrimitiveProxy(this, "drawStringIndexed", ST_BYTE_INDEXED, DrawString.getMethodSignature()), new GraphicsPrimitiveProxy(this, "drawCharsIndexed", ST_BYTE_INDEXED, DrawChars.getMethodSignature()), new GraphicsPrimitiveProxy(this, "drawBytesIndexed", ST_BYTE_INDEXED, DrawBytes.getMethodSignature()), new GraphicsPrimitiveProxy(this, "drawGlyphVectorIndexed", ST_BYTE_INDEXED, DrawGlyphVector.getMethodSignature()), new GraphicsPrimitiveProxy(this, "drawStringByteGray", ST_BYTE_GRAY, DrawString.getMethodSignature()), new GraphicsPrimitiveProxy(this, "drawCharsByteGray", ST_BYTE_GRAY, DrawChars.getMethodSignature()), new GraphicsPrimitiveProxy(this, "drawBytesByteGray", ST_BYTE_GRAY, DrawBytes.getMethodSignature()), new GraphicsPrimitiveProxy(this, "drawGlyphVectorByteGray", ST_BYTE_GRAY, DrawGlyphVector.getMethodSignature()), new GraphicsPrimitiveProxy(this, "drawStringIndex8Gray", ST_INDEX8_GRAY, DrawString.getMethodSignature()), new GraphicsPrimitiveProxy(this, "drawCharsIndex8Gray", ST_INDEX8_GRAY, DrawChars.getMethodSignature()), new GraphicsPrimitiveProxy(this, "drawBytesIndex8Gray", ST_INDEX8_GRAY, DrawBytes.getMethodSignature()), new GraphicsPrimitiveProxy(this, "drawGlyphVectorIndex8Gray", ST_INDEX8_GRAY, DrawGlyphVector.getMethodSignature()), new GraphicsPrimitiveProxy(this, "drawString24BITBGR", ST_3BYTE_BGR, DrawString.getMethodSignature()), new GraphicsPrimitiveProxy(this, "drawChars24BITBGR", ST_3BYTE_BGR, DrawChars.getMethodSignature()), new GraphicsPrimitiveProxy(this, "drawBytes24BITBGR", ST_3BYTE_BGR, DrawBytes.getMethodSignature()), new GraphicsPrimitiveProxy(this, "drawGlyphVector24BITBGR", ST_3BYTE_BGR, DrawGlyphVector.getMethodSignature()), new GraphicsPrimitiveProxy(this, "drawString24BITRGB", ST_24BIT_RGB, DrawString.getMethodSignature()), new GraphicsPrimitiveProxy(this, "drawChars24BITRGB", ST_24BIT_RGB, DrawChars.getMethodSignature()), new GraphicsPrimitiveProxy(this, "drawBytes24BITRGB", ST_24BIT_RGB, DrawBytes.getMethodSignature()), new GraphicsPrimitiveProxy(this, "drawGlyphVector24BITRGB", ST_24BIT_RGB, DrawGlyphVector.getMethodSignature())};
        return graphicsPrimitiveArray;
    }

    static int toGray16(Color color) {
        int n = color.getRGB();
        int n2 = n >> 16 & 0xFF;
        n2 += n2 << 8;
        int n3 = n >> 8 & 0xFF;
        n3 += n3 << 8;
        int n4 = n & 0xFF;
        n4 += n4 << 8;
        return (int)((double)n2 * 0.299 + (double)n3 * 0.587 + (double)n4 * 0.114);
    }

    static int toGray8(Color color) {
        int n = color.getRGB();
        int n2 = n >> 16 & 0xFF;
        int n3 = n >> 8 & 0xFF;
        int n4 = n & 0xFF;
        return (int)((double)n2 * 0.299 + (double)n3 * 0.587 + (double)n4 * 0.114);
    }

    static int toIndexed(Color color, ColorModel colorModel) {
        byte[] byArray = new byte[1];
        colorModel.getDataElements(color.getRGB(), byArray);
        return byArray[0];
    }

    static int toS555(Color color) {
        int n = color.getRGB();
        int n2 = n >> 19 & 0x1F;
        int n3 = n >> 11 & 0x1F;
        int n4 = n >> 3 & 0x1F;
        return n2 << 10 | n3 << 5 | n4;
    }

    static int toS565(Color color) {
        int n = color.getRGB();
        int n2 = n >> 19 & 0x1F;
        int n3 = n >> 10 & 0x3F;
        int n4 = n >> 3 & 0x1F;
        return n2 << 11 | n3 << 5 | n4;
    }

    static int toXBGR(Color color) {
        int n = color.getRGB();
        int n2 = n >> 16 & 0xFF;
        int n3 = n >> 8 & 0xFF;
        int n4 = n & 0xFF;
        return n4 << 16 | n3 << 8 | n2;
    }
}

