/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.pipe;

import java.awt.BasicStroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import sun.dc.path.PathConsumer;
import sun.dc.path.PathException;
import sun.dc.pr.PRException;
import sun.dc.pr.PathDasher;
import sun.dc.pr.PathStroker;
import sun.dc.pr.Rasterizer;

public class DuctusRenderer {
    static final int[] RasterizerCaps = new int[]{30, 10, 20};
    static final int[] RasterizerCorners = new int[]{50, 10, 40};
    private static Rasterizer theRasterizer;

    public static Rasterizer createShapeRasterizer(PathIterator pathIterator, AffineTransform affineTransform, BasicStroke basicStroke) {
        Rasterizer rasterizer = DuctusRenderer.getRasterizer();
        if (basicStroke != null) {
            Object[] objectArray;
            float[] fArray;
            rasterizer.setUsage(3);
            rasterizer.setPenDiameter(Math.max(basicStroke.getLineWidth(), 0.001f));
            rasterizer.setPenDisplacement(0.5f, 0.5f);
            if (affineTransform != null) {
                fArray = new float[4];
                objectArray = new double[6];
                affineTransform.getMatrix((double[])objectArray);
                int n = 0;
                while (n < 4) {
                    fArray[n] = (float)objectArray[n];
                    ++n;
                }
                rasterizer.setPenT4(fArray);
            } else {
                fArray = null;
            }
            rasterizer.setCaps(RasterizerCaps[basicStroke.getEndCap()]);
            rasterizer.setCorners(RasterizerCorners[basicStroke.getLineJoin()], basicStroke.getMiterLimit());
            objectArray = basicStroke.getDashArray();
            if (objectArray != null) {
                rasterizer.setDash((float[])objectArray, basicStroke.getDashPhase());
                rasterizer.setDashT4(fArray);
            }
            rasterizer.setPenFitting(0.01f, 15);
        } else {
            rasterizer.setUsage(pathIterator.getWindingRule() == 0 ? 1 : 2);
        }
        rasterizer.beginPath();
        boolean bl = false;
        float f = 0.0f;
        float f2 = 0.0f;
        float[] fArray = new float[6];
        while (!pathIterator.isDone()) {
            int n = pathIterator.currentSegment(fArray);
            if (bl) {
                bl = false;
                if (n != 0) {
                    rasterizer.beginSubpath(f, f2);
                }
            }
            switch (n) {
                case 0: {
                    f = fArray[0];
                    f2 = fArray[1];
                    rasterizer.beginSubpath(fArray[0], fArray[1]);
                    break;
                }
                case 1: {
                    rasterizer.appendLine(fArray[0], fArray[1]);
                    break;
                }
                case 2: {
                    rasterizer.appendQuadratic(fArray[0], fArray[1], fArray[2], fArray[3]);
                    break;
                }
                case 3: {
                    rasterizer.appendCubic(fArray[0], fArray[1], fArray[2], fArray[3], fArray[4], fArray[5]);
                    break;
                }
                case 4: {
                    rasterizer.closedSubpath();
                    bl = true;
                    break;
                }
            }
            pathIterator.next();
        }
        try {
            rasterizer.endPath();
        }
        catch (PRException pRException) {
            pRException.printStackTrace();
        }
        return rasterizer;
    }

    public static PathConsumer createStroker(PathConsumer pathConsumer, BasicStroke basicStroke, AffineTransform affineTransform) {
        Object[] objectArray;
        PathStroker pathStroker = new PathStroker(pathConsumer);
        pathConsumer = pathStroker;
        pathStroker.setPenDiameter(Math.max(basicStroke.getLineWidth(), 0.001f));
        float[] fArray = new float[6];
        fArray[0] = 1.0f;
        fArray[3] = 1.0f;
        fArray[4] = 0.5f;
        fArray[5] = 0.5f;
        float[] fArray2 = fArray;
        pathStroker.setOutputT6(fArray2);
        if (affineTransform != null) {
            objectArray = new double[6];
            affineTransform.getMatrix((double[])objectArray);
            int n = 0;
            while (n < 4) {
                fArray2[n] = (float)objectArray[n];
                ++n;
            }
        } else {
            fArray2 = null;
        }
        pathStroker.setPenT4(fArray2);
        pathStroker.setCaps(RasterizerCaps[basicStroke.getEndCap()]);
        pathStroker.setCorners(RasterizerCorners[basicStroke.getLineJoin()], basicStroke.getMiterLimit());
        objectArray = basicStroke.getDashArray();
        if (objectArray != null) {
            PathDasher pathDasher = new PathDasher(pathStroker);
            pathDasher.setDash((float[])objectArray, basicStroke.getDashPhase());
            pathDasher.setDashT4(fArray2);
            pathConsumer = pathDasher;
        }
        pathStroker.setPenFitting(0.01f, 100);
        return pathConsumer;
    }

    public static synchronized void dropRasterizer(Rasterizer rasterizer) {
        rasterizer.reset();
        theRasterizer = rasterizer;
    }

    public static void feedConsumer(PathIterator pathIterator, PathConsumer pathConsumer) throws PathException {
        pathConsumer.beginPath();
        boolean bl = false;
        float f = 0.0f;
        float f2 = 0.0f;
        float[] fArray = new float[6];
        while (!pathIterator.isDone()) {
            int n = pathIterator.currentSegment(fArray);
            if (bl) {
                bl = false;
                if (n != 0) {
                    pathConsumer.beginSubpath(f, f2);
                }
            }
            switch (n) {
                case 0: {
                    f = fArray[0];
                    f2 = fArray[1];
                    pathConsumer.beginSubpath(fArray[0], fArray[1]);
                    break;
                }
                case 1: {
                    pathConsumer.appendLine(fArray[0], fArray[1]);
                    break;
                }
                case 2: {
                    pathConsumer.appendQuadratic(fArray[0], fArray[1], fArray[2], fArray[3]);
                    break;
                }
                case 3: {
                    pathConsumer.appendCubic(fArray[0], fArray[1], fArray[2], fArray[3], fArray[4], fArray[5]);
                    break;
                }
                case 4: {
                    pathConsumer.closedSubpath();
                    bl = true;
                    break;
                }
            }
            pathIterator.next();
        }
        pathConsumer.endPath();
    }

    public static synchronized void getAlpha(Rasterizer rasterizer, byte[] byArray, int n, int n2, int n3) throws PRException {
        try {
            rasterizer.writeAlpha(byArray, n, n2, n3);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    public static synchronized Rasterizer getRasterizer() {
        Rasterizer rasterizer = theRasterizer;
        if (rasterizer == null) {
            rasterizer = new Rasterizer();
        } else {
            theRasterizer = null;
        }
        return rasterizer;
    }
}

