/*
 * Decompiled with CFR 0.152.
 */
package sun.jdbc.odbc;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Map;
import sun.jdbc.odbc.JdbcOdbc;
import sun.jdbc.odbc.JdbcOdbcBoundCol;
import sun.jdbc.odbc.JdbcOdbcInputStream;
import sun.jdbc.odbc.JdbcOdbcLimits;
import sun.jdbc.odbc.JdbcOdbcObject;
import sun.jdbc.odbc.JdbcOdbcPseudoCol;
import sun.jdbc.odbc.JdbcOdbcResultSetInterface;
import sun.jdbc.odbc.JdbcOdbcResultSetMetaData;
import sun.jdbc.odbc.JdbcOdbcSQLWarning;
import sun.jdbc.odbc.OdbcDef;

public class JdbcOdbcResultSet
extends JdbcOdbcObject
implements JdbcOdbcResultSetInterface {
    protected JdbcOdbc OdbcApi = null;
    protected int hDbc = 0;
    protected int hStmt = 0;
    protected SQLWarning lastWarning = null;
    protected boolean keepHSTMT = false;
    protected JdbcOdbcBoundCol[] boundCols;
    protected int numberOfCols;
    protected int numResultCols = -1;
    protected int firstPseudoCol;
    protected int lastPseudoCol;
    protected JdbcOdbcPseudoCol[] pseudoCols;
    protected int[] colMappings;
    protected ResultSetMetaData rsmd;
    private Hashtable colNameToNum;
    private Hashtable colNumToName;
    private boolean lastColumnNull = false;
    private boolean closed;
    private int sqlTypeColumn;
    private boolean freed;
    protected Statement ownerStatement;
    public int FETCH_FORWARD = 1000;
    public int FETCH_REVERSE = 1001;
    public int FETCH_UNKNOWN = 1002;
    public int TYPE_FORWARD_ONLY = 1003;
    public int TYPE_SCROLL_INSENSITIVE = 1004;
    public int TYPE_SCROLL_SENSITIVE = 1005;
    public int CONCUR_READ_ONLY = 1007;
    public int CONCUR_UPDATABLE = 1008;

    public boolean absolute(int n) {
        throw new UnsupportedOperationException();
    }

    public void afterLast() {
        throw new UnsupportedOperationException();
    }

    public void beforeFirst() {
        throw new UnsupportedOperationException();
    }

    public void cancelRowUpdates() {
        throw new UnsupportedOperationException();
    }

    public void clearWarnings() throws SQLException {
        this.lastWarning = null;
    }

    public synchronized void close() throws SQLException {
        this.closeInputStreams();
        this.clearWarnings();
        this.lastColumnNull = false;
        if (this.OdbcApi != null && this.hStmt != 0) {
            if (this.keepHSTMT) {
                if (!this.freed) {
                    this.OdbcApi.SQLFreeStmt(this.hStmt, 0);
                    this.freed = true;
                }
            } else {
                this.OdbcApi.SQLFreeStmt(this.hStmt, 1);
                this.hStmt = 0;
            }
            this.closed = true;
        }
    }

    protected void closeInputStreams() {
        int n = 0;
        while (n < this.numberOfCols) {
            this.boundCols[n].closeInputStream();
            ++n;
        }
    }

    public void deleteRow() {
        throw new UnsupportedOperationException();
    }

    protected void finalize() {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("ResultSet.finalize " + this);
        }
        try {
            this.close();
        }
        catch (SQLException sQLException) {}
    }

    public synchronized int findColumn(String string) throws SQLException {
        Integer n;
        if (this.rsmd == null) {
            this.rsmd = this.getMetaData();
            this.colNameToNum = new Hashtable();
            this.colNumToName = new Hashtable();
        }
        if ((n = (Integer)this.colNameToNum.get(string)) == null) {
            int n2 = 1;
            while (n2 <= this.rsmd.getColumnCount()) {
                String string2 = (String)this.colNumToName.get(new Integer(n2));
                if (string2 == null) {
                    string2 = this.rsmd.getColumnName(n2);
                    this.colNameToNum.put(string2, new Integer(n2));
                    this.colNumToName.put(new Integer(n2), string2);
                }
                if (string2.equalsIgnoreCase(string)) {
                    return n2;
                }
                ++n2;
            }
            throw new SQLException("Column not found", "S0022");
        }
        return n;
    }

    public boolean first() {
        throw new UnsupportedOperationException();
    }

    public Array getArray(int n) {
        throw new UnsupportedOperationException();
    }

    public Array getArray(String string) {
        throw new UnsupportedOperationException();
    }

    public InputStream getAsciiStream(int n) throws SQLException {
        this.clearWarnings();
        this.lastColumnNull = false;
        n = this.mapColumn(n);
        int n2 = this.getColumnType(n);
        int n3 = -2;
        switch (n2) {
            case -1: 
            case 1: 
            case 12: {
                n3 = 1;
                break;
            }
        }
        JdbcOdbcInputStream jdbcOdbcInputStream = new JdbcOdbcInputStream(this.OdbcApi, this.hStmt, n, 1, n3, this.ownerStatement);
        this.setInputStream(n, jdbcOdbcInputStream);
        return jdbcOdbcInputStream;
    }

    public InputStream getAsciiStream(String string) throws SQLException {
        return this.getAsciiStream(this.findColumn(string));
    }

    public BigDecimal getBigDecimal(int n) {
        throw new UnsupportedOperationException();
    }

    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        BigDecimal bigDecimal = null;
        this.clearWarnings();
        this.lastColumnNull = false;
        n = this.mapColumn(n);
        if (this.getPseudoCol(n) == null) {
            String string = this.getDataString(n, 300, true);
            if (string != null) {
                bigDecimal = new BigDecimal(string);
                bigDecimal = bigDecimal.setScale(n2, 6);
            }
        } else {
            this.lastColumnNull = true;
        }
        return bigDecimal;
    }

    public BigDecimal getBigDecimal(String string) {
        throw new UnsupportedOperationException();
    }

    public BigDecimal getBigDecimal(String string, int n) throws SQLException {
        return this.getBigDecimal(this.findColumn(string), n);
    }

    public InputStream getBinaryStream(int n) throws SQLException {
        this.clearWarnings();
        this.lastColumnNull = false;
        n = this.mapColumn(n);
        int n2 = this.getColumnType(n);
        int n3 = -2;
        switch (n2) {
            case -1: 
            case 1: 
            case 12: {
                n3 = 1;
                break;
            }
        }
        JdbcOdbcInputStream jdbcOdbcInputStream = new JdbcOdbcInputStream(this.OdbcApi, this.hStmt, n, 3, n3, this.ownerStatement);
        this.setInputStream(n, jdbcOdbcInputStream);
        return jdbcOdbcInputStream;
    }

    public InputStream getBinaryStream(String string) throws SQLException {
        return this.getBinaryStream(this.findColumn(string));
    }

    public Blob getBlob(int n) {
        throw new UnsupportedOperationException();
    }

    public Blob getBlob(String string) {
        throw new UnsupportedOperationException();
    }

    public boolean getBoolean(int n) throws SQLException {
        boolean bl = false;
        this.clearWarnings();
        this.lastColumnNull = false;
        n = this.mapColumn(n);
        if (this.getPseudoCol(n) == null) {
            bl = this.getInt(n) != 0;
        } else {
            this.lastColumnNull = true;
        }
        return bl;
    }

    public boolean getBoolean(String string) throws SQLException {
        return this.getBoolean(this.findColumn(string));
    }

    public byte getByte(int n) throws SQLException {
        byte by = 0;
        this.clearWarnings();
        this.lastColumnNull = false;
        n = this.mapColumn(n);
        if (this.getPseudoCol(n) == null) {
            by = (byte)this.getInt(n);
        } else {
            this.lastColumnNull = true;
        }
        return by;
    }

    public byte getByte(String string) throws SQLException {
        return this.getByte(this.findColumn(string));
    }

    public synchronized byte[] getBytes(int n) throws SQLException {
        byte[] byArray;
        int n2;
        this.clearWarnings();
        this.lastColumnNull = false;
        n = this.mapColumn(n);
        if (this.getPseudoCol(n) != null) {
            this.lastColumnNull = true;
            return null;
        }
        int n3 = this.getMaxBinaryLen(n);
        if (n3 == -1) {
            return null;
        }
        int n4 = this.getColumnType(n);
        byte[] byArray2 = new byte[n3];
        try {
            n2 = this.OdbcApi.SQLGetDataBinary(this.hStmt, n, byArray2);
        }
        catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
            Integer n5 = (Integer)jdbcOdbcSQLWarning.value;
            n2 = n5;
        }
        if (n2 == -1) {
            this.lastColumnNull = true;
            byArray2 = null;
        }
        if (n4 != -2 && n2 != n3) {
            byte[] byArray3 = new byte[n2];
            System.arraycopy(byArray2, 0, byArray3, 0, n2);
            return byArray3;
        }
        if (n2 < JdbcOdbcLimits.MAX_GET_DATA_LENGTH) {
            return byArray2;
        }
        Hashtable hashtable = new Hashtable();
        int n6 = 0;
        int n7 = 0;
        hashtable.put(new Integer(n6++), byArray2);
        while (n2 != -1) {
            n7 += n2;
            byArray = new byte[n3];
            try {
                n2 = this.OdbcApi.SQLGetDataBinary(this.hStmt, n, byArray);
            }
            catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
                Integer n8 = (Integer)jdbcOdbcSQLWarning.value;
                n2 = n8;
            }
            hashtable.put(new Integer(n6++), byArray);
        }
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Total bytes read: " + n7 + ".  Creating buffer");
        }
        byArray = new byte[n7];
        int n9 = 0;
        int n10 = 0;
        while (n10 < n6) {
            byArray2 = (byte[])hashtable.get(new Integer(n10));
            n2 = n7;
            if (n2 > JdbcOdbcLimits.MAX_GET_DATA_LENGTH) {
                n2 = JdbcOdbcLimits.MAX_GET_DATA_LENGTH;
            }
            n7 -= n2;
            System.arraycopy(byArray2, 0, byArray, n9, n2);
            n9 += n2;
            ++n10;
        }
        return byArray;
    }

    public byte[] getBytes(String string) throws SQLException {
        return this.getBytes(this.findColumn(string));
    }

    public Reader getCharacterStream(int n) {
        throw new UnsupportedOperationException();
    }

    public Reader getCharacterStream(String string) {
        throw new UnsupportedOperationException();
    }

    public Clob getClob(int n) {
        throw new UnsupportedOperationException();
    }

    public Clob getClob(String string) {
        throw new UnsupportedOperationException();
    }

    public int getColAttribute(int n, int n2) throws SQLException {
        int n3 = 0;
        this.clearWarnings();
        try {
            n3 = this.OdbcApi.SQLColAttributes(this.hStmt, n, n2);
        }
        catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
            BigDecimal bigDecimal = (BigDecimal)jdbcOdbcSQLWarning.value;
            n3 = bigDecimal.intValue();
            this.setWarning(JdbcOdbc.convertWarning(jdbcOdbcSQLWarning));
        }
        return n3;
    }

    public int getColumnCount() throws SQLException {
        int n = 0;
        this.clearWarnings();
        if (this.lastPseudoCol > 0) {
            return this.lastPseudoCol;
        }
        if (this.colMappings != null) {
            return this.colMappings.length;
        }
        try {
            if (this.numResultCols == -1) {
                this.numResultCols = this.OdbcApi.SQLNumResultCols(this.hStmt);
            }
            n = this.numResultCols;
        }
        catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
            BigDecimal bigDecimal = (BigDecimal)jdbcOdbcSQLWarning.value;
            n = bigDecimal.intValue();
            this.setWarning(JdbcOdbc.convertWarning(jdbcOdbcSQLWarning));
        }
        return n;
    }

    public int getColumnLength(int n) throws SQLException {
        int n2 = -1;
        if (n > 0 && n <= this.numberOfCols) {
            n2 = this.boundCols[n - 1].getLength();
        }
        if (n2 == -1) {
            n2 = this.getColAttribute(n, 3);
            if (n > 0 && n <= this.numberOfCols) {
                this.boundCols[n - 1].setLength(n2);
            }
        }
        return n2;
    }

    public int getColumnType(int n) throws SQLException {
        int n2 = 9999;
        if (n > 0 && n <= this.numberOfCols) {
            n2 = this.boundCols[n - 1].getType();
        }
        if (n2 == 9999) {
            n2 = this.getColAttribute(n, 2);
            n2 = OdbcDef.odbcTypeToJdbc(n2);
            if (n > 0 && n <= this.numberOfCols) {
                this.boundCols[n - 1].setType(n2);
            }
        }
        return n2;
    }

    public int getConcurrency() {
        throw new UnsupportedOperationException();
    }

    public String getCursorName() throws SQLException {
        String string = "";
        this.clearWarnings();
        try {
            string = this.OdbcApi.SQLGetCursorName(this.hStmt);
        }
        catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
            string = (String)jdbcOdbcSQLWarning.value;
            this.setWarning(JdbcOdbc.convertWarning(jdbcOdbcSQLWarning));
        }
        return string.trim();
    }

    public Double getDataDouble(int n) throws SQLException {
        Double d;
        this.lastColumnNull = false;
        try {
            d = this.OdbcApi.SQLGetDataDouble(this.hStmt, n);
        }
        catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
            d = (Double)jdbcOdbcSQLWarning.value;
            this.setWarning(JdbcOdbc.convertWarning(jdbcOdbcSQLWarning));
        }
        if (d == null) {
            this.lastColumnNull = true;
        }
        return d;
    }

    public Float getDataFloat(int n) throws SQLException {
        Float f;
        this.lastColumnNull = false;
        try {
            f = this.OdbcApi.SQLGetDataFloat(this.hStmt, n);
        }
        catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
            f = (Float)jdbcOdbcSQLWarning.value;
            this.setWarning(JdbcOdbc.convertWarning(jdbcOdbcSQLWarning));
        }
        if (f == null) {
            this.lastColumnNull = true;
        }
        return f;
    }

    public Integer getDataInteger(int n) throws SQLException {
        Integer n2;
        this.lastColumnNull = false;
        try {
            n2 = this.OdbcApi.SQLGetDataInteger(this.hStmt, n);
        }
        catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
            n2 = (Integer)jdbcOdbcSQLWarning.value;
            this.setWarning(JdbcOdbc.convertWarning(jdbcOdbcSQLWarning));
        }
        if (n2 == null) {
            this.lastColumnNull = true;
        } else if (n == this.sqlTypeColumn) {
            n2 = new Integer(OdbcDef.odbcTypeToJdbc(n2));
        }
        return n2;
    }

    public Long getDataLong(int n) throws SQLException {
        Long l = null;
        Double d = this.getDataDouble(n);
        if (d != null) {
            l = new Long(d.longValue());
        }
        return l;
    }

    public String getDataString(int n, int n2, boolean bl) throws SQLException {
        String string;
        block5: {
            block4: {
                this.lastColumnNull = false;
                try {
                    string = this.OdbcApi.SQLGetDataString(this.hStmt, n, n2, bl);
                }
                catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
                    string = (String)jdbcOdbcSQLWarning.value;
                    this.setWarning(JdbcOdbc.convertWarning(jdbcOdbcSQLWarning));
                }
                if (string != null) break block4;
                this.lastColumnNull = true;
                break block5;
            }
            if (n != this.sqlTypeColumn) break block5;
            try {
                int n3 = OdbcDef.odbcTypeToJdbc(Integer.valueOf(string));
                string = String.valueOf(n3);
            }
            catch (Exception exception) {}
        }
        return string;
    }

    public String getDataStringDate(int n) throws SQLException {
        String string;
        this.lastColumnNull = false;
        try {
            string = this.OdbcApi.SQLGetDataStringDate(this.hStmt, n);
        }
        catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
            string = (String)jdbcOdbcSQLWarning.value;
            this.setWarning(JdbcOdbc.convertWarning(jdbcOdbcSQLWarning));
        }
        if (string == null) {
            this.lastColumnNull = true;
        }
        return string;
    }

    public String getDataStringTime(int n) throws SQLException {
        String string;
        this.lastColumnNull = false;
        try {
            string = this.OdbcApi.SQLGetDataStringTime(this.hStmt, n);
        }
        catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
            string = (String)jdbcOdbcSQLWarning.value;
            this.setWarning(JdbcOdbc.convertWarning(jdbcOdbcSQLWarning));
        }
        if (string == null) {
            this.lastColumnNull = true;
        }
        return string;
    }

    public String getDataStringTimestamp(int n) throws SQLException {
        String string;
        this.lastColumnNull = false;
        try {
            string = this.OdbcApi.SQLGetDataStringTimestamp(this.hStmt, n);
        }
        catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
            string = (String)jdbcOdbcSQLWarning.value;
            this.setWarning(JdbcOdbc.convertWarning(jdbcOdbcSQLWarning));
        }
        if (string == null) {
            this.lastColumnNull = true;
        }
        return string;
    }

    public Date getDate(int n) throws SQLException {
        this.clearWarnings();
        this.lastColumnNull = false;
        n = this.mapColumn(n);
        if (this.getPseudoCol(n) != null) {
            this.lastColumnNull = true;
            return null;
        }
        String string = this.getDataStringDate(n);
        if (string == null) {
            return null;
        }
        return Date.valueOf(string);
    }

    public Date getDate(int n, Calendar calendar) {
        throw new UnsupportedOperationException();
    }

    public Date getDate(String string) throws SQLException {
        return this.getDate(this.findColumn(string));
    }

    public Date getDate(String string, Calendar calendar) {
        throw new UnsupportedOperationException();
    }

    public double getDouble(int n) throws SQLException {
        double d = 0.0;
        this.clearWarnings();
        this.lastColumnNull = false;
        n = this.mapColumn(n);
        if (this.getPseudoCol(n) == null) {
            Double d2 = this.getDataDouble(n);
            if (d2 != null) {
                d = d2;
            }
        } else {
            this.lastColumnNull = true;
        }
        return d;
    }

    public double getDouble(String string) throws SQLException {
        return this.getDouble(this.findColumn(string));
    }

    public int getFetchDirection() {
        throw new UnsupportedOperationException();
    }

    public int getFetchSize() {
        throw new UnsupportedOperationException();
    }

    public float getFloat(int n) throws SQLException {
        float f = 0.0f;
        this.clearWarnings();
        this.lastColumnNull = false;
        n = this.mapColumn(n);
        if (this.getPseudoCol(n) == null) {
            Float f2 = this.getDataFloat(n);
            if (f2 != null) {
                f = f2.floatValue();
            }
        } else {
            this.lastColumnNull = true;
        }
        return f;
    }

    public float getFloat(String string) throws SQLException {
        return this.getFloat(this.findColumn(string));
    }

    public int getHSTMT() {
        return this.hStmt;
    }

    public int getInt(int n) throws SQLException {
        int n2 = 0;
        this.clearWarnings();
        this.lastColumnNull = false;
        n = this.mapColumn(n);
        if (this.getPseudoCol(n) == null) {
            Integer n3 = this.getDataInteger(n);
            if (n3 != null) {
                n2 = n3;
            }
        } else {
            this.lastColumnNull = true;
        }
        return n2;
    }

    public int getInt(String string) throws SQLException {
        return this.getInt(this.findColumn(string));
    }

    public long getLong(int n) throws SQLException {
        long l = 0L;
        this.clearWarnings();
        this.lastColumnNull = false;
        n = this.mapColumn(n);
        if (this.getPseudoCol(n) == null) {
            Double d = this.getDataDouble(n);
            if (d != null) {
                l = d.longValue();
            }
        } else {
            this.lastColumnNull = true;
        }
        return l;
    }

    public long getLong(String string) throws SQLException {
        return this.getLong(this.findColumn(string));
    }

    protected int getMaxBinaryLen(int n) throws SQLException {
        int n2 = this.getColumnLength(n);
        if (n2 != -1 && (n2 <= 0 || n2 > JdbcOdbcLimits.MAX_GET_DATA_LENGTH)) {
            n2 = JdbcOdbcLimits.MAX_GET_DATA_LENGTH;
        }
        return n2;
    }

    protected int getMaxCharLen(int n) throws SQLException {
        int n2 = this.getColumnType(n);
        int n3 = this.getColumnLength(n);
        if (n3 != -1) {
            switch (n2) {
                case -4: 
                case -3: 
                case -2: {
                    n3 *= 2;
                    break;
                }
                case 91: {
                    n3 = 10;
                    break;
                }
                case 92: {
                    n3 = 8;
                    break;
                }
                case 93: {
                    n3 = 29;
                    break;
                }
                case 2: 
                case 3: {
                    n3 += 2;
                    break;
                }
                case -7: {
                    n3 = 1;
                    break;
                }
                case -6: {
                    n3 = 4;
                    break;
                }
                case 5: {
                    n3 = 6;
                    break;
                }
                case 4: {
                    n3 = 11;
                    break;
                }
                case -5: {
                    n3 = 20;
                    break;
                }
                case 7: {
                    n3 = 13;
                    break;
                }
                case 6: 
                case 8: {
                    n3 = 22;
                    break;
                }
            }
            if (n3 <= 0 || n3 > JdbcOdbcLimits.MAX_GET_DATA_LENGTH) {
                n3 = JdbcOdbcLimits.MAX_GET_DATA_LENGTH;
            }
        }
        return n3;
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*ResultSet.getMetaData");
        }
        if (this.closed) {
            throw new SQLException("ResultSet is closed");
        }
        return new JdbcOdbcResultSetMetaData(this.OdbcApi, this);
    }

    public Object getObject(int n) throws SQLException {
        Object object = null;
        int n2 = this.getColumnType(n);
        int n3 = n;
        this.clearWarnings();
        this.lastColumnNull = false;
        n = this.mapColumn(n);
        if (this.getPseudoCol(n) != null) {
            this.lastColumnNull = true;
            return null;
        }
        switch (n2) {
            case -1: 
            case 1: 
            case 12: {
                object = this.getString(n);
                break;
            }
            case 2: 
            case 3: {
                object = this.getBigDecimal(n, this.getScale(n3));
                break;
            }
            case -7: {
                object = new Boolean(this.getBoolean(n));
                break;
            }
            case -6: 
            case 4: 
            case 5: {
                object = new Integer(this.getInt(n));
                break;
            }
            case -5: {
                object = new Long(this.getLong(n));
                break;
            }
            case 7: {
                object = new Float(this.getFloat(n));
                break;
            }
            case 6: 
            case 8: {
                object = new Double(this.getDouble(n));
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                object = this.getBytes(n);
                break;
            }
            case 91: {
                object = this.getDate(n);
                break;
            }
            case 92: {
                object = this.getTime(n);
                break;
            }
            case 93: {
                object = this.getTimestamp(n);
                break;
            }
        }
        if (this.wasNull()) {
            object = null;
        }
        return object;
    }

    public Object getObject(int n, Map map) {
        throw new UnsupportedOperationException();
    }

    public Object getObject(String string) throws SQLException {
        return this.getObject(this.findColumn(string));
    }

    public Object getObject(String string, Map map) {
        throw new UnsupportedOperationException();
    }

    public JdbcOdbcPseudoCol getPseudoCol(int n) {
        JdbcOdbcPseudoCol jdbcOdbcPseudoCol = null;
        if (n > 0 && n >= this.firstPseudoCol && n <= this.lastPseudoCol) {
            jdbcOdbcPseudoCol = this.pseudoCols[n - this.firstPseudoCol];
        }
        return jdbcOdbcPseudoCol;
    }

    public Ref getRef(int n) {
        throw new UnsupportedOperationException();
    }

    public Ref getRef(String string) {
        throw new UnsupportedOperationException();
    }

    public int getRow() {
        throw new UnsupportedOperationException();
    }

    public int getRowCount() throws SQLException {
        int n = 0;
        this.clearWarnings();
        try {
            n = this.OdbcApi.SQLRowCount(this.hStmt);
        }
        catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
            BigDecimal bigDecimal = (BigDecimal)jdbcOdbcSQLWarning.value;
            n = bigDecimal.intValue();
            this.setWarning(JdbcOdbc.convertWarning(jdbcOdbcSQLWarning));
        }
        return n;
    }

    public int getRowNumber() throws SQLException {
        int n = 0;
        this.clearWarnings();
        try {
            n = this.OdbcApi.SQLGetStmtOption(this.hStmt, (short)14);
        }
        catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
            BigDecimal bigDecimal = (BigDecimal)jdbcOdbcSQLWarning.value;
            n = bigDecimal.intValue();
            this.setWarning(JdbcOdbc.convertWarning(jdbcOdbcSQLWarning));
        }
        return n;
    }

    public int getScale(int n) throws SQLException {
        int n2;
        if (this.getPseudoCol(n) != null) {
            this.lastColumnNull = true;
            n2 = 0;
        } else {
            n2 = this.getColAttribute(n, 5);
        }
        return n2;
    }

    public short getShort(int n) throws SQLException {
        short s = 0;
        this.clearWarnings();
        this.lastColumnNull = false;
        n = this.mapColumn(n);
        if (this.getPseudoCol(n) == null) {
            s = (short)this.getInt(n);
        } else {
            this.lastColumnNull = true;
        }
        return s;
    }

    public short getShort(String string) throws SQLException {
        return this.getShort(this.findColumn(string));
    }

    public Statement getStatement() {
        throw new UnsupportedOperationException();
    }

    public String getString(int n) throws SQLException {
        String string;
        this.clearWarnings();
        this.lastColumnNull = false;
        n = this.mapColumn(n);
        if (this.getPseudoCol(n) != null) {
            this.lastColumnNull = true;
            return null;
        }
        int n2 = this.getMaxCharLen(n);
        if (n2 == -1) {
            return null;
        }
        boolean bl = false;
        int n3 = this.getColumnType(n);
        if ((string = this.getDataString(n, ++n2, bl)) == null) {
            return string;
        }
        int n4 = string.length();
        if (n4 == n2 - 1 && !bl) {
            string = string.substring(0, n2 - 1);
        }
        if ((n3 == -1 || n3 == -4) && n4 == n2 - 1) {
            String string2 = string;
            while (string2.length() == JdbcOdbcLimits.MAX_GET_DATA_LENGTH) {
                string2 = this.getDataString(n, n2, bl);
                if (string2 == null) break;
                if (JdbcOdbcObject.isTracing()) {
                    JdbcOdbcObject.trace(string2.length() + " byte(s) read");
                }
                if (string2.length() == n2) {
                    string2 = string2.substring(0, n2 - 1);
                }
                string = String.valueOf(string) + string2;
                if (!JdbcOdbcObject.isTracing()) continue;
                JdbcOdbcObject.trace(string.length() + " bytes total");
            }
        }
        return string;
    }

    public String getString(String string) throws SQLException {
        return this.getString(this.findColumn(string));
    }

    public Time getTime(int n) throws SQLException {
        this.clearWarnings();
        this.lastColumnNull = false;
        n = this.mapColumn(n);
        if (this.getPseudoCol(n) != null) {
            this.lastColumnNull = true;
            return null;
        }
        String string = this.getDataStringTime(n);
        if (string == null) {
            return null;
        }
        return Time.valueOf(string);
    }

    public Time getTime(int n, Calendar calendar) {
        throw new UnsupportedOperationException();
    }

    public Time getTime(String string) throws SQLException {
        return this.getTime(this.findColumn(string));
    }

    public Time getTime(String string, Calendar calendar) {
        throw new UnsupportedOperationException();
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        this.clearWarnings();
        this.lastColumnNull = false;
        n = this.mapColumn(n);
        if (this.getPseudoCol(n) != null) {
            this.lastColumnNull = true;
            return null;
        }
        String string = this.getDataStringTimestamp(n);
        if (string == null) {
            return null;
        }
        if (string.length() == 10) {
            string = String.valueOf(string) + " 00:00:00";
        }
        return Timestamp.valueOf(string);
    }

    public Timestamp getTimestamp(int n, Calendar calendar) {
        throw new UnsupportedOperationException();
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        return this.getTimestamp(this.findColumn(string));
    }

    public Timestamp getTimestamp(String string, Calendar calendar) {
        throw new UnsupportedOperationException();
    }

    public int getType() {
        throw new UnsupportedOperationException();
    }

    public InputStream getUnicodeStream(int n) throws SQLException {
        this.clearWarnings();
        this.lastColumnNull = false;
        n = this.mapColumn(n);
        int n2 = this.getColumnType(n);
        int n3 = -2;
        switch (n2) {
            case -1: 
            case 1: 
            case 12: {
                n3 = 1;
                break;
            }
        }
        JdbcOdbcInputStream jdbcOdbcInputStream = new JdbcOdbcInputStream(this.OdbcApi, this.hStmt, n, 2, n3, this.ownerStatement);
        this.setInputStream(n, jdbcOdbcInputStream);
        return jdbcOdbcInputStream;
    }

    public InputStream getUnicodeStream(String string) throws SQLException {
        return this.getUnicodeStream(this.findColumn(string));
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.lastWarning;
    }

    public void initialize(JdbcOdbc jdbcOdbc, int n, int n2, boolean bl, Statement statement) throws SQLException {
        this.OdbcApi = jdbcOdbc;
        this.hDbc = n;
        this.hStmt = n2;
        this.keepHSTMT = bl;
        this.numberOfCols = this.getColumnCount();
        this.boundCols = new JdbcOdbcBoundCol[this.numberOfCols];
        int n3 = 0;
        while (n3 < this.numberOfCols) {
            this.boundCols[n3] = new JdbcOdbcBoundCol();
            ++n3;
        }
        this.ownerStatement = statement;
    }

    public void insertRow() {
        throw new UnsupportedOperationException();
    }

    public boolean isAfterLast() {
        throw new UnsupportedOperationException();
    }

    public boolean isBeforeFirst() {
        throw new UnsupportedOperationException();
    }

    public boolean isFirst() {
        throw new UnsupportedOperationException();
    }

    public boolean isLast() {
        throw new UnsupportedOperationException();
    }

    public boolean last() {
        throw new UnsupportedOperationException();
    }

    public int mapColumn(int n) {
        int n2 = n;
        if (this.colMappings != null) {
            n2 = n > 0 && n <= this.colMappings.length ? this.colMappings[n - 1] : -1;
        }
        return n2;
    }

    public String mapColumnName(String string, int n) {
        if (n > 0 && n <= this.numberOfCols) {
            return this.boundCols[n - 1].mapAliasName(string);
        }
        return string;
    }

    public void moveToCurrentRow() {
        throw new UnsupportedOperationException();
    }

    public void moveToInsertRow() {
        throw new UnsupportedOperationException();
    }

    public boolean next() throws SQLException {
        boolean bl = true;
        this.lastColumnNull = false;
        this.closeInputStreams();
        this.clearWarnings();
        try {
            bl = this.OdbcApi.SQLFetch(this.hStmt);
        }
        catch (SQLWarning sQLWarning) {
            this.setWarning(sQLWarning);
        }
        return bl;
    }

    public boolean previous() {
        throw new UnsupportedOperationException();
    }

    public void refreshRow() {
        throw new UnsupportedOperationException();
    }

    public boolean relative(int n) {
        throw new UnsupportedOperationException();
    }

    public boolean rowDeleted() {
        throw new UnsupportedOperationException();
    }

    public boolean rowInserted() {
        throw new UnsupportedOperationException();
    }

    public boolean rowUpdated() {
        throw new UnsupportedOperationException();
    }

    public void setAliasColumnName(String string, int n) {
        if (n > 0 && n <= this.numberOfCols) {
            this.boundCols[n - 1].setAliasName(string);
        }
    }

    public void setColumnMappings(int[] nArray) {
        this.colMappings = nArray;
    }

    public void setFetchDirection(int n) {
        throw new UnsupportedOperationException();
    }

    public void setFetchSize(int n) {
        throw new UnsupportedOperationException();
    }

    protected void setInputStream(int n, JdbcOdbcInputStream jdbcOdbcInputStream) {
        if (n > 0 && n <= this.numberOfCols) {
            this.boundCols[n - 1].setInputStream(jdbcOdbcInputStream);
        }
    }

    public void setPseudoCols(int n, int n2, JdbcOdbcPseudoCol[] jdbcOdbcPseudoColArray) {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Setting pseudo columns, first=" + n + ", last=" + n2);
        }
        this.firstPseudoCol = n;
        this.lastPseudoCol = n2;
        this.pseudoCols = jdbcOdbcPseudoColArray;
    }

    public void setSQLTypeColumn(int n) {
        this.sqlTypeColumn = n;
    }

    public void setWarning(SQLWarning sQLWarning) throws SQLException {
        this.lastWarning = sQLWarning;
    }

    public void updateAsciiStream(int n, InputStream inputStream, int n2) {
        throw new UnsupportedOperationException();
    }

    public void updateAsciiStream(String string, InputStream inputStream, int n) {
        throw new UnsupportedOperationException();
    }

    public void updateBigDecimal(int n, BigDecimal bigDecimal) {
        throw new UnsupportedOperationException();
    }

    public void updateBigDecimal(String string, BigDecimal bigDecimal) {
        throw new UnsupportedOperationException();
    }

    public void updateBinaryStream(int n, InputStream inputStream, int n2) {
        throw new UnsupportedOperationException();
    }

    public void updateBinaryStream(String string, InputStream inputStream, int n) {
        throw new UnsupportedOperationException();
    }

    public void updateBoolean(int n, boolean bl) {
        throw new UnsupportedOperationException();
    }

    public void updateBoolean(String string, boolean bl) {
        throw new UnsupportedOperationException();
    }

    public void updateByte(int n, byte by) {
        throw new UnsupportedOperationException();
    }

    public void updateByte(String string, byte by) {
        throw new UnsupportedOperationException();
    }

    public void updateBytes(int n, byte[] byArray) {
        throw new UnsupportedOperationException();
    }

    public void updateBytes(String string, byte[] byArray) {
        throw new UnsupportedOperationException();
    }

    public void updateCharacterStream(int n, Reader reader, int n2) {
        throw new UnsupportedOperationException();
    }

    public void updateCharacterStream(String string, Reader reader, int n) {
        throw new UnsupportedOperationException();
    }

    public void updateDate(int n, Date date) {
        throw new UnsupportedOperationException();
    }

    public void updateDate(String string, Date date) {
        throw new UnsupportedOperationException();
    }

    public void updateDouble(int n, double d) {
        throw new UnsupportedOperationException();
    }

    public void updateDouble(String string, double d) {
        throw new UnsupportedOperationException();
    }

    public void updateFloat(int n, float f) {
        throw new UnsupportedOperationException();
    }

    public void updateFloat(String string, float f) {
        throw new UnsupportedOperationException();
    }

    public void updateInt(int n, int n2) {
        throw new UnsupportedOperationException();
    }

    public void updateInt(String string, int n) {
        throw new UnsupportedOperationException();
    }

    public void updateLong(int n, long l) {
        throw new UnsupportedOperationException();
    }

    public void updateLong(String string, long l) {
        throw new UnsupportedOperationException();
    }

    public void updateNull(int n) {
        throw new UnsupportedOperationException();
    }

    public void updateNull(String string) {
        throw new UnsupportedOperationException();
    }

    public void updateObject(int n, Object object) {
        throw new UnsupportedOperationException();
    }

    public void updateObject(int n, Object object, int n2) {
        throw new UnsupportedOperationException();
    }

    public void updateObject(String string, Object object) {
        throw new UnsupportedOperationException();
    }

    public void updateObject(String string, Object object, int n) {
        throw new UnsupportedOperationException();
    }

    public void updateRow() {
        throw new UnsupportedOperationException();
    }

    public void updateShort(int n, short s) {
        throw new UnsupportedOperationException();
    }

    public void updateShort(String string, short s) {
        throw new UnsupportedOperationException();
    }

    public void updateString(int n, String string) {
        throw new UnsupportedOperationException();
    }

    public void updateString(String string, String string2) {
        throw new UnsupportedOperationException();
    }

    public void updateTime(int n, Time time) {
        throw new UnsupportedOperationException();
    }

    public void updateTime(String string, Time time) {
        throw new UnsupportedOperationException();
    }

    public void updateTimestamp(int n, Timestamp timestamp) {
        throw new UnsupportedOperationException();
    }

    public void updateTimestamp(String string, Timestamp timestamp) {
        throw new UnsupportedOperationException();
    }

    public boolean wasNull() throws SQLException {
        return this.lastColumnNull;
    }
}

