/*
 * Decompiled with CFR 0.152.
 */
package sun.misc;

import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.PropertyPermission;
import sun.misc.Launcher;

class PathPermissions
extends PermissionCollection {
    private File[] path;
    private Permissions perms;
    URL codeBase;

    PathPermissions(File[] fileArray) {
        this.path = fileArray;
        this.perms = null;
        this.codeBase = null;
    }

    public void add(Permission permission) {
        throw new SecurityException("attempt to add a permission");
    }

    public Enumeration elements() {
        if (this.perms == null) {
            this.init();
        }
        return this.perms.elements();
    }

    URL getCodeBase() {
        return this.codeBase;
    }

    public boolean implies(Permission permission) {
        if (this.perms == null) {
            this.init();
        }
        return this.perms.implies(permission);
    }

    private synchronized void init() {
        if (this.perms != null) {
            return;
        }
        this.perms = new Permissions();
        this.perms.add(new RuntimePermission("createClassLoader"));
        this.perms.add(new PropertyPermission("java.*", "read"));
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                int n = 0;
                while (n < PathPermissions.this.path.length) {
                    String string;
                    File file = PathPermissions.this.path[n];
                    try {
                        string = file.getCanonicalPath();
                    }
                    catch (IOException iOException) {
                        string = file.getAbsolutePath();
                    }
                    if (n == 0) {
                        PathPermissions.this.codeBase = Launcher.getFileURL(new File(string));
                    }
                    if (file.isDirectory()) {
                        if (string.endsWith(File.separator)) {
                            PathPermissions.this.perms.add(new FilePermission(String.valueOf(string) + "-", "read"));
                        } else {
                            PathPermissions.this.perms.add(new FilePermission(String.valueOf(string) + File.separator + "-", "read"));
                        }
                    } else {
                        int n2 = string.lastIndexOf(File.separatorChar);
                        if (n2 != -1) {
                            string = String.valueOf(string.substring(0, n2 + 1)) + "-";
                            PathPermissions.this.perms.add(new FilePermission(string, "read"));
                        }
                    }
                    ++n;
                }
                return null;
            }
        });
    }

    public String toString() {
        if (this.perms == null) {
            this.init();
        }
        return this.perms.toString();
    }
}

