/*
 * Decompiled with CFR 0.152.
 */
package sun.misc;

import java.util.Hashtable;
import sun.misc.NativeSignalHandler;
import sun.misc.SignalHandler;

public final class Signal {
    private static Hashtable handlers = new Hashtable(4);
    private static Hashtable signals = new Hashtable(4);
    private int number;
    private String name;

    public Signal(String string) {
        this.number = Signal.findSignal(string);
        this.name = string;
        if (this.number < 0) {
            throw new IllegalArgumentException("Unknown signal: " + string);
        }
    }

    private static void dispatch(int n) {
        final Signal signal = (Signal)signals.get(new Integer(n));
        final SignalHandler signalHandler = (SignalHandler)handlers.get(signal);
        Runnable runnable = new Runnable(){

            public void run() {
                signalHandler.handle(signal);
            }
        };
        if (signalHandler != null) {
            new Thread(runnable, String.valueOf(String.valueOf(signal)) + " handler").start();
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof Signal)) {
            return false;
        }
        Signal signal = (Signal)object;
        return this.name.equals(signal.name) && this.number == signal.number;
    }

    private static native int findSignal(String var0);

    public String getName() {
        return this.name;
    }

    int getNumber() {
        return this.number;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized SignalHandler handle(Signal signal, SignalHandler signalHandler) throws IllegalArgumentException {
        long l = signalHandler instanceof NativeSignalHandler ? ((NativeSignalHandler)signalHandler).getHandler() : 2L;
        long l2 = Signal.handle0(signal.number, l);
        if (l2 == -1L) {
            throw new IllegalArgumentException("Signal already used by VM: " + signal);
        }
        signals.put(new Integer(signal.number), signal);
        Hashtable hashtable = handlers;
        synchronized (hashtable) {
            SignalHandler signalHandler2 = (SignalHandler)handlers.get(signal);
            handlers.remove(signal);
            if (l == 2L) {
                handlers.put(signal, signalHandler);
            }
            if (l2 == 0L) {
                return SignalHandler.SIG_DFL;
            }
            if (l2 == 1L) {
                return SignalHandler.SIG_IGN;
            }
            if (l2 != 2L) return new NativeSignalHandler(l2);
            return signalHandler2;
        }
    }

    private static native long handle0(int var0, long var1);

    public int hashCode() {
        return this.number;
    }

    public static void raise(Signal signal) throws IllegalArgumentException {
        if (handlers.get(signal) == null) {
            throw new IllegalArgumentException("Unhandled signal: " + signal);
        }
        Signal.raise0(signal.number);
    }

    private static native void raise0(int var0);

    public String toString() {
        return "SIG" + this.name;
    }
}

