/*
 * Decompiled with CFR 0.152.
 */
package sun.misc;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.SocketPermission;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.EmptyStackException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.NoSuchElementException;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import sun.misc.Resource;
import sun.security.action.GetPropertyAction;

public class URLClassPath {
    static final String USER_AGENT_JAVA_VERSION = "UA-Java-Version";
    static final String JAVA_VERSION = (String)AccessController.doPrivileged(new GetPropertyAction("java.version"));
    private ArrayList path = new ArrayList();
    private Stack urls = new Stack();
    private ArrayList loaders = new ArrayList();
    private HashMap lmap = new HashMap();
    private URLStreamHandler jarHandler;

    public URLClassPath(URL[] uRLArray) {
        this(uRLArray, null);
    }

    public URLClassPath(URL[] uRLArray, URLStreamHandlerFactory uRLStreamHandlerFactory) {
        int n = 0;
        while (n < uRLArray.length) {
            this.path.add(uRLArray[n]);
            ++n;
        }
        this.push(uRLArray);
        if (uRLStreamHandlerFactory != null) {
            this.jarHandler = uRLStreamHandlerFactory.createURLStreamHandler("jar");
        }
    }

    static /* synthetic */ Loader access$0(URLClassPath uRLClassPath, int n) {
        return uRLClassPath.getLoader(n);
    }

    public void addURL(URL uRL) {
        Stack stack = this.urls;
        synchronized (stack) {
            this.urls.add(0, uRL);
            this.path.add(uRL);
        }
    }

    static void check(URL uRL) throws IOException {
        Permission permission;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null && (permission = uRL.openConnection().getPermission()) != null) {
            try {
                securityManager.checkPermission(permission);
            }
            catch (SecurityException securityException) {
                if (permission instanceof FilePermission && permission.getActions().indexOf("read") != -1) {
                    securityManager.checkRead(permission.getName());
                }
                if (permission instanceof SocketPermission && permission.getActions().indexOf("connect") != -1) {
                    securityManager.checkConnect(uRL.getHost(), uRL.getPort());
                }
                throw securityException;
            }
        }
    }

    public URL checkURL(URL uRL) {
        try {
            URLClassPath.check(uRL);
        }
        catch (Exception exception) {
            return null;
        }
        return uRL;
    }

    private Loader getLoader(int n) {
        while (this.loaders.size() < n + 1) {
            URL uRL;
            Object object;
            block9: {
                try {
                    object = this.urls;
                    synchronized (object) {
                        uRL = (URL)this.urls.pop();
                    }
                }
                catch (EmptyStackException emptyStackException) {
                    return null;
                }
                if (this.lmap.containsKey(uRL)) continue;
                try {
                    object = this.getLoader(uRL);
                    URL[] uRLArray = ((Loader)object).getClassPath();
                    if (uRLArray == null) break block9;
                    this.push(uRLArray);
                }
                catch (IOException iOException) {
                    continue;
                }
            }
            this.loaders.add(object);
            this.lmap.put(uRL, object);
        }
        return (Loader)this.loaders.get(n);
    }

    private Loader getLoader(final URL uRL) throws IOException {
        try {
            return (Loader)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    String string = uRL.getFile();
                    if (string != null && string.endsWith("/")) {
                        if ("file".equals(uRL.getProtocol())) {
                            return new FileLoader(uRL);
                        }
                        return new Loader(uRL);
                    }
                    return new JarLoader(uRL, URLClassPath.this.jarHandler);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
    }

    public Resource getResource(String string) {
        return this.getResource(string, true);
    }

    public Resource getResource(String string, boolean bl) {
        Loader loader;
        int n = 0;
        while ((loader = this.getLoader(n)) != null) {
            Resource resource = loader.getResource(string, bl);
            if (resource != null) {
                return resource;
            }
            ++n;
        }
        return null;
    }

    public Enumeration getResources(String string) {
        return this.getResources(string, true);
    }

    public Enumeration getResources(final String string, final boolean bl) {
        return new Enumeration(){
            private int index = 0;
            private Resource res = null;

            public boolean hasMoreElements() {
                return this.next();
            }

            /*
             * Unable to fully structure code
             */
            private boolean next() {
                if (this.res == null) ** GOTO lbl6
                return true;
lbl-1000:
                // 1 sources

                {
                    this.res = var1_1.getResource(string, bl);
                    if (this.res == null) continue;
                    return true;
lbl6:
                    // 2 sources

                    ** while ((var1_1 = URLClassPath.access$0((URLClassPath)this, (int)this.index++)) != null)
                }
lbl7:
                // 1 sources

                return false;
            }

            public Object nextElement() {
                if (!this.next()) {
                    throw new NoSuchElementException();
                }
                Resource resource = this.res;
                this.res = null;
                return resource;
            }
        };
    }

    public URL[] getURLs() {
        Stack stack = this.urls;
        synchronized (stack) {
            URL[] uRLArray = (URL[])this.path.toArray(new URL[this.path.size()]);
            Object var3_3 = null;
            return uRLArray;
        }
    }

    public static URL[] pathToURLs(String string) {
        Object object;
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        Object object2 = new URL[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            try {
                object = new File(stringTokenizer.nextToken());
                object2[n++] = ((File)object).toURL();
                object2[n - 1] = new File(((File)object).getCanonicalPath()).toURL();
            }
            catch (IOException iOException) {}
        }
        if (((URL[])object2).length != n) {
            object = new URL[n];
            System.arraycopy(object2, 0, object, 0, n);
            object2 = object;
        }
        return object2;
    }

    private void push(URL[] uRLArray) {
        Stack stack = this.urls;
        synchronized (stack) {
            int n = uRLArray.length - 1;
            while (n >= 0) {
                this.urls.push(uRLArray[n]);
                --n;
            }
        }
    }

    private static class Loader {
        private final URL base;

        Loader(URL uRL) {
            this.base = uRL;
        }

        static /* synthetic */ URL access$0(Loader loader) {
            return loader.base;
        }

        URL getBaseURL() {
            return this.base;
        }

        URL[] getClassPath() throws IOException {
            return null;
        }

        Resource getResource(String string) {
            return this.getResource(string, true);
        }

        Resource getResource(String string, boolean bl) {
            URLConnection uRLConnection;
            URL uRL;
            try {
                uRL = new URL(this.base, string);
            }
            catch (MalformedURLException malformedURLException) {
                throw new IllegalArgumentException("name");
            }
            try {
                if (bl) {
                    URLClassPath.check(uRL);
                }
                if ((uRLConnection = uRL.openConnection()) instanceof HttpURLConnection) {
                    HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
                    int n = httpURLConnection.getResponseCode();
                    if (n >= 400) {
                        return null;
                    }
                } else {
                    InputStream inputStream = uRL.openStream();
                    inputStream.close();
                }
            }
            catch (Exception exception) {
                return null;
            }
            return new Resource(string, this, uRLConnection, uRL){
                private final /* synthetic */ URLConnection val$uc;
                private final /* synthetic */ Loader this$0;
                private final /* synthetic */ URL val$url;
                private final /* synthetic */ String val$name;
                {
                    this.val$name = string;
                    this.this$0 = loader;
                    this.val$uc = uRLConnection;
                    this.val$url = uRL;
                }

                public URL getCodeSourceURL() {
                    return Loader.access$0(this.this$0);
                }

                public int getContentLength() throws IOException {
                    return this.val$uc.getContentLength();
                }

                public InputStream getInputStream() throws IOException {
                    return this.val$uc.getInputStream();
                }

                public String getName() {
                    return this.val$name;
                }

                public URL getURL() {
                    return this.val$url;
                }
            };
        }
    }

    private static class JarLoader
    extends Loader {
        private JarFile jar;
        private URL csu;

        JarLoader(URL uRL, URLStreamHandler uRLStreamHandler) throws IOException {
            super(new URL("jar", "", -1, String.valueOf(String.valueOf(uRL)) + "!/", uRLStreamHandler));
            this.jar = this.getJarFile(uRL);
            this.csu = uRL;
        }

        static /* synthetic */ URL access$0(JarLoader jarLoader) {
            return jarLoader.csu;
        }

        static /* synthetic */ JarFile access$1(JarLoader jarLoader) {
            return jarLoader.jar;
        }

        URL[] getClassPath() throws IOException {
            String string;
            Attributes attributes;
            Manifest manifest = this.jar.getManifest();
            if (manifest != null && (attributes = manifest.getMainAttributes()) != null && (string = attributes.getValue(Attributes.Name.CLASS_PATH)) != null) {
                return this.parseClassPath(this.csu, string);
            }
            return null;
        }

        private JarFile getJarFile(URL uRL) throws IOException {
            if ("file".equals(uRL.getProtocol())) {
                String string = uRL.getFile().replace('/', File.separatorChar);
                File file = new File(string);
                if (!file.exists()) {
                    throw new FileNotFoundException(string);
                }
                return new JarFile(string);
            }
            URLConnection uRLConnection = this.getBaseURL().openConnection();
            uRLConnection.setRequestProperty(URLClassPath.USER_AGENT_JAVA_VERSION, JAVA_VERSION);
            return ((JarURLConnection)uRLConnection).getJarFile();
        }

        Resource getResource(String string, boolean bl) {
            JarEntry jarEntry = this.jar.getJarEntry(string);
            if (jarEntry != null) {
                URL uRL;
                try {
                    uRL = new URL(this.getBaseURL(), string);
                    if (bl) {
                        URLClassPath.check(uRL);
                    }
                }
                catch (MalformedURLException malformedURLException) {
                    return null;
                }
                catch (IOException iOException) {
                    return null;
                }
                catch (AccessControlException accessControlException) {
                    return null;
                }
                return new Resource(jarEntry, string, this, uRL){
                    private final /* synthetic */ JarEntry val$entry;
                    private final /* synthetic */ JarLoader this$0;
                    private final /* synthetic */ URL val$url;
                    private final /* synthetic */ String val$name;
                    {
                        this.val$entry = jarEntry;
                        this.val$name = string;
                        this.this$0 = jarLoader;
                        this.val$url = uRL;
                    }

                    public Certificate[] getCertificates() {
                        return this.val$entry.getCertificates();
                    }

                    public URL getCodeSourceURL() {
                        return JarLoader.access$0(this.this$0);
                    }

                    public int getContentLength() {
                        return (int)this.val$entry.getSize();
                    }

                    public InputStream getInputStream() throws IOException {
                        return JarLoader.access$1(this.this$0).getInputStream(this.val$entry);
                    }

                    public Manifest getManifest() throws IOException {
                        return JarLoader.access$1(this.this$0).getManifest();
                    }

                    public String getName() {
                        return this.val$name;
                    }

                    public URL getURL() {
                        return this.val$url;
                    }
                };
            }
            return null;
        }

        private URL[] parseClassPath(URL uRL, String string) throws MalformedURLException {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            URL[] uRLArray = new URL[stringTokenizer.countTokens()];
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                uRLArray[n] = new URL(uRL, string2);
                ++n;
            }
            return uRLArray;
        }
    }

    private static class FileLoader
    extends Loader {
        private File dir;

        FileLoader(URL uRL) throws IOException {
            super(uRL);
            if (!"file".equals(uRL.getProtocol())) {
                throw new IllegalArgumentException("url");
            }
            this.dir = new File(uRL.getFile().replace('/', File.separatorChar));
        }

        Resource getResource(String string, boolean bl) {
            try {
                File file;
                URL uRL = new URL(this.getBaseURL(), string);
                if (!uRL.getFile().startsWith(this.getBaseURL().getFile())) {
                    return null;
                }
                if (bl) {
                    URLClassPath.check(uRL);
                }
                if ((file = new File(this.dir, string.replace('/', File.separatorChar))).exists()) {
                    return new Resource(file, string, this, uRL){
                        private final /* synthetic */ File val$file;
                        private final /* synthetic */ FileLoader this$0;
                        private final /* synthetic */ URL val$url;
                        private final /* synthetic */ String val$name;
                        {
                            this.val$file = file;
                            this.val$name = string;
                            this.this$0 = fileLoader;
                            this.val$url = uRL;
                        }

                        public URL getCodeSourceURL() {
                            return this.this$0.getBaseURL();
                        }

                        public int getContentLength() throws IOException {
                            return (int)this.val$file.length();
                        }

                        public InputStream getInputStream() throws IOException {
                            return new FileInputStream(this.val$file);
                        }

                        public String getName() {
                            return this.val$name;
                        }

                        public URL getURL() {
                            return this.val$url;
                        }
                    };
                }
            }
            catch (Exception exception) {
                return null;
            }
            return null;
        }
    }
}

