/*
 * Decompiled with CFR 0.152.
 */
package sun.net;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import sun.net.TelnetProtocolException;

public class TelnetInputStream
extends FilterInputStream {
    boolean stickyCRLF = false;
    boolean seenCR = false;
    public boolean binaryMode = false;

    public TelnetInputStream(InputStream inputStream, boolean bl) {
        super(inputStream);
        this.binaryMode = bl;
    }

    public int read() throws IOException {
        if (this.binaryMode) {
            return super.read();
        }
        if (this.seenCR) {
            this.seenCR = false;
            return 10;
        }
        int n = super.read();
        if (n == 13) {
            n = super.read();
            switch (n) {
                default: {
                    throw new TelnetProtocolException("misplaced CR in input");
                }
                case 0: {
                    return 13;
                }
                case 10: 
            }
            if (this.stickyCRLF) {
                this.seenCR = true;
                return 13;
            }
            return 10;
        }
        return n;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.binaryMode) {
            return super.read(byArray, n, n2);
        }
        int n3 = n;
        while (--n2 >= 0) {
            int n4 = this.read();
            if (n4 == -1) break;
            byArray[n++] = (byte)n4;
        }
        return n > n3 ? n - n3 : -1;
    }

    public void setStickyCRLF(boolean bl) {
        this.stickyCRLF = bl;
    }
}

