/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.protocol.doc;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.net.FileNameMap;
import java.net.URL;
import java.security.AccessController;
import java.security.Permission;
import sun.net.www.MessageHeader;
import sun.net.www.URLConnection;
import sun.security.action.GetPropertyAction;

public class DocURLConnection
extends URLConnection {
    InputStream is;
    String filename;
    Permission permission;
    static String installDirectory = (String)AccessController.doPrivileged(new GetPropertyAction("hotjava.home"));

    static {
        if (installDirectory == null) {
            installDirectory = "/usr/local/hotjava";
        }
    }

    DocURLConnection(URL uRL) {
        super(uRL);
    }

    public void connect() throws IOException {
        String string = String.valueOf(installDirectory) + this.url.getFile();
        MessageHeader messageHeader = new MessageHeader();
        FileNameMap fileNameMap = java.net.URLConnection.getFileNameMap();
        String string2 = fileNameMap.getContentTypeFor(string);
        if (string2 != null) {
            messageHeader.add("content-type", string2);
        }
        this.setProperties(messageHeader);
        File file = new File(string);
        if (file.exists()) {
            messageHeader.add("Content-length", String.valueOf(file.length()));
        }
        this.filename = string.replace('/', File.separatorChar);
        this.is = new BufferedInputStream(new FileInputStream(this.filename));
        this.connected = true;
    }

    public synchronized InputStream getInputStream() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        return this.is;
    }

    public Permission getPermission() throws IOException {
        if (this.permission == null) {
            this.permission = File.separatorChar == '/' ? new FilePermission(this.url.getFile(), "read") : new FilePermission(this.url.getFile().replace('/', File.separatorChar), "read");
        }
        return this.permission;
    }
}

